-- All-in-One WP Migration SQL Dump
-- https://servmask.com/
--
-- Host: localhost
-- Database: hasantal_wp975
-- Class: Ai1wm_Database_Mysqli
--

DROP TABLE IF EXISTS `SERVMASK_PREFIX_commentmeta`;
CREATE TABLE `SERVMASK_PREFIX_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `SERVMASK_PREFIX_comments`;
CREATE TABLE `SERVMASK_PREFIX_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

START TRANSACTION;
INSERT INTO `SERVMASK_PREFIX_comments` VALUES (1,1,'A WordPress Commenter','wapuu@wordpress.example','https://wordpress.org/','','2023-10-20 09:29:24','2023-10-20 09:29:24','Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.',0,'1','','comment',0,0);
COMMIT;

DROP TABLE IF EXISTS `SERVMASK_PREFIX_e_events`;
CREATE TABLE `SERVMASK_PREFIX_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `SERVMASK_PREFIX_links`;
CREATE TABLE `SERVMASK_PREFIX_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS `SERVMASK_PREFIX_litespeed_url`;
CREATE TABLE `SERVMASK_PREFIX_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

START TRANSACTION;
INSERT INTO `SERVMASK_PREFIX_litespeed_url` VALUES (1,'https://hasantalukder.com/crocoblock','');
COMMIT;

DROP TABLE IF EXISTS `SERVMASK_PREFIX_litespeed_url_file`;
CREATE TABLE `SERVMASK_PREFIX_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `expired` int(11) NOT NULL DEFAULT 0,
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

START TRANSACTION;
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (3,1,'+webp','e9d47029fd688ac0439cf333bfac9b7b',1,0,0,0);
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (4,1,'+webp','1b0de83903f9a805acd6c9269e02f3d3',2,1699532098,0,0);
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (5,1,'+ismobile+webp','e9d47029fd688ac0439cf333bfac9b7b',1,0,0,0);
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (6,1,'+ismobile+webp','7bae71d8ce56749e9191a33fc22b5f99',2,0,0,0);
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (7,1,'','e9d47029fd688ac0439cf333bfac9b7b',1,0,0,0);
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (8,1,'','7bae71d8ce56749e9191a33fc22b5f99',2,0,0,0);
INSERT INTO `SERVMASK_PREFIX_litespeed_url_file` VALUES (9,1,'+webp','7bae71d8ce56749e9191a33fc22b5f99',2,0,0,0);
COMMIT;

DROP TABLE IF EXISTS `SERVMASK_PREFIX_options`;
CREATE TABLE `SERVMASK_PREFIX_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=600 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

START TRANSACTION;
INSERT INTO `SERVMASK_PREFIX_options` VALUES (1,'siteurl','https://hasantalukder.com/crocoblock','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (2,'home','https://hasantalukder.com/crocoblock','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (3,'blogname','Developers Zone','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (4,'blogdescription','My personal Blog','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (5,'users_can_register','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (6,'admin_email','admin@hasantalukder.com','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (7,'start_of_week','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (8,'use_balanceTags','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (9,'use_smilies','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (10,'require_name_email','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (11,'comments_notify','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (12,'posts_per_rss','10','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (13,'rss_use_excerpt','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (14,'mailserver_url','mail.example.com','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (15,'mailserver_login','login@example.com','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (16,'mailserver_pass','password','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (17,'mailserver_port','110','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (18,'default_category','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (19,'default_comment_status','open','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (20,'default_ping_status','open','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (21,'default_pingback_flag','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (22,'posts_per_page','10','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (23,'date_format','F j, Y','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (24,'time_format','g:i a','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (25,'links_updated_date_format','F j, Y g:i a','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (26,'comment_moderation','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (27,'moderation_notify','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (28,'permalink_structure','/%year%/%monthnum%/%day%/%postname%/','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (29,'rewrite_rules','a:112:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=3422&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (30,'hack_file','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (31,'blog_charset','UTF-8','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (32,'moderation_keys','','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (33,'active_plugins','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (34,'category_base','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (35,'ping_sites','http://rpc.pingomatic.com/','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (36,'comment_max_links','2','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (37,'gmt_offset','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (38,'default_email_category','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (39,'recently_edited','','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (40,'template','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (41,'stylesheet','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (42,'comment_registration','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (43,'html_type','text/html','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (44,'use_trackback','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (45,'default_role','subscriber','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (46,'db_version','55853','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (47,'uploads_use_yearmonth_folders','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (48,'upload_path','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (49,'blog_public','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (50,'default_link_category','2','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (51,'show_on_front','page','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (52,'tag_base','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (53,'show_avatars','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (54,'avatar_rating','G','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (55,'upload_url_path','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (56,'thumbnail_size_w','150','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (57,'thumbnail_size_h','150','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (58,'thumbnail_crop','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (59,'medium_size_w','300','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (60,'medium_size_h','300','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (61,'avatar_default','mystery','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (62,'large_size_w','1024','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (63,'large_size_h','1024','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (64,'image_default_link_type','none','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (65,'image_default_size','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (66,'image_default_align','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (67,'close_comments_for_old_posts','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (68,'close_comments_days_old','14','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (69,'thread_comments','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (70,'thread_comments_depth','5','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (71,'page_comments','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (72,'comments_per_page','50','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (73,'default_comments_page','newest','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (74,'comment_order','asc','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (75,'sticky_posts','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (76,'widget_categories','a:4:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}i:4;a:4:{s:5:\"title\";s:22:\"OUR CONTENT CATEGORIES\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:1;}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (77,'widget_text','a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (78,'widget_rss','a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (79,'uninstall_plugins','a:2:{s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (80,'timezone_string','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (81,'page_for_posts','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (82,'page_on_front','3422','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (83,'default_post_format','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (84,'link_manager_enabled','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (85,'finished_splitting_shared_terms','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (86,'site_icon','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (87,'medium_large_size_w','768','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (88,'medium_large_size_h','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (89,'wp_page_for_privacy_policy','3','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (90,'show_comments_cookies_opt_in','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (91,'admin_email_lifespan','1713346164','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (92,'disallowed_keys','','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (93,'comment_previously_approved','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (94,'auto_plugin_theme_update_emails','a:0:{}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (95,'auto_update_core_dev','enabled','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (96,'auto_update_core_minor','enabled','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (97,'auto_update_core_major','enabled','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (98,'wp_force_deactivated_plugins','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (99,'initial_db_version','55853','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (100,'SERVMASK_PREFIX_user_roles','a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (101,'fresh_site','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (102,'user_count','1','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (103,'widget_block','a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (104,'sidebars_widgets','a:5:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";i:5;s:28:\"smartmag-block-posts-small-2\";}s:16:\"smartmag-primary\";a:7:{i:0;s:22:\"smartmag-block-codes-1\";i:1;s:28:\"smartmag-block-posts-small-1\";i:2;s:15:\"bunyad-social-1\";i:3;s:27:\"smartmag-block-highlights-1\";i:4;s:27:\"smartmag-block-newsletter-1\";i:5;s:22:\"smartmag-block-codes-2\";i:6;s:15:\"bunyad-social-2\";}s:19:\"smartmag-off-canvas\";a:2:{i:0;s:27:\"smartmag-block-newsletter-2\";i:1;s:28:\"smartmag-block-posts-small-3\";}s:11:\"main-footer\";a:3:{i:0;s:21:\"bunyad_about_widget-1\";i:1;s:28:\"smartmag-block-posts-small-4\";i:2;s:12:\"categories-4\";}s:13:\"array_version\";i:3;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (105,'cron','a:11:{i:1697805033;a:4:{s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_ccss\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_ucss\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1697808565;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1697837364;a:4:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697837374;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697880564;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697880574;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697880575;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697880651;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697883664;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698399002;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (106,'widget_pages','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (107,'widget_calendar','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (108,'widget_archives','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (109,'widget_media_audio','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (110,'widget_media_image','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (111,'widget_media_gallery','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (112,'widget_media_video','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (113,'widget_meta','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (114,'widget_search','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (115,'widget_recent-posts','a:2:{s:12:\"_multiwidget\";i:1;i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (116,'widget_recent-comments','a:2:{i:1;a:2:{s:5:\"title\";s:22:\"OUR CONTENT CATEGORIES\";s:6:\"number\";i:4;}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (117,'widget_tag_cloud','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (118,'widget_nav_menu','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (119,'widget_custom_html','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (120,'recovery_keys','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (121,'theme_mods_twentytwentythree','a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1697797227;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (122,'_transient_wp_core_block_css_files','a:2:{s:7:\"version\";s:5:\"6.3.2\";s:5:\"files\";a:496:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:20:\"block/editor-rtl.css\";i:29;s:24:\"block/editor-rtl.min.css\";i:30;s:16:\"block/editor.css\";i:31;s:20:\"block/editor.min.css\";i:32;s:21:\"button/editor-rtl.css\";i:33;s:25:\"button/editor-rtl.min.css\";i:34;s:17:\"button/editor.css\";i:35;s:21:\"button/editor.min.css\";i:36;s:20:\"button/style-rtl.css\";i:37;s:24:\"button/style-rtl.min.css\";i:38;s:16:\"button/style.css\";i:39;s:20:\"button/style.min.css\";i:40;s:22:\"buttons/editor-rtl.css\";i:41;s:26:\"buttons/editor-rtl.min.css\";i:42;s:18:\"buttons/editor.css\";i:43;s:22:\"buttons/editor.min.css\";i:44;s:21:\"buttons/style-rtl.css\";i:45;s:25:\"buttons/style-rtl.min.css\";i:46;s:17:\"buttons/style.css\";i:47;s:21:\"buttons/style.min.css\";i:48;s:22:\"calendar/style-rtl.css\";i:49;s:26:\"calendar/style-rtl.min.css\";i:50;s:18:\"calendar/style.css\";i:51;s:22:\"calendar/style.min.css\";i:52;s:25:\"categories/editor-rtl.css\";i:53;s:29:\"categories/editor-rtl.min.css\";i:54;s:21:\"categories/editor.css\";i:55;s:25:\"categories/editor.min.css\";i:56;s:24:\"categories/style-rtl.css\";i:57;s:28:\"categories/style-rtl.min.css\";i:58;s:20:\"categories/style.css\";i:59;s:24:\"categories/style.min.css\";i:60;s:19:\"code/editor-rtl.css\";i:61;s:23:\"code/editor-rtl.min.css\";i:62;s:15:\"code/editor.css\";i:63;s:19:\"code/editor.min.css\";i:64;s:18:\"code/style-rtl.css\";i:65;s:22:\"code/style-rtl.min.css\";i:66;s:14:\"code/style.css\";i:67;s:18:\"code/style.min.css\";i:68;s:18:\"code/theme-rtl.css\";i:69;s:22:\"code/theme-rtl.min.css\";i:70;s:14:\"code/theme.css\";i:71;s:18:\"code/theme.min.css\";i:72;s:22:\"columns/editor-rtl.css\";i:73;s:26:\"columns/editor-rtl.min.css\";i:74;s:18:\"columns/editor.css\";i:75;s:22:\"columns/editor.min.css\";i:76;s:21:\"columns/style-rtl.css\";i:77;s:25:\"columns/style-rtl.min.css\";i:78;s:17:\"columns/style.css\";i:79;s:21:\"columns/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:30:\"comment-template/style-rtl.css\";i:85;s:34:\"comment-template/style-rtl.min.css\";i:86;s:26:\"comment-template/style.css\";i:87;s:30:\"comment-template/style.min.css\";i:88;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:89;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:90;s:38:\"comments-pagination-numbers/editor.css\";i:91;s:42:\"comments-pagination-numbers/editor.min.css\";i:92;s:34:\"comments-pagination/editor-rtl.css\";i:93;s:38:\"comments-pagination/editor-rtl.min.css\";i:94;s:30:\"comments-pagination/editor.css\";i:95;s:34:\"comments-pagination/editor.min.css\";i:96;s:33:\"comments-pagination/style-rtl.css\";i:97;s:37:\"comments-pagination/style-rtl.min.css\";i:98;s:29:\"comments-pagination/style.css\";i:99;s:33:\"comments-pagination/style.min.css\";i:100;s:29:\"comments-title/editor-rtl.css\";i:101;s:33:\"comments-title/editor-rtl.min.css\";i:102;s:25:\"comments-title/editor.css\";i:103;s:29:\"comments-title/editor.min.css\";i:104;s:23:\"comments/editor-rtl.css\";i:105;s:27:\"comments/editor-rtl.min.css\";i:106;s:19:\"comments/editor.css\";i:107;s:23:\"comments/editor.min.css\";i:108;s:22:\"comments/style-rtl.css\";i:109;s:26:\"comments/style-rtl.min.css\";i:110;s:18:\"comments/style.css\";i:111;s:22:\"comments/style.min.css\";i:112;s:20:\"cover/editor-rtl.css\";i:113;s:24:\"cover/editor-rtl.min.css\";i:114;s:16:\"cover/editor.css\";i:115;s:20:\"cover/editor.min.css\";i:116;s:19:\"cover/style-rtl.css\";i:117;s:23:\"cover/style-rtl.min.css\";i:118;s:15:\"cover/style.css\";i:119;s:19:\"cover/style.min.css\";i:120;s:22:\"details/editor-rtl.css\";i:121;s:26:\"details/editor-rtl.min.css\";i:122;s:18:\"details/editor.css\";i:123;s:22:\"details/editor.min.css\";i:124;s:21:\"details/style-rtl.css\";i:125;s:25:\"details/style-rtl.min.css\";i:126;s:17:\"details/style.css\";i:127;s:21:\"details/style.min.css\";i:128;s:20:\"embed/editor-rtl.css\";i:129;s:24:\"embed/editor-rtl.min.css\";i:130;s:16:\"embed/editor.css\";i:131;s:20:\"embed/editor.min.css\";i:132;s:19:\"embed/style-rtl.css\";i:133;s:23:\"embed/style-rtl.min.css\";i:134;s:15:\"embed/style.css\";i:135;s:19:\"embed/style.min.css\";i:136;s:19:\"embed/theme-rtl.css\";i:137;s:23:\"embed/theme-rtl.min.css\";i:138;s:15:\"embed/theme.css\";i:139;s:19:\"embed/theme.min.css\";i:140;s:19:\"file/editor-rtl.css\";i:141;s:23:\"file/editor-rtl.min.css\";i:142;s:15:\"file/editor.css\";i:143;s:19:\"file/editor.min.css\";i:144;s:18:\"file/style-rtl.css\";i:145;s:22:\"file/style-rtl.min.css\";i:146;s:14:\"file/style.css\";i:147;s:18:\"file/style.min.css\";i:148;s:23:\"footnotes/style-rtl.css\";i:149;s:27:\"footnotes/style-rtl.min.css\";i:150;s:19:\"footnotes/style.css\";i:151;s:23:\"footnotes/style.min.css\";i:152;s:23:\"freeform/editor-rtl.css\";i:153;s:27:\"freeform/editor-rtl.min.css\";i:154;s:19:\"freeform/editor.css\";i:155;s:23:\"freeform/editor.min.css\";i:156;s:22:\"gallery/editor-rtl.css\";i:157;s:26:\"gallery/editor-rtl.min.css\";i:158;s:18:\"gallery/editor.css\";i:159;s:22:\"gallery/editor.min.css\";i:160;s:21:\"gallery/style-rtl.css\";i:161;s:25:\"gallery/style-rtl.min.css\";i:162;s:17:\"gallery/style.css\";i:163;s:21:\"gallery/style.min.css\";i:164;s:21:\"gallery/theme-rtl.css\";i:165;s:25:\"gallery/theme-rtl.min.css\";i:166;s:17:\"gallery/theme.css\";i:167;s:21:\"gallery/theme.min.css\";i:168;s:20:\"group/editor-rtl.css\";i:169;s:24:\"group/editor-rtl.min.css\";i:170;s:16:\"group/editor.css\";i:171;s:20:\"group/editor.min.css\";i:172;s:19:\"group/style-rtl.css\";i:173;s:23:\"group/style-rtl.min.css\";i:174;s:15:\"group/style.css\";i:175;s:19:\"group/style.min.css\";i:176;s:19:\"group/theme-rtl.css\";i:177;s:23:\"group/theme-rtl.min.css\";i:178;s:15:\"group/theme.css\";i:179;s:19:\"group/theme.min.css\";i:180;s:21:\"heading/style-rtl.css\";i:181;s:25:\"heading/style-rtl.min.css\";i:182;s:17:\"heading/style.css\";i:183;s:21:\"heading/style.min.css\";i:184;s:19:\"html/editor-rtl.css\";i:185;s:23:\"html/editor-rtl.min.css\";i:186;s:15:\"html/editor.css\";i:187;s:19:\"html/editor.min.css\";i:188;s:20:\"image/editor-rtl.css\";i:189;s:24:\"image/editor-rtl.min.css\";i:190;s:16:\"image/editor.css\";i:191;s:20:\"image/editor.min.css\";i:192;s:19:\"image/style-rtl.css\";i:193;s:23:\"image/style-rtl.min.css\";i:194;s:15:\"image/style.css\";i:195;s:19:\"image/style.min.css\";i:196;s:19:\"image/theme-rtl.css\";i:197;s:23:\"image/theme-rtl.min.css\";i:198;s:15:\"image/theme.css\";i:199;s:19:\"image/theme.min.css\";i:200;s:29:\"latest-comments/style-rtl.css\";i:201;s:33:\"latest-comments/style-rtl.min.css\";i:202;s:25:\"latest-comments/style.css\";i:203;s:29:\"latest-comments/style.min.css\";i:204;s:27:\"latest-posts/editor-rtl.css\";i:205;s:31:\"latest-posts/editor-rtl.min.css\";i:206;s:23:\"latest-posts/editor.css\";i:207;s:27:\"latest-posts/editor.min.css\";i:208;s:26:\"latest-posts/style-rtl.css\";i:209;s:30:\"latest-posts/style-rtl.min.css\";i:210;s:22:\"latest-posts/style.css\";i:211;s:26:\"latest-posts/style.min.css\";i:212;s:18:\"list/style-rtl.css\";i:213;s:22:\"list/style-rtl.min.css\";i:214;s:14:\"list/style.css\";i:215;s:18:\"list/style.min.css\";i:216;s:25:\"media-text/editor-rtl.css\";i:217;s:29:\"media-text/editor-rtl.min.css\";i:218;s:21:\"media-text/editor.css\";i:219;s:25:\"media-text/editor.min.css\";i:220;s:24:\"media-text/style-rtl.css\";i:221;s:28:\"media-text/style-rtl.min.css\";i:222;s:20:\"media-text/style.css\";i:223;s:24:\"media-text/style.min.css\";i:224;s:19:\"more/editor-rtl.css\";i:225;s:23:\"more/editor-rtl.min.css\";i:226;s:15:\"more/editor.css\";i:227;s:19:\"more/editor.min.css\";i:228;s:30:\"navigation-link/editor-rtl.css\";i:229;s:34:\"navigation-link/editor-rtl.min.css\";i:230;s:26:\"navigation-link/editor.css\";i:231;s:30:\"navigation-link/editor.min.css\";i:232;s:29:\"navigation-link/style-rtl.css\";i:233;s:33:\"navigation-link/style-rtl.min.css\";i:234;s:25:\"navigation-link/style.css\";i:235;s:29:\"navigation-link/style.min.css\";i:236;s:33:\"navigation-submenu/editor-rtl.css\";i:237;s:37:\"navigation-submenu/editor-rtl.min.css\";i:238;s:29:\"navigation-submenu/editor.css\";i:239;s:33:\"navigation-submenu/editor.min.css\";i:240;s:25:\"navigation/editor-rtl.css\";i:241;s:29:\"navigation/editor-rtl.min.css\";i:242;s:21:\"navigation/editor.css\";i:243;s:25:\"navigation/editor.min.css\";i:244;s:24:\"navigation/style-rtl.css\";i:245;s:28:\"navigation/style-rtl.min.css\";i:246;s:20:\"navigation/style.css\";i:247;s:24:\"navigation/style.min.css\";i:248;s:23:\"nextpage/editor-rtl.css\";i:249;s:27:\"nextpage/editor-rtl.min.css\";i:250;s:19:\"nextpage/editor.css\";i:251;s:23:\"nextpage/editor.min.css\";i:252;s:24:\"page-list/editor-rtl.css\";i:253;s:28:\"page-list/editor-rtl.min.css\";i:254;s:20:\"page-list/editor.css\";i:255;s:24:\"page-list/editor.min.css\";i:256;s:23:\"page-list/style-rtl.css\";i:257;s:27:\"page-list/style-rtl.min.css\";i:258;s:19:\"page-list/style.css\";i:259;s:23:\"page-list/style.min.css\";i:260;s:24:\"paragraph/editor-rtl.css\";i:261;s:28:\"paragraph/editor-rtl.min.css\";i:262;s:20:\"paragraph/editor.css\";i:263;s:24:\"paragraph/editor.min.css\";i:264;s:23:\"paragraph/style-rtl.css\";i:265;s:27:\"paragraph/style-rtl.min.css\";i:266;s:19:\"paragraph/style.css\";i:267;s:23:\"paragraph/style.min.css\";i:268;s:25:\"post-author/style-rtl.css\";i:269;s:29:\"post-author/style-rtl.min.css\";i:270;s:21:\"post-author/style.css\";i:271;s:25:\"post-author/style.min.css\";i:272;s:33:\"post-comments-form/editor-rtl.css\";i:273;s:37:\"post-comments-form/editor-rtl.min.css\";i:274;s:29:\"post-comments-form/editor.css\";i:275;s:33:\"post-comments-form/editor.min.css\";i:276;s:32:\"post-comments-form/style-rtl.css\";i:277;s:36:\"post-comments-form/style-rtl.min.css\";i:278;s:28:\"post-comments-form/style.css\";i:279;s:32:\"post-comments-form/style.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"quote/style-rtl.css\";i:357;s:23:\"quote/style-rtl.min.css\";i:358;s:15:\"quote/style.css\";i:359;s:19:\"quote/style.min.css\";i:360;s:19:\"quote/theme-rtl.css\";i:361;s:23:\"quote/theme-rtl.min.css\";i:362;s:15:\"quote/theme.css\";i:363;s:19:\"quote/theme.min.css\";i:364;s:23:\"read-more/style-rtl.css\";i:365;s:27:\"read-more/style-rtl.min.css\";i:366;s:19:\"read-more/style.css\";i:367;s:23:\"read-more/style.min.css\";i:368;s:18:\"rss/editor-rtl.css\";i:369;s:22:\"rss/editor-rtl.min.css\";i:370;s:14:\"rss/editor.css\";i:371;s:18:\"rss/editor.min.css\";i:372;s:17:\"rss/style-rtl.css\";i:373;s:21:\"rss/style-rtl.min.css\";i:374;s:13:\"rss/style.css\";i:375;s:17:\"rss/style.min.css\";i:376;s:21:\"search/editor-rtl.css\";i:377;s:25:\"search/editor-rtl.min.css\";i:378;s:17:\"search/editor.css\";i:379;s:21:\"search/editor.min.css\";i:380;s:20:\"search/style-rtl.css\";i:381;s:24:\"search/style-rtl.min.css\";i:382;s:16:\"search/style.css\";i:383;s:20:\"search/style.min.css\";i:384;s:20:\"search/theme-rtl.css\";i:385;s:24:\"search/theme-rtl.min.css\";i:386;s:16:\"search/theme.css\";i:387;s:20:\"search/theme.min.css\";i:388;s:24:\"separator/editor-rtl.css\";i:389;s:28:\"separator/editor-rtl.min.css\";i:390;s:20:\"separator/editor.css\";i:391;s:24:\"separator/editor.min.css\";i:392;s:23:\"separator/style-rtl.css\";i:393;s:27:\"separator/style-rtl.min.css\";i:394;s:19:\"separator/style.css\";i:395;s:23:\"separator/style.min.css\";i:396;s:23:\"separator/theme-rtl.css\";i:397;s:27:\"separator/theme-rtl.min.css\";i:398;s:19:\"separator/theme.css\";i:399;s:23:\"separator/theme.min.css\";i:400;s:24:\"shortcode/editor-rtl.css\";i:401;s:28:\"shortcode/editor-rtl.min.css\";i:402;s:20:\"shortcode/editor.css\";i:403;s:24:\"shortcode/editor.min.css\";i:404;s:24:\"site-logo/editor-rtl.css\";i:405;s:28:\"site-logo/editor-rtl.min.css\";i:406;s:20:\"site-logo/editor.css\";i:407;s:24:\"site-logo/editor.min.css\";i:408;s:23:\"site-logo/style-rtl.css\";i:409;s:27:\"site-logo/style-rtl.min.css\";i:410;s:19:\"site-logo/style.css\";i:411;s:23:\"site-logo/style.min.css\";i:412;s:27:\"site-tagline/editor-rtl.css\";i:413;s:31:\"site-tagline/editor-rtl.min.css\";i:414;s:23:\"site-tagline/editor.css\";i:415;s:27:\"site-tagline/editor.min.css\";i:416;s:25:\"site-title/editor-rtl.css\";i:417;s:29:\"site-title/editor-rtl.min.css\";i:418;s:21:\"site-title/editor.css\";i:419;s:25:\"site-title/editor.min.css\";i:420;s:24:\"site-title/style-rtl.css\";i:421;s:28:\"site-title/style-rtl.min.css\";i:422;s:20:\"site-title/style.css\";i:423;s:24:\"site-title/style.min.css\";i:424;s:26:\"social-link/editor-rtl.css\";i:425;s:30:\"social-link/editor-rtl.min.css\";i:426;s:22:\"social-link/editor.css\";i:427;s:26:\"social-link/editor.min.css\";i:428;s:27:\"social-links/editor-rtl.css\";i:429;s:31:\"social-links/editor-rtl.min.css\";i:430;s:23:\"social-links/editor.css\";i:431;s:27:\"social-links/editor.min.css\";i:432;s:26:\"social-links/style-rtl.css\";i:433;s:30:\"social-links/style-rtl.min.css\";i:434;s:22:\"social-links/style.css\";i:435;s:26:\"social-links/style.min.css\";i:436;s:21:\"spacer/editor-rtl.css\";i:437;s:25:\"spacer/editor-rtl.min.css\";i:438;s:17:\"spacer/editor.css\";i:439;s:21:\"spacer/editor.min.css\";i:440;s:20:\"spacer/style-rtl.css\";i:441;s:24:\"spacer/style-rtl.min.css\";i:442;s:16:\"spacer/style.css\";i:443;s:20:\"spacer/style.min.css\";i:444;s:20:\"table/editor-rtl.css\";i:445;s:24:\"table/editor-rtl.min.css\";i:446;s:16:\"table/editor.css\";i:447;s:20:\"table/editor.min.css\";i:448;s:19:\"table/style-rtl.css\";i:449;s:23:\"table/style-rtl.min.css\";i:450;s:15:\"table/style.css\";i:451;s:19:\"table/style.min.css\";i:452;s:19:\"table/theme-rtl.css\";i:453;s:23:\"table/theme-rtl.min.css\";i:454;s:15:\"table/theme.css\";i:455;s:19:\"table/theme.min.css\";i:456;s:23:\"tag-cloud/style-rtl.css\";i:457;s:27:\"tag-cloud/style-rtl.min.css\";i:458;s:19:\"tag-cloud/style.css\";i:459;s:23:\"tag-cloud/style.min.css\";i:460;s:28:\"template-part/editor-rtl.css\";i:461;s:32:\"template-part/editor-rtl.min.css\";i:462;s:24:\"template-part/editor.css\";i:463;s:28:\"template-part/editor.min.css\";i:464;s:27:\"template-part/theme-rtl.css\";i:465;s:31:\"template-part/theme-rtl.min.css\";i:466;s:23:\"template-part/theme.css\";i:467;s:27:\"template-part/theme.min.css\";i:468;s:30:\"term-description/style-rtl.css\";i:469;s:34:\"term-description/style-rtl.min.css\";i:470;s:26:\"term-description/style.css\";i:471;s:30:\"term-description/style.min.css\";i:472;s:27:\"text-columns/editor-rtl.css\";i:473;s:31:\"text-columns/editor-rtl.min.css\";i:474;s:23:\"text-columns/editor.css\";i:475;s:27:\"text-columns/editor.min.css\";i:476;s:26:\"text-columns/style-rtl.css\";i:477;s:30:\"text-columns/style-rtl.min.css\";i:478;s:22:\"text-columns/style.css\";i:479;s:26:\"text-columns/style.min.css\";i:480;s:19:\"verse/style-rtl.css\";i:481;s:23:\"verse/style-rtl.min.css\";i:482;s:15:\"verse/style.css\";i:483;s:19:\"verse/style.min.css\";i:484;s:20:\"video/editor-rtl.css\";i:485;s:24:\"video/editor-rtl.min.css\";i:486;s:16:\"video/editor.css\";i:487;s:20:\"video/editor.min.css\";i:488;s:19:\"video/style-rtl.css\";i:489;s:23:\"video/style-rtl.min.css\";i:490;s:15:\"video/style.css\";i:491;s:19:\"video/style.min.css\";i:492;s:19:\"video/theme-rtl.css\";i:493;s:23:\"video/theme-rtl.min.css\";i:494;s:15:\"video/theme.css\";i:495;s:19:\"video/theme.min.css\";}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (124,'https_detection_errors','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (125,'_site_transient_update_core','O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.3.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.3.2\";s:7:\"version\";s:5:\"6.3.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1697797945;s:15:\"version_checked\";s:5:\"6.3.2\";s:12:\"translations\";a:0:{}}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (126,'litespeed.conf.__activation','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (127,'litespeed.purge.queue','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (128,'litespeed.purge.queue2','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (136,'litespeed.cloud._summary','{\"curr_request.ver\":0,\"last_request.ver\":1697798022}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (138,'litespeed.conf.hash','Dr8UW7FDxti95ezhJlcPNP6pJHui9cPj','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (139,'litespeed.conf.auto_upgrade','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (140,'litespeed.conf.api_key','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (141,'litespeed.conf.server_ip','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (142,'litespeed.conf.guest','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (143,'litespeed.conf.guest_optm','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (144,'litespeed.conf.news','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (145,'litespeed.conf.guest_uas','[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"PTST\",\"HeadlessChrome\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (146,'litespeed.conf.guest_ips','[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (147,'litespeed.conf.cache','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (148,'litespeed.conf.cache-priv','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (149,'litespeed.conf.cache-commenter','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (150,'litespeed.conf.cache-rest','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (151,'litespeed.conf.cache-page_login','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (152,'litespeed.conf.cache-favicon','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (153,'litespeed.conf.cache-resources','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (154,'litespeed.conf.cache-mobile','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (155,'litespeed.conf.cache-mobile_rules','[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (156,'litespeed.conf.cache-browser','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (157,'litespeed.conf.cache-exc_useragents','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (158,'litespeed.conf.cache-exc_cookies','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (159,'litespeed.conf.cache-exc_qs','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (160,'litespeed.conf.cache-exc_cat','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (161,'litespeed.conf.cache-exc_tag','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (162,'litespeed.conf.cache-force_uri','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (163,'litespeed.conf.cache-force_pub_uri','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (164,'litespeed.conf.cache-priv_uri','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (165,'litespeed.conf.cache-exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (166,'litespeed.conf.cache-exc_roles','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (167,'litespeed.conf.cache-drop_qs','[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (168,'litespeed.conf.cache-ttl_pub','604800','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (169,'litespeed.conf.cache-ttl_priv','1800','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (170,'litespeed.conf.cache-ttl_frontpage','604800','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (171,'litespeed.conf.cache-ttl_feed','604800','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (172,'litespeed.conf.cache-ttl_rest','604800','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (173,'litespeed.conf.cache-ttl_browser','31557600','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (174,'litespeed.conf.cache-ttl_status','[\"403 3600\",\"404 3600\",\"500 3600\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (175,'litespeed.conf.cache-login_cookie','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (176,'litespeed.conf.cache-vary_group','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (177,'litespeed.conf.purge-upgrade','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (178,'litespeed.conf.purge-stale','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (179,'litespeed.conf.purge-post_all','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (180,'litespeed.conf.purge-post_f','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (181,'litespeed.conf.purge-post_h','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (182,'litespeed.conf.purge-post_p','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (183,'litespeed.conf.purge-post_pwrp','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (184,'litespeed.conf.purge-post_a','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (185,'litespeed.conf.purge-post_y','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (186,'litespeed.conf.purge-post_m','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (187,'litespeed.conf.purge-post_d','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (188,'litespeed.conf.purge-post_t','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (189,'litespeed.conf.purge-post_pt','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (190,'litespeed.conf.purge-timed_urls','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (191,'litespeed.conf.purge-timed_urls_time','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (192,'litespeed.conf.purge-hook_all','[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (193,'litespeed.conf.esi','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (194,'litespeed.conf.esi-cache_admbar','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (195,'litespeed.conf.esi-cache_commform','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (196,'litespeed.conf.esi-nonce','[\"stats_nonce\",\"subscribe_nonce\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (197,'litespeed.conf.util-instant_click','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (198,'litespeed.conf.util-no_https_vary','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (199,'litespeed.conf.debug-disable_all','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (200,'litespeed.conf.debug','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (201,'litespeed.conf.debug-ips','[\"127.0.0.1\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (202,'litespeed.conf.debug-level','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (203,'litespeed.conf.debug-filesize','3','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (204,'litespeed.conf.debug-cookie','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (205,'litespeed.conf.debug-collaps_qs','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (206,'litespeed.conf.debug-inc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (207,'litespeed.conf.debug-exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (208,'litespeed.conf.db_optm-revisions_max','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (209,'litespeed.conf.db_optm-revisions_age','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (210,'litespeed.conf.optm-css_min','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (211,'litespeed.conf.optm-css_comb','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (212,'litespeed.conf.optm-css_comb_ext_inl','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (213,'litespeed.conf.optm-ucss','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (214,'litespeed.conf.optm-ucss_inline','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (215,'litespeed.conf.optm-ucss_whitelist','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (216,'litespeed.conf.optm-ucss_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (217,'litespeed.conf.optm-css_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (218,'litespeed.conf.optm-js_min','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (219,'litespeed.conf.optm-js_comb','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (220,'litespeed.conf.optm-js_comb_ext_inl','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (221,'litespeed.conf.optm-js_exc','[\"jquery.js\",\"jquery.min.js\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (222,'litespeed.conf.optm-html_min','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (223,'litespeed.conf.optm-html_lazy','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (224,'litespeed.conf.optm-qs_rm','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (225,'litespeed.conf.optm-ggfonts_rm','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (226,'litespeed.conf.optm-css_async','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (227,'litespeed.conf.optm-ccss_per_url','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (228,'litespeed.conf.optm-ccss_sep_posttype','[\"page\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (229,'litespeed.conf.optm-ccss_sep_uri','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (230,'litespeed.conf.optm-css_async_inline','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (231,'litespeed.conf.optm-css_font_display','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (232,'litespeed.conf.optm-js_defer','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (233,'litespeed.conf.optm-emoji_rm','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (234,'litespeed.conf.optm-noscript_rm','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (235,'litespeed.conf.optm-ggfonts_async','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (236,'litespeed.conf.optm-exc_roles','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (237,'litespeed.conf.optm-ccss_con','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (238,'litespeed.conf.optm-js_defer_exc','[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (239,'litespeed.conf.optm-gm_js_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (240,'litespeed.conf.optm-dns_prefetch','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (241,'litespeed.conf.optm-dns_prefetch_ctrl','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (242,'litespeed.conf.optm-exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (243,'litespeed.conf.optm-guest_only','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (244,'litespeed.conf.object','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (245,'litespeed.conf.object-kind','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (246,'litespeed.conf.object-host','localhost','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (247,'litespeed.conf.object-port','11211','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (248,'litespeed.conf.object-life','360','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (249,'litespeed.conf.object-persistent','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (250,'litespeed.conf.object-admin','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (251,'litespeed.conf.object-transients','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (252,'litespeed.conf.object-db_id','0','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (253,'litespeed.conf.object-user','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (254,'litespeed.conf.object-pswd','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (255,'litespeed.conf.object-global_groups','[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (256,'litespeed.conf.object-non_persistent_groups','[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (257,'litespeed.conf.discuss-avatar_cache','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (258,'litespeed.conf.discuss-avatar_cron','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (259,'litespeed.conf.discuss-avatar_cache_ttl','604800','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (260,'litespeed.conf.optm-localize','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (261,'litespeed.conf.optm-localize_domains','[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/www.google.com\\/recaptcha\\/api.js\",\"https:\\/\\/www.google-analytics.com\\/analytics.js\",\"https:\\/\\/www.googletagmanager.com\\/gtm.js\",\"https:\\/\\/www.googletagservices.com\\/tag\\/js\\/gpt.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (262,'litespeed.conf.media-lazy','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (263,'litespeed.conf.media-lazy_placeholder','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (264,'litespeed.conf.media-placeholder_resp','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (265,'litespeed.conf.media-placeholder_resp_color','#cfd4db','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (266,'litespeed.conf.media-placeholder_resp_svg','<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (267,'litespeed.conf.media-lqip','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (268,'litespeed.conf.media-lqip_qual','4','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (269,'litespeed.conf.media-lqip_min_w','150','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (270,'litespeed.conf.media-lqip_min_h','150','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (271,'litespeed.conf.media-placeholder_resp_async','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (272,'litespeed.conf.media-iframe_lazy','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (273,'litespeed.conf.media-add_missing_sizes','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (274,'litespeed.conf.media-lazy_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (275,'litespeed.conf.media-lazy_cls_exc','[\"wmu-preview-img\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (276,'litespeed.conf.media-lazy_parent_cls_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (277,'litespeed.conf.media-iframe_lazy_cls_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (278,'litespeed.conf.media-iframe_lazy_parent_cls_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (279,'litespeed.conf.media-lazy_uri_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (280,'litespeed.conf.media-lqip_exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (281,'litespeed.conf.img_optm-auto','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (282,'litespeed.conf.img_optm-cron','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (283,'litespeed.conf.img_optm-ori','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (284,'litespeed.conf.img_optm-rm_bkup','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (285,'litespeed.conf.img_optm-webp','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (286,'litespeed.conf.img_optm-lossless','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (287,'litespeed.conf.img_optm-exif','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (288,'litespeed.conf.img_optm-webp_replace','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (289,'litespeed.conf.img_optm-webp_attr','[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"video.poster\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (290,'litespeed.conf.img_optm-webp_replace_srcset','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (291,'litespeed.conf.img_optm-jpg_quality','82','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (292,'litespeed.conf.crawler','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (293,'litespeed.conf.crawler-usleep','500','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (294,'litespeed.conf.crawler-run_duration','400','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (295,'litespeed.conf.crawler-run_interval','600','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (296,'litespeed.conf.crawler-crawl_interval','302400','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (297,'litespeed.conf.crawler-threads','3','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (298,'litespeed.conf.crawler-timeout','30','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (299,'litespeed.conf.crawler-load_limit','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (300,'litespeed.conf.crawler-sitemap','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (301,'litespeed.conf.crawler-drop_domain','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (302,'litespeed.conf.crawler-map_timeout','120','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (303,'litespeed.conf.crawler-roles','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (304,'litespeed.conf.crawler-cookies','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (305,'litespeed.conf.misc-heartbeat_front','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (306,'litespeed.conf.misc-heartbeat_front_ttl','60','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (307,'litespeed.conf.misc-heartbeat_back','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (308,'litespeed.conf.misc-heartbeat_back_ttl','60','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (309,'litespeed.conf.misc-heartbeat_editor','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (310,'litespeed.conf.misc-heartbeat_editor_ttl','15','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (311,'litespeed.conf.cdn','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (312,'litespeed.conf.cdn-ori','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (313,'litespeed.conf.cdn-ori_dir','[\"wp-content\",\"wp-includes\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (314,'litespeed.conf.cdn-exc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (315,'litespeed.conf.cdn-quic','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (316,'litespeed.conf.cdn-cloudflare','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (317,'litespeed.conf.cdn-cloudflare_email','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (318,'litespeed.conf.cdn-cloudflare_key','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (319,'litespeed.conf.cdn-cloudflare_name','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (320,'litespeed.conf.cdn-cloudflare_zone','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (321,'litespeed.conf.cdn-mapping','[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (322,'litespeed.conf.cdn-attr','[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (323,'_site_transient_timeout_browser_e3f8101c41b40572973227d0a64620d0','1698398974','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (324,'_site_transient_browser_e3f8101c41b40572973227d0a64620d0','a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"118.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (325,'_site_transient_timeout_php_check_18f908370f4cb169b20964c7203d6110','1698398975','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (326,'_site_transient_php_check_18f908370f4cb169b20964c7203d6110','a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (327,'litespeed.gui.lscwp_whm_install','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (328,'litespeed.gui.dismiss','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (329,'litespeed.gui._summary','{\"new_version\":1698398975,\"score\":1699003775}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (330,'litespeed.data.upgrading','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (331,'litespeed.admin_display.messages','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (332,'litespeed.admin_display.msg_pin','-1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (334,'_site_transient_timeout_community-events-cab5e53d30e250c23646e353c5aeb5ef','1697837379','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (335,'_site_transient_community-events-cab5e53d30e250c23646e353c5aeb5ef','a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"103.14.72.0\";}s:6:\"events\";a:0:{}}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (336,'_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3','1697837379','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (337,'_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Oct 2023 00:11:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.4-alpha-56702\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"State of the Word 2023 – Save the Date\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/news/2023/10/state-of-the-word-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Oct 2023 17:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"sotw\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"state of the word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16116\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:322:\"It’s time to save the date, December 11, 2023, for this year’s State of the Word 2023!\n\nState of the Word is the annual keynote address delivered by the WordPress project’s co-founder, Matt Mullenweg. Every year, the event shares reflections on the project’s progress and aspirations for the future of open source.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2933:\"\n<figure class=\"wp-block-image size-large\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=1024%2C576&#038;ssl=1\" alt=\"State of the Word 2023\" class=\"wp-image-16119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>It’s time to <a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2023&amp;dates=20231211T170000Z/20231211T190000Z&amp;details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+Matt+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+Malaga,+Spain,+and+is+free+for+all+to+watch+or+attend+in+person+with+a+ticket.%0A%0Ahttps://wordpress.org/news/2023/10/state-of-the-word-2023/\">save the date</a>, December 11, 2023, for this year’s State of the Word!</p>\n\n\n\n<p>State of the Word is the annual keynote address delivered by the WordPress project’s co-founder, <a href=\"https://ma.tt/\">Matt Mullenweg</a>. Every year, the event shares reflections on the project’s progress and aspirations for the future of open source.&nbsp;</p>\n\n\n\n<p>For the first time, State of the Word will take place outside North America–this time with the Spanish community in <strong>Madrid, Spain</strong>. The event will be live-streamed to WordPress enthusiasts around the globe via WordPress.org social media platforms.&nbsp;</p>\n\n\n\n<p>Join Matt as he provides a retrospective of 2023, demos the latest in WordPress tech, and comments on the future of the WordPress open source project.</p>\n\n\n\n<p>Details including how to reserve a ticket for the in-person event, the link to watch the live stream, and information on how to submit questions for the Q&amp;A portion will be provided in November and shared on <a href=\"https://wordpress.org\">WordPress.org</a> and affiliated social media accounts.</p>\n\n\n\n<p></p>\n\n\n\n<p><em>Thanks to <a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a> and <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> for reviewing this post.</em> </p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16116\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"A New WordPress Showcase\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2023/10/a-new-wordpress-showcase/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 17:34:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Meta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16173\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:406:\"The journey to update WordPress.org continues with the launch of a new Showcase design. The Showcase is a natural starting point for visitors arriving on WordPress.org, and it both inspires creativity and demonstrates what’s possible with WordPress. From unique personal blogs and portfolios to enterprises and celebrity fan sites, the Showcase celebrates WordPress’s flexibility, popularity, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7609:\"\n<p>The <a href=\"https://wordpress.org/news/category/meta/\">journey to update WordPress.org</a> continues with the launch of a new <a href=\"https://wordpress.org/showcase/\">Showcase</a> design. The Showcase is a natural starting point for visitors arriving on WordPress.org, and it both inspires creativity and demonstrates what’s possible with WordPress. From unique personal blogs and portfolios to enterprises and celebrity fan sites, the Showcase celebrates WordPress’s flexibility, popularity, and the freedom to own one’s content.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-1 is-style-rectangular wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"954\" data-id=\"16187\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=1024%2C954&#038;ssl=1\" alt=\"Screenshots from the new Showcase design\" class=\"wp-image-16187\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=1024%2C954&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=300%2C280&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=768%2C716&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=1536%2C1432&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=2048%2C1909&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"954\" data-id=\"16184\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=1024%2C954&#038;ssl=1\" alt=\"A grid of new design elements\" class=\"wp-image-16184\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=1024%2C954&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=300%2C280&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=768%2C716&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=1536%2C1432&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=2048%2C1909&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-id=\"16185\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=1024%2C576&#038;ssl=1\" alt=\"A collage of Showcased websites\" class=\"wp-image-16185\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=2048%2C1152&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n</figure>\n\n\n\n<p>This new design provides much-needed improvements to the aesthetics and user experience. It emphasizes bold visuals and a more dynamic browsing experience through tags and categories. Individual site pages now include desktop and mobile screenshots, while the site introduces an improved layout on mobile devices.&nbsp;</p>\n\n\n\n<p>This redesign also brings new <a href=\"https://wordpress.org/blocks/\">block-based functionality</a> and several components that will be used elsewhere on WordPress.org. All of this was made possible through collaboration between Design, Marketing, and Meta teams. Thank you to everyone.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium\"><a href=\'https://profiles.wordpress.org/adamwood/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>adamwood</a> <a href=\'https://profiles.wordpress.org/alexstine/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>alexstine</a> <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a> <a href=\'https://profiles.wordpress.org/bengreeley/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bengreeley</a> <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a> <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> <a href=\'https://profiles.wordpress.org/dufresnesteven/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dufresnesteven</a> <a href=\'https://profiles.wordpress.org/eidolonnight/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>eidolonnight</a> <a href=\'https://profiles.wordpress.org/fcoveram/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>fcoveram</a> <a href=\'https://profiles.wordpress.org/joen/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joen</a> <a href=\'https://profiles.wordpress.org/jonoaldersonwp/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jonoaldersonwp</a> <a href=\'https://profiles.wordpress.org/jpantani/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jpantani</a> <a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a> <a href=\'https://profiles.wordpress.org/matt/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matt</a> <a href=\'https://profiles.wordpress.org/markoserb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>markoserb</a> <a href=\'https://profiles.wordpress.org/ndiego/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ndiego</a> <a href=\'https://profiles.wordpress.org/pablohoneyhoney/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>pablohoneyhoney</a> <a href=\'https://profiles.wordpress.org/paulkevan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>paulkevan</a> <a href=\'https://profiles.wordpress.org/renyot/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>renyot</a> <a href=\'https://profiles.wordpress.org/ryelle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ryelle</a> <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a> <a href=\'https://profiles.wordpress.org/_dorsvenabili/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>_dorsvenabili</a></p>\n\n\n\n<p>If you would like to propose a change or report an issue, please do so in the <a href=\"https://github.com/WordPress/wporg-showcase-2022\">wporg-showcase-2022</a>&nbsp; GitHub repository. Also, make sure to join the <a href=\"https://wordpress.slack.com/archives/C04U953K77A\">#website-redesign</a> Slack channel if you are interested in additional updates coming to WordPress.org and want to contribute.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.4 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Oct 2023 17:48:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6-4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16147\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"WordPress 6.4 RC1 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s new and how to get involved.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11963:\"\n<p>The first release candidate (RC1) for WordPress 6.4 is now available!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC1 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains vital to ensure that everything in WordPress 6.4 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.4 RC1 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress site.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-RC1</code></li>\n</ol>\n\n\n\n<p>The current target for the WordPress 6.4 release is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a>.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\"><strong>underrepresented gender release squad</strong></a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.4 RC1?</h2>\n\n\n\n<p>This release contains 420 enhancements and 445 bug fixes for the editor, including more than <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.4&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">260 tickets for WordPress 6.4 core</a>. Browse the technical details for all issues recently addressed using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F12%2F2023..10%2F17%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since Beta 4</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Highlights</h3>\n\n\n\n<p>WordPress 6.4 is the third and last major release of 2023. It introduces a multi-purpose default theme, new features, and a keen focus on details to enhance every aspect of your creation journey—from site editing and design to writing flows.</p>\n\n\n\n<ul>\n<li><strong>A new flexible default theme</strong> brings together the latest and greatest of WordPress. Discover its vast collection of templates and patterns to tweak and match your brand. Built for versatility, <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\"><strong>Twenty Twenty-Four</strong></a> is an ideal fit for nearly any type of website.</li>\n\n\n\n<li>Enable <strong>lightbox functionality</strong> in images for immersive viewing experiences.</li>\n\n\n\n<li><strong>Organize your patterns with your own custom categories</strong>. Find them all more intuitively with advanced filtering in the Patterns section of the inserter.</li>\n\n\n\n<li><strong>Enjoy <a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">more writing improvements</a></strong>, including new keyboard shortcuts, smoother list merging, and enhanced control over your link settings. A revamped toolbar experience for Navigation, List, and Quote blocks ensures cohesive and organized access to the tooling options you work with.</li>\n\n\n\n<li><strong>A redesigned </strong><a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\"><strong>Command Palette</strong></a><strong> with new commands</strong> helps you find what you need, perform tasks efficiently, and speed up your workflow.</li>\n\n\n\n<li><strong>Rename Group blocks</strong> to organize and distinguish areas of your content easily.</li>\n\n\n\n<li>See and locate your content’s media assets at a glance with new <strong>gallery and image previews in List View</strong>.</li>\n\n\n\n<li>Build beautiful yet functional layouts with an <strong>expanded set of design tools</strong>. Play with background images in Group blocks for unique creative designs, keep image dimensions consistent with placeholder aspect ratios, and effortlessly add buttons to your Navigation block without custom CSS—among other new capabilities.</li>\n\n\n\n<li><strong>Block Hooks</strong> enable developers to automatically insert blocks at their chosen content locations, enriching the extensibility of block themes through plugins. While developer-centric, this new feature improves your building experience with blocks and gives you complete control to customize Block Hooks to your needs.</li>\n\n\n\n<li><strong>Over 60 accessibility updates</strong>, including significant List View enhancements, aria-label support for the Navigation block, and upgrades to the admin user interface.</li>\n\n\n\n<li><strong>More than 100 performance updates</strong>, focusing on template loading performance for classic and block themes, usage of the script loading strategies “defer” and “async,” and optimization of autoloaded options.</li>\n</ul>\n\n\n\n<p>Are you looking for a deeper dive into details and technical notes? <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-4/\">These recent posts</a> cover a few of the latest updates:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/changes-to-attachment-pages/\">Changes to attachment pages for improved SEO</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/17/miscellaneous-editor-changes-in-wordpress-6-4/\">Miscellaneous Editor changes in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/15/introducing-block-hooks-for-dynamic-blocks/\">Introducing Block Hooks for dynamic blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/17/script-loading-changes-in-wordpress-6-4/\">Script loading changes in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/17/improvements-to-template-loading-in-wordpress-6-4/\">Improvements to template loading in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/introducing-admin-notice-functions-in-wordpress-6-4/\">Introducing admin notice functions in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/editor-components-updates-in-wordpress-6-4/\">Updates to user-interface components in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/new-registerinsertermediacategory-api/\">New `registerInserterMediaCategory` API</a></li>\n</ul>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Ways to contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a community of people collaborating on and contributing to its development. The resources below outline various ways you can help, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to developing the software and ensuring its quality. It’s also a meaningful way for anyone to contribute—whether you have experience or not. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Check out this guide</a> for detailed instructions on testing key features in WordPress 6.4.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>During the release candidate phase of WordPress 6.4, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>Do you build themes and plugins? Your products play an integral role in extending the functionality and value of WordPress for users worldwide.</p>\n\n\n\n<p>You most likely have already been testing your latest themes and plugins with the WordPress 6.4 betas. With RC1, you will want to complete your testing and update the <em>&#8220;Tested up to&#8221;</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin&#8217;s readme file</a> to 6.4.</p>\n\n\n\n<p>Please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> if you find compatibility issues.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Português? Русский? 日本? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help translate WordPress into more than 100 languages</a>. This release also marks the <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a> point of the 6.4 release cycle.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A haiku for RC1</h2>\n\n\n\n<p>RC1 in hand<br>WordPress evolves and takes shape<br>Testing, a sneak peek, in place</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16147\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WP Briefing: Episode 64: Patterns in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16109\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:194:\"Join WordPress Executive Director, Josepha Haden Chomphosy, as she goes back to the basics and offers some insight into block patterns for WordPress. Don’t miss this exciting insider’s look!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://wordpress.org/news/files/2023/10/WPB064.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7408:\"\n<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she goes back to the basics and offers some insight into block patterns for WordPress. Don&#8217;t miss this exciting insider&#8217;s look!</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/using-block-patterns/\">Using Block Patterns</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/patterns/\">Pattern Library</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/taking-advantage-of-query-loops/\">Taking Advantage of Query Loops</a></li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=social\">The WP Annual Survey is available</a>! Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. </li>\n\n\n\n<li><a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia</a> is searching for volunteers for the upcoming WordCamp on March 7–9, 2024. They are looking for Contributor Stories, Event Volunteers, Emcee support, A/V Team Crew, and even designers to help create the official Wapuu for the event.</li>\n\n\n\n<li><a href=\"https://www.meetup.com/pro/wordpress/\">Local WordCamp Meetups</a>! Use this opportunity to find upcoming local events or volunteer to help at the next one. They are an excellent opportunity to meet with others in the community.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16109\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28] (Intro music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> Today&#8217;s briefing topic is going to take a bit of a back-to-basics look at block patterns. Block patterns are one of my favorite enhancements that came through the Gutenberg project, and they&#8217;re pretty much exactly what they sound like. Groups of blocks that are arranged together. These patterns can be as simple as a block that holds a series of social sharing icons, but they can also be as complex as an entire landing page, complete with a call to action and interactive gallery.</p>\n\n\n\n<p>They can be used as a starting point where you activate an entire pattern and then modify the pieces that don&#8217;t quite work for you or as a sort of inspirational catalog of design elements for you to build your own patterns from.&nbsp;</p>\n\n\n\n<p>So, where do these block patterns come from? Who created them? As with most things in WordPress, the answer is lots of places. Some patterns are included with WordPress by default, and there are also sometimes specialized block patterns that are bundled with a particular theme or plugin. There&#8217;s also a pattern library that includes both curated block patterns and all the patterns that are created and shared by the WordPress community itself.</p>\n\n\n\n<p>So from the CMS, from themes, from plugins, from designers, from hobbyists, from people who just like love creating things and putting it out in the world, that&#8217;s, that&#8217;s where those patterns come from. But you can also create and curate your own block patterns, either to share back to the community as some folks do or because you are a site administrator and everyone needs to be able to add, I don&#8217;t know, an author block or something. But you don&#8217;t always want to be the one that has to put the photo on the page.&nbsp;</p>\n\n\n\n<p>There are a few blocks that have their patterns built into settings, most notably the Query Loop Block. I&#8217;ll share a tutorial about how to work with that in the show notes, but ultimately, what&#8217;s important to remember here is that block patterns are a really powerful tool with a lot of ways to implement them. You can start as simple as you want or as complex as you want, but either way, getting familiar with this concept in the software will give you a leg up on your next project.</p>\n\n\n\n<p>[00:02:53] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:03:00] <strong>Josepha:</strong> That brings us now to our small list of big things.&nbsp;</p>\n\n\n\n<p>First up, the annual survey is available. Each year, the WordPress community, so users, site builders, extenders, contributors, artists, you all provide valuable feedback through an annual survey. And every year, I look into the results to get a sense for what areas need the most attention in the project. So click the link in the show notes to take the 2023 survey and help co-create WordPress.&nbsp;</p>\n\n\n\n<p>The next thing on our small list of big things is WordCamp Asia is currently searching for volunteers for the upcoming event on March 7th through 9th, 2024. They&#8217;re looking for Contributor Stories, Event Volunteers, Emcee support, A/V Team Crew, and even designers to help create the official Wapuu for the event. I&#8217;ll include a link to applications for that in the show notes as well.&nbsp;</p>\n\n\n\n<p>And finally, I think it&#8217;s important to mention that if you don&#8217;t really know what a WordCamp is, so you don&#8217;t really understand why you should volunteer to help this one, or why you would want to, then head over to your local meetup. If you look in your WordPress dashboard, there&#8217;s a widget in there that tells you when the next local event will be. And I know that they will all be delighted to have you there. And who knows, maybe your city will be the next to host a WordCamp. I&#8217;ll also include in the show notes just a list of all of the meetup groups that we have in the world. And so if you don&#8217;t trust your dashboard or you don&#8217;t share your location there for some reason, you can just find it on your own.</p>\n\n\n\n<p>And that, my friends, is your small of big things.</p>\n\n\n\n<p>[00:04:32] <strong>Josepha:</strong> Thanks for tuning in today for the WordPress Briefing. Don&#8217;t forget to follow us on your favorite podcast app, or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever a new episode drops. If you liked what you heard today, share it with a fellow WordPresser. Or, if you had questions about what you heard, you can share those directly with me at wpbriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thanks again for listening, and I&#8217;ll see you in a couple of weeks.&nbsp;</p>\n\n\n\n<p>[00:05:00] (Music outro)</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16109\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WordPress 6.3.2 – Maintenance and Security release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2023/10/wordpress-6-3-2-maintenance-and-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Oct 2023 20:44:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16122\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"This security and maintenance release features 19 bug fixes on Core, 22 bug fixes for the Block Editor, and 8 security fixes. WordPress 6.3.2 is a short-cycle release. You can review a summary of the maintenance updates in this release by reading the Release Candidate announcement. Because this is a security release, it is recommended [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9836:\"\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?milestone=6.3.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">19 bug fixes on Core</a>, 22 bug fixes for the Block Editor, and 8 security fixes.</p>\n\n\n\n<p>WordPress 6.3.2 is a short-cycle release. You can review a summary of the maintenance updates in this release by reading the <a href=\"https://make.wordpress.org/core/2023/10/06/wordpress-6-3-2-rc1-is-now-available/\">Release Candidate announcement</a>. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. Backports are also available for other major WordPress releases, 4.1 and later.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-4/\">version 6.4</a> planned for 7 November 2023.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.3.2.zip\">download WordPress 6.3.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-3-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for responsibly reporting vulnerabilities, and allowing them to be fixed in this release:</p>\n\n\n\n<ul>\n<li>Marc Montpas of Automattic for finding a potential disclosure of user email addresses.</li>\n\n\n\n<li>Marc Montpas of Automattic for finding an RCE POP Chains vulnerability.</li>\n\n\n\n<li>Rafie Muhammad and Edouard L of <a href=\"https://patchstack.com/\">Patchstack</a> along with a WordPress commissioned third-party audit for each independently identifying a XSS issue in the post link navigation block.</li>\n\n\n\n<li><a href=\"https://www.linkedin.com/in/audrasjb/\">Jb Audras</a> of the WordPress Security Team and Rafie Muhammad of <a href=\"https://patchstack.com/\">Patchstack</a> for each independently discovering an issue where comments on private posts could be leaked to other users.</li>\n\n\n\n<li>John Blackbourn (WordPress Security Team), <a href=\"https://hackerone.com/jamesgol?type=user\">James Golovich</a>, <a href=\"https://hackerone.com/jdgrimes\">J.D Grimes</a>, <a href=\"https://hackerone.com/numan\">Numan Turle</a>, <a href=\"https://hackerone.com/whitecybersec?type=user\">WhiteCyberSec</a> for each independently identifying a way for logged-in users to execute any shortcode.</li>\n\n\n\n<li><a href=\"https://facebook.com/zino.abdrahim\">mascara7784</a> and a third-party security audit for identifying a XSS vulnerability in the application password screen.</li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> of the WordPress Core Team for identifying XSS vulnerability in the footnotes block.</li>\n\n\n\n<li><a href=\"https://hackerone.com/s5s\">s5s</a> and <a href=\"http://twitter.com/Raoufmaklouf\">raouf_maklouf</a> for independently identifying a cache poisoning DoS vulnerability.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> and <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, with the help of<a href=\"https://profiles.wordpress.org/davidbaumwald/\"> David Baumwald</a> on mission control.</p>\n\n\n\n<p>WordPress 6.3.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance and security fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/akihiroharai\">Akihiro Harai</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/antpb\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/aurooba\">Aurooba Ahmed</a>, <a href=\"https://profiles.wordpress.org/scruffian\">Ben Dwyer</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/coreyw\">Corey Worrell</a>, <a href=\"https://profiles.wordpress.org/colorful tones\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/david.binda\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/desmith\">David E. Smith</a>, <a href=\"https://profiles.wordpress.org/dsas\">Dean Sas</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhruvishah2203\">Dhruvi Shah</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham S.</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/Mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/huzaifaalmesbah\">Huzaifa Al Mesbah</a>, <a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/greenshady\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kimannwall\">Kim Coleman</a>, <a href=\"https://profiles.wordpress.org/lhe2012\">LarryWEB</a>, <a href=\"https://profiles.wordpress.org/lgladdy\">Liam Gladdy</a>, <a href=\"https://profiles.wordpress.org/iammehedi1\">Mehedi Hassan</a>, <a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/nicolefurlan\">Nicole Furlan</a>, <a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/paulkevan\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pooja1210\">Pooja N Muchandikar</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar\">Rajin Sharwar</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shailu25\">Shail Mehta</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/tykoted\">Teddy Patriarca</a>, <a href=\"https://profiles.wordpress.org/TimothyBlynJacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/zunaid321\">Zunaid Amin</a>, <a href=\"https://profiles.wordpress.org/ahardyjpl\">ahardyjpl</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">beryldlg</a>, <a href=\"https://profiles.wordpress.org/floydwilde\">floydwilde</a>, <a href=\"https://profiles.wordpress.org/jastos\">jastos</a>, <a href=\"https://profiles.wordpress.org/martin.krcho\">martin.krcho</a>, <a href=\"https://profiles.wordpress.org/masteradhoc\">masteradhoc</a>, <a href=\"https://profiles.wordpress.org/petitphp\">petitphp</a>, <a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/zieladam\">zieladam</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C055Y7FKS7N\">#6-4-release-leads channels</a>. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p><em>Already testing WordPress 6.4? The fourth beta is now available (<a href=\"https://wordpress.org/wordpress-6.4-beta4.zip\">zip</a>) and it contains these security fixes. For more on 6.4, see the&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\" target=\"_blank\">beta 3 announcement post</a>.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to<em> <a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">@chanthaboune</a>, </em></em><a href=\"https://profiles.wordpress.org/peterwilsoncc/\">@peterwilsoncc</a><em><em> and <a href=\"https://profiles.wordpress.org/rawrly/\">@rawrly</a></em> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16122\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.4 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 16:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16101\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:206:\"WordPress 6.4 Beta 3 is now ready for testing!\n\nThis version is under development, so please do not install, run, or test it on production websites. Learn what\'s new and how to get involved in beta testing.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7440:\"\n<p>WordPress 6.4 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 3 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-beta3</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\"><strong>underrepresented gender release squad</strong></a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> for details.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Your help testing WordPress 6.4 Beta 3 is key to ensuring its quality. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 3</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Update on the Font Library</h2>\n\n\n\n<p><strong>The Font Library feature, initially planned for WordPress 6.4, is now set to release in 6.5</strong>. WordPress is committed to delivering the best possible experience. This decision allows time to address enhancement opportunities, <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\" data-type=\"link\" data-id=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">test</a>, and get enough feedback to meet WordPress&#8217;s quality standards. Thanks for your support as contributors work towards an exceptional Font Library experience.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 3 contains more than 60 updates since the Beta 2 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F04%2F2023..10%2F10%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">29 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F04%2F2023..10%2F10%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since Beta 2</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p>Beta 3 arrives<br>Testing where progress derives<br>Iterate, it thrives</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: </em><a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a> and <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.4 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 17:25:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:288:\"WordPress 6.4 Beta 2 is now ready for testing!\n\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 2 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8284:\"\n<p>WordPress 6.4 Beta 2 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 2 in four ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-beta2</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a> to increase participation and partnership with those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> and tune into <a href=\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\">Episode 63 of the WP Briefing podcast</a> for details.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How to get involved with testing</h2>\n\n\n\n<p>Your help testing the WordPress 6.4 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/blob/a854e6e7a2a49a6b1ec5ef377c756a30e1c7ac5a/lib/experimental/fonts/font-library/README.md\">Font Library feature</a>, currently available in <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">Gutenberg 16.7</a>, requires more testing and feedback to ensure it is ready for inclusion in the upcoming 6.4 release. <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">Check out this guide for detailed test instructions</a>.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 2</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 2 contains more than 50 updates since the Beta 1 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=09%2F27%2F2023..10%2F03%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">18 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=09%2F27%2F2023..10%2F03%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since Beta 1</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Note on Twenty Twenty-Four</h3>\n\n\n\n<p>Please note that some images in the Twenty Twenty-Four theme may not load correctly. A fix is in the works! Learn more on this <a href=\"https://core.trac.wordpress.org/ticket/59526\">Trac ticket</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Note on pattern management improvements in non-block themes</h3>\n\n\n\n<p>While WordPress 6.4 will bring several exciting pattern advancements, improvements to pattern management in non-block themes will eventually be addressed in WordPress 6.5. The <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Beta 1 announcement</a> has been updated to reflect this change accordingly.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p>Not the first, nor last<br>A second space to reflect<br>Both new and not new</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/ironprogrammer/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ironprogrammer</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WP Briefing: Episode 63: A WordPress 6.4 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16050\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:274:\"Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest Sarah Norris, one of the Editor Tech leads for this release. Don\'t miss this opportunity for an insider\'s look!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2023/09/WPB063-Enhanced.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:40977:\"\n<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest Sarah Norris, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Guest: <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a><br>Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo: <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production: <a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>TwentyTwentyFour <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Theme</a> \n<ul>\n<li><a href=\"https://github.com/WordPress/twentytwentyfour\">Repo</a></li>\n\n\n\n<li><a href=\"https://www.figma.com/file/AlYr03vh4dVimwYwQkTdf6/Twenty-Twenty-Four?type=design&amp;node-id=16-14852&amp;mode=design\">Figma File</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/51132\">Image Lightbox Github</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\">Upcoming WordPress Meetings</a> for Contributors</li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li>Find announcements for WordPress 6.4 Beta at:\n<ul>\n<li><a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#Core</a> Slack Channel</li>\n\n\n\n<li><a href=\"https://wordpress.org/news/\">WordPress.org/news/</a></li>\n</ul>\n</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/06/documentation-translation-localization/\" target=\"_blank\">Proposal: Documentation translation/localization</a></li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/09/20/seeking-proposals-for-interop-2024/\" target=\"_blank\">Seeking proposals for Interop 2024</a>&nbsp;&#8211; Interop 2024 is happening! WordPress developers, please contribute your proposals for 2024&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/web-platform-tests/interop/issues/new/choose\" target=\"_blank\">on GitHub</a>&nbsp;or as a comment on this post.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/15/wordcamp-us-2023-qa/\" target=\"_blank\">WordCamp US 2023 Q&amp;A</a> &#8211; With a successful WCUS in the books, an extensive list of post-event questions and answers are available and inspired by the event&#8217;s community and <a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=3Fa0Q-brSeI\" target=\"_blank\">Q&amp;A</a>.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/2023/09/13/accessibility-office-hours/\" target=\"_blank\">Accessibility Office Hours</a>&nbsp;&#8211; In an effort to improve accessibility knowledge in the WordPress project,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/\" target=\"_blank\">the accessibility team</a>&nbsp;will hold Office Hours every Wednesday at 14:00 UTC</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16050\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project some insight into the community that supports it. And get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> I have with me today, Sarah Norris. She is the Core Tech Editor in the WordPress 6.4 release. Welcome, Sarah.</p>\n\n\n\n<p>[00:00:47] <strong>Sarah:</strong> Oh, hi, and thanks for having me.</p>\n\n\n\n<p>[00:00:50] <strong>Josepha:</strong> First, I should give everyone kind of a concept of what we&#8217;re doing.</p>\n\n\n\n<p>So this is the WordPress 6.4 sneak peek episode of our podcast, which means that we&#8217;re going to talk a little bit about like the stuff that we are excited to get into the release stuff that we&#8217;re hoping is actually going to make it into the final release. But also, we&#8217;re going to talk a little bit about like stuff that we wish people knew.</p>\n\n\n\n<p>That we were working on. Things that are going to be really cool for users or developers or plugin authors, theme authors, things like that, that otherwise people would miss because it&#8217;s just hard to see. And so before we get started on all of that, is this your first release where you&#8217;re part of a squad like this?</p>\n\n\n\n<p>[00:01:31] <strong>Sarah:</strong> Ah, so, it&#8217;s actually my second. I was part of 6.1 as well. I led the default theme of 2023. But I am finding that the experience is a little bit different. So I&#8217;m still learning probably just as much.&nbsp;</p>\n\n\n\n<p>[00:01:42] <strong>Josepha:</strong> Yeah, absolutely. Well, and in 6.1 versus 6.4, for one, the themes are very different. Like the default themes are very different, but also the tasks involved with leading a default theme are very different from like leading things happening in the core editor in that Gutenberg plugin.</p>\n\n\n\n<p>[00:02:01] <strong>Sarah:</strong> Yeah, there&#8217;s so many different tasks. Yeah, like, I guess maybe there&#8217;s such, there&#8217;s maybe just like a set of tasks for every part of the release squad. But they&#8217;re so different. And much more involved.</p>\n\n\n\n<p>[00:02:12] <strong>Josepha:</strong> Yeah, absolutely. And as of the time of this recording, we&#8217;re recording this on September 27th. It comes out a little bit later. But as of the time of this recording, like we just wrapped up beta 1 for WordPress 6.4 yesterday. But I understand that, like an hour ago, you wrapped up a final release of the Gutenberg plugin as well.</p>\n\n\n\n<p>So you&#8217;re just kind of everywhere with us right now.</p>\n\n\n\n<p>[00:02:36] <strong>Sarah:</strong> Yeah, that&#8217;s exactly right. Yeah, we tried to make the beta 1 for 6.4 and the latest release of Gutenberg quite close together to make it easier to, to merge those latest changes for beta 1 of 6.4. So yes, that&#8217;s why it&#8217;s so close together, and fingers crossed, they both went really smoothly, so I&#8217;m really happy about that.</p>\n\n\n\n<p>[00:02:53] <strong>Josepha:</strong> Now we all sit around and watch the support queues and hope. That part, the sitting around and watching the support queues, is both my most favorite and least favorite sometimes part of releases. Like, it&#8217;s a little bit my most favorite because I get to talk to our support folks. I&#8217;m like, hey, is anything happening? But also, it&#8217;s my least favorite because it&#8217;s like the Schrödinger&#8217;s cat of releases. You&#8217;re like, as long as I don&#8217;t look at it, it could be all well or all bad, and I just don&#8217;t know.</p>\n\n\n\n<p>[00:03:23] <strong>Sarah:</strong> I hear you. I&#8217;ve just been doing something similar with watching test releases.</p>\n\n\n\n<p>[00:03:27] <strong>Josepha:</strong> Yeah. Just waiting and waiting and waiting. Yeah, absolutely. Absolutely.</p>\n\n\n\n<p>Well, let&#8217;s talk a little bit about 6.4. So WordPress 6.4 is our third major release of 2023, which is kind of a big deal for one because, like, three major releases a year is always exciting. But this particular one is, on the one hand, much larger from a feature standpoint than we kind of expected it to be, or so far, it looks like it&#8217;s going to be a bit larger than we expected.</p>\n\n\n\n<p>But also, it is our second iteration of an underrepresented gender release squad. Which I am very excited about. It&#8217;s a way for us to kind of bring in a lot of voices that otherwise we don&#8217;t see in the space. And so we&#8217;re going to just kind of talk through both of those things today. But let&#8217;s start with first: what are the things that are going into the release that you personally are most excited about, that you are most interested in making sure that we get all the way to the end of the release cycle?</p>\n\n\n\n<p>[00:04:27] <strong>Sarah:</strong> So, ones that I am particularly excited for. So, the first one on my list is the Font Library. This is looking really good to include as well. So it&#8217;s gonna do your way for users to manage fonts across their site regardless of their active themes. So similar how to how their media library works at the moment for images and other media.</p>\n\n\n\n<p>[00:04:44] <strong>Josepha:</strong> And if I recall correctly when I was looking at the prototypes for that, like the early demos of it, that has a lot of local font management as well, which helps us with GDPR concerns that we have had with font management in the CMS for a while. One, is that still correct? And two, does it look like it&#8217;s going to make it into the release?</p>\n\n\n\n<p>[00:05:04] <strong>Sarah:</strong> Yes. Yeah. Both correct. Yes. Yeah. Very easy. Yeah, that&#8217;s exactly right. So yeah, all the fonts will be managed locally. So, including things like Google Fonts. And any of the popular libraries and the way it&#8217;s been built, as it calls its files like this, it&#8217;s been built with extensibility in mind. So yeah, hopefully, the possibility should be endless for any number of font collections to be added.</p>\n\n\n\n<p>[00:05:23] <strong>Josepha:</strong> Yeah. Yeah. I, I know, for folks who are listening to this later, hopefully not much later, but if you are listening to this between when beta 1 came out and between and beta 2 is coming out, we didn&#8217;t get as much of that into beta 1 as we expected, but beta 2 should have a good chunk of it in there.</p>\n\n\n\n<p>So get out there and test that.</p>\n\n\n\n<p>[00:05:43] <strong>Sarah:</strong> It&#8217;s also just been released with Gutenberg 16.7 as well. So, I guess for anyone that you just mentioned listening in between.&nbsp;</p>\n\n\n\n<p>[00:05:51] <strong>Josepha:</strong> I&#8217;m one of those folks that has not; I don&#8217;t run trunk because I&#8217;m not that good with like preventing WordPress from falling apart. I&#8217;m not a developer, but I do run the nightlies and for the major releases for Core, and I run also the beta of Gutenberg. And so, I got both updates done this morning and started going in and looking at everything because I don&#8217;t run trunk. I didn&#8217;t have some of the weird edge cases that I saw reported over the last few weeks, which is probably good.&nbsp;</p>\n\n\n\n<p>[00:06:21] <strong>Josepha:</strong> But also, if anyone&#8217;s running trunk and is running all of the nightlies of anything, let us know where the problems are because there are not a lot of you. It feels like, like, a thousand people in the particular combination. What else is in there that you are very excited to see?</p>\n\n\n\n<p>[00:06:37] <strong>Sarah:</strong> I&#8217;m also looking forward to, so we have a new feature called Block Hook, and for anyone who follows Gutenberg, you might have heard it&#8217;s called Auto Inserting Blocks, but we&#8217;ve renamed it to Block Hook. And yes, this is another powerful feature that expands the extensibility of block themes. And so it allows plugins to automatically insert blocks into content relative to another block.</p>\n\n\n\n<p>And so, a good example that we&#8217;ve been using is automatically adding a like button to the post content block. And so yeah, I think it&#8217;s a, it&#8217;s maybe a more developer-centric feature.&nbsp;</p>\n\n\n\n<p>[00:07:09] <strong>Josepha:</strong> So, like, it detects what block you have and suggests bits and pieces that otherwise would make sense there that other people are usually using in those blocks.</p>\n\n\n\n<p>[00:07:20] <strong>Sarah:</strong> Yeah. Yeah. So you can add all through JSON as well. You can add a block that will automatically be added.</p>\n\n\n\n<p>[00:07:25] <strong>Josepha:</strong> All right. Excellent. That was part of the Interactivity API, or is, is early parts of it rather, I guess.</p>\n\n\n\n<p>[00:07:35] <strong>Sarah:</strong> Yes, that&#8217;s right. Yeah. Yeah. It&#8217;s the start.</p>\n\n\n\n<p>[00:07:39] <strong>Josepha:</strong> Another thing that is a part of the Interactivity API, which we&#8217;ve been working on, folks. I think everybody knows for like a year or two. The other part that is shipping in 6.4 is, I think, the Lightbox for images. Is that right?</p>\n\n\n\n<p>[00:07:55] <strong>Sarah:</strong> Yes, that&#8217;s right. Yes. And yeah, that&#8217;s due to be included with 6.4 as well.</p>\n\n\n\n<p>[00:07:59] <strong>Josepha:</strong> I&#8217;m going to just tell us all a weird story. So, for maybe my entire life, like I understand what a lightbox is from a image and photography standpoint, but for the majority of my life, I thought that lightbox referred to those like big initial letters in old manuscripts. I don&#8217;t actually know what those are called if not lightboxes, but in my mind, that&#8217;s what they were.</p>\n\n\n\n<p>[00:08:22] <strong>Josepha:</strong> And so when we first started talking about this, I was like, that&#8217;s what we&#8217;re shipping is like the drop capital letter, like the big one, but it&#8217;s not. In case anyone else also was confused about what a lightbox is, it&#8217;s the image-based concept of a lightbox.</p>\n\n\n\n<p>[00:08:37] <strong>Sarah:</strong> I think it&#8217;s an important one because previously you would have to install, maybe a third-party plugin or, or build lightbox yourself so. It may sound like a, oh, it&#8217;s a tiny feature that&#8217;s been included, but it&#8217;s actually pretty awesome. You don&#8217;t have to include even more extra code.&nbsp;</p>\n\n\n\n<p>[00:08:51] <strong>Josepha:</strong> Speaking of things that we have been working on for two years or so, I think that every sneak peek for the last year, the folks of WordPress have heard me say that I was super excited about navigation and how we&#8217;re managing it, but it turns out that is a very complicated thing. Like we know that, managing menus, managing navigation on a site is complicated from just like a philosophical standpoint. When our users of WordPress, when consumers of WordPress like go through that process, that is the hardest one to explain. And therefore, very hard to manage as well.&nbsp;</p>\n\n\n\n<p>We have had like a requirement that you know three different admins in order to manage your menu, manage your navigation on your site, but we shipped some early components for it in 6.3 and in 6.4. I believe that we are planning; I&#8217;m crossing my fingers no one can see it, crossing my fingers. We&#8217;re planning on getting an updated treatment for the toolbar out. Is that correct?</p>\n\n\n\n<p>[00:09:53] <strong>Sarah:</strong> Yes, yeah, I was a little bit worried because I didn&#8217;t know too much in detail, but I did know about the toolbar. So, yes, yes, I believe that is planned to get into 6.4.</p>\n\n\n\n<p>[00:10:01] <strong>Josepha:</strong> Yeah. So, and the point of that, because for folks who have not tried this out yet, the point of that is that the navigation is kind of, when you look at it, individual components, it&#8217;s like a bunch of little blocks together, and then we wrap it as like a collection that shows up as the navigation block, but because it&#8217;s a bunch of little blocks and each of the little blocks has their own like toolbar that goes with it, it took a lot of work to kind of figure out how to get all of those toolbars to have a primary expression with the navigation. Versus like every single thing that you put into your navigation has its own toolbar, and good luck to you.</p>\n\n\n\n<p>[00:10:44] <strong>Sarah:</strong> Yeah, it&#8217;s a really, really complicated problem, and I guess maybe it always has been, and hopefully we just keep improving and all the time, and we probably never will stop improving because it&#8217;s, yeah, it&#8217;s just such a complicated thing to edit, and I think particularly in an editor without using any code.</p>\n\n\n\n<p>[00:11:00] <strong>Josepha:</strong> Yes.</p>\n\n\n\n<p>[00:11:01] <strong>Sarah:</strong> We&#8217;re getting there, it always, it always is getting better.</p>\n\n\n\n<p>[00:11:04] <strong>Josepha:</strong> Yeah. Before we move into the question of like things that you wish people knew about the release that maybe they&#8217;re not going to know, I do want to stop and talk about the default theme a little bit. Everyone loves the default theme at the end of the year. But every year, Matt and I talk about, like, what would it look like if we didn&#8217;t have a default theme.</p>\n\n\n\n<p>What if we just were like, all themes are great. Just do whatever you want, which seems too difficult, frankly. But the way that this default theme is envisioned is so different. It&#8217;s got basically three different focuses. Do you know much about this year&#8217;s default theme?</p>\n\n\n\n<p>[00:11:41] <strong>Sarah:</strong> Yeah, a little bit, so I, yeah, I know, I don&#8217;t know, I think it&#8217;s shaping up to be a really good starting point for so many different types of projects. So, I know that that is maybe the aim of every default theme. But we usually show off a lot of the features that are going into the release, like via the default theme.</p>\n\n\n\n<p>I know we did that last time as well, but this time, we&#8217;re doing that stealth. But we&#8217;re also creating like a great baseline for so many different types of projects. And I think maybe in the past, we&#8217;ve maybe only hit like one type of project. And, like, this is a good example for this one very specific thing.</p>\n\n\n\n<p>But yeah, this time, I know that that&#8217;s always like, especially working with other themers, they&#8217;re like, what&#8217;s the best base theme for this type of thing? And I&#8217;m hoping Twenty Twenty-Four is going to be the new answer for so many people.</p>\n\n\n\n<p>[00:12:23] <strong>Josepha:</strong> Yeah, yeah, I looked at the early designs for that with the, because what it has, and these, we&#8217;ll put a link to this in the show notes to the repo about it and the Figma file and all those things. But what it has is like a really robust set of default patterns for anyone who&#8217;s wanting to have like a big commercial site with a lot of things that are required, a really complicated site. Then we have a suite of default patterns that are shipping so that artists and people who are focused primarily on visual assets on their site have the specific patterns and blocks and things required for that and then one that is specific to people who focus on the content in their site.</p>\n\n\n\n<p>I am one of the people who specifically focuses on the content in the site. I was delighted to see that, but it kind of has three different levels of varying complexity based on what it is that people might, might want to have to, oh, not want to have to, might want to be able to do on their sites. And I think that&#8217;s kind of cool.</p>\n\n\n\n<p>[00:13:31] <strong>Sarah:</strong> Yeah. Yeah. It&#8217;s super cool. And I think while we&#8217;re still in the development cycle as well, for 6.4, this is a; the default theme is a great way to jump into contributing if people are looking for good ways to jump in.</p>\n\n\n\n<p>[00:13:44] <strong>Josepha:</strong> Yeah, it runs in a separate repo. And so it has a little bit of a different process, but also it feels like a little bit of a faster process. It kind of runs independently of the release cycle that we have for either the plugin or core. And so it kind of goes a bit faster.</p>\n\n\n\n<p>[00:14:03] <strong>Sarah:</strong> Yes.</p>\n\n\n\n<p>[00:14:05] <strong>Josepha:</strong> Yeah. Excellent. So, then, obvious next question. What Is happening in this release that you wish people knew about?</p>\n\n\n\n<p>[00:14:15] <strong>Sarah:</strong> Yep. Okay. So, I think maybe things that are difficult to fit into the bigger categories that will be easy to shout about when we talk about the release when it&#8217;s been released. There&#8217;s a lot of accessibility enhancement that are going to be included. So there&#8217;s things like better button placements and upgraded spoken messages, especially in site health.</p>\n\n\n\n<p>There&#8217;s also so many performance improvements that are scheduled to be included, so I know there was many performance improvements included in 6.3. We are continuing that for 6.4. There&#8217;s many more improvements to block themes and classic themes in the way the templates are loaded. And we&#8217;ve also got a we&#8217;re including a usage of the new defer and async loading strategies as well for script.</p>\n\n\n\n<p>So these are sort of like, nitty-gritty detail sort of things that will be included that don&#8217;t sound too exciting but are actually really, really cool.&nbsp;</p>\n\n\n\n<p>[00:15:07] <strong>Josepha:</strong> Yeah. I understand the whole like, this is not very exciting. This doesn&#8217;t sound interesting but trust me, it is like, sometimes it feels like half of my job is that I&#8217;m like, I know that nothing I&#8217;m about to say sounds cool, but trust me, it&#8217;s amazing. We&#8217;ve been working on it for a long time, and it&#8217;s cool.</p>\n\n\n\n<p>That&#8217;s great. That&#8217;s great. And so. For those things, it sounds like a lot, this is going to particularly be of interest to folks who are developing for other people using WordPress. But also obviously a little bit of, of benefit, maybe invisible benefit, but still benefit for our end users as we go.</p>\n\n\n\n<p>[00:15:46] <strong>Sarah:</strong> Yeah, yeah, that&#8217;s right, exactly.</p>\n\n\n\n<p>[00:15:48] <strong>Josepha:</strong> So those are kind of the sneak peek items that we&#8217;ve got going into the release. As always, with this particular episode, we&#8217;re not promising that any of those things will 100 percent for sure get in there. There is part of being a release squad that kind of doesn&#8217;t really get talked about outside of WordPress but is probably worth mentioning, which is that the release squad has the really unpleasant job of saying no at the last second for things that are breaking something, things that are not actually a better user experience.</p>\n\n\n\n<p>Like we have the uncomfortable job of saying like, no, it wasn&#8217;t good enough. Sorry, thank you. Come again in the next release cycle. And so, like, all of these things are things that are currently in and being tested, but in the event that we discover it breaks 10 percent of the sites that we have on WordPress, like, we&#8217;re gonna, we&#8217;re gonna pull it.</p>\n\n\n\n<p>So, right now, that&#8217;s all in there, we hope, and if listening to me for a whole year get excited about the changes in navigation, and then also not getting them in didn&#8217;t teach you anything, just because I want it in doesn&#8217;t mean that I get to have it in either. So, but yeah, so that&#8217;s exciting. The other exciting thing about this release, we mentioned it a bit at the top of the discussion, is that it is a gender-upresented, gender-underrepresented release squad. Not upresented, because that is a, not a word. And so this is the second one. Did you participate in the first one?</p>\n\n\n\n<p>[00:17:22] <strong>Sarah:</strong> No, I didn&#8217;t no. Yeah, but I have read all about it, especially in prep to this release as well.</p>\n\n\n\n<p>[00:17:28] <strong>Josepha:</strong> Oh, did you learn anything from it that you brought into this one, or was it just like, I need to know what I&#8217;m getting into kind of reading a lot about it?&nbsp;</p>\n\n\n\n<p>[00:17:36] <strong>Sarah:</strong> Yeah, basically, yeah, I was trying to prep myself, ever since I was involved in 6.1, I&#8217;ve tried to be, I&#8217;ve tried to follow along closely with the releases. But sometimes, there&#8217;s just so much going on all the time. Sometimes it&#8217;s a little bit much. But yeah, I just wanted to see if there was any, any big differences.</p>\n\n\n\n<p>There shouldn&#8217;t be, right? So yeah, it&#8217;s all good.</p>\n\n\n\n<p>[00:17:54] <strong>Josepha:</strong> I think all of the differences were in that boring part where people don&#8217;t, they&#8217;re like, that sounds so un-fun, we&#8217;re going to just stop listening. But it was like, in the planning and preparation for it, and the way that we did all the training, like the initial one had like an 18 month period between like, we&#8217;re gonna do it, and now it&#8217;s done, where we did a lot of additional work to get everybody in there.</p>\n\n\n\n<p>[00:18:18] <strong>Josepha:</strong> And this time, we were like, get in here! That&#8217;s all we did. So, how has your experience been on the release squad? I know that you did one before. You did one in 6.1, but is this particular squad any different compared to your last experience of it, or what you expected?</p>\n\n\n\n<p>[00:18:35] <strong>Sarah:</strong> So, I would say everyone is equally as amazing as every release and, including the resource they&#8217;re involved with. I think that the biggest difference for me, and maybe this links to something you just said, is that I, I knew I was going to be involved in the release squad a lot earlier, especially compared to me for 6.1, but I think I&#8217;ve heard other people say that as well. So, I think that&#8217;s a great thing for this release. We all have had some time ahead of the release and including during this 6.3 release as well, so I was able to watch particular people in, not in a non-creepy way, and make sure I knew which, like what the processes were.</p>\n\n\n\n<p>Yes, to try and get my head around when when I&#8217;d be doing it. And, and obviously, the big help was that I&#8217;d be doing it immediately after they&#8217;d just done it as well. And the previous release squad has been a massive help as well when I&#8217;ve come across either very, very complicated issues or like super silly issues; I can write them and answer your questions so that I think if we could carry that forward with the future releases as well.</p>\n\n\n\n<p>[00:19:28] <strong>Josepha:</strong> Yeah, absolutely. So this time around, we had almost 50 percent new folks that that, like, let us know that they were participating, probably quite a few more than that. But, like, of the people who let us know that they wanted to participate in this release, we had like 28 out of 50 people, something like that, who are brand new to contributing to WordPress in some cases, but certainly, all of them are brand new to contributing to a major release like this. Have you, cause this is not your first time doing this, but it is your first time in this type of release. Have you found that, like, you&#8217;re feeling able to help new people see what&#8217;s happening also, like, do you feel seasoned enough for that? Or are you just like, nope, I&#8217;m also new.</p>\n\n\n\n<p>[00:20:17] <strong>Sarah:</strong> Maybe a little bit of both. I guess I, yeah, I&#8217;m fortunate to have at least experienced, maybe, like how the deadlines roll. Actually, especially the point we&#8217;re at at the moment, where the weekly beta cycles happened. Last time, it took me by surprise. I was like, oh wow, okay, we have a week. Until the next one, and then a week, and so yeah, I feel a bit more psyched up for that this time around.</p>\n\n\n\n<p>And hopefully, I can tap that on you to the new folks as well. But yeah, I also noticed we have a lot of new people. We have, especially from a core editor tech lead; I think we have nearly 30 people who are sort of officially following us along or shadowing us.</p>\n\n\n\n<p>So yeah, yeah, but it&#8217;s really cool. I hope we can teach so many more people if they want to get involved with the next release or even just contributing in general. Yeah, it&#8217;d be amazing.</p>\n\n\n\n<p>[00:21:00] <strong>Josepha:</strong> Yeah. If you are listening to our podcast, and you think to yourself, well, I&#8217;m here. And I wonder if anyone knows because I&#8217;m just watching everyone in a non-creepy way, like feel free at the next meeting that you&#8217;re watching to, to raise your hand and say, I&#8217;m new. We want to know that you&#8217;re there.</p>\n\n\n\n<p>Not because we feel creepy otherwise. But also because we just want to celebrate that you exist new folks that are scared of us. Don&#8217;t be scared of us.</p>\n\n\n\n<p>Oh, man, I feel compelled now to tell everybody about the first time that I led a core chat. So the core chat, I watched that without telling anyone I was watching it for like a year before I had to actually lead it, and I just didn&#8217;t tell anybody I was there like I didn&#8217;t even participate in the waving part at the start where it&#8217;s just like, Hey, everyone, I exist, like, when I was just silently watching it all go by and so when I got announced as part of a release squad. It was shocking for everyone, I think. And there is a public record of a moment where I was panicking. I felt like everyone was asking me a thousand questions, and I didn&#8217;t know the answers to any of them. And I just told all of them, like, there are a million of you and one of me, and you&#8217;re kind of scaring me, so would you stop?</p>\n\n\n\n<p>And so there&#8217;s a public record of me calling out every developer that existed in WordPress at the time. I felt bad about it in the moment, but also like, whew, that was, I don&#8217;t think we have experiences like that for new contributors anymore, but it was, it was quite a moment. I remember distinctly, so Jeffrey Paul, he&#8217;s like one of our, I think we have three or four like self-declared project managing people.</p>\n\n\n\n<p>He is a project manager person in WordPress that I really rely on, and I was DM&#8217;ing him in the background in a full panic. I was like, I don&#8217;t know the answer to any of these questions. What am I supposed to do? And he was like no is also an answer. So, like, just tell them no. Tell them you don&#8217;t know. That&#8217;s fine. And I was like, Oh, God! So, I think that we maybe don&#8217;t have too much of that happening anymore, but I also understand that I wouldn&#8217;t see it if it were happening. No one&#8217;s coming to me to be like, is this normal? Should I panic? They&#8217;re probably coming to you with that.</p>\n\n\n\n<p>[00:23:21] <strong>Sarah:</strong> I think it&#8217;s a sort of good, I&#8217;m not good for you, maybe, but good for observers especially. You know, to see you go through that as well. I can really relate to, like, not even showing, like, a wave emoji because I&#8217;ve totally been in that situation. I think maybe we&#8217;re similar in that regard, like, it, sometimes I just feel really nervous even just showing an emoji.</p>\n\n\n\n<p>And I think, again, shouting out about that and to, to those people who also feel like that, who are watching yeah, yeah, wave if you, if you feel like you want to, and don&#8217;t wave, it&#8217;s also fine just to watch.&nbsp;</p>\n\n\n\n<p>[00:23:48] <strong>Josepha:</strong> Once you&#8217;ve been to 52 meetings, then you can wave. Oh, it&#8217;s so hardworking in open source that way because, like, there is a lot of, like, basically faith in other people because trust comes with, like experiencing things together. But initially, you do just kind of have to have faith that no one&#8217;s going to laugh you out of the room or say that your ideas are stupid or that you are like even remotely understanding the problem, and so that&#8217;s a, it&#8217;s a part of the new contributor experience that I always find so interesting I used to routinely give presentations about like this is how you get started first get ready to be uncomfortable I don&#8217;t give those presentations very often anymore but probably probably I should ask someone to get out there and be like, It&#8217;s scary for everyone, including you!</p>\n\n\n\n<p>Come be scared together! Cause I think that&#8217;s important to normalize. Fear&#8217;s normal. When you first started contributing to WordPress in general, let alone like being on a release squad, what is the team that you first joined through?</p>\n\n\n\n<p>[00:25:02] <strong>Sarah:</strong> So, I guess, full-time contribution, it was themes. I was very involved with themes, and I still am as well; I really love themes, especially block themes. And also with the editor. But, like, years and years ago, I guess it was still themes. I used to build themes.</p>\n\n\n\n<p>But that was very much; I was a forum user, and well, actually, I guess it goes back to me being very nervous and not wanting to admit the question that I wanted to ask, so I would hunt the forums, but afterwards just so helpful.</p>\n\n\n\n<p>Like, yeah, I know this is a lot of people&#8217;s story, but yeah, the forums and just chatting amongst other community members is so, so helpful. So yeah, when I became a full-time contributor, I really, I love talking to other people who are trying to get help or, yeah, reaching out any way they can because I was like, I feel that I was you and still am you as well.</p>\n\n\n\n<p>[00:25:50] <strong>Josepha:</strong> I mean, the good thing about it, like, we will always feel like we&#8217;re learning something because we are, but in my experience of folks in WordPress, and I haven&#8217;t been new in a long time, obviously been doing this for like eight years now which is ancient by technology standards, but like my favorite thing about folks in WordPress is that they are wanting to like learn enough to probably not break it forever.</p>\n\n\n\n<p>Like it&#8217;s the probably is in there, and the forever is in there like I want to. I want to know just enough to be mildly dangerous and then bring everybody with me. Let&#8217;s go be dangerous together. And I think that is really charming in a way because it&#8217;s like we know enough to sort of break it. But not break it a lot.</p>\n\n\n\n<p>So let&#8217;s go see how we break it a little bit to make it better. I think that&#8217;s such a charming attitude for some reason because then we all just get to kind of learn and be a little bit messy together, which is the nature of openly collaborating on a half-written software—all the time. But yeah, I think it&#8217;s kind of neat.</p>\n\n\n\n<p>[00:27:05] <strong>Sarah:</strong> Yeah, yeah, exactly. It&#8217;s exciting too, like if you&#8217;re staying, you&#8217;ve got that enough red push and edge that you&#8217;re just like, Ooh, I might break something. But then there&#8217;s so many people that help you out that, you know, just before you could actually break something important.&nbsp;</p>\n\n\n\n<p>[00:27:18] <strong>Josepha:</strong> Exactly. The one time when I did a very breaking thing because I didn&#8217;t know to ask about it and fixed it immediately was that I mentioned in the middle of a core chat that we were about to have a security release. But it wasn&#8217;t about it wasn&#8217;t like in the next 15 minutes, it was like three weeks away, which is not what you&#8217;re allowed to do like you are not allowed to mention that you have a security release coming in three weeks, and then hope that nobody figures out what it&#8217;s patching.</p>\n\n\n\n<p>Yeah, I got so many messages in such a short amount of time from it felt like every lead developer of WordPress. That was my, my worst moment.</p>\n\n\n\n<p>And I fixed it immediately. So that was good. But also, I don&#8217;t remember if we had to like move up the, the timeline for that release or what. I don&#8217;t; I have no idea what the outcome was because I was just in an outright panic about what I had done incorrectly.</p>\n\n\n\n<p>Anyway, so that&#8217;s the; I&#8217;m just going to tell everybody my most embarrassing early contribution stories today. That&#8217;s what I&#8217;m doing. Excellent. Well, Sarah, before we head out of here, is there a final thought that you would like to share with either our listeners here or future potential contributors to WordPress?</p>\n\n\n\n<p>[00:28:37] <strong>Sarah:</strong> Please help test 6.4, especially through the next few cycles of beta. It would be amazing to have everyone and anyone who would like to help. That is one of the best ways you can help is to test. And then, yeah, if you want to get involved a little bit further, then yeah, I guess, please reach out wherever you think you fit, which I know sounds a bit fake, but there are a lot of different places, and I&#8217;m sure there will be somewhere you fit as well.</p>\n\n\n\n<p>00:28:59] <strong>Josepha:</strong> I will leave in the show notes a link to the page that has all of the upcoming meetings on it. You can probably go to almost any meeting and say, I think this is where I would like to contribute, but also, this is the kind of thing I can contribute, and they will be able to head you in the right direction if you&#8217;re not already in the right direction. But also, like, sometimes your skills that you have are going to be applicable in places where you&#8217;re not aware of yet. And so, go to any meeting—wave to the friendly WordPressers that are around, the Sarah Norrises that exist in the project.&nbsp;</p>\n\n\n\n<p>[00:29:36] <strong>Josepha:</strong> Sarah, thank you so much for joining me today. This was a delight.</p>\n\n\n\n<p>[00:29:39] <strong>Sarah:</strong> Thanks so much for having me on; I really enjoyed it.</p>\n\n\n\n<p>[00:29:42] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:29:42] <strong>Josepha:</strong> That brings us now to our small list of big things. First thing to know is that tomorrow we have Beta 2 for WordPress 6.4. This is our final release of the year, as you know because we&#8217;ve been talking about it for the entire episode. But, just like Sarah said at the end of our conversation, we absolutely need people to help us test it, make sure that it is working in as many places as possible so that we can have the best release possible. So keep an eye out on the core channel in the Making WordPress Slack, and of course, keep an eye on WordPress.org/news as those releases get packaged and ready to go.&nbsp;</p>\n\n\n\n<p>So the second thing is a proposal for documentation translation localization process update. This is an initial step to consolidate all of that documentation into a single easy-to-reach location. So we need some feedback on it. Head on over there, leave a comment to share your feedback about where that should possibly go, where is most useful and valuable for you.&nbsp;</p>\n\n\n\n<p>The second proposal that I have is actually sort of a tangentially related one, but so it&#8217;s not specific to WordPress but does need some WordPress input. There is a call for proposal for Interop 2024. There&#8217;s a post that has a lot more information about it than I do, but we would like for any WordPress developer who&#8217;s interested to head over there and submit a proposal for what they could speak about at Interop, I believe. You can leave your thoughts on the post itself as a comment, or there&#8217;s also a GitHub repo where you can interact as well.</p>\n\n\n\n<p>The next thing on our small list of big things is that the WordCamp US Q&amp;A, the questions that we didn&#8217;t get to because there were something like 87 or something in the queue. The questions that we didn&#8217;t get to, the answers have been posted. They&#8217;re over on make.WordPress.org/project, but I&#8217;ll include a link to those to that post in the show notes.&nbsp;</p>\n\n\n\n<p>And the final thing on the small list of big things, I&#8217;m actually quite excited about. We are hosting now accessibility office hours. In an effort to improve accessibility knowledge in the WordPress project in general, the accessibility team will be holding office hours every Wednesday at 14:00 UTC.</p>\n\n\n\n<p>That started on September 20th. And so it&#8217;s been going for a couple of weeks now. And the purpose is to make sure that we have a dedicated space and time to discuss accessibility principles and best practices as we go through those things.&nbsp;</p>\n\n\n\n<p>[00:32:29] <strong>Josepha:</strong> And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Hayden Chomphosy, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\n\n\n<p>[00:32:38] (Music interlude)&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Help Influence the Future of WordPress by Taking the 2023 Annual Survey Today\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/news/2023/09/help-influence-the-future-of-wordpress-by-taking-the-2023-annual-survey-today/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 10:52:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15982\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. The results can influence the direction of the WordPress project by identifying areas that need attention. Annual surveying can also help track trends over time, with data points often finding their way into the yearly State of the Word address.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4813:\"\n<p>Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. The results can influence the direction of the WordPress project by identifying areas that need attention. Annual surveying can also help track trends over time, with data points often finding their way into the yearly <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a> address.</p>\n\n\n\n<p>This survey helps those who build WordPress understand more about how the software is used and by whom. The survey also allows WordPress open source project leaders to learn more about our contributors’ experiences.&nbsp;&nbsp;</p>\n\n\n\n<p>To ensure your WordPress experience gets represented in the 2023 survey results, take the survey now (link).</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=dotOrgNewsPost\">Take the 2023 Survey</a></div>\n</div>\n\n\n\n<p>You may also take the survey in other languages by using the link above and switching to another language, thanks to the efforts of WordPress polyglot contributors.&nbsp;</p>\n\n\n\n<p>The survey will be open for five weeks. Results will be published on the News blog in early December.</p>\n\n\n\n<p>This year, like last year, the survey has undergone some improvements to the flow and question set. A new platform is also being piloted, offering an updated interface, enhanced multi-lingual support, expanded analysis and visualization tools for the results, and more. The new platform also has built-in accessibility and privacy controls, ensuring the survey meets the diverse needs of the WordPress community.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Spread the word</strong></h2>\n\n\n\n<p>Please help spread the word about the survey by sharing it with your network, through Slack, or within your social media accounts. The more people who complete the survey and share their experience with WordPress, the more the project will benefit.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Security and privacy</strong></h2>\n\n\n\n<p>Data security and privacy are paramount to the WordPress project and community. With this in mind, all data will be anonymized: no email addresses or IP addresses will be associated with published results. To learn more about WordPress.org’s privacy practices, view the <a href=\"https://wordpress.org/about/privacy/\">privacy policy</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Thank you</strong></h2>\n\n\n\n<p>Thank you to the following WordPress contributors for assisting with the annual survey project, including question creation, strategy, survey build-out, and translation:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/adamsilverstein/\">adamsilverstein</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">audrasjb</a>, <a href=\"https://profiles.wordpress.org/alvarogois/\">alvarogóis</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">atachibana</a>, <a href=\"https://profiles.wordpress.org/bjmcsherry/\">bjmcsherry</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\">dansoschin</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">eidolonnight</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">fierevere</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbénard</a>, <a href=\"https://profiles.wordpress.org/hassantafreshi/\">hassantafreshi</a>, <a href=\"https://profiles.wordpress.org/juliagasparyan/\">juliagasparyan</a>, <a href=\"https://profiles.wordpress.org/kittmedia/\">kittmedia</a>, <a href=\"https://profiles.wordpress.org/manudavidos/\">manudavidos</a>, <a href=\"https://profiles.wordpress.org/nao/\">nao</a>, <a href=\"https://profiles.wordpress.org/nilovelez/\">nilovelez</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, and <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner</a>.</p>\n\n\n\n<p>Thanks to <a href=\"https://www.hostinger.com/\">Hostinger</a>, <a href=\"https://cloud.jetpack.com/\">Jetpack</a>, and <a href=\"http://wordpress.com\">WordPress.com</a>, for assisting with promoting the survey to their respective clients.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=dotOrgNewsPost\">Take the 2023 Survey</a></div>\n</div>\n\n\n\n<p>The survey closes on <time datetime=\"2023-10-31T16:00:00-04:00\" data-iso=\"20231031T1600\" class=\"wporg-time\">Tuesday, October 31, 2023 at 12:00</time>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.4 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Sep 2023 20:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15994\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:301:\"WordPress 6.4 Beta 1 is now ready for download and testing!\n\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 1 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:19031:\"\n<p>WordPress 6.4 Beta 1 is ready for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>.<strong> </strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 1 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 1 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin:</strong> Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download: </strong>Download the <a href=\"https://wordpress.org/wordpress-6.4-beta1.zip\">Beta 1 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line:</strong> Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-beta1</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Your help testing this version is key to ensuring everything in the release is the best it can be.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\" target=\"_blank\"><strong>underrepresented gender release squad</strong></a>&nbsp;to increase participation&nbsp;of and partnership with&nbsp;those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p class=\"has-extra-large-font-size\">Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for further details.</p>\n</blockquote>\n\n\n\n<p><em><strong>This post has been updated as of October 5, 2023, to reflect the latest changes.</strong></em></p>\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How you can help: Testing</h2>\n\n\n\n<p>Testing for issues is a critical part of developing any software, and it’s a meaningful way for anyone to contribute—whether you have experience or not. <strong><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing key features in WordPress 6.4.</strong></p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates that have debuted since WordPress 6.3 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>WordPress 6.4 Beta 1 contains over 400 enhancements and 370 bug fixes for the editor, including more than <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.4&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">190 tickets for WordPress 6.4 core</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 1</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities is doubled</a>. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A first look at WordPress 6.4</h2>\n\n\n\n<p>WordPress 6.4 will introduce a versatile default theme, new features, and numerous updates designed to enhance your WordPress experience across multiple areas—from writing and design to workflow efficiency. All while the foundational work continues for Phase 3 of the <a href=\"https://wordpress.org/about/roadmap/\">WordPress roadmap</a>. Read on for some highlights.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meet the Twenty Twenty-Four theme</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a> is a new default theme that will launch with 6.4. With a versatile collection of templates and patterns, this theme covers a diverse range of use cases, from entrepreneurs to small businesses to artists and writers. Twenty Twenty-Four also emphasizes the latest design tooling and site editing features, enabling you to leverage the flexibility of blocks and unlock numerous creative possibilities with just a few tweaks. Follow the theme&#8217;s progress and report any issues on <a href=\"https://github.com/WordPress/twentytwentyfour\">this GitHub repo</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Manage fonts across your site</h3>\n\n\n\n<p>WordPress 6.4 will introduce new font management features:</p>\n\n\n\n<p>The <a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a> enables you to handle fonts across your site, regardless of your active theme—just like you manage assets in the Media Library. Easily install local and Google Fonts and choose which to activate for each theme. This new font manager is a powerful way to control a fundamental piece of your site&#8217;s design and branding without coding. Thanks to its <a href=\"https://github.com/WordPress/gutenberg/issues/53307\">extensibility</a>, custom typographic collections can expand your font choices.</p>\n\n\n\n<p>On the other hand, <a href=\"https://core.trac.wordpress.org/ticket/59165\">Font Face</a> provides server-side <code>@font-face</code> style generation and printing support. It introduces a new global function called <code>wp_print_font_faces()</code>, which processes font data received from styles set in the editor or by the active theme.</p>\n\n\n\n<p><em><strong>Update (October 5, 2023): </strong>The Font Library feature will not debut in WordPress 6.4. Instead, it has been postponed to the next major release, 6.5. WordPress is committed to delivering the best possible experience, meaning this feature requires more feedback and testing to shine. Thank you for your understanding!</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">Add lightbox functionality to your images</h3>\n\n\n\n<p>Showcase your images in an interactive fashion with <a href=\"https://github.com/WordPress/gutenberg/issues/51132\">lightbox functionality</a>. This new core feature will be available for Image blocks, allowing visual assets to be opened and enlarged on top of the existing content.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enjoy new writing improvements</h3>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/issues/53305\">Many enhancements</a> in 6.4 will ensure that your WordPress writing experience remains smooth and enjoyable, from new keyboard shortcuts to more reliable pasting from other sources. Moreover, a fresh toolbar experience will be available for the <a href=\"https://github.com/WordPress/gutenberg/pull/53697\">Navigation</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53306\">List</a>, and <a href=\"https://github.com/WordPress/gutenberg/pull/53699\">Quote</a> blocks, making working with their tooling options more efficient and intuitive.</p>\n\n\n\n<h3 class=\"wp-block-heading\">More design tools, greater creativity</h3>\n\n\n\n<p>New design tools will improve the overall creation experience with WordPress while providing greater layout control and flexibility. Some updates include:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53934\">Background images for Group blocks</a>, allowing for creative and customized layouts.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54216\">Aspect ratios for image placeholders</a>—a new feature that’s particularly useful when creating and using patterns. After setting a placeholder’s desired aspect ratio, you can drag and drop an image, which will adjust to maintain the design consistency.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53667\">Button and heading color customization in Group</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/54104\">Columns blocks</a>, enabling you to define the appearance of these elements when placed within these container blocks. This feature takes a step towards allowing <a href=\"https://github.com/WordPress/gutenberg/issues/40318\">section-specific styling</a>, which will continue to develop in upcoming releases.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54416\">Alignment settings in synced patterns</a>. When creating and converting a synced pattern with wide, full-width, left or right-aligned blocks, this improvement ensures alignment attributes remain intact for a seamless site editing and pattern creation experience.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Upgrades for smoother workflows</h3>\n\n\n\n<p>As the Site Editor continues to evolve and expand its capabilities, so do the interface and tools that support it.</p>\n\n\n\n<p>First introduced in WordPress 6.3, the <a href=\"https://wordpress.org/documentation/article/site-editor-command-palette/\">Command Palette</a> helps you perform actions, search, and quickly navigate your site&#8217;s content and settings. It will receive significant updates in 6.4, featuring an <a href=\"https://github.com/WordPress/gutenberg/pull/53117\">updated design</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/52509#top\">new commands</a> to accomplish block-specific actions, and <a href=\"https://github.com/WordPress/gutenberg/pull/53496\">better command language and action consistency</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/list-view/\">List View</a> provides a great way to browse and work with the blocks that make up your site. This release will introduce enhancements to its interface and usability, making it even more powerful. You can <a href=\"https://github.com/WordPress/gutenberg/pull/53735\">rename Group blocks</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53381\">view media previews for Gallery and Image blocks</a>, and <a href=\"https://github.com/WordPress/gutenberg/pull/53559\">duplicate blocks with a keyboard shortcut</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Pattern advancements</h3>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/site-editor-patterns/\">Patterns</a><strong> </strong>play an essential role in site editing, and its importance remains prominent in the upcoming release.</p>\n\n\n\n<p>6.4 will allow you to better organize <a href=\"https://github.com/WordPress/gutenberg/pull/53835\">your synced and unsynced patterns with categories</a> as part of the creation process. These categories are available for sorting within the insertion flow to make discovering and adding patterns easier. In addition, you can conveniently access all your custom patterns from the same place—the Patterns section of the Block Inserter, which removes the separate tab for synced patterns.</p>\n\n\n\n<p>Other improvements include <a href=\"https://github.com/WordPress/gutenberg/pull/54337\">importing and exporting patterns as JSON files</a>, ensuring backward compatibility with Reusable blocks, and enabling pattern transfer across sites.</p>\n\n\n\n<p>Lastly, building on the groundwork laid in WordPress 6.3, this release will improve the <a href=\"https://github.com/WordPress/gutenberg/issues/52150\">pattern management experience for non-block themes</a> by adding a <a href=\"https://core.trac.wordpress.org/ticket/58827\">Patterns tab</a> under the Appearance menu, allowing access to the Pattern list page of the admin screen.</p>\n\n\n\n<p><strong><em>Update (October 2, 2023): </em></strong><em>While 6.4 will bring several exciting pattern advancements, the previously mentioned improved pattern management experience for non-block themes will regrettably not be included in the 6.4 release. Thank you for your understanding, and be on the lookout for it in WordPress 6.5.</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">Introducing Block Hooks</h3>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a> is a new powerful feature that enriches the extensibility of block themes, drawing inspiration from the familiar WordPress <a href=\"https://learn.wordpress.org/tutorial/wordpress-filter-hooks/\">Hooks</a> concept. Upon activation, plugins can automatically insert blocks into content relative to another block. For example, a &#8220;Like&#8221; button block can automatically be inserted after the Post Content block.</p>\n\n\n\n<p>While developer-centric, Block Hooks enhances the user experience by making block usage more intuitive and allowing for further customization and control over where and how the auto-inserted blocks appear. A <a href=\"https://github.com/WordPress/gutenberg/pull/52969\">new block inspector panel</a> named &#8220;Plugins&#8221; is designed to respect creators&#8217; preferences, ensuring you can add, dismiss, or relocate Block Hooks as desired.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility</h3>\n\n\n\n<p>WordPress 6.4 has 70 accessibility improvements slated for inclusion, 60 of those are included in Beta 1. Notable updates focused on enhancing the user interface (UI) experience include <a href=\"https://core.trac.wordpress.org/ticket/40822\">better button placements</a>, <a href=\"https://core.trac.wordpress.org/ticket/47125\">improved context for “Add New” admin menu items</a>, and <a href=\"https://core.trac.wordpress.org/ticket/58573\">upgraded spoken messages in Site Health</a>.</p>\n\n\n\n<p>Additionally, fixes for <a href=\"https://core.trac.wordpress.org/ticket/58756\">image editing in the Media Library</a>, <a href=\"https://core.trac.wordpress.org/ticket/30685\">error reporting on the login screen</a>, and <a href=\"https://core.trac.wordpress.org/ticket/58756\">&#8220;no motion&#8221; settings for GIFs</a> have been implemented. The cause of some <a href=\"https://core.trac.wordpress.org/ticket/58703\">false positives in automated UI tests</a> has been corrected, and users without JavaScript now see a <a href=\"https://core.trac.wordpress.org/ticket/59229\">direct link to install the Classic Editor plugin</a>. Learn more about these changes and other accessibility improvements for 6.4 on <a href=\"https://core.trac.wordpress.org/query?focuses=~accessibility&amp;milestone=6.4&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">WordPress Trac</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.4 will include more than 100 performance-related updates, including <a href=\"https://core.trac.wordpress.org/query?focuses=~performance&amp;component=Themes&amp;milestone=6.4\">improvements to template loading performance</a> for Block Themes and Classic Themes, <a href=\"https://core.trac.wordpress.org/query?focuses=~javascript+performance&amp;milestone=6.4\">usage of the new script loading strategies “defer” and “async”</a> in core, blocks, and themes, and new functions to optimize the use of <a href=\"https://core.trac.wordpress.org/query?focuses=~performance&amp;component=Options%2C+Meta+APIs&amp;component=Database&amp;milestone=6.4\">autoloaded options</a>.</p>\n\n\n\n<p><strong><em>Please note that features in this list are subject to change before final release.</em></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">A haiku for 6.4</h2>\n\n\n\n<p>Inline fonts, lightbox<br>Command blocks like CLI<br>Almost to 6-4</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a>, <a href=\'https://profiles.wordpress.org/meaganhanes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meaganhanes</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/flixos90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>flixos90</a>, <a href=\'https://profiles.wordpress.org/richtabor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>richtabor</a>,&nbsp; <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a></em>, <em><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/luminuu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>luminuu</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15994\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 20 Oct 2023 09:29:39 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 20 Oct 2023 00:11:44 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211221010300\";}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (338,'_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1697837379','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (339,'_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1697794179','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (340,'_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9','1697837379','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (341,'_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: State of the Word 2023 Will Broadcast Live from Madrid on December 11\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/state-of-the-word-2023-will-broadcast-live-from-madrid-on-december-11\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1494:\"<p>WordPress co-founder Matt Mullenweg will be delivering his annual State of the Word (SOTW) address <a href=\"https://wordpress.org/news/2023/10/state-of-the-word-2023/\">from Madrid</a> before a live audience on December 11, at 16:00 UTC. </p>\n\n\n\n<p>Last year&#8217;s event took place in New York City with attendance by invitation only, and 2023 will mark the first year the SOTW will take place from a city outside North America. This change may be a deliberate recognition of the majority (<a href=\"https://wordpress.org/about/stats/\">51.4%</a>) of WordPress users who run the software in a non-English language. WordPress adoption has the most potential for growth in emerging markets and locales where Spanish, Arabic, and Chinese languages are spoken. </p>\n\n\n\n<p>Traditionally, Mullenweg has used the State of the Word address to make important announcements, share progress, galvanize the contributor base, and recast the vision for WordPress. As the Gutenberg project is now into Phase 3 focusing on collaboration, I would not be surprised to see a demo of functionality that users can expect to see in 2024.</p>\n\n\n\n<p>Live attendees will need to reserve a ticket for their seats at the in-person event. A live stream will be available for the vast majority of the WordPress world who will not be able to attend. As in previous SOTW events, anyone will be able to submit questions for the live Q&amp;A portion. The team managing the event plans to release more details in November.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Oct 2023 03:58:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WordPress Relaunches Showcase Powered by Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150376\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wordpress-relaunches-showcase-powered-by-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4711:\"<p>WordPress.org has launched the redesign of the <a href=\"https://wordpress.org/showcase/\">Showcase</a>, with new block-based components, through a collaboration between the Design, Marketing, and Meta teams that began last year. It&#8217;s part of a larger effort to modernize WordPress.org and comes two months after the project relaunched a <a href=\"https://wordpress.org/news/2022/08/a-new-wordpress-org-homepage-and-download-page/\">new design for the WordPress.org homepage and Download page</a>.</p>\n\n\n\n<p> The updated Showcase allows visitors to browse via categories and tags and offers a significantly improved experience on mobile.  It included 101 sites at launch, which can be filtered by five categories: Business, Community, Creative, Publication, and Store, along with nearly half a dozen tags. Visitors can also select from three flavors: WordPress, WordPress Enterprise, and Multisite.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1432\" height=\"1196\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-18-at-11.08.40-PM.png\" alt=\"\" class=\"wp-image-150379\" />\n\n\n\n<p>The featured listing at the top of the Showcase randomly updates on refresh. Individual listings in the showcase include screenshots of both desktop and mobile views, along with a brief overview of why the site was included. The background for the screenshots is automatically matched to complement the website&#8217;s main colors.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1430\" height=\"1164\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-18-at-11.27.45-PM.png\" alt=\"\" class=\"wp-image-150382\" />\n\n\n\n<p>The showcase was designed to inspire visitors and show them what WordPress can do. It contains a diverse representation of some of the best WordPress-powered sites on the web, including the <a href=\"https://wordpress.org/showcase/meta-newsroom/\">Meta Newsroom</a>, <a href=\"https://wordpress.org/showcase/harvard-university/\">Harvard University</a>, <a href=\"https://wordpress.org/showcase/nasa/\">NASA</a>, <a href=\"https://wordpress.org/showcase/rolling-stone/\">Rolling Stone</a>, <a href=\"https://wordpress.org/showcase/usain-bolt/\">Usain Bolt</a>, <a href=\"https://wordpress.org/showcase/the-white-house/\">The White House</a>, among many other high profile web properties. The showcase also includes some lesser known, beautifully designed sites, featuring art and creativity across a wide range of disciplines, highlighting the endless possibilities and versatility of the WordPress platform. </p>\n\n\n\n<img width=\"2402\" height=\"1088\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-19-at-6.22.19-PM.png\" alt=\"\" class=\"wp-image-150435\" />\n\n\n\n<p>This new implementation of the showcase is powered by blocks, built on a <a href=\"https://github.com/WordPress/wporg-showcase-2022\">custom child theme</a> for WordPress.org&#8217;s <a href=\"https://github.com/WordPress/wporg-parent-2021\">parent block theme</a>.</p>\n\n\n\n<p>&#8220;This structure allows the site to take advantage of Core functionality like Group and Query blocks as well as custom blocks explicitly built for WordPress.org,&#8221; Automattic-sponsored WordPress core contributor Nick Diego said.</p>\n\n\n\n<p>&#8220;The Showcase also introduces new block-based functionality and several components that will be used elsewhere on the WordPress.org network. Improvements, such as the standardization of layout and spacing variables (<a href=\"https://github.com/WordPress/wporg-parent-2021/issues/105\">#105</a>) and the new Query Filter block (<a href=\"https://github.com/WordPress/wporg-mu-plugins/pull/441\">#441</a>), will make it easier to update other areas of WordPress.org to blocks.&#8221;</p>\n\n\n\n<p>The updated showcase is an invaluable resource for agencies and freelancers who are building sites for clients and need to demonstrate the capabilities of WordPress to scale and serve any industry. It&#8217;s also still <a href=\"https://wordpress.org/showcase/\">open for new submissions</a>, which meet the following criteria:</p>\n\n\n\n<ul>\n<li>Using WordPress in a unique or innovative way</li>\n\n\n\n<li>Representing a notable organization, government entity, or corporation as an official blog or website</li>\n\n\n\n<li>Using modern WordPress</li>\n</ul>\n\n\n\n<p>Contributors are working to streamline and <a href=\"https://github.com/WordPress/wporg-showcase-2022/issues/223\">automate</a> the submission process, although it will still include a manual review.  As this process improves, the showcase will become easier to maintain than it has been in previous years.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Oct 2023 23:15:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WordPress.org blog: State of the Word 2023 – Save the Date\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16116\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/news/2023/10/state-of-the-word-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2161:\"<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/Twitter-SOTW-Image-1200x675-1.png?resize=1024%2C576&ssl=1\" alt=\"State of the Word 2023\" class=\"wp-image-16119\" />\n\n\n\n<p>It’s time to <a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2023&dates=20231211T170000Z/20231211T190000Z&details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+Matt+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+Malaga,+Spain,+and+is+free+for+all+to+watch+or+attend+in+person+with+a+ticket.%0A%0Ahttps://wordpress.org/news/2023/10/state-of-the-word-2023/\">save the date</a>, December 11, 2023, for this year’s State of the Word!</p>\n\n\n\n<p>State of the Word is the annual keynote address delivered by the WordPress project’s co-founder, <a href=\"https://ma.tt/\">Matt Mullenweg</a>. Every year, the event shares reflections on the project’s progress and aspirations for the future of open source.&nbsp;</p>\n\n\n\n<p>For the first time, State of the Word will take place outside North America–this time with the Spanish community in <strong>Madrid, Spain</strong>. The event will be live-streamed to WordPress enthusiasts around the globe via WordPress.org social media platforms.&nbsp;</p>\n\n\n\n<p>Join Matt as he provides a retrospective of 2023, demos the latest in WordPress tech, and comments on the future of the WordPress open source project.</p>\n\n\n\n<p>Details including how to reserve a ticket for the in-person event, the link to watch the live stream, and information on how to submit questions for the Q&amp;A portion will be provided in November and shared on <a href=\"https://wordpress.org\">WordPress.org</a> and affiliated social media accounts.</p>\n\n\n\n<p></p>\n\n\n\n<p><em>Thanks to <a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a> and <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> for reviewing this post.</em> </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Oct 2023 17:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Gutenberg Times: Gutenberg Changelog #91 – WordPress 6.4, Gutenberg 16.8 and what’s in the works\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=26071\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-91-wordpress-6-4-gutenberg-16-8-and-whats-discussed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4933:\"<p>Joni Halabi and Birgit Pauli-Haack discuss WordPress 6.4, Gutenberg 16.8 and what’s been worked on outside current releases</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<p><strong>Joni Halabi</strong>, senior developer at Georgetown University</p>\n\n\n\n<ul>\n<li><a href=\"https://gutenbergtimes.com/live-q-a-design-systems-and-theme-json/\">Live Q &amp; A: Design Systems and theme.json</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/02/static-vs-dynamic-blocks-whats-the-difference/\">Static vs. dynamic blocks: What’s the difference?</a></li>\n\n\n\n<li>Book: <a href=\"https://jhalabi.com/book/\">Sweet Little You by Joni Halabi</a></li>\n\n\n\n<li>X (former Twitter) <a href=\"https://twitter.com/jonihalabi\">@jonihalabi</a></li>\n\n\n\n<li>WordPress <a href=\"https://profiles.wordpress.org/thatdevgirl/\">@thatdevgirl</a></li>\n\n\n\n<li><a href=\"https://talks.jhalabi.com/svg-in-wordpress/\">Slides: Creating Accessible SVG</a> (WP Accessibility Day) (Recording will be <a href=\"https://www.youtube.com/@WPA11yDay\">published in YouTube</a> soon) </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s released</h2>\n\n\n\n<p><strong>First Dev Notes for WordPress 6.4 </strong></p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/10/15/introducing-block-hooks-for-dynamic-blocks/\">Introducing Block Hooks for dynamic blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/editor-components-updates-in-wordpress-6-4/\">Editor Components updates in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/new-registerinsertermediacategory-api/\">New `registerInserterMediaCategory` API</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/wordpress-core-is-now-using-playwright-for-all-browser-based-tests/\">WordPress core is now using Playwright for all browser-based tests</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/introducing-admin-notice-functions-in-wordpress-6-4/\">Introducing admin notice functions in WordPress 6.4</a></li>\n</ul>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-1/\">WordPress 6.4 Release Candidate 1</a></p>\n\n\n\n<p><strong>Gutenberg 16.8</strong></p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">What’s new in Gutenberg 16.8 (11 October)</a></li>\n\n\n\n<li><a href=\"https://wptavern.com/gutenberg-16-8-makes-cover-block-smarter-adds-experimental-pages-list-in-site-editor\">Gutenberg 16.8 Makes Cover Block Smarter, Adds Experimental Pages List in Site Editor</a></li>\n</ul>\n\n\n\n<p><strong>What&#8217;s discussed and worked on</strong></p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53788#top\">Site editor: 🥝 Media library proof of concept&nbsp;</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/44214#top\">Introduce experimental form &amp; inputs blocks to allow building basic forms</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54494#top\">Update the default JSX pragma to React instead of @wordpress/element</a></li>\n\n\n\n<li><strong>The Gutenberg repo has now a new label:</strong><a href=\"https://github.com/WordPress/gutenberg/labels/%5BFeature%5D%20Data%20Views\"> Data Views</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p>The transcript is in the works. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Oct 2023 12:52:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"Do The Woo Community: Maintaining Client Relationships and Providing Evolving Services with Julia Eden and Matt Woodman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=77154\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://dothewoo.io/maintaining-client-relationships-and-providing-evolving-services-with-julia-eden-and-matt-woodman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:528:\"<p>In this Woo AgencyChat Julia Eden and Matt Woodman from Atomic Smash talk about evolving services, accessibility, UX/UI design and more.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/maintaining-client-relationships-and-providing-evolving-services-with-julia-eden-and-matt-woodman/\">Maintaining Client Relationships and Providing Evolving Services with Julia Eden and Matt Woodman</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Oct 2023 11:38:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Matt: Wowza!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=101511\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2023/10/wowza/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1538:\"<img width=\"604\" height=\"340\" src=\"https://i0.wp.com/ma.tt/files/2023/10/IMG_1643-edited-scaled.jpeg?resize=604%2C340&ssl=1\" alt=\"\" class=\"wp-image-101520\" />\n\n\n\n<p>Okay, I&#8217;ve seen a lot of things in my life, but this has me fairly floored. I was at an <a href=\"https://ecoamerica.org/\">EcoAmerica</a> board meeting dinner and afterward instead of calling an Uber like I usually would, I tried a self-driving car, a <a href=\"https://waymo.com/\">Waymo</a>. (The name inspired by my friend, <a href=\"https://jaimewaydo.com/\">Jaime Waydo</a>.) As I got home I was so excited to tell my Mom what just happened.</p>\n\n\n\n<p>I feel like every cell in my body is charged, it&#8217;s like the first time I got a script to run, or committed code into b2/cafelog, this is definitely a before and after moment. Here&#8217;s a video as the car arrived and I got out. I&#8217;m really at a loss for words. The &#8220;wow&#8221; you hear me say in one of my most genuine in my life. The thing is <em>I know</em> these self-driving cars exist, I&#8217;ve seen them around San Francisco forever, but the <em>experience</em> of being picked up and dropped off by a robot navigating the tricky SF hills and streets just hits different.</p>\n\n\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>“The future is already here – it&#8217;s just not evenly distributed.&#8221; </p>\n<cite>William Gibson</cite></blockquote>\n\n\n\n<p>One thing that always brings me back to San Francisco is you feel like you&#8217;re living in the future. Tonight was no exception.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Oct 2023 03:54:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Kinsta Launches Free Static Site Hosting for Up to 100 Websites, Including WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150341\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/kinsta-launches-free-static-site-hosting-for-up-to-100-websites-including-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4911:\"<p>Kinsta <a href=\"https://kinsta.com/changelog/static-site-hosting/\">launched its static site hosting</a> product today, making a strong entrance into the market with a free tier that is competitive with established solutions from Vercel, Netlify, and GitHub Pages. Companies can host up to 100 static sites for free, including static WordPress sites, which Kinsta deploys from its global edge network of more than 300 locations.</p>\n\n\n\n<p>Static sites are those that serve HTML pages, media, and assets like JavaScript and CSS. These are usually more suitable for brochure websites, landing pages, personal portfolios, and other simple sites that don&#8217;t require pages to be dynamically generated by code running on a server. Static sites are generally more performant and secure.</p>\n\n\n\n<p>Kinsta&#8217;s free static hosting tier comes with the following features and limitations:</p>\n\n\n\n<ul>\n<li>1 concurrent build/site</li>\n\n\n\n<li>100 sites/company</li>\n\n\n\n<li>600 build minutes/month/company</li>\n\n\n\n<li>100 GB bandwidth/month/company</li>\n\n\n\n<li>1 GB build size limit/site</li>\n\n\n\n<li>API access</li>\n\n\n\n<li>Integration with GitHub, GitLab and BitBucket</li>\n\n\n\n<li>Diff-based Uploads</li>\n\n\n\n<li>Custom domains</li>\n\n\n\n<li>Free SSL support</li>\n</ul>\n\n\n\n<p>Customers can host pre-built static sites or sites built with static site generator frameworks that use Node.js. Kinsta has created <a href=\"https://kinsta.com/docs/static-site-hosting/static-site-quick-start-examples/\">quick start example repositories</a> for many popular static site generators, including Astro, Cuttlebelle, Docusaurus, Eleventy, Gatsby, Nuxt, Qwik, React, React with Vite, and VuePress.</p>\n\n\n\n<p>WordPress users can also deploy static sites to the platform and host it for free by converting an existing site to static. Kinsta published a <a href=\"https://kinsta.com/blog/static-wp-site/\">tutorial</a> on the process for converting a WordPress site using a free plugin. The static hosting can also be used to set up a frontend with any kind of backend or host a headless WordPress site.</p>\n\n\n\n<img width=\"1105\" height=\"1039\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/static-wp-add-static-site.png\" alt=\"\" class=\"wp-image-150366\" />\n\n\n\n<p>Users can launch a static site to Kinsta&#8217;s infrastructure by deploying from a Git repository hosted by BitBucket, GitHub, or GitLab, selecting a branch, and adding a build command and directory to deploy. Kinsta can detect some static site generators automatically, which makes the process easier. A connection and configuration settings can be managed through the MyKinsta dashboard. </p>\n\n\n\n<img width=\"960\" height=\"935\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/kinsta-static-site-build-settings.png\" alt=\"\" class=\"wp-image-150362\" />\n\n\n\n<p>Kinsta plans to introduce add-ons and other features in the future that might be paid, but is committed to keeping the service and this tier free forever.</p>\n\n\n\n<p>&#8220;Just like with every free product or freemium model, our goal is to spread the word with the help of it and let users try out our service, the dashboard in a frictionless way and host a project here for completely free,&#8221; Kinsta Chief Business Officer Tom Zsomborgi said. </p>\n\n\n\n<p>&#8220;The ability of using and testing out a platform and getting first hand experience is the ultimate way of forming an opinion about a provider. We let everyone use the service and host their projects. If the developers and agencies like the Static product we hope they will consider us for their other web projects and start using the paid services.&#8221;</p>\n\n\n\n<p>Kinsta is targeting enterprises, agencies, and companies that need to create websites and landing pages for high-traffic campaigns. The company is working on more features for static site hosting, including the following on the roadmap:</p>\n\n\n\n<ul>\n<li>Wildcardless domains</li>\n\n\n\n<li>Extended Kinsta API support</li>\n\n\n\n<li>Serverless functions, which could be utilized by static sites</li>\n\n\n\n<li>Previews</li>\n\n\n\n<li>Maintenance mode</li>\n\n\n\n<li>Password protection</li>\n\n\n\n<li>Ability for HTML Forms to work</li>\n\n\n\n<li>More builders</li>\n\n\n\n<li>Choose a build template</li>\n\n\n\n<li>Detailed Analytics</li>\n</ul>\n\n\n\n<p>Kinsta&#8217;s static site hosting solution is similar to what the competition offers for building and deploying sites, but Zsomborgi said he thinks that having application, database, and WordPress hosting all under one roof sets them apart. Kinsta also offers analytics for free and unlimited users/seats, the same as Vercel, but Netlify only offers these under paid plans.</p>\n\n\n\n<p>&#8220;The biggest things that we are missing are functions (Vercel, Netlify, and Cloudflare Pages have them) and deploy previews,&#8221; Zsomborgi said. &#8220;Both of those are in the backlog and will be released soon.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 22:18:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WordPress.org blog: A New WordPress Showcase\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2023/10/a-new-wordpress-showcase/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4919:\"<p>The <a href=\"https://wordpress.org/news/category/meta/\">journey to update WordPress.org</a> continues with the launch of a new <a href=\"https://wordpress.org/showcase/\">Showcase</a> design. The Showcase is a natural starting point for visitors arriving on WordPress.org, and it both inspires creativity and demonstrates what’s possible with WordPress. From unique personal blogs and portfolios to enterprises and celebrity fan sites, the Showcase celebrates WordPress’s flexibility, popularity, and the freedom to own one’s content.</p>\n\n\n\n\n<img width=\"1024\" height=\"954\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/2-showcase-site-1.png?resize=1024%2C954&ssl=1\" alt=\"Screenshots from the new Showcase design\" class=\"wp-image-16187\" />\n\n\n\n<img width=\"1024\" height=\"954\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/3-showcase-starry-theme-1.png?resize=1024%2C954&ssl=1\" alt=\"A grid of new design elements\" class=\"wp-image-16184\" />\n\n\n\n<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/10/4-showcase-websites-curaction-1.png?resize=1024%2C576&ssl=1\" alt=\"A collage of Showcased websites\" class=\"wp-image-16185\" />\n\n\n\n\n<p>This new design provides much-needed improvements to the aesthetics and user experience. It emphasizes bold visuals and a more dynamic browsing experience through tags and categories. Individual site pages now include desktop and mobile screenshots, while the site introduces an improved layout on mobile devices.&nbsp;</p>\n\n\n\n<p>This redesign also brings new <a href=\"https://wordpress.org/blocks/\">block-based functionality</a> and several components that will be used elsewhere on WordPress.org. All of this was made possible through collaboration between Design, Marketing, and Meta teams. Thank you to everyone.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium\"><a href=\"https://profiles.wordpress.org/adamwood/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>adamwood</a> <a href=\"https://profiles.wordpress.org/alexstine/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alexstine</a> <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a> <a href=\"https://profiles.wordpress.org/bengreeley/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bengreeley</a> <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a> <a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a> <a href=\"https://profiles.wordpress.org/dufresnesteven/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dufresnesteven</a> <a href=\"https://profiles.wordpress.org/eidolonnight/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>eidolonnight</a> <a href=\"https://profiles.wordpress.org/fcoveram/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>fcoveram</a> <a href=\"https://profiles.wordpress.org/joen/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joen</a> <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jonoaldersonwp</a> <a href=\"https://profiles.wordpress.org/jpantani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jpantani</a> <a href=\"https://profiles.wordpress.org/laurlittle/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>laurlittle</a> <a href=\"https://profiles.wordpress.org/matt/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matt</a> <a href=\"https://profiles.wordpress.org/markoserb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>markoserb</a> <a href=\"https://profiles.wordpress.org/ndiego/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ndiego</a> <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pablohoneyhoney</a> <a href=\"https://profiles.wordpress.org/paulkevan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>paulkevan</a> <a href=\"https://profiles.wordpress.org/renyot/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>renyot</a> <a href=\"https://profiles.wordpress.org/ryelle/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ryelle</a> <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a> <a href=\"https://profiles.wordpress.org/_dorsvenabili/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>_dorsvenabili</a></p>\n\n\n\n<p>If you would like to propose a change or report an issue, please do so in the <a href=\"https://github.com/WordPress/wporg-showcase-2022\">wporg-showcase-2022</a>&nbsp; GitHub repository. Also, make sure to join the <a href=\"https://wordpress.slack.com/archives/C04U953K77A\">#website-redesign</a> Slack channel if you are interested in additional updates coming to WordPress.org and want to contribute.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 17:34:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: #95 – Pooja Derashri on Diversity, Equity, Inclusion, and Belonging in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=150290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/podcast/95-pooja-derashri-on-diversity-equity-inclusion-and-belonging-in-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39320:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how we can promote diversity, equity, inclusion, and belonging in the WordPress project and community.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Pooja Derashri. Pooja is a co-founder of WPVibes, a plugin development company based in India. With a passion for WordPress, pooja has been actively involved in the community since 2013. Her journey as a contributor began in 2017 when she attended her first local WordCamp. Her expertise and dedication have under various key roles in the WordPress ecosystem. She currently serves as co-team rep for the training team, and GTE for the Hindi local. In addition, she holds key positions in the WordPress release squad for version 6.3 and 6.4, where she heads up the test team.</p>\n\n\n\n<p>Pooja shares her insights on the importance of diversity, equity, inclusion, and belonging within the WordPress community, and explores how you don&#8217;t need to be a coder to be a part of the community and all that it is.</p>\n\n\n\n<p>We discussed the work of teams like polyglots, who focus on translating WordPress projects into different languages, and docs, who provide much needed documentation to help users understand and contribute to the platform. These initiatives alone make it clear that WordPress is reliant on non-coding contributions, and there are more ways to contribute than have a before.</p>\n\n\n\n<p>I ask Pooja about her experiences with diversity and inclusivity in the tech industry, and she reflects on the challenges she has faced, discussing the importance of recognizing and addressing unconscious biases. She shares her insights on the need for training and workshops that empower diverse individuals to contribute and speak up within the WordPress community.</p>\n\n\n\n<p>We delve into Birgit Olzem&#8217;s proposal to form an official D E I B team within WordPress, aiming to implement diversity, equity, inclusion, and belonging throughout the whole community. I express my excitement about the potential outcome of this proposal, and we think about how WordPress compares to other parts of the tech industry.</p>\n\n\n\n<p>We explore the various initiatives and efforts being made to build a more inclusive WordPress culture. From mentorship programs, to targeted outreach and safe spaces, we uncover the ways in which underrepresented voices are being uplifted.</p>\n\n\n\n<p>If you&#8217;re interested in creating a more inclusive community, this episode is for you.</p>\n\n\n\n<p>If you&#8217;d like to find out more, you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Pooja Derashri</p>\n\n\n\n<p>I am joined on the podcast today by Pooja Derashri. Hello Pooja!</p>\n\n\n\n<p>[00:04:09] <strong>Pooja Derashri:</strong> Hi Nathan. So glad to join you.</p>\n\n\n\n<p>[00:04:12] <strong>Nathan Wrigley:</strong> Yeah thank you for joining me today. We&#8217;re going to be talking a little bit today about a subject which you may well have heard me talk about before. I had an interview with Jill Binder and Birgit Olzem quite recently. This episode is going to follow on shortly after that. We&#8217;re going to be talking about an acronym, DEIB or Diversity, Equity, Inclusion and Belonging.</p>\n\n\n\n<p>Before we get into the subject at hand though. Pooja I wonder, would you mind just introducing yourself? Tell us a bit about who you are, where you are, and what it is that brought you to WordPress, what it is that you do within WordPress and so on?</p>\n\n\n\n<p>[00:04:50] <strong>Pooja Derashri:</strong> Yeah. My name is Pooja Derashri, and I am from India. I&#8217;m a co founder of WPVibes, a plugin development company, and I am also a WordPress contributor. Currently I&#8217;m a co team rep for the training team and GTE for Hindi locale. Along with this, I&#8217;m also in the WordPress release squad for 6.3 and 6.4, where I&#8217;m leading the test team.</p>\n\n\n\n<p>Basically I&#8217;ve been working in WordPress since 2013. But my contribution journey started in 2017 when I was first introduced to WordPress community in one of the local WordCamps.</p>\n\n\n\n<p>[00:05:30] <strong>Nathan Wrigley:</strong> That&#8217;s an amazing story. You&#8217;ve got a lot of past, and heritage, and interest in the community. I&#8217;m guessing if you are part of the WordPress community and you&#8217;ve been part of the release squad, and it sounds like you are attending events and things like that as well. You&#8217;ve got a real interest in the community being diverse, equitable, inclusive, and the last word in the acronym, belonging.</p>\n\n\n\n<p>Do you want to just tell us a little bit about how you came to be interested in this subject? Obviously, if you&#8217;ve got a plugin development company, one might expect that all of your endeavours would be towards coding and plugins and documentation and all of those kind of things, but clearly not. You&#8217;ve got an interest in all of these things. Tell us why it is that you&#8217;ve found this to be important.</p>\n\n\n\n<p>[00:06:13] <strong>Pooja Derashri:</strong> Yes. Basically I have a short story to tell about. In my region, where I&#8217;m belonging, there is a conception that women are not good for tech jobs and women can&#8217;t do coding. In my first job there were members of 10 to 12 in my company. They have a stereotype thinking that women are not for the tech jobs, women are not good for tech jobs. And at that time I feel like an outsider, and I&#8217;m not good for that.</p>\n\n\n\n<p>In that company they were not giving me challenging tasks, and they were just giving me simple, easy tasks. So I was thinking like, what am I doing here? Then soon I realised, I switched from that company, in just two months. Then I joined a different company which is far better than that company.</p>\n\n\n\n<p>And there I got respected. I was welcomed. They gave me equal chances to work, and they gave me equal opportunities to work on coding. That was quite a nice experience. If I was not being treated unfairly, then I would never know about how that feeling was.</p>\n\n\n\n<p>When I got that feeling, then I searched about and heard in a workshop, what is DEIB, and why it matters? And I just connected the dots, like I similarly faced that issue in my first job and I should do something about it. So in my opinion diversity is all about making sure that everyone feels welcome, respected and treated fairly no matter who they ,are.</p>\n\n\n\n<p>[00:07:52] <strong>Nathan Wrigley:</strong> Thank you. That&#8217;s a really interesting story that you&#8217;ve got there. I wonder if we might just delve into that a little bit more deeply. You obviously had two fairly different experiences there. One, which was fairly negative, and you wish to separate yourself from that company and go and work at a different company. And it sounds like that was a much better experience.</p>\n\n\n\n<p>You&#8217;re obviously coming out of India on this call today. Do you feel that this is a problem which is systemic where you live? Do you, in other words, feel that this bias, for want of a better word, this lack of diversity and equity and inclusion, is something which is endemic where you live? So what I&#8217;m really asking is, do you think that there&#8217;s a problem in your part of the world that maybe isn&#8217;t quite so pronounced in other parts of the world?</p>\n\n\n\n<p>[00:08:44] <strong>Pooja Derashri:</strong> Yeah. Actually I come from a rural background where people have held certain fixed mindsets, and they are being biased in some situations. So yeah, we can say that they are not treated, they are thinking like this tech world is only for male or something like that, particularly in my region.</p>\n\n\n\n<p>I&#8217;m not talking about the whole of India. We have some better mindsets, and better conceptions in other part of India. But in my region, in my small city, that is a very unfair, or we can say biased, conception or misconception.</p>\n\n\n\n<p>[00:09:23] <strong>Nathan Wrigley:</strong> Thank you for that. I wonder if there&#8217;s legislation in place in your part of the world to tackle this kind of thing. And whether or not there&#8217;s legislation, doesn&#8217;t of course mean that it does not happen, I think the same would be true in other parts of the world as well. Simply because there are laws to prevent this kind of thing, doesn&#8217;t mean that those laws are obeyed.</p>\n\n\n\n<p>So quick question around that, we&#8217;ll go off piste for a moment. In the part of the world where you are, is there laws around this kind of thing, around discrimination and inclusion? In other words, from a legal point of view, is this not tolerated?</p>\n\n\n\n<p>[00:09:58] <strong>Pooja Derashri:</strong> Yes we have very tough laws on these things. But we can&#8217;t change any person&#8217;s conception. But I was lucky enough that my parents were not thinking that if a female can do that. They gave us equal rights. For my in laws, they gave me the equal opportunities and encouraged me, motivated me always to do whatever I wanted to do. So it&#8217;s about the few people in my first company. They had that mindset but not every people is going with the same mindset.</p>\n\n\n\n<p>[00:10:35] <strong>Nathan Wrigley:</strong> I have a follow up question, and it&#8217;s about the place where you described first, the job where that organisation wasn&#8217;t particularly diverse, and they certainly don&#8217;t sound like they were particularly inclusive. Was there any part of you that felt like throwing in the towel? And what I mean by that is just thinking okay this is what tech is like, I&#8217;m just going to change industry altogether.</p>\n\n\n\n<p>Now it sounds like you have got a background where you described your parents making sure that everything was equal for you. But despite that, did you at any point think well if this is what the tech industry is going to be like, I&#8217;m not going to be a part of it?</p>\n\n\n\n<p>And I wonder really if that&#8217;s the root of the problem here. In that we&#8217;re trying to get it to the point where no person, no matter what their background is, no matter what their ethnicity is or religion or whatever it may be. Where they feel that they can&#8217;t be part of the industry because they&#8217;re getting signals from their employers, and the industry more broadly that they don&#8217;t belong. So yeah, the question basically is, did you ever feel like, okay I shan&#8217;t be part of tech if this is what it&#8217;s going to be like?</p>\n\n\n\n<p>[00:11:43] <strong>Pooja Derashri:</strong> No, I never thought that. I was always encouraged by my close circle that you should do whatever you want, despite what other people think. You should face that problem and overcome from that.</p>\n\n\n\n<p>I thought in my first job that if they are not accepting me and they are not finding me good enough then, why shouldn&#8217;t I change the job? I can&#8217;t change their mindset but I can change my job. I can change my company.</p>\n\n\n\n<p>[00:12:13] <strong>Nathan Wrigley:</strong> Yeah that&#8217;s a very enlightening approach, isn&#8217;t it? Okay so you&#8217;ve laid out what the problem is. I think this question may be not particularly relevant, but I would be interested to know. Why do you find this to be so important a cause? I mean it&#8217;s obvious the answer to that, isn&#8217;t it? But I want to hear you express in your own words why you&#8217;ve attached yourself to this and why you believe it&#8217;s important.</p>\n\n\n\n<p>[00:12:36] <strong>Pooja Derashri:</strong> DEIB basically means we are making a big circle of friends where everyone is invited, treated fairly and feels like they are one of them. And it is important because when people work, play, and live together with love and respect, then the world becomes a happier and stronger place for everyone.</p>\n\n\n\n<p>When we talk about open source projects, open source projects make sure that everyone is included and feels they belong to this community. It encourages other people to come and share their skills.</p>\n\n\n\n<p>So it is important basically because our world will be more happier, stronger, and people live with peace and harmony. If they are not biased, they are living together with respect. All person are welcomed.</p>\n\n\n\n<p>[00:13:29] <strong>Nathan Wrigley:</strong> What a lovely answer. I&#8217;m really quite touched by that, that&#8217;s beautiful. The next thing that you wanted to talk about is really interesting to me, because I haven&#8217;t given this too much thought. And it&#8217;s the idea that the problem may not be something that people are necessarily conscious of. And in the share notes that you&#8217;ve shared with me, you&#8217;ve talked about this thing called unconscious bias. And I have an intuition as to what you&#8217;re meaning there but I&#8217;d like you to explain that. What is unconscious bias? Let&#8217;s delve into that a little bit.</p>\n\n\n\n<p>[00:14:01] <strong>Pooja Derashri:</strong> Basically, a sneaky or hidden friend in your mind, brain. Who sometimes make a decision for you, without you even realising it. For example, imagine your favorite color is blue. Sometimes without thinking much, you choose blue color in everything, because your brain automatically likes them. What if that happens with people not color? If your mind is unconsciously like a certain kind of people then you will be not inclusive in environment.</p>\n\n\n\n<p>[00:14:35] <strong>Nathan Wrigley:</strong> So the idea being that, and I guess we can all admit to this in many aspects of our lives, we have things that instinctively, we can&#8217;t quite necessarily understand why, there are certain things that we are drawn to. The taste of a particular meal, a particular color, the kind of vacation that you want to go on, the kind of things that you like to do in your spare time.</p>\n\n\n\n<p>We have all of these biases, that have crept into our lives over time, and we may not be aware of them but they impact the decisions that we make. So we may feel that we&#8217;re being equal and thoughtful, and we&#8217;re giving everybody the greatest opportunity possible. But somehow, somewhere, our brain is stepping in and making a slightly different decision.</p>\n\n\n\n<p>So if that&#8217;s the case, how do you spot your unconscious bias? Because, by definition, it&#8217;s unconscious. You&#8217;re unaware that it&#8217;s happening, but clearly there must be a way of short circuiting that problem, and figuring out, okay take a step back, have a think about that, was that the right decision? What&#8217;s the conversation that you need to have with yourself or your colleagues, or whatever it may be?</p>\n\n\n\n<p>[00:15:38] <strong>Pooja Derashri:</strong> Yeah. When you or your colleague indicate that you are facing unconscious biased to someone, for example, I will explain this with a core contributor example. Like imagine two programmers submitting code changes to a project. One programmer is well known to the community, and the other is new and less known, less famous.</p>\n\n\n\n<p>Due to our unconscious bias, the community might pay more attention to the code changes from the well known programmer, assuming that they are of higher quality. But it is not like that. Your newcomer can be a good coder and he might of submitted a nice or similar coding. This can lead to the new programmer&#8217;s contribution being overlooked or undervalued.</p>\n\n\n\n<p>If we are doing this kind of bias then we are not doing intentionally. This is something unconsciously we are doing, if we say about in open source. So when someone indicates this to us, first we should accept that we are becoming a biased person for some particular coder, or some particular person. Then we should self realise that how we can give both of them a fair chance by looking into their code or by giving them fair opportunities.</p>\n\n\n\n<p>[00:16:59] <strong>Nathan Wrigley:</strong> It&#8217;s very difficult, isn&#8217;t it, to be as reflective as that. So I would imagine that in almost any unconscious bias that you may have, be it towards code or, you know the kind of food that you like, there is something very deep in that. And so when somebody points it out that you have a bias, sometimes the shutters go up if you like, and you feel that that&#8217;s a, well I guess you could describe it as a personal attack.</p>\n\n\n\n<p>You&#8217;ve been biased there. You&#8217;ve clearly exhibited some bias. It&#8217;s not always straightforward to admit to yourself that you have these biases. And so I guess that&#8217;s the enterprise that we&#8217;re going to discuss now. How do we build an inclusive culture? In which people are able to recognise that, yes they have biases, yes they need to pay attention to that, or at least listen to other people&#8217;s opinions.</p>\n\n\n\n<p>So let&#8217;s move on to that. Your third point, if you like, building inclusive cultures. Before we get into the meat and the bones of that, I&#8217;d like to ask what you think broadly about how WordPress as a community is doing with all of this. Because it feels like at the moment this is a particularly hot topic, for want of a better word. It feels like it&#8217;s getting lots of coverage, lots of endeavors are being made.</p>\n\n\n\n<p>I&#8217;m not making the claim that everything is perfect, but it feels like this is a conversation which is becoming increasingly normal. We&#8217;re constantly being told about this and we&#8217;re constantly alert and aware of this. So, how do you think we do as a community, the WordPress community? What can we do, and how are we doing?</p>\n\n\n\n<p>[00:18:32] <strong>Pooja Derashri:</strong> Actually in my perspective taking the DEIB initiative doesn&#8217;t mean just ticking the boxes. It is all about where people feel they are among all of us. And nurturing the community of where everyone feels respected, valued, and their voices are heard. As you said, this is already a hot topic that is discussed everywhere in the community right now.</p>\n\n\n\n<p>Few of the initiatives, in my opinion, are very great, WordPress community is taking. Like WordPress 6.4 release, it is lead by all women, and non binary people. So that many underrepresented people will get a chance to be part of the release squad, in spite of their background or something.</p>\n\n\n\n<p>In another way, if we speak about workshop, that is a great initiative. Like Jill Binder is doing workshops on diversity in every part of the world. And for a few years Jill Binder has been running a workshop, and promoting and uplifting diverse people who are not so comfortable in public speaking, but are expert in their respective fields. There she&#8217;s uplifting them, and creating an inclusive environment. So they feel comfortable, and can deliver their talk, and can be a part of this WordPress family.</p>\n\n\n\n<p>And one of the great examples, great initiatives taken by Birgit Olzem, she submitted a proposal for forming an official Make WordPress DEIB team, so that DEIB can be implemented in every aspect of WordPress, with every WordPress Make team, and can align with other make teams.</p>\n\n\n\n<p>This will be discussed in the community summit. I guess today this is going to be discussed. I must say I&#8217;m really excited, what happened and what the outcome and decision was made on this topic. And I would be really happy if this team was to be in existence.</p>\n\n\n\n<p>And if you heard about a month ago, there was a mentorship program initiated by Hari Shanker. Initiatives taken by Hari Shanker started a project called Mentorship Program, Contributor Mentorship Program. In this a dedicated mentor is assigned to a mentee, or what we say, new contributor who wants to contribute to WordPress, but doesn&#8217;t know how to contribute, how to start.</p>\n\n\n\n<p>So the mentor can guide them, and help them to onboard as a contributor. Basically they are creating a path for them to feel included in this environment and get settled. As soon as they join they feel belonging. They have a sense of belonging in this WordPress community as soon as they join.</p>\n\n\n\n<p>So it was great I must say. It was a pilot project but it was a great success. So many contributers who are now regularly contributing to the WordPress projects, and bringing their fresh ideas and innovation to that. So these are a few examples or initiatives community is taking now.</p>\n\n\n\n<p>[00:21:55] <strong>Nathan Wrigley:</strong> How do you feel then about how the WordPress community is doing? I should add that I will link in the show notes to the make.wordpress.org piece which is talking about the establishment of a diversity, equity, inclusion, and belonging team. And there&#8217;s also, as I said, an episode with Birgit and Jill which you can find in the WP Tavern podcast archive if you want to go a little bit deeper, but I will link to those.</p>\n\n\n\n<p>How do you feel that wordPress as a community is doing in comparison to other parts of the tech industry? Do you feel that WordPress is perhaps at the cutting edge? Or are we taking our cues from other communities which have been there, done that, tackled this problem before us?</p>\n\n\n\n<p>It feels a lot of the things that WordPress is doing are fairly innovative. So we are having to create, as a community, these things for ourselves. But I could be wrong about that. So perhaps we could just have a chat about whether WordPress is at the vanguard of this or not.</p>\n\n\n\n<p>[00:23:00] <strong>Pooja Derashri:</strong> Yes, in my opinion if we go back five or ten years back in WordPress community then the WordPress community was not that diverse. But in the past few years the community is taking diversity very seriously, and taking a great initiative so every person all across the globe can share their feelings, or share their ideas, and they are implemented.</p>\n\n\n\n<p>I&#8217;m taking one of my example, when I joined the training team in 2019, the team was gearing up for the initial WordPress launch. Then Courtney Robertson and Hauwa Abashiya was the team rep at that time. And I was like, I was having a coding background, I don&#8217;t know about how content works, and how I can contribute and help in that. They helped me in a lot in onboarding to the training team, and they helped me to learn the process. And soon after I got involved and Learn WordPress launched.</p>\n\n\n\n<p>After that we worked hard on the training team to make it as diverse across the globe. That time from basically APAC region, there was not much contribution. So we created an inclusive environment in team, everyone can come and ask everything. We were available. We all work from different parts of the world. So we can say we were available 24 hours at that time.</p>\n\n\n\n<p>We were trying our best to treat everyone equally, no matter where they are from. At that time I started APAC meetings to boost the contribution in this region. We run some workshops to explain what the training team, and what it does.</p>\n\n\n\n<p>I understand the true meaning of how a diverse team can work together to raise awareness and bring all other members on board, and then they can become a part of the regular contribution.</p>\n\n\n\n<p>[00:25:09] <strong>Nathan Wrigley:</strong> Yeah thank you. The fifth part that I&#8217;ve got written down here in our shared show notes is your desire to make sure that underrepresented voices are empowered. And I wonder if you could expand on that a little bit. What was it that you were meaning there? Who are you meaning by underrepresented? What are the things that need to be done in order to empower those voices?</p>\n\n\n\n<p>[00:25:35] <strong>Pooja Derashri:</strong> So it depends. If we talk about the tech world, basically in the programming field there are more male coders involved in comparison. Not like I&#8217;m saying all programmers are male, but in comparison to that there are more male representative are there.</p>\n\n\n\n<p>The lack of representation can be based on various factors just like gender, race, ethnicity, age, geographic location. There can be a more diverse perspective and less inclusive community that can be underrepresented. Few examples like female minorities, people of color, non English speakers, developing countries, accessibility advocates.</p>\n\n\n\n<p>One more example can be non technical roles, LGBTQ+ individuals. It&#8217;s important to address the underrepresented of these groups to ensure that the WordPress community is diverse, inclusive, and welcoming to everyone. No matter who they are and what background they came from. As a community, our efforts to promote diversity and inclusion can include targeted outreach, like some mentorship programs, creating a safe space, providing them resources if they want.</p>\n\n\n\n<p>Your question was, how can we empower the underrepresented voices? It&#8217;s crucial for creating a more diverse and inclusive environment in community, or in an organisation, or in industries, including open source or WordPress community. We can amplify their achievements like recognising and highlighting their contributions, and provide them equal opportunities and their voices are heard in bigger roles.</p>\n\n\n\n<p>We can provide diverse leadership. We can create a safe space for them so they feel comfortable in speaking, or in putting their skills in front of everyone. Basically a long term commitment, empowering in underrepresented voices is an ongoing effort. It requires consistent dedication, and a commitment to sustainable change.</p>\n\n\n\n<p>[00:28:02] <strong>Nathan Wrigley:</strong> I&#8217;m curious in your last little portion there you mentioned quite a few different things. When I hear conversations around diversity and inclusion and DEIB in general, there are certain topics which come into my mind, and it might be things in the community which I&#8217;ve heard of recently. So I don&#8217;t know, it might be that there&#8217;s equal representation at WordPress events, that we make sure that the speaker lineup is diverse.</p>\n\n\n\n<p>But curious there that you listed out quite a few other things as well. So for example, just geographical, the spread of where you are on the planet. You need to think perhaps differently depending on where you&#8217;re based, and the metrics by which you would measure how you&#8217;re doing in this sphere may be different in, for example, India than it would be where I am in the UK.</p>\n\n\n\n<p>So it doesn&#8217;t feel like there&#8217;s one size fits all. There&#8217;s no standard operating procedure for making sure this is all done correctly. Different parts of the world may be on a different journey and have a different trajectory, and have different things that they need to focus on. Would you say that&#8217;s true?</p>\n\n\n\n<p>[00:29:10] <strong>Pooja Derashri:</strong> Yes, different parts of countries may have different perceptions regarding diversity. I agree with your point that our WordPress related events are focusing on diverse speaker lineup. If we check our WordCamp US speaker lineup, that is much diverse. And similarly in WordCamp Asia, where I was part of speaker organising teams, we put our full efforts in creating a diverse speaker lineup. So yeah, I completely add with your point. We might have different perceptions, we might have different geographical location. There are different means of diversity.</p>\n\n\n\n<p>[00:29:50] <strong>Nathan Wrigley:</strong> Now inevitably when this kind of conversation comes around, there are always people in the community who have a very different opinion. And they have the opinion that, well really I&#8217;m only here for the code. I want to be able to download the WordPress code base, I want to be able to use WordPress, I want to make it the foundation of my business and so on and so forth.</p>\n\n\n\n<p>And they push back and they say look conversations like this, they&#8217;re not relevant. It&#8217;s code, that&#8217;s all it is to me. What do you say to them? Clearly you would have a different opinion but, how do we get those people interested, and make it so that they feel that this is important? Because I feel that there&#8217;s quite a few members of the community who just say oh, can we just concentrate on the code? We don&#8217;t need to be worried too much about all these other tangential things.</p>\n\n\n\n<p>[00:30:41] <strong>Pooja Derashri:</strong> If we talk about specifically WordPress, there is nothing we can only do with code. There are other things as well like non code contribution. There are other teams, other contributors that are putting in their efforts to make it a successful project. Like a Polyglots team is putting so many efforts into converting WordPress projects into the other languages, so it can be used by so many other people.</p>\n\n\n\n<p>Similarly if we talk about docs team. Docs team is not putting coding efforts, but they are working on providing documentation so everyone can understand the process. Understand how to use WordPress, how you can build something on it, and how you can contribute.</p>\n\n\n\n<p>So basically it is not about you can only do it with code. Diversity in terms of every aspect in non code contribution also matters. The whole community came from coding, non coding and other. All the people came together and built a community. Not only one person or one kind of people, like all coders can build a community. It should be a collective effort and it should be a collective output in my opinion.</p>\n\n\n\n<p>[00:32:03] <strong>Nathan Wrigley:</strong> Yeah thank you, I think that was really nicely put. A good explanation of the problem at hand. Yeah that&#8217;s brilliant. Thank you.</p>\n\n\n\n<p>If we were to be a listener to this podcast and some of the messages that you&#8217;ve talked about click with us, and we think, yeah everything that Pooja said, that&#8217;s vitally important. I&#8217;m not involved in it yet. I&#8217;d like to be more involved with it. I wonder if you could give us some pointers as to how you might get involved. Perhaps you could tell us about places that we could go. I can link to anything that you mention in the show notes, so they&#8217;ll all be in there. But also maybe you could highlight some of the people who are doing good work in this area.</p>\n\n\n\n<p>So there&#8217;s obviously, you know you, yourself. But you mentioned Birgit Olzem and you&#8217;ve also mentioned Jill Binder, there&#8217;s a couple of other voices. But maybe there&#8217;s some other literature that you can point us in the direction of. Some websites, some project or endeavour that WordPress itself is doing, so that we can dig into this a little bit more.</p>\n\n\n\n<p>[00:33:03] <strong>Pooja Derashri:</strong> Yes. I would like to mention the mentorship program lead by Hari Shanker. More contributors from diverse community come and join the WordPress project. It is a nice initiative in my opinion.</p>\n\n\n\n<p>The WordPress six point release, they can join the WordPress six point release Slack channel and people will go through the process of how release works, and how, if they want to be a part of Core. There is not only they can part of Core by just coding. There are so many other areas like testing, like documentation, marketing, content training team. There are so many other teams they can also join.</p>\n\n\n\n<p>Courtney Robertson is also raising awareness about diversity and she is putting so much effort into onboarding to people from different parts of the world. So yeah these are the few things I would like to mention.</p>\n\n\n\n<p>[00:34:00] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s great. Thank you very much. And on a more personal note, if somebody has listened to this and they would like to make contact with you. Do you have a web page or a social media profile that you would point people towards?</p>\n\n\n\n<p>[00:34:17] <strong>Pooja Derashri:</strong> I&#8217;m available on Twitter at PoojaDerashri, the same handle as my name, P O O J A D E R A S H R I. I&#8217;m available on Make WordPress Slack channel. So if anyone wants to contact me they can contact me through Twitter or Make Slack WordPress channel.</p>\n\n\n\n<p>[00:34:38] <strong>Nathan Wrigley:</strong> Well Pooja, thank you for joining me today. I think I have asked all of the questions that I wish to ask. I&#8217;ll just end by giving you the opportunity, if there was anything else that you wanted to add. If not I will say thank you very much for joining us and giving us some really important information about this really important subject. So over to you if there&#8217;s anything that I missed.</p>\n\n\n\n<p>[00:35:00] <strong>Pooja Derashri:</strong> No actually you have covered everything very well and I think there is nothing I would like to mention in hand. Just one thing I would like to state here, I heard in one of the workshops by Jill Binder that many underrepresented are experts. She shared in one of the workshops where people sometimes have a misconception that there are two different type of people, like WP experts and the underrepresented. But there is not something like that. My personal conception was changed after hearing her workshop that she stated that many underrepresented people are also experts.</p>\n\n\n\n<p>[00:35:45] <strong>Nathan Wrigley:</strong> Okay thank you. Pooja Derashri, thank you so much for joining us on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:35:51] <strong>Pooja Derashri:</strong> Thank you. Thank you so much</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/poojaderashri\">Pooja Derashri</a>.</p>\n\n\n\n<p>Pooja is a co-founder of <a href=\"https://wpvibes.com/\">WPVibes</a>, a plugin development company based in India. With a passion for WordPress, Pooja has been actively involved in the community since 2013. Her journey as a contributor began in 2017, when she attended her first local WordCamp. Her expertise and dedication have earned her various key roles in the WordPress ecosystem. She currently serves as a co-team rep for the training team and GTE for the Hindi locale. In addition, she holds key positions in the WordPress release squad for versions 6.3 and 6.4, where she heads up the test team.</p>\n\n\n\n<p>Pooja shares her insights on the importance of diversity, equity, inclusion, and belonging within the WordPress community, and explores how you don’t need to be a coder to be a part of the community and all that it is.</p>\n\n\n\n<p>We discuss the work of teams like Polyglots, who focus on translating WordPress projects into different languages, and Docs, who provide much needed documentation to help users understand and contribute to the platform. These initiatives alone make it clear that WordPress is reliant on non-coding contributions, and there are more ways to contribute than ever before.</p>\n\n\n\n<p>I ask Pooja about her experiences with diversity and inclusivity in the tech industry, and she reflects on the challenges she has faced, discussing the importance of recognising and addressing unconscious biases. She shares her insights on the need for training and workshops that empower diverse individuals to contribute and speak up within the WordPress community.</p>\n\n\n\n<p>We delve into Birgit Olzem&#8217;s proposal to form an official DEIB team within WordPress, aiming to implement diversity, equity, inclusion, and belonging throughout the whole community. I express my excitement about the potential outcome of this proposal, and we think about how WordPress compares to other parts of the tech industry.</p>\n\n\n\n<p>We explore the various initiatives and efforts being made to build a more inclusive WordPress culture. From mentorship programs, to targeted outreach and safe spaces, we uncover the ways in which underrepresented voices are being uplifted.</p>\n\n\n\n<p>If you’re interested in creating a more inclusive community, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links mentioned in the podcast</h2>\n\n\n\n<p><a href=\"https://wptavern.com/podcast/94-birgit-olzem-and-jill-binder-on-creating-a-diverse-and-sustainable-wordpress-community\">Jukebox Podcast #94 – Birgit Olzem and Jill Binder on Creating a Diverse and Sustainable WordPress Community</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/training/\">Training team</a></p>\n\n\n\n<p><a href=\"https://twitter.com/poojaderashri\">Pooja&#8217;s Twitter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Links supplied by Pooja in relation to the podcast</h2>\n\n\n\n<p><a href=\"https://heropress.com/\" target=\"_blank\" rel=\"noreferrer noopener\">HeroPress</a> by Topher DeRosia</p>\n\n\n\n<p><a href=\"https://yoast.com/yoast-diversity-fund/\" target=\"_blank\" rel=\"noreferrer noopener\">Yoast Diversity Fund</a></p>\n\n\n\n<p><a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\" target=\"_blank\" rel=\"noreferrer noopener\">Kim Parsell Memorial Scholarship</a></p>\n\n\n\n<p><a href=\"https://opencollective.com/thewpcc\" target=\"_blank\" rel=\"noreferrer noopener\">The WP Community Collective</a>&nbsp;by Courtney Robertson, Sé Reed, and Katie Adams Farrell</p>\n\n\n\n<p><a href=\"https://www.underrepresentedintech.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Underrepresented in Tech</a>&nbsp;by Allie Nimmons and Michelle Frechette</p>\n\n\n\n<p><a href=\"https://wpspeakers.com/\" target=\"_blank\" rel=\"noreferrer noopener\">WP Speakers</a>&nbsp;by Michelle Frechette</p>\n\n\n\n<p><a href=\"https://womeninwp.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Women in WP Show</a> by  Amy Masson,  Tracy Apps, and Angela Bow</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/project/2023/07/13/proposal-for-establishing-a-make-diversity-equity-inclusion-and-belonging-deib-team-within-the-wordpress-community/\" target=\"_blank\" rel=\"noreferrer noopener\">DEIB Make WordPress team proposal</a> by Birgit Olzem</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/diversity-speaker-training-workshop/\" target=\"_blank\" rel=\"noreferrer noopener\">Diversity Workshops</a> by  Jill Binder</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/project/2023/08/11/the-inaugural-cohort-of-the-wordpress-contributor-mentorship-program-has-concluded/\" target=\"_blank\" rel=\"noreferrer noopener\">Contributor Mentorship Program&nbsp;</a>by&nbsp; Hari Shanker</p>\n\n\n\n<p><a href=\"https://www.youtube.com/@gowithwp\" target=\"_blank\" rel=\"noreferrer noopener\">Go with WP</a> podcast by the Nepal Community</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Akismet: 10 Powerful AI Marketing Tools to Grow Your Business in 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=281899\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://akismet.com/blog/ai-marketing-tools-for-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:38655:\"<p>AI (artificial intelligence) has drastically changed the way many industries operate. In particular, there are tons of AI marketing tools that make it quicker and easier to manage (and expand) your business. But with the growing popularity of these tools, you might find it difficult to keep up with your competitors.&nbsp;</p>\n\n\n<p>Luckily, you can retain your competitive edge and expand your business by implementing the best AI marketing tools. You can find anti&#8209;spam software, customer service automation tools, email marketing programs, and more that can take care of routine tasks and procedures. This way, you can get more done with less&nbsp;time.</p>\n\n<p>In this post, we’ll take a closer look at the features you should look for in AI marketing tools. Then, we’ll explore ten of the best AI tools for&nbsp;business.</p>\n\n\n<span id=\"more-281899\"></span>\n\n\n<h2 class=\"wp-block-heading\">What features should businesses seek in an AI marketing&nbsp;tool?</h2>\n\n\n<p>With the emergence of AI in the marketing industry, it’s much quicker and easier to complete many routine tasks. You can find tools that help you automate email campaigns, research keywords, write content, and more.&nbsp;</p>\n\n\n\n<p>When you’re able to get these tasks done faster, you can free up time to invest into other aspects of your business. Or, you can implement AI tools that help you improve your current practices. For instance, you can find advanced programs to conduct competitor research or optimize your ad campaigns.&nbsp;</p>\n\n\n<p>No matter what your motivation for using artificial intelligence marketing tools, there are a few key features to look out for when choosing them. Here are some of the main factors to&nbsp;consider:</p>\n\n\n<ul><li><strong>Automation. </strong>Automated tools, as the name suggests, work automatically. Since these tasks take place in the background, they often require minimal effort and input once&nbsp;configured.</li>\n\n<li><strong>Customization options. </strong>It’s important to find a solution that offers various customization options. This way, you can create a unique tool that fits in seamlessly with the rest of your business and&nbsp;brand.</li>\n\n<li><strong>Personalization. </strong>The drawback of using automated solutions is that you can end up adopting a one&#8209;size&#8209;fits&#8209;all approach. Still, the best AI marketing tools will provide a great deal of personalization both for you and your&nbsp;customers.</li>\n\n\n<li><strong>Data analytics. </strong>It’s vital to have access to analytics for any marketing activity for your business. This way, you can identify what’s working and what isn’t. Then, you can adjust your approach accordingly.&nbsp;</li>\n</ul>\n\n\n<p>With these things in mind, you’ll be better equipped to find the right AI marketing tools to complement your marketing&nbsp;strategy.</p>\n\n\n<h2 class=\"wp-block-heading\">The 10 best AI tools for marketing&nbsp;</h2>\n\n\n<p>Now that you know what to look for in an AI marketing tool, let’s check out ten of the best options to help grow your&nbsp;business.</p>\n\n\n<img width=\"1600\" height=\"866\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-9.png\" alt=\"Akismet home page design\" class=\"wp-image-282629\" />\n\n\n<h3 class=\"wp-block-heading\">1. <a href=\"https://akismet.com/\">Akismet: AI anti&#8209;spam that boosts conversion&nbsp;rates</a></h3>\n\n\n<p>Akismet is an automated tool that filters out comment and form spam with an accuracy rating of 99.99 percent. Better yet, the tool analyzes every piece of user-submitted content in real time to protect your site from attacks.&nbsp;</p>\n\n\n<p>The Akismet plugin provides an easy way to save time, since it can take hours to manually review comments and form submissions. In fact, the average Akismet user saves 20 hours a month by switching over from manual&nbsp;filtering.</p>\n\n<p>One of the most common ways to block spam online is to <a href=\"https://akismet.com/blog/wordpress-captcha/\">implement a CAPTCHA</a>. But this adds friction to the user experience, which can result in fewer conversions and sales. <a href=\"https://akismet.com/features/\">Akismet</a>, on the other hand, blocks spam without disrupting the user experience.&nbsp;</p>\n\n\n<p>Trusted by companies like Microsoft, Bluehost, <a href=\"https://akismet.com/blog/convertkit-customerstory/\">and ConvertKit</a>, Akismet blocks bots, but provides a quicker, smoother process for real people. Without the need to find all the stop lights or decipher jumbled text, more people will complete your forms and your bottom line can improve overnight.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Spam filters with 99.99 percent&nbsp;accuracy</li>\n\n<li>Form, text, and <a href=\"https://akismet.com/blog/best-wordpress-comment-plugins-compared/\">comment spam</a>&nbsp;protection</li>\n\n<li>The ability to save 20 hours per month managing&nbsp;spam</li>\n\n\n<li>Real-time analysis</li>\n\n\n<li>An open API&nbsp;key</li>\n\n<li>Customizable enterprise&nbsp;solutions</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>You can install and activate the Akismet plugin directly through your WordPress dashboard. Then, simply access the dedicated interface to find out how many pieces of spam have been blocked. You can also configure your privacy, filtering, and comments settings using simple checkboxes.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n\n<p><a href=\"https://akismet.com/pricing/\">Akismet plans</a> for businesses start at $4.95 per month.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"627\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-23.png\" alt=\"HubSpot homepage, with details about the tool\" class=\"wp-image-283373\" />\n\n\n<h3 class=\"wp-block-heading\">2. <a href=\"https://www.hubspot.com/products/marketing/marketing-automation\" target=\"_blank\" rel=\"noreferrer noopener\">HubSpot Marketing&nbsp;Automation</a></h3>\n\n<p>HubSpot provides one of the easiest ways to automate your marketing campaigns. The software uses intuitive workflows to help you launch campaigns quickly — across mediums like email, websites, SMS, and&nbsp;more.</p>\n\n<p>For instance, you can build beautiful email templates with no code. Then, configure triggers and actions to send the right emails to the right people at the right time. This way, you’re able to create more email campaigns, generate more leads, and conduct regular&nbsp;follow&#8209;ups.</p>\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Email drip campaigns (with triggers, conditions, and&nbsp;actions)</li>\n\n<li>Targeted workflows with a visual&nbsp;editor</li>\n\n\n<li>Advanced segmentation</li>\n\n\n<li>The ability to personalize campaigns with CRM&nbsp;data</li>\n\n<li>Internal notification triggers following key&nbsp;actions</li>\n\n\n<li>Automated task reminders&nbsp;</li>\n\n\n<li>Logs of important campaign&nbsp;metrics</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n<p>Some of HubSpot’s tools can be complex and difficult to work with. But the marketing automation platform makes nearly every function accessible from the primary&nbsp;dashboard.</p>\n\n\n<p>It doesn’t require any coding experience, though coding is still an option for users who want to refine their marketing assets. Better yet, you’ll get access to a growing library of templates, reusable layouts, and resources to help you get started.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n\n<p>You can try HubSpot’s marketing tools for free after creating an account. Or upgrade to the <a href=\"https://www.hubspot.com/pricing/marketing/\" target=\"_blank\" rel=\"noreferrer noopener\">Starter plan</a> for $18 per month.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"630\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-24.png\" alt=\"Grammarly homepage with screenshots\" class=\"wp-image-283375\" />\n\n\n\n<h3 class=\"wp-block-heading\">3. <a href=\"https://www.grammarly.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Grammarly</a></h3>\n\n\n<p>Grammarly is a popular AI marketing tool that instantly generates clear, concise content. While Grammarly is well known for its spelling and grammar checking abilities, you can also use the software to improve your writing style and brand voice throughout your content&nbsp;creation.</p>\n\n\n<p>One of the best parts about Grammarly is that you can use it directly within your desktop applications and across the web. So you can easily improve all content from emails and social media posts, to documents.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>GrammarlyGo, which enables you to write full content pieces with just a&nbsp;prompt</li>\n\n<li>Summarized emails, and the ability to respond using context&#8209;specific&nbsp;prompts</li>\n\n<li>Integration on desktop and&nbsp;mobile</li>\n\n<li>Guidance to adjust the tone and attitude of your&nbsp;writing</li>\n\n<li>The ability to create shared guidelines across your&nbsp;team</li>\n\n<li>Integrations with over 500,000 applications, like Gmail, Google Docs, Microsoft, and&nbsp;Slack</li>\n\n<li>Enterprise&#8209;grade privacy and&nbsp;security</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>Once you install Grammarly, you can select your preferred English dialect and writing style in your account settings. Then, the tool works automatically to elevate your writing.&nbsp;</p>\n\n\n\n<p>You’ll receive various types of suggestions, highlighted in different colors. Then, you’re able to click on each suggestion to find more information about it. Plus, it’s easy to accept or reject the suggestions.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n\n<p>It’s completely free to create a Grammarly account. Or, opt for the <a href=\"https://www.grammarly.com/plans\" target=\"_blank\" rel=\"noreferrer noopener\">Premium plan</a> to access full-sentence rewrites, tone suggestions, and vocabulary ideas. This costs $12 per month with an annual subscription.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"673\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-25.png\" alt=\"Synthesia homepage with a video\" class=\"wp-image-283378\" />\n\n\n\n<h3 class=\"wp-block-heading\">4. <a href=\"https://www.synthesia.io/\" target=\"_blank\" rel=\"noreferrer noopener\">Synthesia</a>&nbsp;</h3>\n\n\n<p>Synthesia is a neat AI marketing tool that instantly converts your written content into high&#8209;quality videos. You can choose from a bunch of natural&#8209;sounding AI voices in over 120 languages. Meanwhile, you’re able to make your videos more engaging with over 140&nbsp;avatars.</p>\n\n\n<p>Synthesia is a great choice for agencies that produce training videos at scale. You can create, share, and edit videos all in one place. And, there are plenty of e-learning courses in sales, customer service, and marketing to help get your team up to speed.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Consistent voices in over 120&nbsp;languages</li>\n\n<li>Automatic closed&nbsp;captions</li>\n\n<li>The ability to clone your own&nbsp;voice</li>\n\n<li>Over 140 avatars (or create your&nbsp;own)</li>\n\n<li>Video prototypes that you can share with your&nbsp;team</li>\n\n\n<li>One-click video updates&nbsp;</li>\n\n\n\n<li>SOC 2 and GDPR compliance&nbsp;&nbsp;</li>\n\n\n\n<li>Over 200 free templates&nbsp;</li>\n\n\n<li>Integrations with WordPress and&nbsp;YouTube</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>This AI video generator is very easy to use thanks to Synthesia’s clean, simple interface. To start making videos, you’ll enter your audience and topic before generating a script.&nbsp;</p>\n\n\n\n<p>Next, you’re able to choose a layout for all the different scenes. Then, you can replace avatars, edit your script directly, and overlay text, images, or your business logo. When you’re done, you can download the video to share as part of your social media marketing or generate a handy link to embed it on your website.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n\n<p>Synthesia provides custom enterprise packages for large companies following a demo. But, you can get started with the <a rel=\"noreferrer noopener\" href=\"https://www.synthesia.io/pricing\" target=\"_blank\">Synthesia Personal plan</a> for $22.50 per month.&nbsp;</p>\n\n\n\n<img width=\"1999\" height=\"912\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image14-1.png\" alt=\"Albert homepage with a dark background\" class=\"wp-image-283379\" />\n\n\n\n<h3 class=\"wp-block-heading\">5. <a href=\"https://albert.ai/\" target=\"_blank\" rel=\"noreferrer noopener\">Albert.ai</a></h3>\n\n\n<p>Albert is one of the best AI&#8209;powered tools for business because it can help you improve the effectiveness of your digital advertising. For instance, Albert can group keywords, build campaigns and audiences, manage budget allowance, optimize media, and provide reports with key&nbsp;insights.</p>\n\n<p>It’s a fully autonomous solution that can pretty much run the bulk tasks for certain marketing campaigns. This makes it one of the most valuable options on the list. All&#8209;in&#8209;all, it can save you tons of time, and improve the success of your&nbsp;campaigns.</p>\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Analytics with data&nbsp;visualization</li>\n\n<li>A dedicated dashboard to manage&nbsp;campaigns</li>\n\n\n<li>Calendar management</li>\n\n\n<li>A/B split&nbsp;testing</li>\n\n\n<li>Ad variations</li>\n\n\n<li>Budget allocation and&nbsp;scheduling</li>\n\n\n<li>Bid optimization&nbsp;</li>\n</ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>Albert gives you access to an intuitive dashboard where it’s easy to track your budget allowance and oversee your advertising tasks. Additionally, Albert can handle super complex tasks with ease, which saves your business time and resources. It’s constantly learning and adapting, so your campaigns will be continually improving.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n<p>Albert offers customized pricing plans. That means you’ll need to <a href=\"https://albert.ai/pricing/\" target=\"_blank\" rel=\"noreferrer noopener\">request an estimate</a> to get an idea of what you can expect to&nbsp;pay.</p>\n\n\n<img width=\"1600\" height=\"685\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-26.png\" alt=\"Phrasee homepage with examples of the tool in use\" class=\"wp-image-283381\" />\n\n\n\n<h3 class=\"wp-block-heading\">6. <a href=\"https://phrasee.co/\" target=\"_blank\" rel=\"noreferrer noopener\">Phrasee</a></h3>\n\n\n<p>Phrasee provides one of the easiest ways to elevate your online marketing messaging. You can use the software to predict what content will resonate most with your audience. Plus, you can optimize all of your content, and gain insight into what’s working and what’s&nbsp;not.</p>\n\n<p>What’s more, Phrasee is a great option for agencies, since each team member will get access to a stylish dashboard where they’ll find performance data and language insights. Here, you can also automate A/B split tests, and create high&#8209;performing marketing content for every stage of your customer journey to more effectively implement your marketing&nbsp;strategy.</p>\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Copy generation in real&nbsp;time</li>\n\n<li>Content Engine, which crafts material that’s backed by&nbsp;data</li>\n\n<li>Brand compliance&nbsp;support</li>\n\n<li>Support for all major digital channels, from emails to blog&nbsp;posts</li>\n\n<li>The ability to adjust the distribution of your message variants on the&nbsp;fly</li>\n\n<li>Integration with leading ESPs, CDPs, and digital engagement&nbsp;platforms</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>Phrasee is a complex tool, but it’s easy to learn how to use. You can access all of Phrasee’s AI features from one intuitive dashboard.&nbsp;</p>\n\n\n\n<p>Plus, the platform offers planning, creation, optimization, and analytics, so you won’t need separate solutions for each of these tasks. Better yet, it’s a great option for enterprise marketing teams, since the package includes unlimited seats.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n<p><a href=\"https://phrasee.co/pricing/\" target=\"_blank\" rel=\"noreferrer noopener\">The Starter plan</a> costs $500 a month, but includes unlimited content writing and unlimited seats. Phrasee also offers flexible enterprise solutions which might be best for larger&nbsp;businesses.</p>\n\n\n<img width=\"1600\" height=\"736\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-27.png\" alt=\"FullStory homepage with stats about their success\" class=\"wp-image-283384\" />\n\n\n\n<h3 class=\"wp-block-heading\">7. <a href=\"https://www.fullstory.com/\" target=\"_blank\" rel=\"noreferrer noopener\">FullStory</a></h3>\n\n\n\n<p>FullStory uses proprietary autocapture technology to monitor the quality of your digital experience. For instance, you can see where (and why) visitors are struggling with your website or mobile app.&nbsp;</p>\n\n\n\n<p>Better yet, the software flags opportunities for improvement, and prioritizes these changes by quantifying impact. This way, you can reduce friction on your site and increase sales and conversions. And, with tons of integrations, FullStory can work seamlessly with tools that your team is already using.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Tagless web&nbsp;autocapture</li>\n\n<li>Core product&nbsp;analytics</li>\n\n\n<li>Conversion analysis</li>\n\n\n\n<li>Retention analysis</li>\n\n\n\n<li>Session replays</li>\n\n\n<li>Robust privacy&nbsp;settings</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>FullStory is a highly user-friendly tool, especially when it comes to developing analytics. All you need to do is create a metric and add it to your dashboard.&nbsp;</p>\n\n\n\n<p>You can also set up different dashboards with different metrics. Better yet, FullStory adapts a “set it and forget it” model, so you can simply return to the dashboard to check on your website’s performance.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n<p>FullStory offers <a href=\"https://www.fullstory.com/plans/\" target=\"_blank\" rel=\"noreferrer noopener\">three plans</a>: Business, Advanced, and Enterprise. But, you won’t find prices on the website. The good news is that you can test the product for 14 days. Plus, you can speak with a professional to choose the right plan for your&nbsp;business.</p>\n\n\n<img width=\"1600\" height=\"793\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-28.png\" alt=\"Zapier homepage with icons of tools it integrates with\" class=\"wp-image-283385\" />\n\n\n\n<h3 class=\"wp-block-heading\">8. <a href=\"https://zapier.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Zapier</a></h3>\n\n\n<p>Zapier is a handy AI marketing tool that enables you to build custom workflows and automate many routine tasks. Better yet, it can connect tons of apps that you’re currently using to help save time and&nbsp;energy.</p>\n\n<p>All you need to do is describe what you want to automate and Zapier will write the code and build the Zaps for you. Additionally, many tasks can be automated directly within the ChatGPT interface where you can execute over 30,000 Zapier&nbsp;actions.</p>\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>More than 30 AI app&nbsp;partners</li>\n\n\n<li>Multistep Zaps</li>\n\n\n<li>The ability to save multiple versions of your&nbsp;Zaps</li>\n\n<li>Retries for any task&nbsp;failures</li>\n\n<li>Custom logic based on certain&nbsp;conditions</li>\n\n\n<li>Advanced workflows</li>\n\n\n<li>Shared app connections (Team&nbsp;plan)</li>\n\n<li>Live chat (Team&nbsp;plan)</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>Zapier easily makes connections between various apps, so you don’t need to manage them all separately. Better yet, since Zapier automates actions between apps, you don&#8217;t need to monitor tasks yourself. In Zapier’s well-organized interface, you’ll lay out the triggers and steps that you want to occur, and the tool takes care of all the behind-the-scenes coding.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n\n<p>You can start with Zapier for free, but this will only give you access to 100 tasks per month and single-step Zaps. <a href=\"https://zapier.com/pricing\" target=\"_blank\" rel=\"noreferrer noopener\">Premium Zapier plans</a> are highly customizable. You can choose from four tiers, then select the number of tasks you can use per month, paying accordingly. Plans start at $19.99 per month for 750 tasks per month.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"853\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-29.png\" alt=\"Chatfuel homepage with a bright green background\" class=\"wp-image-283386\" />\n\n\n\n<h3 class=\"wp-block-heading\">9. <a href=\"https://chatfuel.com/\" target=\"_blank\" rel=\"noreferrer noopener\">ChatFuel</a></h3>\n\n\n<p>ChatFuel is one of the best AI tools for ecommerce businesses and marketers. It can help boost your lead generation and increase revenue on WhatsApp. It enables you to improve your customer service and response times by adding unlimited agents to just one business&nbsp;number.</p>\n\n\n<p>You’ll also get the verified green badge, so customers know you’re trustworthy. Then, you can display personalized messages, collect customer feedback, and activate drip campaigns with an automated triggering system.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>99.99 percent uptime&nbsp;guarantee</li>\n\n\n<li>GDPR compliance</li>\n\n\n\n<li>A/B testing</li>\n\n\n<li>Audience segmentation based on behavior and&nbsp;preferences</li>\n\n<li>Auto&#8209;replies to Instagram messages or&nbsp;mentions</li>\n\n<li>The ability to chat with visitors via the Messenger&nbsp;button</li>\n\n<li>Integration with&nbsp;ChatGPT</li>\n\n<li>The ability to sell products on&nbsp;WhatsApp</li>\n\n<li>Personalized messages to recover abandoned&nbsp;carts</li></ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>ChatFuel provides one of the easiest and most intuitive chatbots on the market. It gives you access to a straightforward platform that’s simple and scalable. Plus, there’s a wide range of features to configure more complex chatbots if you need them.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n<p>You can try out ChatFuel at no cost. The free plan supports 50 conversions per month. You can upgrade, with <a href=\"https://chatfuel.com/pricing-main\" target=\"_blank\" rel=\"noreferrer noopener\">premium ChatFuel plans</a> starting at $14.99 per&nbsp;month.</p>\n\n\n<img width=\"1600\" height=\"698\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-30.png\" alt=\"Keyword Insights AI homepage\" class=\"wp-image-283388\" />\n\n\n<h3 class=\"wp-block-heading\">10. <a href=\"https://www.keywordinsights.ai/\" target=\"_blank\" rel=\"noreferrer noopener\">Keyword Insights&nbsp;AI</a></h3>\n\n<p>With Keyword Insights AI, you’re able to generate thousands of keyword ideas and group them into topic clusters. Then, it’s easy to create and optimize content without spending lots of time implementing key search engine optimization&nbsp;techniques.</p>\n\n<p>Better yet, you can quickly identify the search intent behind your chosen keywords, whether it’s transactional, informational, or something else. Then, when you’re happy with your keyword choice, you can send the cluster for brief creation in just a click. All of this contributes to a smoother, faster content creation&nbsp;process.</p>\n\n\n<h4 class=\"wp-block-heading\">Key features:</h4>\n\n\n\n<ul><li>Clusters for up to 45,000&nbsp;keywords</li>\n\n<li>The ability to create content&nbsp;briefs</li>\n\n<li>Up to 20 keyword searches per&nbsp;month</li>\n\n<li>Live Chat&nbsp;support</li>\n\n<li>SERP Similarity&nbsp;Pro</li>\n\n<li>SERP Explorer&nbsp;Pro</li>\n\n<li>Team sharing and reporting (with paid&nbsp;plans)</li>\n\n\n<li>Cluster analysis</li>\n</ul>\n\n\n<h4 class=\"wp-block-heading\">Ease of&nbsp;use:</h4>\n\n\n<p>Keyword Insights AI gives you access to a user-friendly interface where you can generate a large list of keywords around a certain topic quickly and easily. Then, you can group keywords and uncover topical clusters that are missing from your content.&nbsp;</p>\n\n\n\n<p>Next, with the AI-driven content brief generator, you’re able to create an outline for a piece of content. And in just one click, you can send off the outline to your team for review, or direct the brief straight to your content writer.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Pricing:</h4>\n\n\n<p>You can try Keyword Insights AI for $1 for four days. Then, upgrade to one of its <a href=\"https://www.keywordinsights.ai/pricing/\" target=\"_blank\" rel=\"noreferrer noopener\">paid plans</a> from $58 per month. This includes 6000 keyword clusters, ten content briefs, and five keyword searches per&nbsp;month.</p>\n\n\n<h2 class=\"wp-block-heading\">Factors to consider when choosing an AI marketing tool&nbsp;</h2>\n\n\n<p>While there are many useful AI marketing tools available, it’s important to find the right option for your unique business needs. Here are some key factors to consider when choosing artificial intelligence platforms to&nbsp;implement.</p>\n\n\n<h3 class=\"wp-block-heading\">Algorithm type</h3>\n\n\n<p>There are four main types of machine learning algorithms to choose from. Since each algorithm can result in a different level of accuracy and performance, this is an important factor to consider before opting for a particular AI&nbsp;tool.</p>\n\n<p>For instance, supervised learning algorithms can draw conclusions, make estimations, and develop an understanding between different algorithms. Typically, this type of learning is used to analyze trends or make predictions about your&nbsp;content.</p>\n\n\n<p>You can also find tools that rely on semi-supervised learning. This works similarly to supervised learning, but it uses labeled (contains tags to help sort information) and unlabeled data.&nbsp;</p>\n\n\n<p>Meanwhile, unsupervised learning is a great way to identify patterns and correlations. It’s often used to cluster similar data sets for tasks like customer&nbsp;segmentation.</p>\n\n\n<p>Lastly, reinforced algorithms provide a set of parameters to teach the software using trial and error. These tools learn through experience and can adapt their approach according to different situations.&nbsp;</p>\n\n\n<h3 class=\"wp-block-heading\">Integration with other&nbsp;systems</h3>\n\n<p>While there are plenty of excellent AI tools, it’s important to assess whether the platform will fit nicely within your current workflow. So, it’s a good idea to take a look at the possible integrations, and how easy it is to connect the&nbsp;platforms.</p>\n\n\n<img width=\"1600\" height=\"916\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-31.png\" alt=\"list of available Akismet integrations\" class=\"wp-image-283390\" />\n\n\n<p>What’s more, it’s best to plan ahead when possible. For example, if you plan on expanding your business, you might be looking to upgrade certain systems. Keep this in mind when selecting your AI marketing tools. This way, you can prevent any future disruptions to your usual&nbsp;procedures.</p>\n\n<h3 class=\"wp-block-heading\">Ease of&nbsp;use</h3>\n\n\n<p>Most platforms that feature AI boast about speed and automation. It’s these qualities that enable you to increase productivity and manage (or monitor) your business more efficiently.&nbsp;</p>\n\n\n\n<p>But some AI tools for businesses can be tricky to set up. For instance, some complex platforms can require access to your CRM or other types of data, which can be difficult to establish.&nbsp;</p>\n\n\n<p>Additionally, while most AI tools don’t require any coding skills, they might not be suitable for beginners. That’s why it’s a good idea to thoroughly read the customer reviews to get a sense of a tool’s&nbsp;usability.</p>\n\n<p>Sometimes, you can even try a demo or access a free trial first. That way, you can determine whether the tool will be accessible and manageable for everybody on your team. Plus, you can sometimes find free resources and forums where you can gain support and solutions to your&nbsp;problems.</p>\n\n\n<h3 class=\"wp-block-heading\">Updates</h3>\n\n\n\n<p>No matter what kind of tool you add to your business (whether AI or not), it’s important to make sure that it’s updated regularly. This way, you know that the development team is still active, and the tool isn’t running outdated technology. You should expect new features to be released, which can give your business a competitive edge.&nbsp;</p>\n\n\n<p>But updates are also important for security. That’s because the longer a piece of software has been available, the more likely hackers can find a way around its security barriers. Meaning, outdated software can be used as a backdoor to your site. Plus, most updates come with fixes for common bugs and&nbsp;errors.</p>\n\n\n<p>When you’re dealing with an AI-powered tool specifically, updates are even more vital to the success of your business. This is because AI content creation tools are trained on resources until a certain point.&nbsp;</p>\n\n\n<p>For instance, <a href=\"https://openai.com/blog/chatgpt\" target=\"_blank\" rel=\"noreferrer noopener\">ChatGPT</a> is only trained on data until late 2021. Essentially, if your chosen AI tool isn’t being updated frequently, you risk publishing outdated content, which can affect your search ranking and&nbsp;trustworthiness.</p>\n\n\n<h3 class=\"wp-block-heading\">Scalability</h3>\n\n\n<p>Typically, when business owners and marketers start looking for new tools, they consider their current situation. But it’s important to consider future plans as well. Are you expecting any significant growth? Does your business fluctuate at certain times of the&nbsp;year?</p>\n\n<p>If this is the case, you can outgrow your new tool and require an upgrade, or, an entirely new solution. Therefore, it’s best to factor this into your decision&#8209;making process. You can even find specific AI marketing tools that offer plans that make it easy to scale resources up and&nbsp;down.</p>\n\n<h3 class=\"wp-block-heading\">Security and&nbsp;privacy</h3>\n\n<p>One of the most important factors when choosing the best AI tool is security and privacy. You’ll want to make sure that your business is protected, and that any sensitive data like customer information and payment details are kept&nbsp;confidential.</p>\n\n\n<p>With this in mind, pay attention to the tool’s data handling practices, encryption methods, and compliance with regulations like GDPR. That way, you can assess whether there are any risks associated with implementing the tool on your website.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Frequently asked questions&nbsp;</h2>\n\n\n<p>Up to now, we’ve tried to cover everything you need to know about AI marketing tools, but you still may have a few doubts. So, in this section, we’ll answer some of the most common questions on the&nbsp;subject.</p>\n\n<h3 class=\"wp-block-heading\">How do I know which AI marketing tool to&nbsp;choose?</h3>\n\n\n<p>Since there are so many diverse AI marketing tools, it can be difficult to choose the right solution for your business. Typically, this will depend on your own unique needs.&nbsp;</p>\n\n\n\n<p>In any case, Akismet is a great tool for practically every business, since spam will always be an issue for any website. With Akismet, you can block all comment, form, and text spam without the need to manually analyze every submission.&nbsp;</p>\n\n\n<p>Better yet, Akismet boasts a 99.99% detection accuracy rate. Unlike other anti&#8209;spam solutions such as CAPTCHAs, Akismet performs these tasks without disrupting the user&nbsp;experience.</p>\n\n<h3 class=\"wp-block-heading\">How can AI tools help businesses improve their marketing&nbsp;strategies?</h3>\n\n<p>There are tons of artificial intelligence tools that can help businesses improve their marketing strategies. Most of these platforms make it easier and quicker to perform certain functions, enabling you to increase your content output and make your campaigns more&nbsp;effective.</p>\n\n\n<p>For instance, you can identify thousands of keywords and topical clusters using a content strategy tool like AI Keyword Insights. Meanwhile, ChatFuel enables you to boost lead generation and revenue across social media marketing apps like WhatsApp, Instagram, and Facebook. Synthesia transforms simple text prompts into engaging videos in just a few minutes.&nbsp;</p>\n\n\n<h3 class=\"wp-block-heading\">How does AI help businesses with lead&nbsp;generation?</h3>\n\n\n<p>By implementing the best AI marketing tools, you can improve many aspects of your business, including lead generation.&nbsp;</p>\n\n\n\n<p>In particular, Akismet is a great way to get more leads on your website. That’s because the tool <a href=\"https://akismet.com/blog/best-anti-spam-wordpress-plugins-compared/\">protects your site against spam</a> (and the associated risks), without adding friction to the user experience.&nbsp;</p>\n\n\n\n<p>Many websites ask visitors to prove that they’re not a robot using protocols like CAPTCHA, this can be frustrating for visitors who might decide to exit your page.&nbsp;</p>\n\n\n<p>Akismet is more user&#8209;friendly, so it can help you increase conversions and sales on your&nbsp;site.</p>\n\n<h3 class=\"wp-block-heading\">What are the technical requirements for implementing AI tools in&nbsp;marketing?</h3>\n\n\n<p>The requirements for integrating and using AI tools will vary depending on your choice. Adding them to your workflows and practices may take a while, though the efficiency gained will quickly make it a worthwhile effort.&nbsp;</p>\n\n\n<p>But, if your site is on WordPress, implementing Akismet is as easy as installing the plugin directly from your WordPress&nbsp;dashboard.</p>\n\n\n<p>To do this, go to <strong>Plugins </strong>→ <strong>Add New </strong>within your WordPress dashboard. Here, search for “Akismet” and it will be the top option that’s presented.&nbsp;</p>\n\n\n\n<img width=\"1280\" height=\"636\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-32.png\" alt=\"Akismet plugin in the WordPress dashboard\" class=\"wp-image-283393\" />\n\n\n\n<p>Then, select <strong>Install Now </strong>→ <strong>Activate. </strong>After that, navigate to <strong>Settings </strong>→ <strong>Akismet Anti-Spam.&nbsp;</strong></p>\n\n\n\n<img width=\"316\" height=\"548\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-33.png\" alt=\"Aksimet Anti-Spam settings in the dashboard\" class=\"wp-image-283394\" />\n\n\n<p>If you already have an API key, click on <strong>Manually enter an API key. </strong>Or, choose <strong>Set up your Akismet&nbsp;account</strong>.</p>\n\n\n<img width=\"1600\" height=\"760\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-34.png\" alt=\"Akismet setup wizard\" class=\"wp-image-283395\" />\n\n\n\n<p>Since the tool starts working automatically, you can start enjoying robust anti-spam protection without lifting a finger.&nbsp;</p>\n\n\n<h3 class=\"wp-block-heading\">What is an example of an AI tool that addresses a significant marketing&nbsp;challenge?</h3>\n\n<p>One of the biggest challenges in marketing is finding a way to block spam without ruining the user experience. Traditionally, website owners and marketers use methods like CAPTCHA to reduce spam, since this entails the visitor proving that they aren’t a&nbsp;robot.</p>\n\n\n<img width=\"770\" height=\"925\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-35.png\" alt=\"CAPTCHA example with red spheres\" class=\"wp-image-283396\" />\n\n\n<p>The problem with CAPTCHA is that it can lead to fewer conversions since it adds friction to the user experience. This can be frustrating for visitors who might choose to leave your website, ditch your form, or abandon their&nbsp;cart.</p>\n\n<p>But, Akismet is a clever AI tool that filters your comment, text, and form spam automatically. It eliminates the need for CAPTCHA by analyzing submissions in real&#8209;time with 99.99%&nbsp;accuracy.</p>\n\n<h3 class=\"wp-block-heading\">What are the benefits of using Akismet’s AI&#8209;powered spam&nbsp;protection?</h3>\n\n<p>There are tons of benefits to using Akismet’s AI&#8209;powered spam protection. First off, it enables you to filter spam from your site without implementing intrusive alternatives like CAPTCHA. This way, you can keep visitors on your website and increase your conversion&nbsp;rate.</p>\n\n<p>Akismet blocks form and comment spam with incredible accuracy. By analyzing any piece of user&#8209;submitted text, you can keep your website better protected against common security&nbsp;threats.</p>\n\n\n<p>What’s more, using Akismet saves site administrators an average of 20 hours per month when it replaces a manual spam filtering process.&nbsp;</p>\n\n\n<p>Akismet provides a flexible API, so it’s easy to build it into any enterprise application your organization may&nbsp;use.</p>\n\n<h3 class=\"wp-block-heading\">What types of companies generally use&nbsp;Akismet?</h3>\n\n<p>Akismet is a powerful anti&#8209;spam solution that can be used by complete beginners. But, it’s also a great option for small businesses and <a href=\"https://akismet.com/enterprise/\">large&nbsp;enterprises</a>.</p>\n\n\n<p>For instance, there are currently over 100 million websites using the AI-powered Akismet tool. Some of these brands include Microsoft, WordPress.com, Bluehost, and ConvertKit. And across these websites, Akismet has blocked over 545,000,000,000 pieces of spam.&nbsp;</p>\n\n\n<h2 class=\"wp-block-heading\">Akismet: AI&#8209;powered spam protection that boosts conversion&nbsp;rates</h2>\n\n<p>AI marketing tools can simplify many aspects of running your business. This way, you can complete tons of tasks in a much shorter time frame. Plus, you can offload routine procedures and free up time to invest into other areas of your business, like&nbsp;growth.</p>\n\n<p>With this in mind, you might want to implement a tool like <a href=\"https://www.grammarly.com/\">Grammarly</a> to enhance your copy. <a href=\"https://zapier.com/\">Zapier</a> can enable you to build custom workflows by connecting tons of apps. Or you could use a tool like <a href=\"https://www.synthesia.io/\">Synthesia</a> to create high&#8209;quality videos with no&nbsp;equipment.</p>\n\n<p>Additionally, Akismet provides robust anti&#8209;spam protection. Using advanced AI, Akismet filters out comment and form spam with 99.99% accuracy. Better yet, user submissions are analyzed in real time, and Akismet works without disrupting the user experience. <a href=\"https://akismet.com/pricing/\">Get started with Akismet&nbsp;today</a>!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Cost of Spam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=101397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2023/10/cost-of-spam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1551:\"<p><a href=\"https://fortune.com/2023/10/17/twitter-x-charging-new-users-1-dollar-year-to-tweet/\">Twitter/X is testing charging users $1/year</a> with the idea that will keep out bots and spam. It&#8217;s an appealing idea, and charging definitely does introduce a &#8220;proof of work&#8221; that wasn&#8217;t there before, but the history of the web shows this is not really a big deterrent. Domains cost money, usually a lot more than a dollar a year, and millions are used for spam or nefarious purposes. The spammers obviously thought their benefit would be more than the cost of the domain, or they use stolen credit cards and identities. Charging may cause a short-term drop in bots while the bad guys update their scripts, but the value of manipulating X/Twitter is so high I imagine there is already millions of dollars being spent on it.</p>\n\n\n\n<p>Long term to keep a platform healthy you really have to take a nuanced look at behavior and content, like Automattic does with <a href=\"https://akismet.com/\">Akismet</a>, and have a fairly sophisticated trust and safety operation with great engineers. T&amp;S is really important, not an enemy of progress, which would have been my chief edit to the otherwise exciting <a href=\"https://a16z.com/the-techno-optimist-manifesto/\">The Techno-Optimist Manifesto by Marc Andreessen</a>. (If you missed Marc&#8217;s <a href=\"https://a16z.com/ai-will-save-the-world/\">Why AI Will Save the World</a>, that&#8217;s also an excellent read with dozens of references you can go down a rabbit hole with.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 09:18:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"HeroPress: The Fuel Of Everything That’s Great In The World – Rotițele care fac lumea să se miște\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=5952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"https://heropress.com/essays/the-fuel-of-everything-thats-great-in-the-world/#utm_source=rss&utm_medium=rss&utm_campaign=the-fuel-of-everything-thats-great-in-the-world\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24704:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2023/10/101723-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I think people are the fuel of everything that’s great in this world. — Cred că oamenii sunt catalizatorul a ceea ce este mai bun în lume.\" /><p><a href=\"https://heropress.com/feed/#romanian\">Eseul este disponibil și în română.</a></p>\n\n\n\n<p>It&#8217;s a beautiful coincidence how, at the time of writing this story, I&#8217;m a few weeks shy of celebrating nine years of working at Themeisle. I think it&#8217;s a big deal to have this continuity and consistency in something.&nbsp;</p>\n\n\n\n<p>This anniversary also marks nine years of being part of the WordPress community. But let&#8217;s start from the beginning.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-from-journalism-to-content-writing\">From journalism to content writing</h2>\n\n\n\n<p>When I started working at Themeisle, I barely knew anything about WordPress. My only links to it were a personal blog on WordPress.com that I had created in college and writing for a few press websites in Romania that were built on WordPress.&nbsp;</p>\n\n\n\n<p>That was all I knew about WordPress, which was not zero (I just knew how to write a post and publish it) but still far from what I should have known for the job. I was willing to learn, though, and here I am nine years later. Actually, I would say that I got here, in the WordPress community, rather accidentally than intentionally.</p>\n\n\n\n<p>Having a degree in Journalism and Communication Studies, my initial plans were revolving around being a sports reporter or press journalist. Funny enough, I ended up doing a different kind of press… WordPress. Haha!</p>\n\n\n\n<p>But before getting into the WordPress world, I was an aspiring journalist for a short time. Or a wanna-be journalist, if you will. I was adding brick by brick to the career in journalism that I had envisioned for myself.&nbsp;</p>\n\n\n\n<p>One of these bricks was an <a href=\"https://www.sportrevolution.ro/catalina-ponor-mi-am-dorit-sa-fiu-printre-putinele-gimnaste-din-tara-care-au-mers-la-doua-olimpiade/\">interview with Cătălina Ponor</a> &#8211; a three-time Olympic champion in artistic gymnastics and one of the best Romanian gymnasts. She used to be one of my sports idols growing up.&nbsp;</p>\n\n\n\n<p>Another brick to the journalism career was a feature article about how corruption in Romania was slowly killing performance in sports. This article, initially published on a website called Semnal Plus, received a lot of engagement and appreciation from Romanian sports fans. It eventually <a href=\"https://treizecizero.ro/burse/2015/12/08/sportul-comoara-nationala-care-ne-scapa-printre-degete/\">ended up on a popular tennis publication</a> in Romania &#8211; Treizecizero &#8211; as part of a writing contest, which brought me an internship with their editorial team.</p>\n\n\n\n<p>I did write more similar content during college about sports for a popular sports newspaper in Romania and about rock/metal music for a niche news website. I remember being particularly proud of a bunch of them. They gave me the confidence that I had it in me for this career.&nbsp;</p>\n\n\n\n<p>But the future had different plans for me.&nbsp;</p>\n\n\n\n<p>Soon after, I began to realize that being a reporter or press writer would bring too much stress, lack of free time, and little money. Let alone giving away a little bit of your dignity every day. At least, this is how I would describe most of the journalism work in Romania.&nbsp;</p>\n\n\n\n<p>For me, these factors played a big role in thinking that maybe, just maybe, I could explore some other options to see if there was something there for me that wasn’t a direct affront to these values that were paramount to me.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-working-at-themeisle\">Working at Themeisle</h2>\n\n\n\n<p>I’m not exaggerating for the sake of the story when I tell you that I got lucky finding Themeisle’s job announcement on a Facebook group. They were looking for a WordPress content writer. I didn’t even know what that meant, really. I just knew that yes, I did publish some articles on WordPress, so what could go wrong? I mean, I’ve used the platform before.&nbsp;</p>\n\n\n\n<p>Well, it turned out to be different from what I expected because the job didn’t imply writing on WordPress but writing <em>about</em> WordPress. Which got me confused. So I had to learn the inside-outs of WordPress <em>while</em> I was trying to do my job.</p>\n\n\n\n<p>Even more, the job implied writing in English, which I had never done before. All my writing up until that point used to be in Romanian. This was also a struggle, to completely switch the language and make it sound okay and readable.&nbsp;</p>\n\n\n\n<p>It was not easy to start from almost zero experience and knowledge. And not once did I feel like an impostor seeing other people excelling at their jobs. I used to be so hard on myself, beating myself up for every little mistake and feedback that was not meeting my expectations.&nbsp;</p>\n\n\n\n<p>In a way, that’s a good thing because this is how you evolve. But now, as I’m getting wiser, I understand that this was a sign of perfectionism, which I will never achieve and I don’t even want to anymore. Simply because it doesn’t exist.&nbsp;</p>\n\n\n\n<p>As I was saying, I started my journey at Vertigo Studio (the company behind <a href=\"https://themeisle.com/\">Themeisle</a> and <a href=\"https://www.codeinwp.com/\">CodeinWP</a>) at the age of 22. At that time, the company had around six or seven employees. This picture was taken a few years after when new people got on board:</p>\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2023/10/image1.jpg\"><img width=\"1024\" height=\"685\" src=\"https://heropress.com/wp-content/uploads/2023/10/image1-1024x685.jpg\" alt=\"\" class=\"wp-image-5958\" /></a>\n\n\n\n<p>My role was that of a content writer. But I&#8217;m a person who loves to experiment and try new things, so I have juggled many roles over the years.&nbsp;</p>\n\n\n\n<p>I went through social media, recruiting interns, mentoring, copywriting, outreach, email marketing, interviews, and partnerships with WordPress companies. The variety of activities kept me engaged, curious, and motivated. It’s always exciting and challenging when you do something for the first time.&nbsp;</p>\n\n\n\n<p>But my favorite would still be writing. My first love.&nbsp;</p>\n\n\n\n<p>Even though I was mainly writing content for the Themeisle and CodeinWP blogs, I had the opportunity to collaborate with other WordPress blogs, too. So I contributed a few pieces of content to websites like <a href=\"https://www.smashingmagazine.com/author/adelina-tuca/\">Smashing Magazine</a>, <a href=\"https://torquemag.io/2018/04/is-that-plugin-reliable-how-to-test-wordpress-plugins/\">TorqueMag</a>, <a href=\"https://www.wpexplorer.com/wordpress-block-patterns/\">WPExplorer</a>, <a href=\"https://oceanwp.org/blog/are-ad-blockers-affecting-your-income-heres-how-to-prevent-them-from-harming-your-wordpress-business/\">OceanWP</a>, or <a href=\"https://www.wpzoom.com/blog/how-to-start-travel-blog-wordpress/\">WPZoom</a>.&nbsp;</p>\n\n\n\n<p>Even if I&#8217;m doing it in different forms, it all comes down to writing in the end. Interviews, for example, do count as writing plus a little bit of spice to the mix, which is connecting and meeting inspiring people in the community. It&#8217;s always interesting to meet people &#8211; even virtually &#8211; and hear their perspectives. You learn and become more open to different ideas and standpoints.&nbsp;</p>\n\n\n\n<p>It&#8217;s also interesting how a socially anxious person like me finds meaning in connecting with other people. It&#8217;s like a paradox, healing my social anxiety through socializing.</p>\n\n\n\n<p><a href=\"https://themeisle.com/blog/category/wordpress-community/interviews/\">Here</a>’s the full collection of interviews that I did on the Themeisle blog with the cool people we have in our WordPress ecosystem.&nbsp;</p>\n\n\n\n<p>At Themeisle, I grew not only as a professional but also as a person. As a bonus, I had the chance to meet the amazing people that are my colleagues. In our company, we always motivate each other to grow and improve. So I had the opportunity to build meaningful bonds and valuable friendships that I hope will last a long, long time.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-contributing-to-wordcamps\">Contributing to WordCamps</h2>\n\n\n\n<p>As a team, we always strove to engage more with the WordPress community. This means getting involved in the local and international community. I, personally, enjoy WordCamps more when I play a bigger part than just attending.&nbsp;</p>\n\n\n\n<p>Almost every year I either volunteered or enrolled in the media partners program which, yet again, meant meeting and interviewing people in person. The latter made me feel that journalist vibe again, bringing back old memories and emotions. It was about conversing with someone live, in real time, and getting into that nice sense of belonging. I wrote about this unique experience from WordCamp Europe <a href=\"https://www.codeinwp.com/blog/behind-the-scenes-of-wceu-media-partners/\">here</a>.&nbsp;</p>\n\n\n\n<p>I still remember my first WordCamp Europe in Vienna, which I will never forget. I was all over the place, trying to do many things at once. I remember that I barely slept back then, trying to be on my volunteer duty early in the morning and also not miss any parties that would take place at night. That one was an event when I kind of forgot about my social anxiety and simply went with the flow, socializing and making friends. At that time I was a <a href=\"https://twitter.com/WCEurope/status/967051319923150849\">volunteer in the Communication Team</a>.</p>\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2023/10/image2.jpg\"><img width=\"1024\" height=\"673\" src=\"https://heropress.com/wp-content/uploads/2023/10/image2-1024x673.jpg\" alt=\"\" class=\"wp-image-5959\" /></a>\n\n\n\n<p>I mean, yes, signing up for extra work does put some pressure on your shoulders. But it’s worth it. You feel more fulfilled and useful to the world.&nbsp;</p>\n\n\n\n<p>My message is, if you’re up for something, try to step out of your comfort zone a little bit. Know your comfort zone and step out a little bit every time. You’ll enjoy the experience more and most of the time you’ll be surprised by the outcome. This is how you grow.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-what-s-next\">What’s next</h2>\n\n\n\n<p>Honestly, I don’t know what the future has in store for me. I might find myself doing a totally different thing years from now or, who knows, still being part of the WordPress community. But no matter what’s next for me, I wouldn’t change a thing about the past and these awesome experiences that I shared together with amazing, inspiring people.&nbsp;</p>\n\n\n\n<p>I think people are the fuel of everything that’s great in this world. And I want to believe that I’m one of these people who always strive to bring their best into the world and do good. At least, I’m trying.</p>\n\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id5952_c190c2-15 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top\">\n\n<div class=\"wp-block-kadence-column kadence-column5952_1ad0f6-31\"><div class=\"kt-inside-inner-col\">\n<h2 id=\"work-environment\" class=\"kt-adv-heading5952_886b34-83 wp-block-kadence-advancedheading\">Adelina&#8217;s Work Environment</h2>\n\n\n\n<p>We asked Adelina for a view into her development life and this is what she sent! </p>\n\n\n	<div class=\"hotspots-image-container\">\n		<img width=\"1024\" height=\"768\" src=\"https://heropress.com/wp-content/uploads/2023/10/office-workspace-twin-peaks.jpg\" alt=\"Adelina Tuca\" class=\"hotspots-image skip-lazy\" />\n	</div>\n\n\n\n\n<p class=\"kt-adv-heading5952_976380-bf wp-block-kadence-advancedheading has-theme-palette-9-background-color has-background\">HeroPress would like to thank <a href=\"https://wpdrawattention.com/\">Draw Attention</a> for their donation of the plugin to make this interactive image!</p>\n</div></div>\n\n</div></div>\n\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h1 id=\"romanian\" class=\"kt-adv-heading5952_361701-44 wp-block-kadence-advancedheading\">Rotițele care fac lumea să se miște</h1>\n\n\n\n<p>E o frumoasă coincidență că, în timp ce scriu acest articol, sunt foarte aproape de a celebra nouă ani de când lucrez la Themeisle. Mai lipsesc câteva săptămâni până la aniversare. Cred că este mare lucru să ai o continuitate și consistență în ceva, oricare ar fi acel ceva.</p>\n\n\n\n<p>Această aniversare mai înseamnă și nouă ani de când fac parte din comunitatea WordPress. Dar să începem cu începutul.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-de-la-jurnalism-la-content-writing\">De la jurnalism la content writing</h2>\n\n\n\n<p>Când am început să lucrez la Themeisle, abia dacă știam ceva despre WordPress. Toate cunoștințele mele legate de asta se rezumau la un blog personal avut în facultate și câteva articole scrise pe niște site-uri de presă din România care foloseau platforma WordPress.</p>\n\n\n\n<p>Cam asta știam despre WordPress. Nu înseamnă neapărat că nu știam nimic, dar eram totuși departe de ce ar fi trebuit să știu pentru job. Totuși, eram o persoană dornică să învețe, așa că iată-mă tot aici nouă ani mai târziu. De fapt, aș putea spune că am nimerit în comunitatea WordPress mai mult dintr-un accident decât intenționat.&nbsp;</p>\n\n\n\n<p>Având studii în Jurnalism și Științele Comunicării, planul meu inițial era să ajung reporter sportiv sau jurnalist de presă sportivă. Ca să fac un joc de cuvinte care are sens mai mult în engleză, am sfârșit prin a face tot un fel de press, doar că WordPress. Sună mai bine în engleză partea asta. Haha!&nbsp;</p>\n\n\n\n<p>Dar înainte să pătrund în lumea WordPress, am făcut jurnalism pentru puțin timp. Eram o jurnalistă în devenire, dacă pot să spun așa. Cert e că începusem să construiesc în această direcție, punând cărămidă cu cărămidă.&nbsp;</p>\n\n\n\n<p>Una dintre aceste cărămizi a fost <a href=\"https://www.sportrevolution.ro/catalina-ponor-mi-am-dorit-sa-fiu-printre-putinele-gimnaste-din-tara-care-au-mers-la-doua-olimpiade/\">interviul pe care l-am făcut cu Cătălina Ponor</a> &#8211; triplă campioană olimpică la gimnastică artistică și una dintre cele mai bune gimnaste din istoria României. Ea a fost unul dintre idolii mei din sport când eram copil și chiar adolescentă.</p>\n\n\n\n<p>O altă cărămidă pe care o puneam la cariera în jurnalism a fost un articol de tip feature despre cum corupția din România ucide performanța sportivă încetul cu încetul. Inițial, articolul fusese publicat pe un website numit Semnal Plus, unde a primit multe reacții și apreciere din partea consumatorilor de sport din România. Acum mai apare online într-o populară publicație despre tenis &#8211; <a href=\"https://treizecizero.ro/burse/2015/12/08/sportul-comoara-nationala-care-ne-scapa-printre-degete/\">Treizecizero</a> &#8211; ca urmare a unui concurs la care am participat cu acest articol și pentru care am primit un internship la ei în redacție.</p>\n\n\n\n<p>Tot cam în aceeași perioadă am mai scris conținut similar despre sport pentru o publicație sportivă cunoscută în țară și despre muzica rock/metal pentru un site de știri de nișă. Îmi amintesc că am fost mândră de multe dintre ele. Toate acestea la un loc îmi dăduseră încredere că aveam ce îmi trebuie ca să continui pe drumul ăsta.</p>\n\n\n\n<p>Dar viitorul avea alte planuri pentru mine.&nbsp;</p>\n\n\n\n<p>La puțin timp după, începeam să realizez că a fi reporter sau jurnalist de presă venea la pachet cu mult prea mult stres, puțin timp liber și puțini bani în comparație cu efortul depus. Lăsând la o parte faptul că trebuia să îți calci pe demnitate puțin câte puțin, până când aveai să ți-o pierzi pe toată. Cel puțin, așa aș descrie eu jurnalismul din România din acest moment.&nbsp;</p>\n\n\n\n<p>Pentru mine, acești factori au jucat un rol foarte important când am început să mă gândesc că poate aș putea să mă reorientez către ceva mai apropiat de valorile mele morale. Valori pe care nu îmi permiteam să mi le încalc.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-munca-la-themeisle\">Munca la Themeisle</h2>\n\n\n\n<p>Nu de dragul poveștii spun că am dat ca printr-un noroc de anunțul celor de la Themeisle pe un grup de Facebook. Căutau un content writer care să scrie despre WordPress. Nici măcar nu știam ce însemna asta. Știam doar că mai folosisem WordPress în trecut, deci ce putea să fie așa de greu?&nbsp;</p>\n\n\n\n<p>Ei bine, s-a dovedit a fi diferit față de ce mă așteptam eu pentru că jobul nu presupunea a scrie pe platforma WordPress, ci a scrie <em>despre</em> platforma WordPress. Lucru care m-a bulversat puțin. Așa că am fost nevoită să învăț WordPress de la zero.&nbsp;</p>\n\n\n\n<p>Mai mult decât atât, jobul presupunea să scriu în limba engleză, ceea ce nu mai făcusem înainte. Tot ce scrisesem până atunci fusese în română. Asta iarăși a îngreunat puțin lucrurile pentru că trebuia să schimb complet limba și s-o fac într-un mod în care să sune bine, inteligibil.&nbsp;</p>\n\n\n\n<p>Nu a fost ușor să o iau aproape de la zero cu experiența și cunoștințele. Și nu de puține ori m-am simțit ca un impostor văzând cum alte persoane erau atât de bune în domeniul lor. Eram foarte dură cu mine, criticându-mă pentru orice greșeală sau feedback care nu îmi îndeplinea așteptările.</p>\n\n\n\n<p>Într-un fel, asta poate fi un lucru bun pentru că te ajută să evoluezi. Dar acum, cu cât devin mai înțeleaptă, înțeleg că era perfecționismul din mine care nu-mi dădea pace. Un perfecționism pe care nu-l voi atinge niciodată pentru că el nu există. Acum sunt mai tolerantă cu mine.&nbsp;</p>\n\n\n\n<p>Mi-am început călătoria la Vertigo Studio (compania din spatele <a href=\"https://themeisle.com/\">Themeisle</a> și <a href=\"https://www.codeinwp.com/\">CodeinWP</a>) la vârsta de 22 de ani. La acea vreme, compania avea în jur de șase sau șapte angajați. Poza următoare a fost făcută câțiva ani mai târziu, când deja firma angajase colegi noi:</p>\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2023/10/image1.jpg\"><img width=\"1024\" height=\"685\" src=\"https://heropress.com/wp-content/uploads/2023/10/image1-1024x685.jpg\" alt=\"\" class=\"wp-image-5958\" /></a>\n\n\n\n<p>Rolul meu era acela de content writer. Dar, fiind o persoană căreia îi place să experimenteze și să încerce lucruri noi, am explorat mai multe roluri de-a lungul anilor.&nbsp;</p>\n\n\n\n<p>Am făcut social media, recrutare de interni, mentorat, copywriting, outreach, email marketing, interviuri și parteneriate cu companii din comunitatea WordPress. Această varietate de activități m-a ținut în priză, curioasă și motivată. E mereu mișto când faci ceva pentru prima oară.</p>\n\n\n\n<p>Dar principala și prima dragoste a rămas și va rămâne scrisul.&nbsp;</p>\n\n\n\n<p>Chiar dacă am scris exclusiv pe blogurile Themeisle și CodeinWP în toți acești ani, am avut ocazia de a mai colabora și cu alte bloguri din WordPress. Am contribuit cu câteva articole pe site-uri precum <a href=\"https://www.smashingmagazine.com/author/adelina-tuca/\">Smashing Magazine</a>, <a href=\"https://torquemag.io/2018/04/is-that-plugin-reliable-how-to-test-wordpress-plugins/\">TorqueMag</a>, <a href=\"https://www.wpexplorer.com/wordpress-block-patterns/\">WPExplorer</a>, <a href=\"https://oceanwp.org/blog/are-ad-blockers-affecting-your-income-heres-how-to-prevent-them-from-harming-your-wordpress-business/\">OceanWP</a>, sau <a href=\"https://www.wpzoom.com/blog/how-to-start-travel-blog-wordpress/\">WPZoom</a>.</p>\n\n\n\n<p>Chiar dacă ia diverse forme, la sfârșitul zilei totul se rezumă la scris. Interviurile, de exemplu, îmbină scrisul cu conectarea. E mereu interesant să întâlnești persoane noi &#8211; chiar și virtual &#8211; și să vezi ce perspective au ele. Înveți din chestia asta și devii mai deschis la noi puncte de vedere și idei.&nbsp;</p>\n\n\n\n<p>Totodată, mai e interesant cum o persoană anxioasă ca mine găsește confort în conexiunea cu alți oameni. E ca un paradox în care îți vindeci anxietatea socială prin socializare.</p>\n\n\n\n<p><a href=\"https://themeisle.com/blog/category/wordpress-community/interviews/\">Aici</a> găsiți întreaga colecție de interviuri pe care le-am făcut pe blogul Themeisle cu oameni mișto din comunitatea noastră de WordPress.&nbsp;</p>\n\n\n\n<p>La Themeisle, nu doar am crescut ca om și ca profesionist. Pe deasupra, am avut șansa să cunosc și să lucrez cu niște oameni minunați cum sunt colegii mei. În compania noastră, ne motivăm unii pe alții să ne îmbunătățim și să evoluăm. Am avut oportunitatea să construiesc legături semnificative și prietenii valoroase care sper că vor rămâne neschimbate.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-contribuția-la-wordcamps\">Contribuția la WordCamps</h2>\n\n\n\n<p>La nivel de echipă, ne-am dorit mereu să ne implicăm în comunitate și să contribuim cât putem de mult. Atât pe piața locală, cât și internațională. Personal, eu mă bucur mai mult de experiența unui WordCamp când fac ceva în plus decât să particip.&nbsp;</p>\n\n\n\n<p>Aproape în fiecare an în care am participat, am ales fie să fiu voluntar, fie să mă implic în echipa de Media Partners, să simt că fac ceva.&nbsp;</p>\n\n\n\n<p>Prin programul de Media Partners am intervievat oameni din WordPress, de data asta live, în persoană. Ceea ce m-a făcut să simt din nou vibe-ul jurnalistic, aducând cu sine un soi de nostalgie. Acolo aveai o conversație cu cineva fizic, în timp real, ceea ce îți aducea un sentiment de apartenență. Am scris despre experiența de a fi partener media la WordCamp Europe <a href=\"https://www.codeinwp.com/blog/behind-the-scenes-of-wceu-media-partners/\">aici</a>.</p>\n\n\n\n<p>Încă îmi amintesc primul meu WordCamp Europe din Viena, pe care nu o să-l uit niciodată. Eram peste tot atunci, încercând să fac cât mai multe lucruri deodată. Îmi amintesc că abia dacă dormeam, încercând să îmi fac și datoria de voluntar dis de dimineață, dar și să particip la petrecerile care aveau loc seara. Acela a fost un eveniment care m-a făcut să uit de anxietatea mea socială, în care pur și simplu am profitat la maximum de toate ocaziile de a socializa și cunoaște oameni mișto. Atunci am făcut parte din echipa de Comunicare, ca <a href=\"https://twitter.com/WCEurope/status/967051319923150849\">voluntar</a>.</p>\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2023/10/image2.jpg\"><img width=\"1024\" height=\"673\" src=\"https://heropress.com/wp-content/uploads/2023/10/image2-1024x673.jpg\" alt=\"\" class=\"wp-image-5959\" /></a>\n\n\n\n<p>Este adevărat că, atunci când te înscrii la muncă extra, vine la pachet cu presiune și cu emoții mai grele. Dar merită. Te face să te simți mai împlinit, mai util celor din jur.&nbsp;</p>\n\n\n\n<p>Mesajul meu pentru voi este să ieșiți din zona de confort măcar puțin atunci când vă implicați în ceva. Cunoașteți-vă zona de confort și ieșiți din ea câte puțin de fiecare dată. Vă veți bucura mai mult de experiență și, de cele mai multe ori, veți fi surprinși de rezultate. Așa reușim să creștem.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-ce-urmeaza\">Ce urmează</h2>\n\n\n\n<p>Sincer, nu știu ce îmi pregătește viitorul, dacă o să mai fiu în comunitatea WordPress peste ani sau dacă o să fac cu totul altceva, în alt domeniu. Cine știe? Dar oricare ar fi viitorul, nu aș schimba nimic din ce s-a întâmplat până acum, din trecut. Nu aș schimba aceste experiențe pe care le-am împărțit cu oameni minunați.&nbsp;</p>\n\n\n\n<p>Cred că oamenii sunt catalizatorul a ceea ce este mai bun în lume. Și vreau să cred că și eu sunt unul dintre acești oameni care caută mereu să fie cea mai bună versiune a lor și să facă bine pe oriunde merg. Cel puțin, încerc.&nbsp;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/the-fuel-of-everything-thats-great-in-the-world/\">The Fuel Of Everything That’s Great In The World &#8211; Rotițele care fac lumea să se miște</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Adelina Tuca\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"WPTavern: WordPress 6.4 RC1 Released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150315\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wptavern.com/wordpress-6-4-rc1-released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2332:\"<p>WordPress 6.4 is one step closer to prime time with <a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-1/\">RC1 available today</a>. The <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-4/\">dev notes</a> are rolling out with details on technical improvements in the upcoming release &#8211;<a href=\"https://make.wordpress.org/core/2023/10/15/introducing-block-hooks-for-dynamic-blocks/\">block hooks for dynamic blocks</a>, <a href=\"https://make.wordpress.org/core/2023/10/17/improvements-to-template-loading-in-wordpress-6-4/\">improvements to template loading</a>, <a href=\"https://make.wordpress.org/core/2023/10/16/changes-to-attachment-pages/\">changes to attachment pages</a>, and many more.</p>\n\n\n\n<p>RC1 is ready for another round of testing. There are <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F12%2F2023..10%2F17%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">40 additional closed Trac tickets</a> since 6.4 Beta 4, <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">dozens of GitHub commits</a>, and <a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">commits for Twenty Twenty-Four</a>. </p>\n\n\n\n<p>Although the flagship font library feature had to be <a href=\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\">punted to 6.5</a> due to gaps in the Font APIs that couldn&#8217;t be resolved in time, the upcoming release is still packed with new features and improvements. A few highlights include a new lightbox functionality, redesigned command palette, block hooks, expanded design tools, and a new default theme.</p>\n\n\n\n<p>The release candidate phase marks the hard string freeze where no new strings can be added so that the Polyglots team can ensure WordPress 6.4 gets translated. At this point, only regressions introduced during this development cycle and expansions to the test suite can be addressed in the 6.4 milestone.</p>\n\n\n\n<p>Theme and plugin developers are encouraged to test their extensions against the release candidate. Plugin authors are also advised to update the<em>“Tested up to”</em> version in their readme files to 6.4.</p>\n\n\n\n<p>A second RC is expected next week. WordPress 6.4 is on track to be released on November 7, 2023.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Oct 2023 03:35:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Preview WordPress Core Pull Requests with Playground\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150295\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/preview-wordpress-core-pull-requests-with-playground\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3999:\"<p>Adam Zieliński, creator of WordPress Playground, <a href=\"https://twitter.com/adamzielin/status/1714311403849363944\">announced</a> today that the WordPress Core PR previewer is now live. Playground is an experimental project that uses WebAssembly (WASM) to <a href=\"https://wptavern.com/new-prototype-runs-wordpress-in-the-browser-with-no-php-server\">run WordPress in the browser</a>. It creates a WordPress instance with admin access without having to install PHP, MySQL, or Apache, making it nearly instantaneous to fire up a test site.</p>\n\n\n\n<p>Testing pull requests is one of the most exciting use cases for the Playground project. The newly launched WordPress Core PR previewer can be found at <a href=\"https://playground.wordpress.net/wordpress.html\">playground.wordpress.net/wordpress.html</a>. Users can enter the PR number or the URL.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2332\" height=\"1298\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-17-at-4.10.46-PM.png\" alt=\"\" class=\"wp-image-150303\" />\n\n\n\n<p>The <a href=\"https://github.com/WordPress/wordpress-playground/pull/700\">PR for for previewing wordpress-develop repository pull pequests</a> adds support for a few query parameters that developers can use to customize how the preview loads:<a href=\"https://user-images.githubusercontent.com/205419/274972437-e30e9ac6-c99e-4e81-b68f-45e14116f6c9.png\" target=\"_blank\" rel=\"noreferrer noopener\"></a></p>\n\n\n\n<ul>\n<li><code>?pr=5481</code>&nbsp;– preview that PR</li>\n\n\n\n<li><code>?url=/wp-admin/post-new.php</code>&nbsp;– load that URL in WordPress</li>\n\n\n\n<li><code>?mode=seamless</code>&nbsp;– redirect to a full-screen Playground without the browser chrome and any other extra UI elements</li>\n</ul>\n\n\n\n<p>Zieliński identified a couple of known issues with this first implementation that developers should be aware of when working with the previewer: Existing PRs need a rebase to work but new PRs work just fine. Additionally, if you test it out, you will find that downloading WordPress may take a long time, as the bundle is ~45MB. Contributors are working on finding a way to optimize this so that it&#8217;s quicker and more efficient to preview PRs. Any problems or bugs can be reported to the <a href=\"https://github.com/WordPress/wordpress-playground/issues\">Playground repository&#8217;s issues</a>.</p>\n\n\n\n<p>As part of the <a href=\"https://github.com/WordPress/wordpress-playground/issues/696\">Playground roadmap</a>, Zieliński is working on making <a href=\"https://github.com/WordPress/wordpress-playground/issues/696\">a pull request previewer for all WordPress projects</a>, not just core, as he outlined in a planning issue:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Previewing WordPress Pull Requests requires either a local development setup or a staging setup.</p>\n\n\n\n<p>WordPress developers often use either a staging environment that can only run a single branch at a time, or no staging environment at all. This makes testing and team workflows difficult.</p>\n\n\n\n<p>Providing an easy way to preview pull requests using Playground would alleviate that burden, catalyze more reviews across the ecosystem, and make calls for testing easier.</p>\n</blockquote>\n\n\n\n<p>WordPress meta contributors recently implemented a “Live Preview” button for plugins in the official directory but ended up <a href=\"https://wptavern.com/wordpress-reverts-live-preview-button-on-plugins-after-developer-backlash\">reverting it after many plugins were broken</a> due to inadequate support in the Playground environment.  Zieliński and contributors are  still refining the <a href=\"https://github.com/WordPress/wordpress-playground/issues/662\">live preview experience for plugins</a> hosted on WordPress.org, and are <a href=\"https://github.com/WordPress/wordpress-playground/issues/664\">creating a Blueprints API</a> that will be easy for developers to use for customizing their Playground instances.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Oct 2023 22:07:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"BuddyPress: BuddyPress 11.3.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=331640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://buddypress.org/2023/10/buddypress-11-3-2-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2823:\"<p><a href=\"https://downloads.wordpress.org/plugin/buddypress.11.3.2.zip\">BuddyPress 11.3.2</a> is now available. This is a security release. <strong>All BuddyPress installations should be updated as soon as possible</strong>.</p>\n\n\n\n<p>The 11.3.2 release addresses the following security issue:</p>\n\n\n\n<ul>\n<li>A Potential Cross Site Scripting using Members/Groups block props by a user having a contributor role vulnerability. Discovered by Rafie Muhammad (Patchstack).</li>\n</ul>\n\n\n\n<p>This vulnerability was reported privately to the BuddyPress team, in accordance with&nbsp;<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">WordPress’s security policies</a>. Our thanks to the reporter for practicing coordinated disclosure.</p>\n\n\n\n<p>For complete details, visit the <a href=\"https://codex.buddypress.org/releases/version-11-3-2/\">11.3.2 changelog</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background no-border-radius wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.11.3.2.zip\">Get BuddyPress 11.3.2</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p>You can get the latest version by clicking on the above button, downloading it from the&nbsp;<a href=\"https://wordpress.org/plugins/buddypress/\">WordPress.org plugin directory</a>&nbsp;or checking it out from our&nbsp;<a href=\"https://buddypress.trac.wordpress.org/browser/branches/11.0\">Subversion repository.</a></p>\n\n\n\n<p>If for a specific reason you can&#8217;t upgrade to 11.3.2, we have also ported the security fix to BuddyPress versions going all the way back to 7.0. Here&#8217;s the list of the available downloads for the corresponding tags, you can also find these links on our <a href=\"https://wordpress.org/plugins/buddypress/advanced/\">WordPress.org Plugin Directory &#8220;Advanced&#8221; page:</a></p>\n\n\n\n<ul>\n<li>If you are using BP 7.x and can&#8217;t upgrade to 11.3.1, please upgrade to <a href=\"https://downloads.wordpress.org/plugin/buddypress.7.3.4.zip\">7.3.4</a></li>\n\n\n\n<li>If you are using BP 8.x and can&#8217;t upgrade to 11.3.1, please upgrade to <a href=\"https://downloads.wordpress.org/plugin/buddypress.8.0.4.zip\">8.0.4</a></li>\n\n\n\n<li>If you are using BP 9.x and can&#8217;t upgrade to 11.3.1, please upgrade to <a href=\"https://downloads.wordpress.org/plugin/buddypress.9.2.2.zip\">9.2.2</a></li>\n\n\n\n<li>If you are using BP 10.x and can&#8217;t upgrade to 11.3.1, please upgrade to <a href=\"https://downloads.wordpress.org/plugin/buddypress.10.6.2.zip\">10.6.2</a></li>\n</ul>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Oct 2023 20:14:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: WordPress 6.4 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16147\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/10/wordpress-6-4-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11774:\"<p>The first release candidate (RC1) for WordPress 6.4 is now available!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC1 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains vital to ensure that everything in WordPress 6.4 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.4 RC1 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress site.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.4-RC1</code></li>\n</ol>\n\n\n\n<p>The current target for the WordPress 6.4 release is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a>.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\"><strong>underrepresented gender release squad</strong></a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.4 RC1?</h2>\n\n\n\n<p>This release contains 420 enhancements and 445 bug fixes for the editor, including more than <a href=\"https://core.trac.wordpress.org/query?status=closed&milestone=6.4&group=component&max=500&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">260 tickets for WordPress 6.4 core</a>. Browse the technical details for all issues recently addressed using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F12%2F2023..10%2F17%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">Closed Trac tickets since Beta 4</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Highlights</h3>\n\n\n\n<p>WordPress 6.4 is the third and last major release of 2023. It introduces a multi-purpose default theme, new features, and a keen focus on details to enhance every aspect of your creation journey—from site editing and design to writing flows.</p>\n\n\n\n<ul>\n<li><strong>A new flexible default theme</strong> brings together the latest and greatest of WordPress. Discover its vast collection of templates and patterns to tweak and match your brand. Built for versatility, <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\"><strong>Twenty Twenty-Four</strong></a> is an ideal fit for nearly any type of website.</li>\n\n\n\n<li>Enable <strong>lightbox functionality</strong> in images for immersive viewing experiences.</li>\n\n\n\n<li><strong>Organize your patterns with your own custom categories</strong>. Find them all more intuitively with advanced filtering in the Patterns section of the inserter.</li>\n\n\n\n<li><strong>Enjoy <a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">more writing improvements</a></strong>, including new keyboard shortcuts, smoother list merging, and enhanced control over your link settings. A revamped toolbar experience for Navigation, List, and Quote blocks ensures cohesive and organized access to the tooling options you work with.</li>\n\n\n\n<li><strong>A redesigned </strong><a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\"><strong>Command Palette</strong></a><strong> with new commands</strong> helps you find what you need, perform tasks efficiently, and speed up your workflow.</li>\n\n\n\n<li><strong>Rename Group blocks</strong> to organize and distinguish areas of your content easily.</li>\n\n\n\n<li>See and locate your content’s media assets at a glance with new <strong>gallery and image previews in List View</strong>.</li>\n\n\n\n<li>Build beautiful yet functional layouts with an <strong>expanded set of design tools</strong>. Play with background images in Group blocks for unique creative designs, keep image dimensions consistent with placeholder aspect ratios, and effortlessly add buttons to your Navigation block without custom CSS—among other new capabilities.</li>\n\n\n\n<li><strong>Block Hooks</strong> enable developers to automatically insert blocks at their chosen content locations, enriching the extensibility of block themes through plugins. While developer-centric, this new feature improves your building experience with blocks and gives you complete control to customize Block Hooks to your needs.</li>\n\n\n\n<li><strong>Over 60 accessibility updates</strong>, including significant List View enhancements, aria-label support for the Navigation block, and upgrades to the admin user interface.</li>\n\n\n\n<li><strong>More than 100 performance updates</strong>, focusing on template loading performance for classic and block themes, usage of the script loading strategies “defer” and “async,” and optimization of autoloaded options.</li>\n</ul>\n\n\n\n<p>Are you looking for a deeper dive into details and technical notes? <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-4/\">These recent posts</a> cover a few of the latest updates:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/changes-to-attachment-pages/\">Changes to attachment pages for improved SEO</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/17/miscellaneous-editor-changes-in-wordpress-6-4/\">Miscellaneous Editor changes in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/15/introducing-block-hooks-for-dynamic-blocks/\">Introducing Block Hooks for dynamic blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/17/script-loading-changes-in-wordpress-6-4/\">Script loading changes in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/17/improvements-to-template-loading-in-wordpress-6-4/\">Improvements to template loading in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/introducing-admin-notice-functions-in-wordpress-6-4/\">Introducing admin notice functions in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/editor-components-updates-in-wordpress-6-4/\">Updates to user-interface components in WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/16/new-registerinsertermediacategory-api/\">New `registerInserterMediaCategory` API</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Ways to contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a community of people collaborating on and contributing to its development. The resources below outline various ways you can help, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to developing the software and ensuring its quality. It’s also a meaningful way for anyone to contribute—whether you have experience or not. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Check out this guide</a> for detailed instructions on testing key features in WordPress 6.4.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>During the release candidate phase of WordPress 6.4, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>Do you build themes and plugins? Your products play an integral role in extending the functionality and value of WordPress for users worldwide.</p>\n\n\n\n<p>You most likely have already been testing your latest themes and plugins with the WordPress 6.4 betas. With RC1, you will want to complete your testing and update the <em>&#8220;Tested up to&#8221;</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin&#8217;s readme file</a> to 6.4.</p>\n\n\n\n<p>Please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> if you find compatibility issues.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Português? Русский? 日本? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help translate WordPress into more than 100 languages</a>. This release also marks the <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a> point of the 6.4 release cycle.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A haiku for RC1</h2>\n\n\n\n<p>RC1 in hand<br />WordPress evolves and takes shape<br />Testing, a sneak peek, in place</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>, <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/priethor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>priethor</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Oct 2023 17:48:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Security, From the Basics to Enterprise with Calvin Alkan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=77093\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/security-from-the-basics-to-enterprise-with-calvin-alkan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:447:\"<p>Calvin Alkan joins our hosts to talk security. From malware scanners to firewalls to enterprise sites, with a layered security approach.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/security-from-the-basics-to-enterprise-with-calvin-alkan/\">Security, From the Basics to Enterprise with Calvin Alkan</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Oct 2023 09:13:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WordPress.org blog: WP Briefing: Episode 64: Patterns in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16109\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7414:\"<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she goes back to the basics and offers some insight into block patterns for WordPress. Don&#8217;t miss this exciting insider&#8217;s look!</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br />Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br />Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/using-block-patterns/\">Using Block Patterns</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/patterns/\">Pattern Library</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/taking-advantage-of-query-loops/\">Taking Advantage of Query Loops</a></li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=social\">The WP Annual Survey is available</a>! Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. </li>\n\n\n\n<li><a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia</a> is searching for volunteers for the upcoming WordCamp on March 7–9, 2024. They are looking for Contributor Stories, Event Volunteers, Emcee support, A/V Team Crew, and even designers to help create the official Wapuu for the event.</li>\n\n\n\n<li><a href=\"https://www.meetup.com/pro/wordpress/\">Local WordCamp Meetups</a>! Use this opportunity to find upcoming local events or volunteer to help at the next one. They are an excellent opportunity to meet with others in the community.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16109\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28] (Intro music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> Today&#8217;s briefing topic is going to take a bit of a back-to-basics look at block patterns. Block patterns are one of my favorite enhancements that came through the Gutenberg project, and they&#8217;re pretty much exactly what they sound like. Groups of blocks that are arranged together. These patterns can be as simple as a block that holds a series of social sharing icons, but they can also be as complex as an entire landing page, complete with a call to action and interactive gallery.</p>\n\n\n\n<p>They can be used as a starting point where you activate an entire pattern and then modify the pieces that don&#8217;t quite work for you or as a sort of inspirational catalog of design elements for you to build your own patterns from.&nbsp;</p>\n\n\n\n<p>So, where do these block patterns come from? Who created them? As with most things in WordPress, the answer is lots of places. Some patterns are included with WordPress by default, and there are also sometimes specialized block patterns that are bundled with a particular theme or plugin. There&#8217;s also a pattern library that includes both curated block patterns and all the patterns that are created and shared by the WordPress community itself.</p>\n\n\n\n<p>So from the CMS, from themes, from plugins, from designers, from hobbyists, from people who just like love creating things and putting it out in the world, that&#8217;s, that&#8217;s where those patterns come from. But you can also create and curate your own block patterns, either to share back to the community as some folks do or because you are a site administrator and everyone needs to be able to add, I don&#8217;t know, an author block or something. But you don&#8217;t always want to be the one that has to put the photo on the page.&nbsp;</p>\n\n\n\n<p>There are a few blocks that have their patterns built into settings, most notably the Query Loop Block. I&#8217;ll share a tutorial about how to work with that in the show notes, but ultimately, what&#8217;s important to remember here is that block patterns are a really powerful tool with a lot of ways to implement them. You can start as simple as you want or as complex as you want, but either way, getting familiar with this concept in the software will give you a leg up on your next project.</p>\n\n\n\n<p>[00:02:53] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:03:00] <strong>Josepha:</strong> That brings us now to our small list of big things.&nbsp;</p>\n\n\n\n<p>First up, the annual survey is available. Each year, the WordPress community, so users, site builders, extenders, contributors, artists, you all provide valuable feedback through an annual survey. And every year, I look into the results to get a sense for what areas need the most attention in the project. So click the link in the show notes to take the 2023 survey and help co-create WordPress.&nbsp;</p>\n\n\n\n<p>The next thing on our small list of big things is WordCamp Asia is currently searching for volunteers for the upcoming event on March 7th through 9th, 2024. They&#8217;re looking for Contributor Stories, Event Volunteers, Emcee support, A/V Team Crew, and even designers to help create the official Wapuu for the event. I&#8217;ll include a link to applications for that in the show notes as well.&nbsp;</p>\n\n\n\n<p>And finally, I think it&#8217;s important to mention that if you don&#8217;t really know what a WordCamp is, so you don&#8217;t really understand why you should volunteer to help this one, or why you would want to, then head over to your local meetup. If you look in your WordPress dashboard, there&#8217;s a widget in there that tells you when the next local event will be. And I know that they will all be delighted to have you there. And who knows, maybe your city will be the next to host a WordCamp. I&#8217;ll also include in the show notes just a list of all of the meetup groups that we have in the world. And so if you don&#8217;t trust your dashboard or you don&#8217;t share your location there for some reason, you can just find it on your own.</p>\n\n\n\n<p>And that, my friends, is your small of big things.</p>\n\n\n\n<p>[00:04:32] <strong>Josepha:</strong> Thanks for tuning in today for the WordPress Briefing. Don&#8217;t forget to follow us on your favorite podcast app, or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever a new episode drops. If you liked what you heard today, share it with a fellow WordPresser. Or, if you had questions about what you heard, you can share those directly with me at wpbriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thanks again for listening, and I&#8217;ll see you in a couple of weeks.&nbsp;</p>\n\n\n\n<p>[00:05:00] (Music outro)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Do the work\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=94633\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2023/10/do-the-work/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"<p>There&#8217;s a way to run a company like managing a government, with reports, surveys, and abstractions.</p>\n\n\n\n<p>There&#8217;s a way to run a company like building a ship, where every board and seam has to be understood and checked.</p>\n\n\n\n<p>Both can be successful, but you need to decide which you want to do.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Oct 2023 05:05:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Gutenberg Times: WordCamp Germany, Gutenberg 16.8, WordPress 6.4 and Barriers to building a block theme – Weekend Edition 272\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=25992\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://gutenbergtimes.com/wordcamp-germany-gutenberg-16-8-wordpress-6-4-and-barriers-to-building-a-block-theme-weekend-edition-272/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16109:\"<p>Howdy, </p>\n\n\n\n<p>I am almost ready to head out for a two-week trip starting with <a href=\"https://germany.wordcamp.org/2023/\">WordCamp Germany</a> on Thursday. I can hardly wait to meet members of the German WordPress community for a collective nerd-out over WordPress. I loved their <a href=\"https://germany.wordcamp.org/2023/ueber-das-design-des-wordcamp-deutschland-2023/#english\">graphic design so much</a>, I used it as a featured image for this post on the web. Although there won&#8217;t be a livestream, I know the talks will be recorded and will show up on WordPress TV shortly after, and we&#8217;ll have a list of the <a href=\"https://germany.wordcamp.org/2023/schedule/\">English talks from Track 2</a> </p>\n\n\n\n\n\n<p>There will be a three week-break on the Gutenberg Times due to business travel and vacation. </p>\n\n\n\n<p>There will be lots to catch up in November. Be well. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<p>PS: Oh, oh… Voting is open for <strong><a href=\"https://thewpweekly.com/awards/\">The WP Awards 2023</a></strong>. Pick your favorite<strong> </strong>blog (19) and podcast (20) , hint, hint 🙂 </p>\n\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/10/12/wordpress-6-4-beta-4/\"><strong>WordPress 6.4 Beta 4</strong></a> is out, ahead of RC 1 there might be another Beta 5. Please continue testing over the weekend. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In last week&#8217;s Hallway Hangout, <strong>Justin Tadlock</strong>, <strong>Nick Diego</strong> and <strong>Ryan Welcher</strong>, discussed <strong><a href=\"https://wordpress.tv/2023/10/12/hallway-hangout-whats-new-for-developers-in-wordpress-6-4/\">What’s new for developers in WordPress 6.4</a>,</strong> from Block Hooks and improved Editor flows to the new Twenty Twenty-Four theme. The recording is available on WordPress TV. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>If you are not a developer but still want to catch up what will be in WordPress 6.4 the secret tool is the <a href=\"https://nomad.blog/2023/10/09/wordpress-6-4-source-of-truth/\"><strong>Source of Truth WordPress 6.4</strong></a> post by <strong>Anne McCarthy</strong>. It takes a deep dive into all the nooks and grannies of the new version, in more detail, you&#8217;d ever wanted to know.  The good part is that it tags each feature for the various user groups</p>\n\n\n\n<ul>\n<li>[end user]: end user focus.&nbsp;</li>\n\n\n\n<li>[theme author]: block or classic theme author.&nbsp;</li>\n\n\n\n<li>[plugin author]: plugin author, whether block or otherwise.</li>\n\n\n\n<li>[site admin]: this includes a “builder” type.&nbsp;</li>\n</ul>\n\n\n\n<p>Now you can use your browser&#8217;s <strong>Find </strong>feature and look for the <em>tag strings</em> to surface relevant information for you. Or use the 35 items Table of Contents to navigate around the mother of a post.  </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Vicente Canales</strong> managed the release of Gutenberg 16.8.  In his release post <strong><a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">What’s new in Gutenberg 16.8 (11 October)</a></strong> he highlighted: </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/10/12/whats-new-in-gutenberg-16-8-11-october/#cover-block-automatically-set-overlay-color-when-applying-the-initial-background-image\">Cover block: automatically set overlay color when applying the initial background image</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/12/whats-new-in-gutenberg-16-8-11-october/#show-template-toggle-when-editing-pages\">Show template toggle when editing pages</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/10/12/whats-new-in-gutenberg-16-8-11-october/#font-library-add-an-uploads-tab\">Font Library: add Uploads tab</a></li>\n</ul>\n\n\n\n<p>Canales also pointed out the first iteration of a pages list in the Site editor, which is a start into Phase 3 of modernizing the Admin pages. </p>\n\n\n\n<a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\"><img width=\"652\" height=\"393\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/10/Screenshot-2023-10-14-at-12.42.26.png?resize=652%2C393&ssl=1\" alt=\"The color of the background overlay will be automatically chosen from the dominant color of the background image. - Screenshot\" class=\"wp-image-26005\" /></a>The color of the background overlay will be automatically chosen from the dominant color of the background image.\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In her article <a href=\"https://wptavern.com/gutenberg-16-8-makes-cover-block-smarter-adds-experimental-pages-list-in-site-editor\"><strong>&#8220;Gutenberg 16.8 Makes Cover Block Smarter, Adds Experimental Pages List in Site Editor</strong></a>&#8221; <strong>Sarah Gooding </strong>discusses the  improvements to the cover block, making it smarter and more versatile. Additionally, she calls out an experimental feature:  the pages list has been added to the site editor, providing users with a different way to navigate and manage their pages. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</a> with Tammie Lister as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Joen Asmussen</strong> shared in his post <a href=\"https://make.wordpress.org/design/2023/10/10/11610/\"><strong>Design Share: Sep 25-Oct 6</strong></a> the work the WordPress Design team has been producing. He recaps the work on the Lightbox improvements, the Toolbar button consistency, on the exploration of a color/token system package for the wp-admin redesign, and a few more site editor improvements. Some work could use some community input, and you&#8217;ll find in the post the links to the various GitHub Issues to comment. on. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>for the latest Call for Testing, <strong>Anne McCarthy</strong> published that summary <a href=\"https://make.wordpress.org/test/2023/10/10/fse-program-final-touches-summary/\"><strong>FSE Program Final Touches Summary</strong></a>. This testing call spanned numerous planned WordPress 6.4 features, including a focus on the Font Library (which is no longer planned for 6.4). Feedback covered more usability needs for pattern categories, more verbosity for command palette commands interface and the hope for more design tools around background images for blocks. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Bud Kraus</strong> scheduled a training event: <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296568956/\"><strong>What’s New In WordPress 6.4?</strong></a> for November 7, 2023, at 17:00 UTC the day of the release. He&#8217;ll focus on the improvements to the Site Editor, better ways to use patterns and show off the Lightbox functionality for image blocks. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> wants you to watch his video before selecting a block theme for your next project: <a href=\"https://www.youtube.com/watch?v=QHn2uKkRJWI\"><strong>Don&#8217;t Choose a WordPress Theme Until You Watch This!</strong></a> as he has 10 questions you should consider before you make a final decision. He also explains the what and why. Marsland pulls his examples from <a href=\"https://wordpress.org/themes/ollie/\">Ollie</a> by Mike McAlister, the about to be released default theme <a href=\"https://github.com/wordpress/twentytwentyfour\">Twenty-Twenty-Four</a> and <a href=\"https://wordpress.org/themes/spectra-one/\">Spectra One</a> by Brainstorm Force, the team who also built Astra </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://learn.wordpress.org/tutorial/choosing-and-installing-theme/\">Choosing and installing a theme</a></strong> was also the topic of a recent Learn.WordPress tutorial. The recording is now available. In this session, you&#8217;ll learn about the different types of themes as well as how to find and evaluate a theme. Furthermore, <strong>Wes Theron</strong>,  looked at how to install, update and delete a theme and where to go for support. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Gooding</strong> reported on how <a href=\"https://wptavern.com/wordpress-contributors-speed-up-twenty-twenty-four-default-theme-performance-by-40\"><strong>WordPress Contributors Speed Up Twenty Twenty-Four Default Theme Performance by 40%</strong></a>. &#8220;“I am very excited to report that most (if not all) of the server-side performance concerns have been addressed, via additional general performance fixes that landed in core,” Arntz said.&#8221; Gooding quoted Felix Arntz. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Wes Thereon</strong> invites every one to the workshop: <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296575670/\"><strong>Using the Query Loop block and Category templates</strong></a> on October 17, 2023, at 20:00 UTC. You&#8217;ll learn how to display posts using the Query Loop block and how to utilize category templates if you want to change the look and feel of a page that displays posts by category.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Anne McCarthy</strong> invited WordPress theme authors to a Hallway Hangout <strong><a href=\"https://make.wordpress.org/test/2023/10/12/hallway-hangout-lets-chat-about-the-experience-of-building-a-block-theme/\">Let’s chat about the experience of building a block theme</a>. </strong>The recording and summary is now available on the make blog of the Test team. The overall question was What keeps developers from building block themes? </p>\n\n\n\n\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>On the WordPress Developer News, I published the ninth edition of the <a href=\"https://developer.wordpress.org/news/2023/10/whats-new-for-developers-october-2023/\"><strong>What&#8217;s new for developers round-up posts: October 2023</strong></a>.You can find a list of updates for plugin and theme developers. Furthermore, you&#8217;ll learn about the beginning of the Gutenberg as a framework documentation site. I also highlight a new plugin to for plugin authors to check their plugins against the plugin guidelines, before they submit it to the plugin repository to shorten the length it spends with the plugin review team. It&#8217;s just at the beginning, but it should help new and seasoned plugin builders to cut down on review time, that is right now still at about 90 days. I couldn&#8217;t use the work plugin one more time 🙂 </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> published a tutorial on <a href=\"https://learn.wordpress.org/tutorial/custom-database-tables/\"><strong>Custom Database Tables</strong></a>. In this short video, you&#8217;ll learn when and how to create custom database tables and how to update, and delete custom database tables</p>\n\n\n\n<p></p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: <a href=\"https://germany.wordcamp.org/2023/ueber-das-design-des-wordcamp-deutschland-2023/#english\">Block Design for WordCamp Germany</a> by Lührsen &amp; Hendrik </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Oct 2023 13:25:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Gutenberg 16.8 Makes Cover Block Smarter, Adds Experimental Pages List in Site Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/gutenberg-16-8-makes-cover-block-smarter-adds-experimental-pages-list-in-site-editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3806:\"<p><a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">Gutenberg 16.8</a> was released this week with improvements to existing blocks and some experiments that lay the foundation for Phase 3 focused on collaboration. </p>\n\n\n\n<p>The Cover block now <a href=\"https://github.com/WordPress/gutenberg/pull/54054\">automatically sets an overlay color</a> when a user applies the initial background image. If the user doesn&#8217;t manually set an overlay color prior to uploading the image, the code extracts the overlay color by computing the average color of the image. Automattic-sponsored core contributor Vicente Canales included a video, which demonstrates how expertly the block selects the most complimentary overlay color:</p>\n\n\n\nvideo credit: <a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">Gutenberg 16.8 release post</a>\n\n\n\n<p>Work on the Font Library continues, even though the feature was <a href=\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\">punted to WordPress 6.5</a>. Gutenberg 16.8 moves font uploads to a new Upload tab, improves error messaging, and removes the use of snackbar. This feature can be seen under Global Style > Typography in the Site Editor.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1698\" height=\"1260\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/image-1.png\" alt=\"\" class=\"wp-image-150239\" />image credit: Gutenberg <a href=\"https://github.com/WordPress/gutenberg/pull/54655\">PR #54655</a>\n\n\n\n<p>There is still a wide chasm between the post and site editors, but version 16.8 introduces a new option toggling templates when editing pages. This allows users to switch back and forth from focusing on the content to seeing the page within the context of the template.</p>\n\n\n\nvideo credit: <a href=\"https://github.com/WordPress/gutenberg/pull/52674\">Gutenberg PR #52674</a>\n\n\n\n<p>Gutenberg 16.8 adds some experiments on the roadmap for Phase 3, including an initial implementation of <a href=\"https://github.com/WordPress/gutenberg/pull/54966\">the pages list in the site editor</a>. Users can test it by enabling the &#8220;New admin views&#8221; experiment under Gutenberg > Experiments. The experiment can be found in the site editor by navigating to <code>Pages->Manage all pages</code>. The list is paginated and there are options to sort and filter it. This is one small part of the DataViews roadmap to <a href=\"https://github.com/WordPress/gutenberg/issues/55083\">improve table and list views</a> in the site editor and other interfaces. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\nvideo credit: Gutenberg <a href=\"https://github.com/WordPress/gutenberg/pull/54966\">PR #54966</a>\n\n\n\n<p>Other improvements in this release include the following: </p>\n\n\n\n<ul>\n<li>Add template replace flow to template inspector (<a href=\"https://github.com/WordPress/gutenberg/pull/54609\">54609</a>).</li>\n\n\n\n<li>Adds ‘nofollow’ setting to Button block. (<a href=\"https://github.com/WordPress/gutenberg/pull/54110\">54110</a>)</li>\n\n\n\n<li>Footnotes: Use core’s meta revisioning if available. (<a href=\"https://github.com/WordPress/gutenberg/pull/52988\">52988</a>)</li>\n\n\n\n<li>Show confirmation dialog when moving a post to the trash. (<a href=\"https://github.com/WordPress/gutenberg/pull/50219\">50219</a>)</li>\n\n\n\n<li>Add template replace flow to template inspector. (<a href=\"https://github.com/WordPress/gutenberg/pull/54609\">54609</a>)</li>\n</ul>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">Gutenberg 16.8 release post</a> for the full changelog with links to all the fixes, enhancements, tooling, performance, and accessibility improvements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Oct 2023 02:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Nasdaq Chat\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=100741\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2023/10/nasdaq-chat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:273:\"<p class=\"is-style-matt-rothko-style\">When I was at <a href=\"https://summit.siliconslopes.com/\">Silicon Slopes Summit</a> in Salt Lake City I got a chance to talk to folks from Nasdaq about my latest thoughts on the WordPress project, open source, and distributed work.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Oct 2023 19:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Do The Woo Community: State of the Woo and the Seshies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://dothewoo.io/state-of-the-woo-and-the-seshies/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"<p>In WooBits, we look at the WooSesh State of the Woo and their community awards for WooCommerce, the Seshies.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/state-of-the-woo-and-the-seshies/\">State of the Woo and the Seshies</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Oct 2023 11:15:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"WPTavern: Behind the Lens: WordPress Photos Directory Surpasses 10,000 Images, Moderators Explore Future Enhancements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/behind-the-lens-wordpress-photos-directory-surpasses-10000-images-moderators-explore-future-enhancements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11175:\"<img width=\"1422\" height=\"1058\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-12-at-12.39.13-PM.png\" alt=\"\" class=\"wp-image-150170\" />\n\n\n\n<p>The <a href=\"https://wordpress.org/photos/\">WordPress Photos Directory</a> crossed a major milestone this week, surpassing 10,000 photos. It&#8217;s a growing resource that exists to provide free, publicly-contributed, CC0-licensed photographs. Every photo submitted is moderated by a volunteer.</p>\n\n\n\n<p>I’m super excited about this milestone,&#8221; Photos team moderator Michelle Frechette said. &#8220;Most (if not all) of the moderators are also photographers, and we appreciate the photography skills and the time it takes for people to take, edit, and submit a photo. It’s really fulfilling to see the numbers grow and include so many people and their art.&#8221;</p>\n\n\n\n<p>All the images included in the directory are also available through Openverse, which aggregates various media sources. One distinction about the directory is that it accepts user submissions from anyone &#8211; they don&#8217;t have to be professional-level photos.</p>\n\n\n\n<p>&#8220;The fact that there are now over 10,000 photos in the directory that folks can use &#8211; completely attribution-free &#8211; is incredible,&#8221; Photos team moderator Marcus Burnette said. &#8220;What I love even more, though, is that there are 1400+ contributors that make up that number! While submitting a photo is simple, often times composing, taking, and editing a photo is not. I appreciate everyone who has taken the time to make the directory as high-quality as it is.&#8221;</p>\n\n\n\n<p>Selections from the WordPress Photos Directory were featured as hanging prints in the Open Source | Open Canvas art gallery at WordCamp US 2023. The QR codes below each photo linked to their respective pages on <a href=\"http://wp.org/photos\" target=\"_blank\" rel=\"noreferrer noopener\">WP.org/photos</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n\n<img width=\"355\" height=\"500\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/IMG_7939-355x500.jpg\" alt=\"\" class=\"wp-image-150183\" />\n\n\n\n<img width=\"500\" height=\"375\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/IMG_7987-500x375.jpg\" alt=\"\" class=\"wp-image-150184\" />\nphoto credit: Christy Nyiri\n\n\n\n<p>Moderators report that roughly 85.5% of the photos submitted so far have been approved. Photos getting rejected are usually not following the guidelines (ex: human face in the photo, private info like a license plate in image), or are not high enough quality (ex: low resolution, crooked horizon.)</p>\n\n\n\n<p>Moderating photos only takes a minute or two on average and the queue has been fairly manageable. The moderators use various checks to ensure photos are high quality and original, include accurate alt text, cross-check subject tags, and add the main colors of the image. In some cases, when a submission is rejected, moderators will email asking them to correct the issues and re-submit. Most photos are moderated within two to three business days. </p>\n\n\n\n<p>Becoming a photo moderator after starting as someone who submits photos, is one of the natural paths many contributors have taken to joining the team. It&#8217;s one of the many opportunities to contribute back to the open source project without writing code.</p>\n\n\n\n<p>&#8220;Some of my photos were the first to seed the directory for the announcement and launch, which was a huge honor,&#8221; Frechette said. &#8220;Becoming a moderator and helping others submit their photos is really fulfilling.</p>\n\n\n\n<p>&#8220;Although it doesn’t always make you happy to decline a photo, it’s helping the project be competitive and high quality, and oftentimes a photographer can make a small tweak (like blurring a license plate or leveling a horizon) and then re-submit it.</p>\n\n\n\n<p>&#8220;I’ve learned a ton about the world and the WordPress community &#8211; and about what they love &#8211; by moderating photos.&#8221;</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n\n<img width=\"375\" height=\"500\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/40064ff8de0c50228.88755667-1536x2048-1-375x500.jpg\" alt=\"A Cup of white tea on a wooden table besides an open window.\" class=\"wp-image-150194\" /><a href=\"https://wordpress.org/photos/photo/40064ff8de/\" rel=\"nofollow\">A Cup of white tea on a wooden table besides an open window.</a> by <a href=\"https://ajithrn.com\" rel=\"nofollow\">ajithrn</a> is licensed under <a href=\"https://creativecommons.org/publicdomain/zero/1.0/\" rel=\"nofollow\">CC-CC0 1.0</a>\n\n\n\n<img width=\"500\" height=\"333\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/98864ef7e987db857.41234681-2048x1365-1-500x333.jpg\" alt=\"Abondant bike without a seat.\" class=\"wp-image-150193\" /><a href=\"https://wordpress.org/photos/photo/98864ef7e9/\" rel=\"nofollow\">Abondant bike without a seat.</a> by <a href=\"http://vnima.lt\" rel=\"nofollow\">vatoyiit</a> is licensed under <a href=\"https://creativecommons.org/publicdomain/zero/1.0/\" rel=\"nofollow\">CC-CC0 1.0</a>\n\n\n\n<img width=\"500\" height=\"375\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/4246321d58607e375.52860513-2048x1536-1-500x375.jpg\" alt=\"Estuary at Ölfus, Iceland\" class=\"wp-image-150192\" /><a href=\"https://wordpress.org/photos/photo/4246321d58/\" rel=\"nofollow\">Estuary at Ölfus, Iceland</a> by <a href=\"https://github.com/Pierre-Lannoy\" rel=\"nofollow\">Pierre Lannoy</a> is licensed under <a href=\"https://creativecommons.org/publicdomain/zero/1.0/\" rel=\"nofollow\">CC-CC0 1.0</a>\n\n\n\n<img width=\"500\" height=\"281\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/6216321d556284699.47023750-2048x1152-1-500x281.jpeg\" alt=\"Dried mud texture\" class=\"wp-image-150191\" /><a href=\"https://wordpress.org/photos/photo/6216321d55/\" rel=\"nofollow\">Dried mud texture</a> by <a href=\"https://github.com/Pierre-Lannoy\" rel=\"nofollow\">Pierre Lannoy</a> is licensed under <a href=\"https://creativecommons.org/publicdomain/zero/1.0/\" rel=\"nofollow\">CC-CC0 1.0</a>\nA few moderator-selected favorites from the WordPress Photos Directory\n\n\n\n<h3 class=\"wp-block-heading\">Making WordPress&#8217; Photos Directory a More Competitive Resource for CC0 Images</h3>\n\n\n\n<p>The photo moderators have many ideas for making the directory a more competitive resource for CC0 photos but currently do not have quantifiable ways to measure the growth in traffic and usage.</p>\n\n\n\n<p>&#8220;As far as I know, we (the moderators) don’t have access to any traffic data,&#8221; Burnette said.</p>\n\n\n\n<p>&#8220;I’d love to see the directory more prominently featured as a source of media inside WordPress core. In addition, having some access to stats (search queries, traffic patterns, photo downloads) would give us a better view of where we are and how to focus our future growth.&#8221;</p>\n\n\n\n<p>Most of the promotion for the directory has happened during photo walks at WordCamps and contributor tables where photographers are trained to understand what makes a good photo, how the process works, and moderate as many as they can that day.</p>\n\n\n\n<p>&#8220;There has been some promotion on Twitter through official WordPress channels, but I’d love to see some of these images used in the yearly themes and in the block pattern directory,&#8221; moderator Chuck Grimmett said.</p>\n\n\n\n<p>&#8220;Another thing we are missing is easy selection in the block editor.&#8221;</p>\n\n\n\n<p>Users have a few different sources to select from, depending on whether they have plugins like Jetpack installed that add more. All of the WordPress Photo Directory images are included in Openverse, but searching for CC0 images from the WordPress directory itself is not an option. Grimmett opened a <a href=\"https://github.com/WordPress/gutenberg/issues/55286\">ticket</a> on GitHub to put the idea on contributors&#8217; radar.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1332\" height=\"860\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/image.png\" alt=\"\" class=\"wp-image-150189\" />\n\n\n\n<p>One of the biggest hurdles to expanding the volume of the directory is that images that include human faces are prohibited from getting listed in the collection. This is a a legal requirement that the team would have to work out with legal council to change.</p>\n\n\n\n<p>&#8220;We’ve attempted to get this cleared on several occasions over the last year or two,&#8221; Burnette said. &#8220;The legal hurdle seems to be quite large to allow for this, so the status of that is in a holding pattern.&#8221;</p>\n\n\n\n<p>As a result, nature is the most popular category with more than 6,000 images. Athletics is the least popular, as it&#8217;s not easy to get great photos without the faces. </p>\n\n\n\n<p>&#8220;We do not have access to the searches that folks are making, so it’s hard to know what people are looking for specifically,&#8221; Burnette said.</p>\n\n\n\n<p>&#8220;Something that no doubt is searched for frequently is corporate type images (offices, desk setups, meetings, etc) and we don’t have a ton of those &#8211; likely also due in part to the requirement about not including human faces.&#8221;</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1862\" height=\"926\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/CleanShot-2023-10-11-at-15.11.50@2x.jpg\" alt=\"\" class=\"wp-image-150187\" />\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p>&#8220;Another big thing is search,&#8221; Photo moderator Topher DeRosia said. &#8220;Early on in the project, and sometimes even now, the alt text is not great, and tags aren&#8217;t well thought out, so a keyword search may not find what we&#8217;re really looking for.  I&#8217;d love for a set of skilled moderators to review all 10,000 photos and make the alt text amazing. I think a really good AI search tool that can look at the images and try to get it right might be a great inclusion.&#8221;</p>\n\n\n\n<p>The Photos Directory project is a unique contribution opportunity that gives moderators a glimpse into the beauty of things and places around the world that photographers were inspired to capture and submit. The fact that the images are available inside the WordPress editor makes it more than just another collection of photos on the web. It&#8217;s an important, growing resource that showcases the creative lives of contributors.</p>\n\n\n\n<p>&#8220;I added the incoming stream to my RSS reader, so I&#8217;ve literally laid eyes on every single image in there, whether I moderated it or not,&#8221; DeRosia said. &#8220;Because of this I&#8217;ve seen photos from everyplace in the world that WordPressers have submitted them, and that&#8217;s a lot. </p>\n\n\n\n<p>&#8220;I&#8217;ve learned that we have some amazingly talented photographers in the community.  I&#8217;ve learned about geography and history.  I&#8217;ve also met some new and wonderful people. As always, contribution pays great dividends.&#8221;<a href=\"https://files.slack.com/files-pri/T024MFP4J-F061ET96XCG/cleanshot_2023-10-11_at_16.25.28_2x.png\"></a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Oct 2023 04:20:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WordPress.org blog: WordPress 6.3.2 – Maintenance and Security release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16122\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2023/10/wordpress-6-3-2-maintenance-and-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9798:\"<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?milestone=6.3.2&group=component&col=id&col=summary&col=milestone&col=owner&col=type&col=status&col=priority&order=priority\">19 bug fixes on Core</a>, 22 bug fixes for the Block Editor, and 8 security fixes.</p>\n\n\n\n<p>WordPress 6.3.2 is a short-cycle release. You can review a summary of the maintenance updates in this release by reading the <a href=\"https://make.wordpress.org/core/2023/10/06/wordpress-6-3-2-rc1-is-now-available/\">Release Candidate announcement</a>. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. Backports are also available for other major WordPress releases, 4.1 and later.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-4/\">version 6.4</a> planned for 7 November 2023.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.3.2.zip\">download WordPress 6.3.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-3-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for responsibly reporting vulnerabilities, and allowing them to be fixed in this release:</p>\n\n\n\n<ul>\n<li>Marc Montpas of Automattic for finding a potential disclosure of user email addresses.</li>\n\n\n\n<li>Marc Montpas of Automattic for finding an RCE POP Chains vulnerability.</li>\n\n\n\n<li>Rafie Muhammad and Edouard L of <a href=\"https://patchstack.com/\">Patchstack</a> along with a WordPress commissioned third-party audit for each independently identifying a XSS issue in the post link navigation block.</li>\n\n\n\n<li><a href=\"https://www.linkedin.com/in/audrasjb/\">Jb Audras</a> of the WordPress Security Team and Rafie Muhammad of <a href=\"https://patchstack.com/\">Patchstack</a> for each independently discovering an issue where comments on private posts could be leaked to other users.</li>\n\n\n\n<li>John Blackbourn (WordPress Security Team), <a href=\"https://hackerone.com/jamesgol?type=user\">James Golovich</a>, <a href=\"https://hackerone.com/jdgrimes\">J.D Grimes</a>, <a href=\"https://hackerone.com/numan\">Numan Turle</a>, <a href=\"https://hackerone.com/whitecybersec?type=user\">WhiteCyberSec</a> for each independently identifying a way for logged-in users to execute any shortcode.</li>\n\n\n\n<li><a href=\"https://facebook.com/zino.abdrahim\">mascara7784</a> and a third-party security audit for identifying a XSS vulnerability in the application password screen.</li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> of the WordPress Core Team for identifying XSS vulnerability in the footnotes block.</li>\n\n\n\n<li><a href=\"https://hackerone.com/s5s\">s5s</a> and <a href=\"http://twitter.com/Raoufmaklouf\">raouf_maklouf</a> for independently identifying a cache poisoning DoS vulnerability.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> and <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, with the help of<a href=\"https://profiles.wordpress.org/davidbaumwald/\"> David Baumwald</a> on mission control.</p>\n\n\n\n<p>WordPress 6.3.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance and security fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/akihiroharai\">Akihiro Harai</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/antpb\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/aurooba\">Aurooba Ahmed</a>, <a href=\"https://profiles.wordpress.org/scruffian\">Ben Dwyer</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/coreyw\">Corey Worrell</a>, <a href=\"https://profiles.wordpress.org/colorful tones\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/david.binda\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/desmith\">David E. Smith</a>, <a href=\"https://profiles.wordpress.org/dsas\">Dean Sas</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhruvishah2203\">Dhruvi Shah</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham S.</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/Mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/huzaifaalmesbah\">Huzaifa Al Mesbah</a>, <a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/greenshady\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kimannwall\">Kim Coleman</a>, <a href=\"https://profiles.wordpress.org/lhe2012\">LarryWEB</a>, <a href=\"https://profiles.wordpress.org/lgladdy\">Liam Gladdy</a>, <a href=\"https://profiles.wordpress.org/iammehedi1\">Mehedi Hassan</a>, <a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/nicolefurlan\">Nicole Furlan</a>, <a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/paulkevan\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pooja1210\">Pooja N Muchandikar</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar\">Rajin Sharwar</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shailu25\">Shail Mehta</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/tykoted\">Teddy Patriarca</a>, <a href=\"https://profiles.wordpress.org/TimothyBlynJacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/zunaid321\">Zunaid Amin</a>, <a href=\"https://profiles.wordpress.org/ahardyjpl\">ahardyjpl</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">beryldlg</a>, <a href=\"https://profiles.wordpress.org/floydwilde\">floydwilde</a>, <a href=\"https://profiles.wordpress.org/jastos\">jastos</a>, <a href=\"https://profiles.wordpress.org/martin.krcho\">martin.krcho</a>, <a href=\"https://profiles.wordpress.org/masteradhoc\">masteradhoc</a>, <a href=\"https://profiles.wordpress.org/petitphp\">petitphp</a>, <a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/zieladam\">zieladam</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C055Y7FKS7N\">#6-4-release-leads channels</a>. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p><em>Already testing WordPress 6.4? The fourth beta is now available (<a href=\"https://wordpress.org/wordpress-6.4-beta4.zip\">zip</a>) and it contains these security fixes. For more on 6.4, see the&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\" target=\"_blank\">beta 3 announcement post</a>.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to<em> <a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">@chanthaboune</a>, </em></em><a href=\"https://profiles.wordpress.org/peterwilsoncc/\">@peterwilsoncc</a><em><em> and <a href=\"https://profiles.wordpress.org/rawrly/\">@rawrly</a></em> for proofreading.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Oct 2023 20:44:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordPress.com Enters the Fediverse with ActivityPub Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150137\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/wordpress-com-enters-the-fediverse-with-activitypub-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4623:\"<p>WordPress.com <a href=\"https://wordpress.com/blog/2023/10/11/activitypub/\">added support for ActivityPub</a> today, a decentralized social networking protocol that is now available for across free and paid plans. This allows users to join the fediverse from their WordPress.com sites, and interact with content across federated platforms like Mastodon (and many others) with replies automatically published back to the blog as comments.</p>\n\n\n\n<p>The <a href=\"https://wptavern.com/activitypub-1-0-0-released-introducing-blog-wide-accounts-and-new-blocks\">latest version</a> of the <a href=\"https://wordpress.org/plugins/activitypub/\">ActivityPub plugin</a> for WordPress allows blogs or sites to have their own ActivityPub profile. (Previously, profiles were limited to individual authors). Automattic acquired the plugin in March 2023, from German developer <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> who joined the company and has continued to improve it and add new features.</p>\n\n\n\n<p>Practically speaking, this new ActivityPub support allows fediverse users to follow participating WordPress.com blogs on their chosen service, and comment on the content with those comments synced back to the blog &#8211; all without leaving their federated platform.</p>\n\n\n\n<p>WordPress.com users can activate ActivityPub support under <em>Settings > Discussion</em>. They also have the option to use a custom domain for a shorter, more memorable identifier.</p>\n\n\n\n<p>Once activated, ActivityPub support is available on new posts only &#8211; it is not retroactive. There may also be a delay in short delay for newly published posts appearing on federated platforms.</p>\n\n\n\n<p>One WordPress.com user asked &#8220;When will WordPress Reader be able to follow Fediverse accounts?&#8221; This isn&#8217;t yet on the roadmap, based on the response from WordPress.com representatives, but may now be on their radar for future improvements to ActivityPub support.</p>\n\n\n\n<p>This plugin and its addition to WordPress.com marks a significant expansion for the availability of ActivityPub interoperability, as support can now be effortlessly added for WordPress.com sites in addition to self-hosted sites. </p>\n\n\n\n<p>In 2022, Automattic CEO Matt Mullenweg said Tumbler would add support for ActivityPub but this has not yet materialized and a current Tumblr employee said in July 2023, that they are <a href=\"https://indieweb.social/@_jv_@mastodon.social/110692572899315822\">still evaluating it</a> but that it may cost more than it&#8217;s worth to the company. It may have become a lower priority, as Tumblr doesn&#8217;t appear to be in a position to embrace new projects that don&#8217;t generate cash flow. </p>\n\n\n\n<p>Adoption of the ActivityPub protocol has been slow moving and has not yet delivered the avalanche of new users that Twitter/X has practically gift wrapped with its many unfavorable changes and, most recently, its laughable <a href=\"https://slate.com/technology/2023/10/elon-musk-x-twitter-news-links-headlines-why.html\">treatment of external links</a>, which is an affront to the open web. Blogging pioneer and podcaster Dave Winer, who has watched social networks come and go, is not banking on ActivityPub and believes &#8220;<a href=\"http://scripting.com/2023/10/10/114018.html\">the world will not coalesce behind ActivityPub</a>&#8221; in its search for a standard. </p>\n\n\n\n<p>For those who are already active on fediverse platforms that support ActivityPub, WordPress.com&#8217;s new features may be useful for ensuring that blogs can meaningfully participate there. It&#8217;s a quick and easy way to allow more people to follow WordPress sites and give their content further reach into the fediverse. </p>\n\n\n\n<p>The future adoption of the ActivityPub protocol across more apps and platforms remains to be proven. In July, when Threads announced it would support the protocol, Mastodon CEO Eugen Rochko said in a <a href=\"https://blog.joinmastodon.org/2023/07/what-to-know-about-threads/\">blog post</a>, &#8220;The fact that large platforms are adopting ActivityPub is not only validation of the movement towards decentralized social media but a path forward for people locked into these platforms to switch to better providers.&#8221; Although this wider network of ActivityPub support gives users more choice about the platforms they use to communicate, the evolution of the social media landscape is still volatile and unpredictable, leaving many people with the burden of hedging their bets by interacting across multiple networks while waiting for the dust to settle.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Oct 2023 04:07:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WordPress Contributors Speed Up Twenty Twenty-Four Default Theme Performance by 40%\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/wordpress-contributors-speed-up-twenty-twenty-four-default-theme-performance-by-40\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4348:\"<p>WordPress 6.4 will be shipping a new default theme, <a href=\"https://wptavern.com/wordpress-unveils-design-for-upcoming-twenty-twenty-four-default-theme\">Twenty Twenty-Four</a> (TT4), expected in early November. This theme is more feature-rich than previous default themes, and contributors have been working on <a href=\"https://core.trac.wordpress.org/ticket/59465\">identifying potential performance improvements</a> that can be made ahead of the release.</p>\n\n\n\n<p>As a starting point, Google-sponsored Performance team contributor Felix Arntz conducted several benchmarks comparing TT4 with the TT3 block theme. These included overall Web Vitals covering both server-side (TTFB) and client-side (LCP-TTFB), along with a separate server-side load time performance benchmark. Arntz posted a summary of this data:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<ul>\n<li>For the home page:\n<ul>\n<li>Overall load time (LCP) is 58.8% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Client-side performance (LCP-TTFB) is 93.5% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Server-Timing (<code>wp-total</code>) is 71.8% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n\n\n\n<li>For the singular post:\n<ul>\n<li>Overall load time (LCP) is 3.9% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Client-side performance (LCP-TTFB) is 40.1% faster. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f7e2.png\" alt=\"🟢\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Server-Timing (<code>wp-total</code>) is 42.3% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n</ul>\n</blockquote>\n\n\n\n<p>He noted that the reason TT4 is slower is because it provides a lot more feature rich content out of the box than TT3.</p>\n\n\n\n<p>&#8220;Interestingly, the server-side performance difference between TT4 and TT3 seems to come almost exclusively from the number of block editor features used by the theme, but not by any problems from the theme itself,&#8221; Arntz said. &#8220;In fact, the theme only includes a single function of PHP logic. It does however include more complex content than TT3 and comes with a large number of patterns, so potentially that plays a role there.&#8221;</p>\n\n\n\n<p>After just two weeks of work on specific tickets for a few flagged issues, performance contributors were able to make the new Twenty Twenty-Four theme (and other themes) load more than 40% faster.</p>\n\n\n\n<p>&#8220;I am very excited to report that most (if not all) of the server-side performance concerns have been addressed, via additional general performance fixes that landed in core,&#8221; Arntz said.</p>\n\n\n\n<p>He summarized the improvements in the server-timing benchmarks when comparing TT4 and TT3 with the latest core trunk:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<ul>\n<li>TT4 home page loads in 85.91ms, compared to 78.08ms in TT3.\n<ul>\n<li>→&nbsp;<strong>10.0% slower, but before was 71.8% slower</strong>&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n\n\n\n<li>TT4 &#8220;Hello world!&#8221; post loads in 96.44ms, compared to 86.35ms in TT3.\n<ul>\n<li>→&nbsp;<strong>11.7% slower, but before was 42.3% slower</strong>&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n</ul>\n</blockquote>\n\n\n\n<p>There are a few outstanding client-side performance enhancements, but Arntz said these require more thought and time investment so they have been milestoned for the 6.5 release. </p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\">WordPress 6.4 Beta 3</a> was released yesterday. Although the flagship Font Library feature has been <a href=\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\">punted to 6.5</a>, contributors said this change will not affect Twenty Twenty-Four, as the theme will ship with preselected fonts that get loaded from the theme assets, just like previous default themes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Oct 2023 22:42:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: #94 – Birgit Olzem and Jill Binder on Creating a Diverse and Sustainable WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=150098\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/podcast/94-birgit-olzem-and-jill-binder-on-creating-a-diverse-and-sustainable-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:55141:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, diversity in the WordPress community.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Birgit Olzem and Jill Binder.</p>\n\n\n\n<p>Birgit Olzem is a WordPress enthusiast who juggles diverse roles, and advocates for mental health awareness, diversity and unsung contributors. A proud mother and grandmother, she also consults on personal branding and explore surface pattern design. Birgit champions the WordPress community, as you&#8217;ll hear, in many ways.</p>\n\n\n\n<p>Jill Binder is the founder and CEO of Diverse In Tech. She leads the diverse speaker training group in the wordpress.org community team, which encourages people from underrepresented groups to speak at WordPress events. She helped organize the first BuddyCamp, and for three years, co-organized WordCamp Vancouver.</p>\n\n\n\n<p>Jill and Birgit join me today to discuss the importance of diversity, equity, inclusion, and belonging, D E I B for short, within the WordPress community.</p>\n\n\n\n<p>They share valuable insights regarding their efforts to create a more global and inclusive WordPress ecosystem. This includes the formation of a new working group on the make WordPress Slack account, and the use of GitHub project boards to track tasks and ideas.</p>\n\n\n\n<p>We talk about the need for unity within the community, the significance of diverse perspectives, and the importance of effective communication.</p>\n\n\n\n<p>We also get into Jill&#8217;s experience, organizing a training program for the Vancouver meetup. Emphasizing the importance of understanding the specific needs of different communities.</p>\n\n\n\n<p>We explore the concept of sustainability within the WordPress community, addressing the financial support and resources necessary to retain and support active contributors.</p>\n\n\n\n<p>Throughout the episode, both Jill and Birgit stress the importance of inclusivity, creating a welcoming environment, and providing opportunities for underrepresented voices to participate and contribute.</p>\n\n\n\n<p>If you&#8217;ve been wanting to know more about how to make the WordPress community more diverse and welcoming, this episode is for you.</p>\n\n\n\n<p>In some places, the audio is a little choppy, so apologies for that, but it really is more than listable.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Birgit Olzem and Jill Binder.</p>\n\n\n\n<p>I am joined on the podcast today by Birgit Olzem and Jill Binder. Hello.</p>\n\n\n\n<p>[00:04:11] <strong>Jill Binder:</strong> Hi there.</p>\n\n\n\n<p>[00:04:12] <strong>Birgit Olzem:</strong> Hello.</p>\n\n\n\n<p>[00:04:13] <strong>Nathan Wrigley:</strong> It is absolutely lovely to have you both on the show today. We&#8217;re going to get into an interesting topic. It really isn&#8217;t something that we&#8217;ve touched for a very long time. A new initiative, perhaps not a new initiative, new initiative for an old problem shall we say. And we&#8217;re going to talk about that.</p>\n\n\n\n<p>But before we begin the podcast and talk about the subject at hand, I think it would be important to give you both an opportunity to introduce yourself. Obviously we&#8217;re talking about a WordPress community issue today.</p>\n\n\n\n<p>Be nice to know a little bit about your involvement in the WordPress community. Perhaps a little bit about your backstory, which companies you work for? Anything really. And let&#8217;s start with Birgit, shall we?</p>\n\n\n\n<p>[00:04:53] <strong>Birgit Olzem:</strong> Yeah thank you Nathan. Thank you very much for giving us the room to talk about this amazing topic.</p>\n\n\n\n<p>So I&#8217;m from Germany and as a listener here I struggle a bit. But I&#8217;m a mom of five children, well almost grown up children. And I used WordPress since its first release. I was always curious how things work. I&#8217;m always curious looking behind the scenes, and I want to know how things are building up. I&#8217;ve contributed to WordPress for over a decade now. I was at my first WordCamp in 2010 and since then I&#8217;m totally invested into the WordPress community.</p>\n\n\n\n<p>And as my friend Carole Olinger always cites, &#8221; we came for the software and stayed for the people&#8221;. And I am a people person, and I love to connect people with each other. And I try to help people to find their way and their path on a big journey. And so that&#8217;s why I&#8217;m so invested into the WordPress community because we are building a great software environment, not just software at all, but also the people around it.</p>\n\n\n\n<p>I&#8217;m currently a freelancer, and not sponsored to contribute to WordPress yet, but I&#8217;d like to. I&#8217;m currently part of the new contributor mentorship program, with the cohort in July as a mentor. And I had a great mentee from Austria so we tried also the localised mentorship program.</p>\n\n\n\n<p>We are also currently organising WordCamp Germany at the time of this recording. We&#8217;re in the middle of August. WordCamp Germany will happen in October this year in my hometown, in a small hometown in Germany, Western Germany. So yeah. I will also be part of a female and non binary release squad for WordPress 6.4 as a cohort member for the test team. And besides that I&#8217;m locale manager for the de.wordpress.org site and organising also polyglots, and publishing posts on de.wordpress.org news, and do a lot of stuff.</p>\n\n\n\n<p>[00:07:05] <strong>Nathan Wrigley:</strong> Yeah that was going to be what I was going to say. You do a lot of stuff. That really is a remarkable litany. I know that everybody that uses WordPress realises that there&#8217;s a lot of people in the background doing bits and pieces, but that is quite the laundry list of achievement. So from me to you, thank you for all of the different things that you do. That&#8217;s pretty remarkable. Okay, Jill.</p>\n\n\n\n<p>[00:07:29] <strong>Jill Binder:</strong> How do I follow that? I don&#8217;t know.</p>\n\n\n\n<p>[00:07:32] <strong>Nathan Wrigley:</strong> Yeah. So it&#8217;s your turn. Basically the same question, just give us a little bit of a backstory about yourself and WordPress and so on.</p>\n\n\n\n<p>[00:07:39] <strong>Jill Binder:</strong> Sure thing. So I&#8217;m Jill Binder and I&#8217;m the lead of the diverse speaker training group, #wpdiversity. I was a web developer from 2011 to 2018 ish. And what happened is I was a co organiser for WordCamp Vancouver 2013 and we had hardly any women and people from other underrepresented groups apply to speak at our WordCamp. And that started me on a whole journey. I found out we weren&#8217;t the only ones who had the issue. I asked other groups you know, how do you get more applications? And they&#8217;re like, you had seven? That&#8217;s amazing.</p>\n\n\n\n<p>So in Vancouver we wound up solving the problem for us. We created a workshop that gathered as many women and non binary and other genders in the room who wanted to join, which was a full room. And we went through the myths of what it is to be a, well let me back up a second.</p>\n\n\n\n<p>So we wound up solving the problem for us in Vancouver. We created a workshop and we based the workshop around the issue that we were having which is, when we would ask people if they would apply to speak at our WordCamp they would say, oh well I don&#8217;t even know what I would talk about. Or I&#8217;m not good enough in anything to give a talk, I&#8217;m not an expert.</p>\n\n\n\n<p>So we created a workshop that answers both those questions. It busts through the myth of what it is to be the speaker at the front of the stage. And it goes through, helps people find a topic, and having a whole room of people saying yes, I want to hear you talk about that topic. Goes a huge way in helping people overcome any obstacles they have to wanting to speak.</p>\n\n\n\n<p>We had so much success with that other cities ran it, and it was so successful that in late 2017 Andrea Middleton asked if I would create this group. And I found that it was totally my purpose and passion. And now since 2019 this has been my full time job. This is what I do. Half for WordPress, half for other companies.</p>\n\n\n\n<p>The company that I have now is called diversein.tech. That&#8217;s the website. That&#8217;s what I do. Currently in WordPress I&#8217;m sponsored by Automattic and by Green Geeks to do this work.</p>\n\n\n\n<p>[00:09:47] <strong>Nathan Wrigley:</strong> Thank you so much. I feel that we should just lay the groundwork a little bit, because for many people, myself I think included, the discussion around diversity, I find it difficult sometimes to get my hands on that, and to know who we&#8217;re talking about and who we&#8217;re trying to push this message out to.</p>\n\n\n\n<p>So could you just lay the groundwork for, well I guess in Jill&#8217;s case, she&#8217;s just described how she came up with this training program for the Vancouver meetup and so on. So you obviously had some sort of handle there as what you thought was going wrong, because if you&#8217;re going to create training materials, you must have some idea of what was the problem and what the solution was to that.</p>\n\n\n\n<p>Could you just describe the problem? Because there&#8217;s bound to be people listening to this who will be just thinking, okay interesting podcast but I need more data, more information about who these people are.</p>\n\n\n\n<p>[00:10:37] <strong>Jill Binder:</strong> Yeah that&#8217;s a great question. So the way that we think about it is, each region has people who are well represented. In North America that&#8217;s typically straight, cisgender, meaning same gender now as they were at birth. Male, white, able bodied people. And basically everybody else is underrepresented.</p>\n\n\n\n<p>That&#8217;s specific to North America. So North America we&#8217;ve got ethnicity, race, neurodivergence, different physical abilities, age, different genders, that&#8217;s kind of typically who the underrepresented is.</p>\n\n\n\n<p>And I have learned a lot over the last couple of years that in other parts of the world there are different underrepresented groups. So there might be religion, different spoken languages, different countries that people come from, culture, caste, class, et cetera. Birgit, do you want to add anything to that?</p>\n\n\n\n<p>[00:11:31] <strong>Birgit Olzem:</strong> You put it in the right word and as you said, especially in European countries, but also Asian, African. Australia for instance, you are more difficult to find their BIPOC people on the stage. And when you go to Asia, colored people are more in the lower represented.</p>\n\n\n\n<p>But as Jill already said, diversity is not only race or gender, but also I think diversity is a bit broader as well. Like how we think. And this is influenced by where we are born into and where we are born at. So everyone shares and brings into an own perspective.</p>\n\n\n\n<p>And also the perspective itself is also diversity. When we bring not only people of a kind of label into the community, but also allowing different perspectives and diverse perspectives. Learn from this.</p>\n\n\n\n<p>[00:12:29] <strong>Jill Binder:</strong> 100% to what Birgit just said. Part of the whole reason that I&#8217;ve gotten so passionate about this is because of the different perspectives that different people bring into the communities.</p>\n\n\n\n<p>You know most of my work is around the people on stage and by having different voices on stage we bring in ideas that help bring in more of that kind of person. So make it more inclusive. As well as bring in ideas that wind up benefiting everyone. So for example, closed captioning used to be for people with hearing impairments, limited hearing. But it winds up being great for everyone, you know. Somebody has a crying baby, can&#8217;t hear, they&#8217;re on the bus, they&#8217;re watching something at work, winds up helping everybody.</p>\n\n\n\n<p>[00:13:09] <strong>Nathan Wrigley:</strong> Thank you for that. Yeah really interesting. So one piece that I just took out of that was that the location that you are on the planet might have a very significant effect on the work that you would be doing. So you described the scenario in North America and then you know we heard about all the different parts of the world.</p>\n\n\n\n<p>I&#8217;m really interested in that because I&#8217;m guessing that in the future, the materials that you&#8217;re going to provide, the bits and pieces that you&#8217;re hoping to promote, would be encouraging that. You&#8217;re not in this scenario trying to have a one template fits all. It&#8217;s more of a, look here&#8217;s the underlying things that need to be thought about. Now go and figure out what the jigsaw puzzle of life in your part of the world is like. And then work through what it is that you&#8217;re going to do based upon where you are.</p>\n\n\n\n<p>[00:14:00] <strong>Birgit Olzem:</strong> Yeah exactly. When you see it, not everyone has the privilege of a fast internet connection, for instance. We have contributors in a region where they are depending on mobile cell phones, and are only contributing on a mobile phone. I heard a story that someone was contributing on an old mobile phone with an old internet access browser and was able to do that, but with a hard effort.</p>\n\n\n\n<p>When you see the difference in culture, and where the people come from it influences us like that a lot. And the template that you mentioned, we can&#8217;t bring a one fits all solution. As you already said. We want to invite our contributors, or people who are interested into contributing, to find their own mission but also their values. What is diversity for their community, for their tribe? What is diversity? What makes their event diverse? What makes their contributing team diverse?</p>\n\n\n\n<p>When we see also our contributing teams in the global WordPress community, we have the makewordpress.org teams but we have also local communities with their own Make teams. What is the diversity for them? How can they include people? How can open the gate for new contributors, for instance? Maybe Jill might add something on this.</p>\n\n\n\n<p>[00:15:26] <strong>Jill Binder:</strong> In the team that I&#8217;ve been working in, it&#8217;s a pretty mature team at this point. And so we have completely refined materials, and we have already helped 100 cities in 50 countries around the world with these issues. And we&#8217;re actually now at three programs. One is the diverse speakers. One is actually placing underrepresented speakers at events. But the other one is creating more inclusive, and welcoming and diverse events.</p>\n\n\n\n<p>And so for that first and last one we have set materials, and we&#8217;ve basically generalised, and we&#8217;ve made it, for our material, we&#8217;ve made it like people of underrepresented groups and we&#8217;ve just kind of boxed them in. I&#8217;m really excited for Birgit&#8217;s work that is going to make it more customised for the other things in the project. And maybe even bring some of that into the work that my team is doing.</p>\n\n\n\n<p>But we also just added in some content into our organising inclusive and diverse events workshop to help people define what is diversity in their own region. And to compare what we think it is with actual data of, you know in Vancouver I&#8217;m like, okay I&#8217;m pretty sure that we want to reach out to more of the black community. And I look at the data and find oh the black community is tiny.</p>\n\n\n\n<p>We don&#8217;t want to forget about the black community, but we have to remember actually, there&#8217;s a lot of Asian, South Asian, East Asian and so if they&#8217;re not showing up to our events and not speaking at our stages, what is going on? But I also want to say I&#8217;m not an organiser in Vancouver right now, so I&#8217;m not actually having a say in it. It&#8217;s just an example in my workshop.</p>\n\n\n\n<p>[00:17:00] <strong>Nathan Wrigley:</strong> One curious thing that&#8217;s just popped into my head, as a result of what you&#8217;ve both been saying, we will get very much onto how WordPress is doing with all of this throughout the globe. But one thing that occurs to me is that, I guess as members of the WordPress community, let&#8217;s hope that we&#8217;re behind everything that you&#8217;ve just said, all of us. But there has been in the past sort of little disagreements within the WordPress community. Where people have raised concerns about a particular event which is happening over there. And maybe they&#8217;ve looked at the speaker lineup and they&#8217;ve been unhappy with the different faces that are in that list and all of that.</p>\n\n\n\n<p>But what you&#8217;ve just said is really important because we need to be mindful that if the teams in those different locations have different requirements, if you like around diversity, that&#8217;s just something we be mindful of.</p>\n\n\n\n<p>[00:17:48] <strong>Birgit Olzem:</strong> Exactly, especially this particular discussion sparked my idea, or brought this onto the surface of what was boiling for several years now. Our first attempt to start a global diversity team was in 2018. Germany started a kind of umbrella group awareness team for the WordCamps in Germany.</p>\n\n\n\n<p>But also we thought already about to create some global working group to connect all teams. And this idea sparked and growed over several years now. And the pandemic also showed us where we have issues, and where we are struggling to stay connected with our community and with the people around us.</p>\n\n\n\n<p>But also it opened the gate for new contributors and finding new ways to communicate with each other. But we still have to learn and grow much better. But I think it&#8217;s not only bringing diverse people into it and discuss and judge people about how they are pronouncing something if they are not a native speaker in English, for instance.</p>\n\n\n\n<p>Especially written communication is hard to understand. And when you are not a native English speaking person you&#8217;re trying to find the right words to express your thought on it. And someone else put on his or hers or theirs filter on. And there&#8217;s an expression in German that you have a different listening ear and a different filter when you read something online. And you have only one channel, input channel, into your understanding where you can digest information.</p>\n\n\n\n<p>And when we are seeing each other&#8217;s face in-person meeting, we have the full surrounding, like hearing, seeing, feeling. And text is very condensed and it&#8217;s difficult to understand ideas and concepts and written word. Especially in heated discussions on platforms with limited characters for instance.</p>\n\n\n\n<p>And as I said, it is really important that we stay open minded and instead of calling out, calling in. And contact the person first on one on one level. And ask, hey I see an issue, this is what I feel about, what is your thinking about it? And what can we do about it? Before we&#8217;re calling out something in public, for instance.</p>\n\n\n\n<p>It&#8217;s one thing which fuels a better inclusion feeling, and belonging feeling into the community. Instead of pointing a finger to someone, or a group of people for wrongdoing. Because everyone has an own value system and own experience. Instead of asking what is their different culture.</p>\n\n\n\n<p>And as you said, every event has an individual setting, an individual group around it, that needs to fulfill other requirements and legal requirements for instance. So we can&#8217;t ask for a gender or more details on personal level, for instance, in Germany. Because we have to obey the GDPR regulations. How we can collect data, and how can we work with this data. So it is really helpful when we also create documents to showcase how diverse our global community is. To educate our community members who are also willing to learn how different and diverse we are.</p>\n\n\n\n<p>[00:21:32] <strong>Nathan Wrigley:</strong> I think it&#8217;s a really amazing time that we live in, but it&#8217;s also full of so many tripwires and pitfalls. Because we are, well I don&#8217;t really know if the term we are the first generation. But certainly in the last 20 years, we&#8217;re the first generations of human beings that have been able to communicate with people really straightforwardly at any point in the globe.</p>\n\n\n\n<p>So all of a sudden we&#8217;re thrown into the mix of, okay I can see Australian things and I can see Cambodian things and I can see Mexican things and American things. And you are going to bring the prejudice, for want of a better word, the things that you have been brought up with. I guess some of that is going to be transferred into your expectations of what those things are.</p>\n\n\n\n<p>And it was lovely, the language that you use there. Because again, a new experiment that we&#8217;re running globally I guess is the whole social media thing. And one of the outcomes I have seen of that, is that it is very easy to adopt a tone that doesn&#8217;t, well that seems perhaps more aggressive than you may have intended. This truncated little portion of texts that you&#8217;ve got. Sometimes you don&#8217;t manage to be perhaps as polite as you wanted, and so on and so forth. So there&#8217;s an awful lot in there.</p>\n\n\n\n<p>But one of the things that I took out of that Birgit, was the need to, if you have something to say, and if you have something that you&#8217;d like to be changed. A good way to go about that is to think about saying, okay this is what I think, and here&#8217;s my suggestion, but not to sort of put the boot down and say you need to be doing in this way. That does seem to be a more wholesome and straightforward way of going about it. And Jill, I&#8217;m conscious that you didn&#8217;t get a chance to add anything to that.</p>\n\n\n\n<p>[00:23:12] <strong>Jill Binder:</strong> Birgit said it perfectly.</p>\n\n\n\n<p>[00:23:14] <strong>Nathan Wrigley:</strong> Great. Okay a completely different question. Slightly off piste from the topic that we&#8217;re covering directly. I just wonder, broadly, how does WordPress do in this sphere? Because it feels from the outside, or from the inside that, on the whole the WordPress community, which is fairly unique, it spans all the globe, it&#8217;s got thousands of people involved in it. It&#8217;s pretty unique and it&#8217;s very often a fairly philanthropic thing, people giving up their time and all of that kind of stuff.</p>\n\n\n\n<p>How does WordPress compare? I feel like this might be a question for Jill, given that she&#8217;s been looking around elsewhere. But Birgit perhaps it is for you as well. How do we compare to other industries? Other, yeah, industries is probably the best word I&#8217;ve got. Are we really behind in all of this, or are we at the vanguard, or are we just sort of somewhere in the middle?</p>\n\n\n\n<p>[00:24:04] <strong>Jill Binder:</strong> So I don&#8217;t have official data and I don&#8217;t actually know. But anecdotally from what I&#8217;ve seen, at least in the open source world, so looking at, I don&#8217;t want to name the other ones specifically. In the open source world, which is what WordPress is part of, WordPress tends to be more diverse overall. And we also have the resources to put into working on this issue.</p>\n\n\n\n<p>So WordPress tends to have an easier entry point, at least when I started doing this work back in 2011, 2013 ish, when I was thinking about this a lot. Such that anybody no matter their level of education, no matter their background, can jump into it, start creating blog posts. Then start wanting to tweak the CSS a little. Start coding, and then next thing you know the person is a full blown web dev agency, and so starting is easier.</p>\n\n\n\n<p>And then there&#8217;s this amazing, rich community of people to help teach, that people can learn from. And now we&#8217;ve got even more robust systems with Learn WordPress where there&#8217;s official, easy to grasp, knowledge on all things WordPress. And so our community tends to be more diverse from that standpoint.</p>\n\n\n\n<p>When I started my work the issue was, well our audience is diverse, but the people on stage are not. And now we&#8217;re looking more at contributors and Birgit can maybe talk more about that. But it&#8217;s definitely an issue with our contributors as well. So we&#8217;re anecdotally, unofficially, I would say we are ahead of the curve, but there&#8217;s so much more curve to get over.</p>\n\n\n\n<p>[00:25:55] <strong>Nathan Wrigley:</strong> I like that expression. We&#8217;re ahead of the curve but there&#8217;s lots more curve. Birgit, anything to add?</p>\n\n\n\n<p>[00:26:00] <strong>Birgit Olzem:</strong> Jill already said it nicely, and I just want to add my personal experience. When I was visiting open source events, WordPress was not the focus. And I heard a lot that the WordPress community is the most welcoming community over several years now. And I love that we improve. We are eager to improve our efforts to be more welcoming again.</p>\n\n\n\n<p>Jill mentioned the learn.wordpress.org platform, for instance. On my last WordPress Community Summit in 2014, I was part of the early years of the training team of the WordPress community. And to see how this evolved over the year, that we have a pillar into our WordPress community to educate our user base but also our contributors.</p>\n\n\n\n<p>The recent experience from the mentorship program was very helpful to digest and to evaluate where we have to improve, or where we can improve our ways into contributing. But as Jill mentioned it is easy to contribute to WordPress. The entry way has a lower barrier.</p>\n\n\n\n<p>But I think we have a big challenge to keep active contributors, and over a long term. Because I saw a lot of people burning out over the years, including myself. Over contributing to such an open source system in a higher amount of hours putting into it, for instance. I&#8217;m talking for the people who are more maintaining WordPress instead of contributing occasionally. I think there&#8217;s a lot of room for improvement to support and also create a sustainable social sustainability into our WordPress community.</p>\n\n\n\n<p>And I see the social component, social sustainable component and also a big pillar into the DEIB proposal I wrote, to make sure that active contributors who are investing more than 10 hours, for instance, are well funded, who need to be funded, and who asked to be funded.</p>\n\n\n\n<p>We have a great base of contributors who are already sponsored, or have the ability during their work time to contribute to WordPress. And there are people, for instance like me who are a freelancer, who invests on private time and has no financial backing. But also needs to decide, do I need to make client work to fill my fridge, or do I contribute to WordPress?</p>\n\n\n\n<p>I always have the struggle to maintain my time, for instance. And I think this experience translates also to the initiatives to create a sustainable WordPress community and keep contributors active, not losing that. I guess I went a bit away from it, but I think you get what I want to say.</p>\n\n\n\n<p>[00:29:04] <strong>Nathan Wrigley:</strong> Yeah, thank you. So I think we painted a reasonably good picture of what the issue at hand here is. Okay let&#8217;s pivot slightly and change the direction, because I feel like we&#8217;ve laid the groundwork pretty well there for what is going on, and what we would like to change. As I say, let&#8217;s move it on and let&#8217;s talk about the things that you are both involved with, amongst others I&#8217;m sure, to help change this.</p>\n\n\n\n<p>So one of the things, I&#8217;m going to use the acronym first, it&#8217;s DEIB. That stands for diversity, equity, inclusion, and belonging. Now we&#8217;re going to be referring to that. I&#8217;ll try to use those words instead of the acronym because it&#8217;s probably going to be a lot easier.</p>\n\n\n\n<p>The idea here is that there&#8217;s going to be a team put together. Maybe the team is already in existence and fully fledged. But I just want to flesh out what the things are that you&#8217;re hoping to tackle with that. Now as luck would have it, both Birgit and Jill, they have both been very helpful in providing me with some show notes to this episode. And there&#8217;s a bunch of links in those show notes which will provide an awful lot of context.</p>\n\n\n\n<p>So it&#8217;s links in all sorts of direction, explaining what the philosophy is, how it&#8217;s going to be achieved, how you can get involved, all of those kinds of things. So if at any point you&#8217;re curious about that, pause the podcast, search for this episode on WP Tavern and then come back and you&#8217;ll have more context to the discussion at hand.</p>\n\n\n\n<p>In the show notes you&#8217;ve put five key messages down. I&#8217;ll just run through them quickly now. The first one is diversity is strength. The second one is inclusion means everyone. Third one, unified efforts, bigger impacts. Fourth one, shared responsibility. And the fifth one, call to action. Now I don&#8217;t know who wants to take this first, but I&#8217;m guessing they&#8217;re the underpinnings.</p>\n\n\n\n<p>It looks like it&#8217;s going to be Birgit who&#8217;s going to take this first. I&#8217;m guessing these are the underpinnings. I don&#8217;t know if you want to just take them in the round or do them one at a time. But maybe we should talk through what those individual pieces are for, and why it&#8217;s been distilled to those five key messages.</p>\n\n\n\n<p>[00:31:10] <strong>Birgit Olzem:</strong> Thank you Nathan. Yeah, I was thinking about to find the really key messages to digest the information better because it&#8217;s a very, very complex topic. Diversity, equity, inclusion and belonging is a mouthful to speak for many people, but the meaning behind it. Diversity, it&#8217;s not a buzzword.</p>\n\n\n\n<p>As we already said, you need to have diverse perspectives, diverse input, that a sustainable WordPress can grow and grow much better and more sturdy. Imagine you&#8217;re buying a house, you need strong basement where you put your house on. Diversity brings the strengths to keep the house sturdy and build the pillar.</p>\n\n\n\n<p>And inclusion is, for my instance, you&#8217;re inviting people and lowering the barrier to come into your house and celebrate a party with you. Work with you on the house building. And that&#8217;s also translated to the unified efforts. If you are building a house you need more people that only, you can&#8217;t build it on your own. So the more people the better impact you have.</p>\n\n\n\n<p>But also when you see shared responsibility, no one in the WordPress community has the weight of all decisions on their shoulder. It&#8217;s a team effort, and everyone takes a part of the responsibility. So you don&#8217;t have to put the weight of the world on your shoulders alone, you can share the responsibility with others.</p>\n\n\n\n<p>My perspective, and also what I was proposing with the team, the global team, is that everyone can contribute to that. We in the WordPress community have more diversity, more equity, and more inclusion, and everyone feels belonging to the WordPress community.</p>\n\n\n\n<p>It&#8217;s late in the day for me. I&#8217;m struggling for words. I apologise to our listeners and it&#8217;s a very important message and I invite everyone to read the proposal. It&#8217;s a long proposal, and I also digested it from seven pages down to four pages. But it&#8217;s full of information and so please read it when you have time and find your personal key points also in it.</p>\n\n\n\n<p>[00:33:33] <strong>Nathan Wrigley:</strong> I will copy and paste the exact phrasing of your five key messages there because I just paraphrased them very quickly, but there&#8217;s more in depth. And as I said, all of the links will be provided. So Jill, I think you might have something to add to that.</p>\n\n\n\n<p>[00:33:45] <strong>Jill Binder:</strong> I just want to add that Birgit&#8217;s proposal is brilliant and yes you should read it, audience members of this podcast. The only things that I&#8217;ll add is that I&#8217;m going to add another link to the show notes on an article that I wrote called, why is diversity important to WordPress and your local community?</p>\n\n\n\n<p>And that&#8217;s specifically to do with you know, why do we care about this for meetups and WordCamps? Whereas Birgit is talking about overall all contributing groups, why is it important? So, if anybody is wondering for the specific niche of events, I&#8217;ll add a link for people to read there.</p>\n\n\n\n<p>[00:34:23] <strong>Nathan Wrigley:</strong> Great thank you for that. What&#8217;s the status of this team at the moment? So we&#8217;re recording this right in the middle of August 2023. I don&#8217;t know the status, whether this is an official team, whether it&#8217;s become an official part of the WordPress project. Maybe it&#8217;s an aspirational thing at the moment. So just let&#8217;s clarify that for everybody.</p>\n\n\n\n<p>[00:34:44] <strong>Birgit Olzem:</strong> Yeah at the current status we have already managed to create a new Slack channel on a Make WordPress Slack account. It&#8217;s called deib-working-group, and everyone is invited to join. And we also have GitHub project board to track tasks, ideas, et cetera, where we can work together on this big topic.</p>\n\n\n\n<p>It&#8217;s a long term project and we are in the very first beginning to make it more global, and incorporate the current pillars, like WP Diversity initiative. Like the speaker support group.</p>\n\n\n\n<p>But also the sustainability team which was officially announced during WordCamp Europe this year. So where also the social sustainability is also part of the sustainability team. And with the upcoming WordPress Community Summit, we are also running a session about the diversity, equity, inclusion and belonging team efforts. My hope is that we get an official team sooner than later, so that we can form a team and start working on the key objectives.</p>\n\n\n\n<p>[00:36:05] <strong>Nathan Wrigley:</strong> I have a question surrounding the second of your bullet points, which is inclusion means everyone. And I just want to get some context nailed down here. And I&#8217;m going to read what you said, because I think it sums it up beautifully. Inclusion means everyone. So that&#8217;s clarifying the D E I B, the acronym we&#8217;ve been mentioning, efforts aren&#8217;t about favouring some over others, but ensuring that everyone has equal opportunity and feels welcomed.</p>\n\n\n\n<p>And I guess that&#8217;s the crucial point, isn&#8217;t it? The intention here isn&#8217;t to have some sort of tick list of things which must be achieved at every event, and it must look like this, and sound like this, and be written in this. It&#8217;s more about making sure that everybody, well, I say it&#8217;s. Is it more about just laying the groundwork, making sure that everybody knows that they are welcome, and hoping that they feel welcomed enough to show up and then contribute, and make it their own, and feel that they&#8217;re part of the whole thing?</p>\n\n\n\n<p>So again, it&#8217;s not a tick list of things which must be done. It&#8217;s more, well, here&#8217;s what we would like to have happen. Let&#8217;s just make it an open, welcoming space, make sure that everybody understands that it&#8217;s open and welcoming and therefore, we hope, that they will show up. I may have misrepresented that, but if I haven&#8217;t, I will be happy with myself.</p>\n\n\n\n<p>[00:37:24] <strong>Jill Binder:</strong> This is sort of my area of stuff. It&#8217;s a great question. I love this question. We&#8217;ll just make it open and welcoming and people will show up. There&#8217;s a lot of things that, we see the world through our own lens, and there&#8217;s a lot of things that we don&#8217;t think about.</p>\n\n\n\n<p>So we make it open welcoming for ourselves, and don&#8217;t think about things for other people. For example, for my first few years of participating with Meetup and WordCamp Vancouver, our events were held in an amazing space on a third floor, up three flights of really rickety stairs.</p>\n\n\n\n<p>And even me, as a mostly able bodied person still hated those stairs, and we excluded a lot of people from our community. But it was such a beautiful space, and we were getting it for free and so nobody really questioned it. When we held our first speaker workshop for underrepresented members of our community, I insisted we have to find a space with elevators.</p>\n\n\n\n<p>And then I suggested that, and then we wound up having people with wheelchairs, walkers, people who&#8217;d never come out to our events before attend that event. And then I asked if we could move all of our meetups there, and we did. So, it&#8217;s just a simple little thing that, try to make it welcoming. There&#8217;s a lot of things we don&#8217;t think about.</p>\n\n\n\n<p>People might be thinking, well, what can I do? How can I learn how to do this? Oh, well, I&#8217;m so glad to tell you there&#8217;s a workshop on Learn that you can watch. The workshop on Learn, the name of it there is, creating more diverse and inclusive WordPress spaces. I think that&#8217;s what it&#8217;s called. But also I am putting together all of my knowledge and material into one spot. And I&#8217;m going to have a link to it there. So, that along with some other articles that people should read to learn more about what can we do. It&#8217;s all going to be there, the short link is tiny.cc/wpdiversity. And that links to a page in our WordPress handbook. And so it goes through like mindset, community, spaces, allyship, et cetera. Lots of great info.</p>\n\n\n\n<p>[00:39:25] <strong>Nathan Wrigley:</strong> I guess the whole premise of, I don&#8217;t know because I don&#8217;t know, that&#8217;s what you&#8217;re tackling really, isn&#8217;t it? You are saying, well, if you don&#8217;t know, here&#8217;s how to know. Here&#8217;s a bunch of stuff that you can access. It&#8217;s all online. We know you&#8217;re in the WordPress community. Very likely you have access to a computer, so you can read these things. So here it is.</p>\n\n\n\n<p>[00:39:45] <strong>Jill Binder:</strong> Yeah, yeah.</p>\n\n\n\n<p>[00:39:46] <strong>Nathan Wrigley:</strong> That, kind of excuse, I guess, going forward of, I don&#8217;t know, because I don&#8217;t know, becomes a little bit more difficult to maintain. If you don&#8217;t know, here&#8217;s the resources, go and have a look, educate yourself in those things, and hopefully in the future, we can have a more diverse WordPress than we do currently.</p>\n\n\n\n<p>I have asked all of the things that I wish to ask. However, I&#8217;m keen to let you just take the floor. If there&#8217;s something that you wish to mention or something that I just neglected to ask.</p>\n\n\n\n<p>[00:40:16] <strong>Birgit Olzem:</strong> Yeah, I just want to add something on my mind. It&#8217;s the part of the digital accessibility. It&#8217;s also part of the diversity, equity, inclusion and belonging. Especially for people with, I don&#8217;t want to focus on that, but for instance, people who are are in a neurodivergent spectrum. Accessing information, digesting information, understand how to contribute to GitHub, for instance. It can be a barrier contributing to Slack. It&#8217;s also a barrier.</p>\n\n\n\n<p>I learned that Slack is not that accessible as it should be, for instance. But also the WordPress backend itself, complies not yet to digital accessibility. That is something we also want to think about, and also to understand that there are barriers. An able person don&#8217;t think of it, because as Jill also said, everyone has, looks through their own lens.</p>\n\n\n\n<p>That&#8217;s the aim also of this initiative, to bring all Make teams to one table. Ask question, how can we improve, and where are the blind spots we also have? Because everyone has a blind spot. Where we very not aware, be aware of what someone might be hindering someone to access the community, access the software itself.</p>\n\n\n\n<p>And, I think that is something we need to focus on. To have also this in mind. Not only the visible disabilities, for instance, like a wheelchair or someone with a cane. I&#8217;m circling a bit to events.</p>\n\n\n\n<p>Events need to be also inclusive for people with neurodivergent spectrum. Where they can find some quiet room, but also attendees who need to take some breaks in between walking distances. When I attend to a WordCamp, I need to overcome distances. I need to take sitting breaks in between, because I need to catch my breath, especially after I got COVID two years ago. It&#8217;s difficult for me to navigate through a large venue, to come from spot A to spot B, without taking a break in between. And we need to take this also into consideration when we are looking for event venues.</p>\n\n\n\n<p>My key message on it, we have a lot of good material already gathered, but it&#8217;s freckled around the community handbooks. I imagine to have a central place where we can guide and have a kind of a contributor or user journey, and a learning path. Where can willing people or contributors find the information easier? Currently, it&#8217;s all over, spread over every head book and, yeah, creating a central place to find this information.</p>\n\n\n\n<p>[00:43:15] <strong>Nathan Wrigley:</strong> Could I ask Birgit, where currently, I know you&#8217;ve just said that it&#8217;s spread all over the place, if somebody having listened to this podcast, their interest is piqued and you would have just one memorable thing, memorable place, where you would send them to a page or a contact form or whatever it may be. What would be in your mind, the quickest way to get involved and express your interest in all of this?</p>\n\n\n\n<p>[00:43:39] <strong>Birgit Olzem:</strong> As I said, it&#8217;s currently difficult to tackle this specifically because there is no central place yet.</p>\n\n\n\n<p>[00:43:46] <strong>Jill Binder:</strong> I have a suggestion of where to point people to. Birgit, I&#8217;ll ask if agree, but I think the Slack channel might be kind of a easy first.</p>\n\n\n\n<p>[00:43:57] <strong>Birgit Olzem:</strong> Yes. Yeah.</p>\n\n\n\n<p>[00:43:58] <strong>Nathan Wrigley:</strong> Okay. So that is most certainly going to be linked in the show, and I will make sure that that&#8217;s in there. I&#8217;m conscious Jill that I asked Birgit if there was anything that she wanted to say. So I&#8217;ll pass the torch to you. Did we miss anything? Was there anything that you thought we failed to discuss?</p>\n\n\n\n<p>[00:44:13] <strong>Jill Binder:</strong> Things that I will add are that I&#8217;m really excited about Birgit&#8217;s proposal and Birgit&#8217;s new group. I feel like this is something that we&#8217;ve needed for a long time. And to have somebody as passionate and driven as Birgit behind it to see it through is so amazing.</p>\n\n\n\n<p>You know, the work that I&#8217;m doing with events is just one small piece of the puzzle. One of the things that I&#8217;ve said all along is when we get more people on stage, magic things happen, like they become contributors, they help out more with the project.</p>\n\n\n\n<p>And pre pandemic we had systems in place for that to happen, and post pandemic we haven&#8217;t really had that anymore. And so Birgit&#8217;s group is going to be one of the things that is going to help with that. And her group to have diversity considered in all of our Make teams, is going to be just incredible. It&#8217;s going to be so vital for our work. And I&#8217;m so excited it&#8217;s happening. And I&#8217;m really honored that the events work, the diverse speaker training group, is going to be able to basically be a piece of this bigger picture that Birgit is putting together.</p>\n\n\n\n<p>[00:45:21] <strong>Nathan Wrigley:</strong> One of the nice things about doing this podcast is getting to meet wonderful people, doing wonderful things. And I kind of feel this is a really important, really interesting, really meaningful, impactful work. So full bravo to the pair of you, and anyone else who is in fact touching this.</p>\n\n\n\n<p>I&#8217;m sure there&#8217;s more people that we could thank, as well. And Birgit&#8217;s nodding her head. So yeah, the answer to that is yes. But, I have you two on the call. So I&#8217;m thanking you. Really amazing stuff.</p>\n\n\n\n<p>Very final question. A very brief one. If somebody wants to reach out to you personally, A, is that possible? And B, what&#8217;s your preferred method for them reaching out? I guess it could be a, an email address or a website, or a social media handle, whatever you like.</p>\n\n\n\n<p>[00:46:06] <strong>Jill Binder:</strong> Can I add, not just me, but our group as well. There&#8217;s a few links I wanted to mention for our work. So to read up more on the diverse speaker training group, as well as to get all of our resources that I am, in August right now, currently putting together before I&#8217;m away for a few months starting in September, and I want to make sure the community has all of the resources there.</p>\n\n\n\n<p>They can all be found at tiny.cc/wpdiversity. And this is going to answer things like how do you achieve more diversity inclusion at your WordCamps? And how do you actually get that diverse speaker lineup? And also being able to hold our workshops for your local communities. So holding our diverse speaker workshop, which we&#8217;ve renamed to, how to own your expertise and find a topic to speak on. As well as holding the how to create a diverse and inclusive WordPress event.</p>\n\n\n\n<p>And so that&#8217;s all at tiny.cc/wpdiversity. I also invite people to join our Slack channel, which is purely around supporting the underrepresented voices in WordPress to speak at events. Which is diverse-speaker-support. I will make sure it&#8217;s in the show notes.</p>\n\n\n\n<p>And also to mention that the first part of my break is not an entire break. I&#8217;m still holding two big events, speaker workshop for women in India is happening September, the weekend of September 23rd, Saturday and Sunday morning in India time.</p>\n\n\n\n<p>And also a women, both of them are for WordPress, a women in WordPress Speaker Workshop, for Latin America that we&#8217;re holding in San Jose, Costa Rica, in person. Except that I&#8217;m unable to travel myself, so my head on a giant screen. It&#8217;s worked out very well when we&#8217;ve done this previously, along with a Spanish translator, and that&#8217;s happening November 11th in person for everyone but me.</p>\n\n\n\n<p>And to reach me, I won&#8217;t really be available from September to December of this year, but I would love if people go ahead and follow me on social media, and I might post some of my adventures from my break. And of course, more diversity knowledge when I come back, and maybe some things while I&#8217;m on break too if I want to put things out into the world. On Twitter, LinkedIn and Mastodon.social, I am Jill Binder on all three.</p>\n\n\n\n<p>[00:48:22] <strong>Nathan Wrigley:</strong> Thank you very much. And Birgit.</p>\n\n\n\n<p>[00:48:25] <strong>Birgit Olzem:</strong> Yeah. Thank you. And I&#8217;m kind of a sad little face for Jill leaving us for a sabbatical. But I&#8217;m also very grateful that Jill has opportunity to take a break after a long, long work in the WordPress project. And I&#8217;m very thankful for the groundwork you did already. Yeah, thank you.</p>\n\n\n\n<p>When someone wants to reach me, I&#8217;m always with my handle coachbirgit on all socials. Also on my personal website coachbirgit.com. And I&#8217;m really inviting everyone to join our Slack channel to discuss and contribute to the initiative on, dib-working-group on a Making WordPress Slack account.</p>\n\n\n\n<p>[00:49:10] <strong>Nathan Wrigley:</strong> Jill Binder, Birgit Olzem, thank you so much for chatting to me on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:49:17] <strong>Jill Binder:</strong> Thank you.</p>\n\n\n\n<p>[00:49:18] <strong>Birgit Olzem:</strong> Thank you. Bye.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/coachbirgit\">Birgit Olzem</a> and <a href=\"https://twitter.com/jillbinder\">Jill Binder</a>.</p>\n\n\n\n<p>Birgit Olzem is a WordPress enthusiast who juggles diverse roles and advocates for mental health awareness, diversity, and unsung contributors. A proud mother and grandmother, she also consults on personal branding and explores surface pattern design. Birgit champions the WordPress community, as you’ll hear, in many ways.</p>\n\n\n\n<p>Jill Binder is the Founder and CEO of Diverse in Tech. She leads the Diverse Speaker Training Group in the WordPress.org Community Team, which encourages people from underrepresented groups to speak at WordPress events. She helped organise the first BuddyCamp, and for three years co-organised WordCamp Vancouver.</p>\n\n\n\n<p>Jill and Birgit join me today to discuss the importance of diversity, equity, inclusion, and belonging (DEIB for short) within the WordPress community.</p>\n\n\n\n<p>They share valuable insights regarding their efforts to create a more global and inclusive WordPress ecosystem. This includes the formation of a new working group on the Make WordPress Slack account and the use of GitHub project boards to track tasks and ideas.</p>\n\n\n\n<p>We talk about the need for unity within the community, the significance of diverse perspectives, and the importance of effective communication.</p>\n\n\n\n<p>We also get into Jill&#8217;s experience organising a training program for the Vancouver Meetup, emphasising the importance of understanding the specific needs of different communities.</p>\n\n\n\n<p>We explore the concept of sustainability within the WordPress community, addressing the financial support and resources necessary to retain and support active contributors.</p>\n\n\n\n<p>Throughout the episode both Jill and Birgit stress the importance of inclusivity, creating a welcoming environment, and providing opportunities for underrepresented voices to participate and contribute.</p>\n\n\n\n<p>If you’ve been wanting to know more about how to make the WordPress community more diverse and welcoming, this episode is for you.</p>\n\n\n\n<p>In some places the audio is a little choppy, so apologies for that, but it really is more than listenable.</p>\n\n\n\n<h2 class=\"wp-block-heading\">5 key messages mentioned in the podcast.</h2>\n\n\n\n<ol>\n<li><strong>Diversity is Strength:</strong>&nbsp;Emphasize that diversity isn’t just a buzzword; it’s the backbone of innovation and progress, especially in collaborative spaces like the WordPress community.</li>\n\n\n\n<li><strong>Inclusion Means Everyone:</strong>&nbsp;Clarify that DEIB efforts aren’t about favoring some over others, but ensuring everyone has equal opportunity and feels welcomed.</li>\n\n\n\n<li><strong>Unified Efforts, Bigger Impact:</strong>&nbsp;Talk about the importance of consolidating individual initiatives for a broader, more cohesive impact on the WordPress ecosystem.</li>\n\n\n\n<li><strong>Shared Responsibility:</strong>&nbsp;It’s not just up to a single group or team to promote DEIB; it’s a collective responsibility of the entire community.</li>\n\n\n\n<li><strong>Call to Action:</strong>&nbsp;Everyone can and should play a role in fostering DEIB in the WordPress community. Get involved, offer support, and be part of the change.</li>\n</ol>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links provided by Birgit and Jill.</h2>\n\n\n\n<ul>\n<li>Diversity, Equity and Inclusion Statement: <a href=\"https://make.wordpress.org/handbook/diversity-equity-and-inclusion-in-wordpress/\">https://make.wordpress.org/handbook/diversity-equity-and-inclusion-in-wordpress/</a></li>\n\n\n\n<li>DEIB team proposal: <a href=\"https://make.wordpress.org/project/2023/07/13/proposal-for-establishing-a-make-diversity-equity-inclusion-and-belonging-deib-team-within-the-wordpress-community/\">https://make.wordpress.org/project/2023/07/13/proposal-for-establishing-a-make-diversity-equity-inclusion-and-belonging-deib-team-within-the-wordpress-community/</a></li>\n\n\n\n<li>Quicklink to the Diverse Speaker Training Group (#WPDiversity) <a href=\"https://tiny.cc/wpdiversity\">https://tiny.cc/wpdiversity</a></li>\n\n\n\n<li>For tasks of the working-group: <a href=\"https://github.com/WordPress/DEIB-Issue-Tracker/issues\">DEIB-Issue-Tracker</a> and the <a href=\"https://github.com/orgs/WordPress/projects/131\">related project board</a></li>\n\n\n\n<li>Slack channel for the DEIB working group: <a href=\"https://wordpress.slack.com/archives/C05ND1KPW0Y\">#deib-working-group</a></li>\n\n\n\n<li>Slack channel to support underrepresented speakers in WP: <a href=\"https://wordpress.slack.com/archives/C028SE81N3H\">#diverse-speaker-support</a></li>\n\n\n\n<li>WP Briefing Podcast: <a href=\"https://wordpress.org/news/2021/07/episode-13-cherishing-wordpress-diversity/\">Episode 13: Cherishing WordPress Diversity</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Other links mentioned in the podcast.</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/project/2023/05/17/wordpress-contributor-mentorship-program-pilot-program-proposal/\">Contributor Mentorship Program</a></p>\n\n\n\n<p><a href=\"https://germany.wordcamp.org/2023/\">WordCamp Germany</a></p>\n\n\n\n<p><a href=\"https://vancouver.wordcamp.org/2023/\">WordCamp Vancouver</a></p>\n\n\n\n<p><a href=\"https://diversein.tech/\">Diverse in Tech website</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/community/2021/10/19/tuesday-training-why-is-diversity-important-to-wordpress-and-your-local-community/\">Why is diversity important — To WordPress and YOUR local community?</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/summit/\">WordPress Community Summit</a></p>\n\n\n\n<p><a href=\"https://twitter.com/jillbinder\">Jill&#8217;s Twitter</a></p>\n\n\n\n<p><a href=\"https://twitter.com/coachbirgit\">Birgit&#8217;s Twitter</a></p>\n\n\n\n<p><a href=\"https://coachbirgit.com/\">Birgit&#8217;s website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Oct 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: State of the Woo 2023: WooCommerce Highlights AI-Powered Future and Continued Core Blockification\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150044\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://wptavern.com/state-of-the-woo-2023-woocommerce-highlights-ai-powered-future-and-continued-core-blockification\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5792:\"<p><a href=\"https://woosesh.com/\">WooSesh 2023</a>, the virtual conference for WooCommerce store builders, kicked off today with the State of the Woo address. This year’s theme is “Next Generation Commerce,&#8221; featuring advances across the e-commerce industry, as well as WooCommerce core and the wider ecosystem of tools and payment integrations. </p>\n\n\n\n<p>WooCommerce CEO Paul Maiorana began the presentation with a few stats on Woo&#8217;s growth in 2023:</p>\n\n\n\n<ul>\n<li>4.4M+ live websites currently using WooCommerce (<a href=\"https://storeleads.app/\">StoreLeads.app</a> Woo usage)</li>\n\n\n\n<li>33% of the top 1 million online store are powered by Woo </li>\n\n\n\n<li>8.9% of the internet is powered by Woo (<a href=\"https://w3techs.com/technologies/details/cm-woocommerce\">W3Techs</a>)</li>\n\n\n\n<li>270M+ Woo downloads to date (WooCommerce internal data)</li>\n\n\n\n<li>908 products in the Marketplace</li>\n\n\n\n<li>66 languages supported</li>\n</ul>\n\n\n\n<p>Maiorana highlighted a few e-commerce trends the company is watching, including the expansion of chatbots, on-site search, and AR. WooCommerce is seeing more merchants attracting non-local buyers through cross-boarder selling strategies, with high-growth stores focused on expanding across countries, languages, channels, and payment methods. Maiorana said customers are now expecting seamless experiences across devices and store must be fast, smooth, and intuitive from screen to screen.</p>\n\n\n\n<p>Maiorana also shared insights from <a href=\"https://woocommerce.com/partner-program/\">WooExperts</a>, officially endorsed WooCommerce agencies, who are seeing an increase in merchants embracing multi-channel selling, diversified payment options, and immersive buying experience that leverage AI, AR, virtual try-ons, and 3D images.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2100\" height=\"1178\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-10-at-12.13.52-PM.png\" alt=\"\" class=\"wp-image-150047\" />\n\n\n\n<p>The State of the Woo featured several milestones WooCommerce logged this year. WooCommerce Payments is now available in 38 countries. WooPay, the gateway&#8217;s opt-in single-click cross-site checkout experience, is out of beta. WooCommerce has also continued expanding its payment integrations covering more geographies and localized payment methods. The company recently launched <a href=\"https://woocommerce.com/products/tiktok-for-woocommerce/\">TikTok for WooCommerce</a> as a new integration to help merchants improve conversion by selling directly via TikTok Shop.</p>\n\n\n\n<p>WooExperts onboarded 88 new agencies, who are ambassadors for Woo, building enterprise projects at scale. They are also invited to collaborate with WooCommerce on technical planning.</p>\n\n\n\n<p>WooCommerce core has crossed several important milestones in 2023, including making High-Performance Order Storage (HPOS), more commonly known as custom order tables, the default on <a href=\"https://developer.woocommerce.com/2023/10/10/woocommerce-8-2-0-released/\">version 8.2</a>. This major overhaul delivers significant performance gains and makes databases more scalable.</p>\n\n\n\n<p>The full blockification of WooCommerce core is on the way <a href=\"https://developer.woocommerce.com/roadmap/block-based-product-creation-experience/\">a new product management experience using the Blocks API</a>. It was auto-enabled for a subset of new stores in 7.9, released in July, and will be enabled for more stores as soon as WooCommerce adds variable product management support.</p>\n\n\n\n<p>Block-based order confirmation is next on the roadmap, and block-based cart and checkout will soon be the default, as WooCommerce is working closely with partners to increase extension support.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Woo Express: More AI-Powered Features Coming Soon</h3>\n\n\n\n<img width=\"2440\" height=\"1242\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-10-at-12.32.27-PM.png\" alt=\"\" class=\"wp-image-150061\" />\n\n\n\n<p>During today&#8217;s WooSesh keynote, WooCommerce also highlighted a few milestones for Woo Express, the all-in-one WooCommerce plan hosted on WordPress.com. The product launched in 2023 as &#8220;Woo&#8217;s biggest bet ever.&#8221; It kicked off in September 2022, launched free trials in April 2023, and had 1,000 paying customers as of July 2023.</p>\n\n\n\n<p>The team demonstrated the new onboarding flow and store personalization experience. Woo Express&#8217; current priorities are making store setup easier with an AI-driven assistant to guide merchants through setup and growing stores, along with offering smart recommendations to drive more revenue, based on store analytics. The product defaults to a block-based theme, cart, and checkout. It includes the Woo AI plugin for early feedback.</p>\n\n\n\n<p>Woo Express is currently only available on WordPress.com, but WooCommerce representatives said what its features will also be surfaced in Woo core. The product is being used as a proving ground for the next phases of product development.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2056\" height=\"1132\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-10-at-12.31.30-PM.png\" alt=\"\" class=\"wp-image-150059\" />\n\n\n\n<p><a href=\"https://woosesh.com/\">WooSesh</a> will be live again tomorrow with more sessions on using AI tools for support, creating effective landing pages, using Amazon Pay, shipping trends, case studies, and more. Registration is free but the sessions must be viewed live. The sessions will be recorded and published to <a href=\"https://wpsessions.com/?utm_source=WooSesh\">WPSessions</a> after the live event has ended, available with a subscription.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Oct 2023 03:39:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 6.4 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7126:\"<p>WordPress 6.4 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 3 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.4-beta3</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\"><strong>underrepresented gender release squad</strong></a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> for details.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Your help testing WordPress 6.4 Beta 3 is key to ensuring its quality. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 3</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Update on the Font Library</h2>\n\n\n\n<p><strong>The Font Library feature, initially planned for WordPress 6.4, is now set to release in 6.5</strong>. WordPress is committed to delivering the best possible experience. This decision allows time to address enhancement opportunities, <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">test</a>, and get enough feedback to meet WordPress&#8217;s quality standards. Thanks for your support as contributors work towards an exceptional Font Library experience.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 3 contains more than 60 updates since the Beta 2 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F04%2F2023..10%2F10%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">29 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F04%2F2023..10%2F10%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">Closed Trac tickets since Beta 2</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p>Beta 3 arrives<br />Testing where progress derives<br />Iterate, it thrives</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: </em><a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a> and <a href=\"https://profiles.wordpress.org/michelleames/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michelleames</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 16:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: Breaking Down YMIR and a Lot of Other Things in Carl Alexander’s Mind\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76836\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/breaking-down-ymir-and-a-lot-of-other-things-in-carl-alexanders-mind/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:457:\"<p>When you dive deep into Carl\'s mind to learn more about what he built for WordPress, the end result is today\'s show.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/breaking-down-ymir-and-a-lot-of-other-things-in-carl-alexanders-mind/\">Breaking Down YMIR and a Lot of Other Things in Carl Alexander&#8217;s Mind</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 11:15:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WordPress Reverts Live Preview Button on Plugins After Developer Backlash\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/wordpress-reverts-live-preview-button-on-plugins-after-developer-backlash\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7858:\"<img width=\"2036\" height=\"1438\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screenshot-2023-09-15-at-6.29.19-pm.png\" alt=\"\" class=\"wp-image-150011\" />\n\n\n\n<p>Last week WordPress meta contributors <a href=\"https://meta.trac.wordpress.org/changeset/12931\">implemented a &#8220;Live Preview&#8221; button</a> for plugins in the official directory, with the intention of allowing users to safely test any plugin in one click. The button went live across all of WordPress.org&#8217;s 59,000+ plugins but took plugin developers by surprise as it was pushed through without any communication or input from stakeholders. </p>\n\n\n\n<p>The implementation was premature and failed to take into consideration the many different types of plugins that appear to be broken due to inadequate support in the Playground testing environment. </p>\n\n\n\n<p>Five weeks ago, Automattic-sponsored Meta team contributor Steve Dufresne <a href=\"https://meta.trac.wordpress.org/timeline?from=2023-09-07T00%3A29%3A45Z&precision=second\">commented</a> on the ticket, &#8220;Adding that it&#8217;s likely still the case (someone else can confirm), not all plugins work in the Playground so we should build in an opt-out mechanism.&#8221;</p>\n\n\n\n<p>This suggestion was roundly ignored by other participants on the ticket and the Playground previews went live. It became immediately apparent that this was done without thorough testing as many plugin authors reported the previews created an unfavorable, broken experience for users. </p>\n\n\n\n<p>&#8220;Who decided to release Preview without posting on <a href=\"https://make.wordpress.org/plugins/\">make.wordpress.org/plugins/</a> with some advanced warning to plugin devs?&#8221; WordPress developer Alan Fuller asked, starting a <a href=\"https://wordpress.slack.com/archives/C02QB8GMM/p1696523391533419\">discussion</a> in the #meta Slack channel. &#8220;Was that a #meta decision? Can it be reverted and due notice given?&#8221;</p>\n\n\n\n<p>Retired Plugins team rep Mika Epstein identified three major use cases that were missed, which she estimates will impact 30-40% of plugins not working in the Playground environment: </p>\n\n\n\n<ol>\n<li>It won’t work for add-on plugins (ie. anything for Woo) because we have no way to identify plugin dependancies, and the sandbox won’t know to install the ‘parent’ plugin</li>\n\n\n\n<li>It won’t work (well) for anything that requires a lot of customization (WooCommerce itself)</li>\n\n\n\n<li>It won’t work AT ALL for anything that’s a server integration (Memcached, Redis, etc).</li>\n\n\n\n<li>Multisite</li>\n</ol>\n\n\n\n<p>Participants noted that DEBUG is also set to True, allowing unrelated warnings and notices to be displayed to the visitor.</p>\n\n\n\n<p>&#8220;It stinks to work really hard on a plugin and then have some preview show up that makes it look totally broken when it&#8217;s not,&#8221; WordPress developer Ben Sibley said.</p>\n\n\n\n<p>&#8220;This feature is a neat idea, but it needs a lot more work. We&#8217;ve gone decades without live previews; why was there suddenly a rush to launch this today when it&#8217;s demonstrably unreliable?</p>\n\n\n\n<p>&#8220;As others have stated, this should be rolled back immediately and switched to an opt-in feature. Once it&#8217;s rolled back, work on giving plugin devs information about how the preview works so we can decide if it&#8217;s right for us or not. There is no rush to release this without proper communication and testing!&#8221;</p>\n\n\n\n<p>Newsletter Glue co-founder Lesley Sim requested the feature be opt-in, contending that the average user won&#8217;t have patience if something appears broken and will assume there is a problem with the plugin, not the directory or the playground.</p>\n\n\n\n<p>&#8220;So it ends up reflecting badly on the plugin developer, which can be really stressful for them if it means a loss in (potential) revenue/installs (yes, I understand that many people think this shouldn&#8217;t be a key concern, but it is the reality for many small plugin devs) or if they have additional support burden as a result of this feature, which is completely out of their hands,&#8221; Sim said.</p>\n\n\n\n<p>After others echoed these concerns, Automattic-sponsored contributor Alex Shiels, who implemented the feature, <a href=\"https://meta.trac.wordpress.org/timeline?from=2023-10-06T02%3A26%3A06Z&precision=second\">said</a> he didn&#8217;t expect it would be controversial and <a href=\"https://wordpress.slack.com/archives/C02QB8GMM/p1696571100525509?thread_ts=1696523391.533419&cid=C02QB8GMM\">said</a> he was &#8220;over-optimistic about how smoothly it would work.&#8221; He deployed a commit that <a href=\"https://meta.trac.wordpress.org/changeset/12933\">added an opt-out toggle</a> so plugin committers could disable the Live Preview button.</p>\n\n\n\n<p>&#8220;The reason I didn’t communicate prior to deploy is, there was discussion on the ticket for a month prior; and because Playground has been live for several months now,&#8221; Shiels said. &#8220;Every published plugin in the directory has already been available for running in the Playground since well before this ticket. All I did was make it easy to get there with a single click. Apologies for catching you all off-guard.&#8221;</p>\n\n\n\n<p>Others requested WordPress.org implement a customizable Demo link url in the readme file, instead of turning Playground previews on for all plugins, along with many more suggestions for making the environment better for showcasing  plugins.</p>\n\n\n\n<p>After continued pushback urging Shiels to make the feature opt-in instead of opt-out, he <a href=\"https://meta.trac.wordpress.org/changeset/12934\">removed the button</a> on Friday, October 6. </p>\n\n\n\n<p>&#8220;I do want to emphasize that a lot of the worry and concern wasn’t about the fact that a plugin was broken in Playground,&#8221; plugin developer Aurooba Ahmed said. &#8220;Most of us know if our plugin works in playground or not, it was that a very apparent feature was pushed to the plugin repo that affects how users evaluate plugins, without discussion and feedback from enough of the key stakeholder audiences.</p>\n\n\n\n<p>&#8220;I look forward to seeing how the feature is iterated upon (because ultimately it’s a fantastic concept) so that it can be useful in all the right ways for all stakeholders.&#8221;</p>\n\n\n\n<p>In the meantime, users who enjoy having quick access to Playground may want to check out the Chrome browser extension created by LUBUS, a development agency. It <a href=\"https://wptavern.com/new-chrome-browser-extension-enables-one-click-plugin-and-theme-testing-with-wordpress-playground\">adds a Playground” button to theme and plugin pages</a> on WordPress.org so users can test drive extensions with one click.</p>\n\n\n\n<p>When adding the opt-out toggle, Shiels commented on the ticket that plugins broken in Playground were broken before the ticket was opened and will remain that way even if the plugin does not opt into the Live Preview button.</p>\n\n\n\n<p>&#8220;I know the Playground team is hard at work on addressing bugs and compatibility issues there,&#8221; Shiels said. &#8220;And I intend to further improve the Live Preview support in the plugin directory to make things better for users and plugin developers alike. Many of your concerns can be addressed using <a href=\"https://wordpress.github.io/wordpress-playground/blueprints-api/index\">Blueprints</a> which will allow configuring and installing dependencies, importing demo content, and other neat things. I&#8217;ll work on making Blueprint support available as soon as I&#8217;ve confirmed some engineering details with the Playground team.&#8221;</p>\n\n\n\n<p>There is more work to be done before this feature is ready for rollout. The live preview button is currently disabled while contributors iron out compatibility issues.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 03:18:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"Gutenberg Times: Font Library punted, WordPress 6.4 sneak peek, Design tools for Artists, create block package, and so much more – Weekend Edition 271\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=25863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:155:\"https://gutenbergtimes.com/font-library-punted-wordpress-6-4-sneak-peek-design-tools-for-artists-create-block-package-and-so-much-more-weekend-edition-271/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17557:\"<p>Howdy, </p>\n\n\n\n<p>Seems Summer break is over for many developers, designers, and site builders, and they came back inspired to write and share their learning with the rest of the community.  There is a ton of material in today&#8217;s weekend edition for every level of WordPress users. Dig in.  And if you still us browser bookmarks bookmark it. </p>\n\n\n\n<p>Have a wonderful weekend!!</p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\"><strong>WordPress 6.4 Beta</strong> <strong>2</strong></a> was released this week, and again, two calls for testing will help you familiarize yourself with new features, and also help the underrepresented gender release squad to make it the best version it could be. </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">Help Test the Font Library</a> (for 6.5)</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Help Test WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\">FSE Program Testing Call #26: Final touches</a></li>\n</ul>\n\n\n\n<p>Before everyone headed into the weekend, core contributors and release squad discussed the state of the Font Library and concluded, in the words of Tonya Mork, core tech lead 6.4, &#8220;The feature is not ready yet.&#8221; and &#8220;It needs more time. &#8221; Release lead, Josepha Haden Chomphosy, decided to punt the Font Management feature to WordPress 6.5. </p>\n\n\n\n<p><strong>Sarah Gooding </strong>at the WPTavern has the details for you: <a href=\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\"><strong>WordPress 6.4 Font Library Feature Punted to 6.5 Release</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Listening to the <a href=\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>WP Briefing: Episode 63: A WordPress 6.4 Sneak Peek</strong></a> you can join WordPress Executive Director, <strong>Josepha Haden Chomphosy</strong>, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest <strong>Sarah Norris</strong>, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<p>Reminder: <strong>Nick Diego, Justin Tadlock</strong> and <strong>Ryan Welcher</strong> invite you to their <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296105065/\"><strong>Hallway Hangout: What&#8217;s new for developers in WordPress 6.4</strong></a> on October 12th, 2023 at 18:00 UTC. They will cover, among other things, Block Hooks and the Default theme Twenty-Twenty-Four. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</a> with Tammie Lister as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<p><strong>Anne McCarthy</strong> invites you to join her for a <a href=\"https://make.wordpress.org/core/2023/10/02/hallway-hangout-working-session-consolidating-modes/\"><strong>Hallway Hangout: Working session on consolidating various navigation modes</strong></a> on November 15, 2023, at 15:00 UTC. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Vicente Canales</strong> is released <strong><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v16.8.0-rc.1\">16.8 RC1 is available for testing</a>.</strong> Mainly the release contains fixes and improvements that were necessary after WordPress 6.4 beta testing. Out of 160 PRs, <a href=\"https://github.com/WordPress/gutenberg/pulls?page=2&q=is%3Apr+milestone%3A%22Gutenberg+16.8%22+is%3Aclosed+I+just+cherry-picked+this+PR\">49 were back ported</a> to the WordPress 6.4 Beta branches.  many bug fixes that came from WordPress 6.4 Beta testing or improved code quality. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In the 10-minute tutorial, <a href=\"https://learn.wordpress.org/tutorial/templates/\"><strong>Using Page Templates</strong></a>, <strong>Wes Theron</strong> teaches you what templates are, how you can expand them to create full-page layouts with header, sidebar, and footer areas. You will learn how to use, edit and add templates to customize your site by giving your posts and pages their own unique look and feel.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Gooding</strong> researched <a href=\"https://wptavern.com/why-nasa-chose-wordpress-for-revamping-its-flagship-website\"><strong>Why NASA Chose WordPress for Revamping Its Flagship Website </strong></a> and identified 3 major reasons: Ample access to resources, a a plugin ecosystem around real time content analysis, and, as expected, ease of use of the content authoring environment. &#8220;The block editor’s flexibility for authoring landing pages and breaking free of a rigid templating system was one of the most important factors in NASA’s selection of WordPress as a CMS.&#8221; she wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In their post <a href=\"https://block-museum.com/2023/10/03/get-creative-with-wordpress-6-4s-design-tools/\"><strong>Get Creative with WordPress 6.4’s Design Tools</strong></a>, <strong>Anne McCarthy</strong> summarized the upcoming changes to Design Tools for artists who would like to submit new Block patterns to the Block Museum of Art. The new Font Library vertical text orientation, and background image for Group block enrich the block artist&#8217;s toolbox, together with the core blocks enhance support for more design tools. Of those, the stretch alignment for column blocks is probably the most interesting one. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://www.youtube.com/@TylerMoore/\"><strong>Tyler Moore</strong></a>, WordPress YouTuber with 450+K Subscribers , published his first Block Theme in the WordPress repository. Meet <strong><a href=\"https://wordpress.org/themes/variations/\">Variations</a> &#8211;</strong> &#8220;a block theme and hopefully the last theme you will even have to install. It comes with many templates and block patterns to make creating a website easy.&#8221; he wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his video, <strong><a href=\"https://www.youtube.com/watch?v=OZW8wREJT6A\">WordPress Block Themes are amazing</a>,</strong> <strong>Jamie Marsland</strong> showed how to create custom post layouts, custom post archives, and display custom fields using Block Themes  (oh and snazzy CSS Grids with the query loop block),as he announced in <a href=\"https://twitter.com/pootlepress/status/1709832407338135553\">his tweet.</a> </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister</strong> reported <a href=\"https://olliewp.com/the-ollie-block-theme-is-now-available-on-wordpress-org/\"><strong>the Ollie block theme is now available on WordPress.org!</strong></a> It sports 50 beautiful pattern designs, 7 full-page pattern layouts,&nbsp;and a fully customizable design system with Global Styles. <a href=\"https://wordpress.org/themes/ollie/\">Download Ollie here</a></p>\n\n\n\n<p><strong>Sarah Gooding</strong> at the WPTavern, accompanied McAllister on his contributor odyssey to get his theme approved. She wrote several articles (<a href=\"https://wptavern.com/ollie-theme-previews-new-onboarding-wizard-in-development\">here</a>, <a href=\"https://wptavern.com/contentious-review-process-leads-ollie-theme-to-remove-innovative-onboarding-features-amid-stagnating-block-theme-adoption\">here</a>, <a href=\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\">here</a> and <a href=\"https://wptavern.com/ollie-theme-now-available-on-wordpress-org\">here</a>) to give context and background with comments from the wider community. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On <strong>October 17, 2023, at 20:00 UTC</strong>, <strong>Wes Theron</strong> will host an online live tutorial on <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296575670/\"><strong>Using the Query Loop block and Category templates</strong></a>. This will cover the heart of a website that is how to display archive pages and category summary pages. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://memberpress.com/blog/author/syble/\">Syble Harrison</a> </strong>celebrates the release of MemberPress version 1.11.7. It comes with&nbsp;<a href=\"https://memberpress.com/blog/gutenberg-membership-blocks/\"><strong>Gutenberg Membership Blocks</strong></a>&nbsp;and all MemberPress widgets now also work as Gutenberg membership blocks. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>Let <strong>Ganesh Dahal </strong>take you on a journey <strong><a href=\"https://www.smashingmagazine.com/2023/09/exploring-enhanced-patterns-system-wordpress/\">Exploring Enhanced Patterns In WordPress 6.3</a></strong> on Smashing Magazine.  Synched patterns (former <em>Reusable blocks)</em> and block patterns give users &#8220;the ability to&nbsp;write content once and synch it&nbsp;across pages and posts and modular components to&nbsp;enforce a consistent visual experience&nbsp;throughout a site.&#8221; Dahal wrote. Don&#8217;t forget to replace &#8220;reusable blocks&#8221; with &#8220;synched patterns&#8221;. One of the curses of a fast-moving development project. Features names sometimes change. </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<p><strong><a href=\"https://johannes-wp.com/\">Johannes</a></strong> is a wireframe and UX kit that wants to help you with your  next WordPress design project. Built by the WordPress VIP partner <a href=\"https://twitter.com/be_api\"><strong>Be API </strong></a>in France, the tool consists of a library of ready-to-use components in Figma, Hero and other samples templates, styles, and pattern variations. Johannes uses Figma features, including components, auto-layout and variants.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In <strong><a href=\"https://href.li/?https://www.youtube.com/watch?v=TtmdYbHKDL0\">Developer Hours: Building better blocks with the create-block package</a>,</strong> <strong>Nick Diego </strong>and <strong>Ryan Welcher</strong> covered the official scaffolding tool for custom block development. Besides the fundamentals, participants learned about other features such as external project templates and variants for dynamic blocks or blocks using the interactivity API.&nbsp;</p>\n\n\n\n<p>If you&#8217;d like to participate in a live online tutorial, <strong>Jonathan Bossenger</strong> will hold a session on the same topic on October 12th, 2023 at 14:00 UTC. You can RSVP on Meetup.com <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296580191/\"><strong>The WordPress Create Block tool</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Gabriel Rose</strong>, developer at 10up, created the Microsoft VS Code extension: <a href=\"https://marketplace.visualstudio.com/items?itemName=GabrielRose.wordpress-theme-json-css-autosuggest\"><strong>WordPress theme.json CSS Autosuggest</strong></a> that provides autocomplete for your WordPress theme.json tokens in your CSS.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mark Wilkinson</strong> of Highrise Digital and co-host of the <em><a href=\"https://wpcafe.show/\">WP Café podcast</a></em>, shared his approach and code to make the <a href=\"https://markwilkinson.dev/code-snippets/wordpress-search-block-to-only-search-in-a-custom-post-type/\"><strong>WordPress search block to only search in a custom post type</strong></a>. Once implemented, users can use patterns to add the feature to their site.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ronald Huereca</strong> wrote a tutorial on <a href=\"https://dlxplugins.com/tutorials/how-to-create-a-permanent-unique-id-for-your-wordpress-block/\"><strong>How to Create a Permanent Unique ID for Your WordPress Block</strong></a>. Maybe that&#8217;s something you were always wondering about. The tutorial is reach on  code examples and gives you step-by-step instructions to follow along. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Next in his series <em>Block Developer Cook Book recipes</em>, <strong>Ryan Welcher</strong> tackles the <a href=\"https://www.youtube.com/watch?v=asCNlHxtemE\"><strong>Formats API</strong></a> in his latest video. &#8220;Uncover the secrets of the Format API to flavor your text, just like a master chef creates unique sauces.&#8221; her wrote in the description. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: Hawa Mahal, Jaipur, Rajasthan by Bigul Malayi</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Oct 2023 11:21:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Ollie Theme Now Available on WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149955\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/ollie-theme-now-available-on-wordpress-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4011:\"<p>The free <a href=\"https://olliewp.com/\">Ollie block theme</a>, created by Mike McAlister and Patrick Posner, is now available for <a href=\"https://wordpress.org/themes/ollie/\">download on WordPress.org</a>. A <a href=\"https://wptavern.com/contentious-review-process-leads-ollie-theme-to-remove-innovative-onboarding-features-amid-stagnating-block-theme-adoption\">contentious review process</a> led the team to remove the onboarding features, despite having gotten the green light from WordPress&#8217; leadership who advocated for moving forward with the experiment. The version of Ollie available on WordPress.org is simply the theme without the guided onboarding experience that reduces the amount of time it takes to get through the first 30-40 minutes of setting up the theme.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1144\" height=\"858\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/ollie-wporg.webp\" alt=\"\" class=\"wp-image-149959\" />\n\n\n\n<p>McAlister explained why the team reached this surprising decision in a 10-minute <a href=\"https://twitter.com/mikemcalister/status/1708929134490005759\">video</a> earlier this week, as well as in the theme&#8217;s launch <a href=\"https://wordpress.org/themes/ollie/\">post</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>In a surprising twist of events, WordPress leadership actually <em>wanted</em> to give it a shot as an experiment! While it was awesome to see that kind of support, by this point it had become clear that it was too controversial to try this right now.</p>\n\n\n\n<p>There were valid concerns that without a system or understanding in place at the directory level, this could set a precedent with unknown outcomes and potentially burden volunteers with longer theme review queues. We don’t want that, and the idea that a feature of Ollie would burden anyone is <em>the antithesis</em> of our aim of helping users through this exciting era of modern WordPress.</p>\n</blockquote>\n\n\n\n<p>Ollie&#8217;s creators are working on putting the onboarding into a plugin in order to &#8220;deliver our original vision, free of constraints.&#8221; It will be available on GitHub and they <a href=\"https://twitter.com/mikemcalister/status/1710050878042821071?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1710050878042821071%7Ctwgr%5Eb107394162dfda43307002c16128506f013147ff%7Ctwcon%5Es1_&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-admin%2Fpost.php%3Fpost%3D149955action%3Dedit\">plan to submit it to WordPress.org</a>, but the severe backlog may prevent it from being live in the directory for a few months.</p>\n\n\n\n<p>The theme on WordPress.org has more hurdles to getting started with a new website. Users will need to know how to navigate the Site Editor to edit templates and place patterns. After installing the theme, it&#8217;s painfully clear how much simpler the onboarding wizard would make everything. Ollie comes with seven full-page pattern layouts, which helps if you want to build a site similar to the demo. It also packages seven style variations and an astonishing 50 custom block patterns for building nearly any kind of website.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2842\" height=\"1296\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-06-at-9.22.42-PM.png\" alt=\"\" class=\"wp-image-149968\" />\n\n\n\n<p>With different combinations of patterns, Ollie is suitable for personal websites, agencies, portfolios, nonprofit organizations, blogs, and businesses of various kinds. Although this version doesn&#8217;t deliver on the &#8220;40-hour head start&#8221; that the onboarding offers, it&#8217;s still a very well designed theme with meticulous attention to detail and an abundance of customizable patterns.</p>\n\n\n\n<p>Check out the <a href=\"https://demo.olliewp.com/\">Ollie demo</a> to see the theme in action and <a href=\"https://wordpress.org/themes/ollie/\">install/download it from WordPress.org</a> to take it for a test drive.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Oct 2023 03:00:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Why NASA Chose WordPress for Revamping Its Flagship Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/why-nasa-chose-wordpress-for-revamping-its-flagship-website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7984:\"<img width=\"2836\" height=\"1306\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-06-at-3.48.43-PM.png\" alt=\"\" class=\"wp-image-149947\" />\n\n\n\n<p>NASA has removed the beta label from the new <a href=\"https://t.co/EnLX4Rmld4\" target=\"_blank\" rel=\"noreferrer noopener\">nasa.gov</a> website, which was launched on WordPress, replacing Drupal as the CMS. After a lengthy process, which required 18 months of active web development, data migration, and content building, NASA has emerged with modernized flagship and science websites, showcasing the innovation and discoveries that have defined the agency for more than 65 years.</p>\n\n\n\n<p>The multi-million dollar project began a few years ago when a combination of the IDEA Act and Drupal 7 EOL provided an opportunity for NASA to reconsider the CMS they were using for nasa.gov. <a href=\"https://lonerockpoint.com/\">Lone Rock Point</a>, a WordPress.com VIP Gold Agency Partner, led the project, which began with  a year of UX design and an evaluation of various enterprise CMS&#8217;s that would ultimately end up supporting 456 CMS users, 68,698 migrated pages, and 3,023 new landing pages. As part of the project, NASA&#8217;s website infrastructure was migrated from an Amazon Web Services environment to WordPress.com VIP.</p>\n\n\n\n<p>&#8220;In earlier discovery phases of the project, content authors were were vocal that they were interested in a CMS that allowed them to break free of templates that were perceived to be rigid,&#8221; Lone Rock Point President J.J. Toothman said. &#8220;The block based authoring approach of Gutenberg is delivering on that and user testing showed that WordPress could provide that. Now that the site is live, the different types of landing pages being created with block based approach further validates that.&#8221;</p>\n\n\n\n<p>NASA evaluated both proprietary and open source solutions, and Toothman said they took a high level look at over a hundred CMS platforms. They narrowed it down to four CMS&#8217;s &#8211; two were commercial and two were open source (WordPress and Drupal). The team completed high level prototyping and user evaluation on all four of the finalists, and used this data in the CMS selection process.</p>\n\n\n\n<p>Toothman outlined a few of the factors that set WordPress apart from the others:</p>\n\n\n\n<ul>\n<li>Access to resources. Simply put, there’s a huge community around WordPress. That community is extending WordPress in innovative ways; sharing knowledge and training for WordPress; and continuously building up WordPress skills amongst the community. That makes it easier for an organization like NASA to acquire support. There’s options for that. What was found with commercial CMS solutions is that, more often than not, NASA would have to go back to the original CMS vendor to find resources. That’s limited flexibility, which is undesirable for them.</li>\n\n\n\n<li>A plugin ecosystem that delivered real time content analysis capabilities within the WordPress admin environment in the ares of SEO and accessibility. The fact that content could be analyzed by the author before it was published was significant.</li>\n\n\n\n<li>Ease of use of the content authoring environment</li>\n</ul>\n\n\n\n<p>&#8220;It’s a big win for open source,&#8221; Toothman said. &#8220;There were a number of CMS capabilities that would have been more time consuming to implement without previous work by others in the WordPress community.&#8221;</p>\n\n\n\n<p>He cited the  integration that the NASA WordPress site has with NASA’s image library at <a href=\"http://images.nasa.gov/\" target=\"_blank\" rel=\"noreferrer noopener\">images.nasa.gov</a> as one example. Content authors in the CMS can search for images in the library and include them in their content via an augmentation that was made to the WordPress media library. Human Made did some previous work with commercial digital asset management solutions that NASA was able to leverage for the <a href=\"http://images.nasa.gov/\" target=\"_blank\" rel=\"noreferrer noopener\">images.nasa.gov</a> integration.</p>\n\n\n\n<h3 class=\"wp-block-heading\">NASA Goes All In on WordPress&#8217; Block Editor</h3>\n\n\n\n<p>The block editor&#8217;s flexibility for authoring landing pages and breaking free of a rigid templating system was one of the most important factors in NASA&#8217;s selection of WordPress as a CMS. As part of the project, Lone Rock Point created 55 custom editor blocks to help NASA website authors share discoveries and tell their stories.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1692\" height=\"1080\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/tabbed-content-block.gif\" alt=\"\" class=\"wp-image-149949\" />NASA&#8217;s Tabbed Content block &#8211; source: <a href=\"https://lonerockpoint.com/2023/10/nasa-flagship-wordpress-site-launch/\">Lone Rock Point</a>\n\n\n\n<p>&#8220;There’s over 400 content authoring/editor users in NASA’s WordPress CMS,&#8221; Toothman said. &#8220;With that many users, there’s a lot of variance in pre-existing familiarity to WordPress and Gutenberg. It was challenging. The learning curve was more significant than expected and change management was a big part of this project. </p>\n\n\n\n<p>&#8220;Some took the block editor quickly, others needed more support. It wasn’t just learning the mechanics of a new CMS, but learning about the storytelling options available via the new design system and the block editor. We built a lot of custom of blocks to bring the design system to live in WordPress, while also attempting to adhere to the intention of those design system components.&#8221;</p>\n\n\n\n<p>Toothman and his team found strategic ways of helping new block editor users become familiar with the authoring tools. They created hands-on training and working sessions to build pages in real time alongside users and created an online knowledge base.</p>\n\n\n\n<p>&#8220;To encourage the user community as they learned the new CMS, we created weekly blogs and newsletters that featured screenshots of pages in progress,&#8221; Toothman said. &#8220;Seeing their peers’ work and out-of-the-box use of the custom blocks, users were inspired to try different things and ask more questions. Our content team held weekly office hours for managing editors to answer questions users may have, hold live demonstrations, and collect feedback to produce more user resources. </p>\n\n\n\n<p>&#8220;By creating an environment that invites discussion, collaboration, and creativity, the content team was able to enforce content quality control standards on a massive scale while delivering a high-quality end-user experience.&#8221;</p>\n\n\n\n<p>Toothman said he was surprised and delighted by the creative ways authors utilized certain blocks.</p>\n\n\n\n<p>&#8220;Content authors figured out ways to use some of the custom Gutenberg editor blocks as design layout options and broke free of the content intention they were originally designed for,&#8221; he said.</p>\n\n\n\n<p>NASA will be open sourcing some of its custom blocks and other pieces of the project to give back to the WordPress community as part of the roadmap. The completed project stands as a high-profile testament to the agency&#8217;s confidence in the block editor and the wider ecosystem of available tools. It also highlights WordPress as a reliable CMS with exemplary adaptability for enterprise-level projects with complex publishing requirements.</p>\n\n\n\n<p>&#8220;For years, myself and many of us in the WordPress community have been mythbusting the perception from customer stakeholders in 2 areas: (a) WordPress isn’t enterprise. It’s just a blogging platform. (B) WordPress is not a secure CMS,&#8221; Toothman said.</p>\n\n\n\n<p>&#8220;While I don’t expect NASA choosing WordPress to wipe out those pre-existing perceptions, it is further evidence to support the fact that WordPress is enterprise class, and that it can meet security benchmarks.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2023 20:17:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Do The Woo Community: Thoughts on WordPress News, Resources and Paid Exposure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76771\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://dothewoo.io/thoughts-on-wordpress-news-resources-and-paid-exposure/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:421:\"<p>How to get exposure from your WordPress product or service? There are many options, but also a lot of competition.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/thoughts-on-wordpress-news-resources-and-paid-exposure/\">Thoughts on WordPress News, Resources and Paid Exposure</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2023 11:52:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress 6.4 Font Library Feature Punted to 6.5 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5306:\"<p>The WordPress 6.4 release squad has decided to <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1696525101347939\">punt the planned Font Library feature to 6.5</a> after core maintainers found major gaps in the Font APIs that cannot be resolved in time for the upcoming release.</p>\n\n\n\n<p>&#8220;I am currently reviewing the font APIs <a href=\"https://github.com/WordPress/wordpress-develop/pull/5285\" target=\"_blank\" rel=\"noreferrer noopener\">PR</a>,&#8221; WordPress REST API co-maintainer Jonny Harris said. &#8220;I must say, I am very worried about the PR in its current state. The code simply doesn&#8217;t follow the WP core code style and doesn&#8217;t feel WordPress.&#8221; He listed a number of problems he found with the feature:</p>\n\n\n\n<ul>\n<li>Limited developer API. We need functions like <code>wp_insert_font</code> / <code>wp_create_font</code> etc.</li>\n\n\n\n<li>Lack of filter or actions</li>\n\n\n\n<li>No way to unregister font collections</li>\n\n\n\n<li>Capabilities. Creating new fonts should have capabilies and not simply map to&nbsp;<code>edit_theme_options</code></li>\n\n\n\n<li>Confusing API structure.&nbsp; Collection should have embedded font objects</li>\n\n\n\n<li>What happens to fonts when collections are unregistered?</li>\n\n\n\n<li>If fonts are stored as post object, can I query to get all fonts from a collection?</li>\n\n\n\n<li>Are fonts deleted when the user is deleted?</li>\n\n\n\n<li>No way to filter where a font is stored</li>\n</ul>\n\n\n\n<p>&#8220;With time very limited in this release, it feels like actioning the above, feel like it is going too hard to achieve in this release,&#8221; Harris said.</p>\n\n\n\n<p>&#8220;I think this feature needs some more time to bake.&#8221;</p>\n\n\n\n<p>Harris said none of the REST API maintainers were involved in the early stages of the Font Library feature and they are currently &#8220;playing catch up.&#8221; The team was attempting to patch the existing design, but Harris said if a redesign of the API is planned, he would like to understand the requirements for the feature before drawing up a design.</p>\n\n\n\n<p>Punting a flagship feature is never an easy decision, but it&#8217;s far more preferable than shipping poorly designed API&#8217;s that don&#8217;t allow users to modify and disable the feature to fit their needs.</p>\n\n\n\n<p>&#8220;No is temporary but yes is forever,&#8221; WordPress core committer Aaron Jorbin said. &#8220;Once the code is merged into core for release, it’s something that needs to be maintained for our extenders forever. To me, the concerns I see being raised about how people will extend the feature are enough to punt the feature.&#8221;</p>\n\n\n\n<p>The Font Library feature was put forward late in the release cycle, landing in <a href=\"https://wptavern.com/gutenberg-16-7-introduces-font-management\">Gutenberg 16.7</a> last week, with very little time for testing.</p>\n\n\n\n<p>&#8220;Features have landed after beta 1 in the past,&#8221; WordPress core committer Jonathan Desrosiers said. &#8220;But my preference is to <em>not</em> land something with this much outstanding feedback. We&#8217;d be making last minute changes and merging for public release with very little actual testing. Sure, everyone here would test as best they can. But &#8216;in the wild&#8217; WordPress testing is much different and always uncovers some strange use cases or issues that we can&#8217;t foresee.&#8221;</p>\n\n\n\n<p>Contributors briefly considered delaying the release date to allow the feature more time but the consensus was for punting to 6.5, with the decision anchored in <a href=\"https://wordpress.org/about/philosophy/\">WordPress&#8217; philosophy</a> of &#8220;deadlines are not arbitrary.&#8221;</p>\n\n\n\n<p>&#8220;Changing a scheduled release date to leave room for finalizing a feature—no matter its priority—should not be considered,&#8221; WordPress core committer Joe McGill said. &#8220;This would not be the first time that we really hoped to have a feature shipped in a release but delayed it to the next release. It seems to me that a lot of effort has gone into preparing this feature for release and the consensus is that folks need more time to get it into a state that is ready to ship in a major WordPress release, which I know is disappointing, but also speaks to the care and quality folks want to ensure we put into these releases. If it&#8217;s not ready, it&#8217;s not ready. Let&#8217;s delay it — meanwhile we are still getting valuable user feedback via the Gutenberg plugin, which is a good thing.&#8221;</p>\n\n\n\n<p>WordPress 6.4 release lead Josepha Haden Chomphosy made the difficult <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1696522535253159\">decision to punt the feature</a> based on contributor feedback. The removal of the Font Library does not affect other key features anticipated to land in the release. Jessica Lyschik, 6.4 default theme co-lead, <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1696525030439049\">confirmed</a> the Font Library isn&#8217;t a requirement for Twenty Twenty-Four. The theme will ship with preselected fonts that get loaded from the theme assets, just like previous default themes.</p>\n\n\n\n<p>WordPress 6.4 Beta 3 is scheduled for October 10, 2023. This will be the last scheduled beta before RC1. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2023 02:41:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: The Contributor Orientation Tool with Milana Cap and Aleksandar Predić\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76765\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://dothewoo.io/contributor-orientation-tool-with-milana-cap-and-aleksandar-predic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:471:\"<p>The Contributor Orientation Tool on WordPress.org. How this tool came to be, how it has evolved and its future for helping contributors.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/contributor-orientation-tool-with-milana-cap-and-aleksandar-predic/\">The Contributor Orientation Tool with Milana Cap and Aleksandar Predić</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Oct 2023 10:34:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: #93 – Piermario Orecchioni on How and Why WordPress Gets Translated\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=149789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/podcast/93-piermario-orecchioni-on-how-and-why-wordpress-gets-translated\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:45768:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how and why wordPress gets translated.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Piermario Orecchioni.</p>\n\n\n\n<p>Piermario a freelance web designer resides in Italy, and is deeply involved in the global WordPress community. His journey with WordPress began in early 2017, when he created his wordpress.org account. Among his many contributions Piermario has focused primarily on the Polyglots team, which, if you didn&#8217;t know, deals with translations. His dedication and involvement in this aspect of the WordPress community have been important to him, and he shares more about his experiences with the team and how they work.</p>\n\n\n\n<p>Piermario begins by questioning the moral and legal obligations of making websites available in multiple languages. Is it simply a nice thing to do, or are they legal reasons behind it? He sheds light on the importance of language localisation, especially when WordPress is used on government websites to provide user centric experiences.</p>\n\n\n\n<p>But translating websites comes with its own set of challenges, and we discuss the difficulties in translating and reviewing strings in WordPress, where slight changes can lead to a large number of strings needing translations. He emphasizes the need for maintaining consistency, and standards in translations by having a glossary in each language.</p>\n\n\n\n<p>We then talk about Piermario&#8217;s journey as a contributor to the Polyglots team. He highlights recent improvements in the translation process, thanks to the GlotPress translation platform.</p>\n\n\n\n<p>We get into how the project is always on the lookout for new contributors, and discuss how they can become editors for specific projects, if their translations meet the required quality standards.</p>\n\n\n\n<p>We delve into the intricacies of language variations and the importance of localised translations. Piermario reiterates that coding expertise is not necessary for this work. Even newcomers with a curious mind and a willingness to help can contribute meaningfully. He paints a picture of how the work of translation is both accessible and beneficial, where short portions of text can be tackled in small amounts of time.</p>\n\n\n\n<p>We end with a discussion of the ongoing projects being translated, such as Learn and Openverse, which aims to reach a larger audience and make WordPress education accessible in multiple languages.</p>\n\n\n\n<p>Piermario shares insights into the Italian WordPress community, and the process of translating plugins and themes.</p>\n\n\n\n<p>So if you&#8217;re looking to help out translating WordPress, or just interested in hearing about a way that you can contribute, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Piermario Orecchioni.</p>\n\n\n\n<p>I am joined on the podcast today by Piermario Orecchioni. Hello!</p>\n\n\n\n<p>[00:04:31] <strong>Piermario Orecchioni:</strong> Hey. Hi Nathan. How are you doing?</p>\n\n\n\n<p>[00:04:33] <strong>Nathan Wrigley:</strong> Yeah really nice. Thank you for joining me on the podcast today. We&#8217;re going to stray into a subject which, I confess, as I often do on these episodes, it&#8217;s an area that I don&#8217;t really know a great deal about. So hopefully Piermario will be able to school me all about this.</p>\n\n\n\n<p>I was introduced to Piermario, I don&#8217;t know if he knows this, but it was Courtney Robertson that pointed me in your direction because she thought it would be fascinating on the WP Tavern Jukebox podcast to have an episode all about Polyglots and the Polyglot team. So that&#8217;s what we&#8217;re going to do today. That is the endeavor.</p>\n\n\n\n<p>Before we do that though, Piermario, I wonder if you wouldn&#8217;t mind just giving us two or three minutes of your time explaining, who you are, where you live, what your involvement is with WordPress. And I guess, importantly what your relationship is with Polyglots, translations, and the team that&#8217;s helping with that endeavor.</p>\n\n\n\n<p>[00:05:28] <strong>Piermario Orecchioni:</strong> Yeah. First of all, thanks again for having me, and thanks to the ever amazing Courtney for just making my name.</p>\n\n\n\n<p>In the everyday life I am a freelance web designer and besides that I&#8217;m part of the Italian and international WordPress community.</p>\n\n\n\n<p>I started contributing in, I think early 2017, was the time when I started my wordpress.org account. And I&#8217;ve been mainly contributing to the Polyglots team for reasons that we&#8217;ll cover soon.</p>\n\n\n\n<p>Over the course of the years I picked into other teams, like there&#8217;s a lot to be done in WordPress. Being not a native English speaker, so having access to bits and parts of WordPress that are not always translated. Everything must undergo some form of translation to allow people like me, and poeple that don&#8217;t speak English, to use it in a more comfortable way. So that&#8217;s what kept me going, and it&#8217;s still why I contribute to this day.</p>\n\n\n\n<p>[00:06:40] <strong>Nathan Wrigley:</strong> Oh thank you. That&#8217;s really nice. I should probably stress at the beginning that maybe there&#8217;s a line to be drawn between translating the front end of a website, and translating the backend, WordPress itself. The software that may download from .org.</p>\n\n\n\n<p>We&#8217;re probably, if you&#8217;re a WordPress user for any length of time, you&#8217;re probably aware that there&#8217;s a bunch of third party plugins which will handle the translations of say text on your homepage, or any other page or post from one language to another, and you&#8217;ve probably come across some of those. There&#8217;s a variety of them in the ecosystem.</p>\n\n\n\n<p>But this is not that. Polyglots is more about the backend. Translating WordPress. At least I think that&#8217;s the case.</p>\n\n\n\n<p>[00:07:27] <strong>Piermario Orecchioni:</strong> Well actually Polyglots, and the whole Polyglots team, is responsible, if we want to use a big word. But it actually touches all the WordPress ecosystem and touch points, because we translate WordPress Core. We translate and localise, which sometimes it&#8217;s a more appropriate term. Like the bundle teams, like every standard team that comes with a new release of WordPress. We also do that.</p>\n\n\n\n<p>We translate and contribute to plugins, like all the plugins that exist in some language and must be translated, go somehow, somewhere through a polyglots. A polyglots that localised it. Localises that plugin into their own language.</p>\n\n\n\n<p>We also translate what we call Rosetta. That&#8217;s kind of an internal lingo. But Rosetta is just like the stone. It&#8217;s basically every localised version of wordpress.org, like the Italian wordpress.org, Spanish wordpress.org. So we&#8217;re basically everywhere the WordPress ecosystem needs a translation.</p>\n\n\n\n<p>[00:08:44] <strong>Nathan Wrigley:</strong> Yeah now that you say that it makes so much sense. I for some reason hadn&#8217;t managed to parse that. But of course the wordpress.org website needs translating, and of course there needs to be attention given over to plugins and things like that. So yeah, that&#8217;s great. Thank you for clarifying that. It does seem like there&#8217;s a lot of work to be done, and we&#8217;ll touch upon that in a moment.</p>\n\n\n\n<p>Slight aside, for somebody that is an English speaker the word polyglots is quite an unusual one. I mean, I can imagine it&#8217;s broken up into two parts. Poly I guess meaning multiple, more than one. But do you have any indication of what the glots bit means? I&#8217;m guessing it&#8217;s got something to do with language, but in all my years I&#8217;ve never just heard that word in an isolated environment. I&#8217;ve never heard anybody talk about a glot.</p>\n\n\n\n<p>[00:09:31] <strong>Piermario Orecchioni:</strong> Yeah, a glot is, now I didn&#8217;t do my homework. It definitely means language but I don&#8217;t remember if it&#8217;s Latin or Greek. I would guess Latin.</p>\n\n\n\n<p>[00:09:42] <strong>Nathan Wrigley:</strong> Well that&#8217;s the meaning anyway. If we collide those two bits, multiple languages is really kind of what it means.</p>\n\n\n\n<p>Let&#8217;s talk about the actual endeavor of doing this work then. And although it seems like a fairly basic question, this question could go in multiple directions. So I&#8217;ll just ask the question, then I&#8217;ll give you some more context on that.</p>\n\n\n\n<p>Why do we need there to be translations in our website? So that&#8217;s the basic question, and then I&#8217;ll pad it out a little bit more. What I mean by that is, is it just kind of like a morally decent thing to do to have something like WordPress, which is obviously downloaded across the globe millions of times. Is it just a nice, good thing to do to make it available to as many languages as possible?</p>\n\n\n\n<p>Or perhaps there is something a bit more pressing. In other words maybe there&#8217;s legal things which come into play. I don&#8217;t know if you have any insight into either of those things, but obviously it is a nice thing to do. But I also wonder if as a piece of software which is shipping, albeit an open source piece of software, I don&#8217;t know if there&#8217;s any legal compulsion to have it translated.</p>\n\n\n\n<p>[00:10:49] <strong>Piermario Orecchioni:</strong> I don&#8217;t think there is a legal obligation or some sort of legal requirement to have WordPress translated. Obviously if you use WordPress on a government website, the plugins or components you&#8217;re using should be localised into the language users will be using because that&#8217;s just user centricity 101.</p>\n\n\n\n<p>I think that the simple reason why WordPress must, and wants to be, translated into possibly any language in the world is that we like to make this tool available to anybody, anywhere for whatever reason. The more we make WordPress available in somebody&#8217;s native language, the higher the chance that they will use it, and they could start something.</p>\n\n\n\n<p>I think it&#8217;s just one of the few left idealistic things of the web. Do things for the common good, and having WordPress in your language definitely is quite something. And I was just digging a little bit into the Polyglots pages yesterday on the WordPress site, and one of the bits I found is that, as of June 2020, roughly 55% of all WordPress websites running were not running in English.</p>\n\n\n\n<p>[00:12:17] <strong>Nathan Wrigley:</strong> That&#8217;s a big statistic, isn&#8217;t it? Yeah I did not know that number. That&#8217;s extraordinary.</p>\n\n\n\n<p>[00:12:22] <strong>Piermario Orecchioni:</strong> I might even argue it&#8217;s even higher by now because in three years we improved and we have way more translation available by now. But it&#8217;s true that English is the international language, but it&#8217;s also true that there&#8217;s a lot of people that does not English, or are not fluent enough to go into a backend of a site and deal with that, if that&#8217;s not in their language. So with the translation we remove this barrier and we make WordPress available to everybody.</p>\n\n\n\n<p>[00:12:58] <strong>Nathan Wrigley:</strong> So let&#8217;s dig into the work of the team, the Polyglots team, the people who are translating. I noticed incidentally that you use the word locale a little bit. And so I guess these terms are interchangeable, if anybody&#8217;s listening and not quite sure what that word might mean.</p>\n\n\n\n<p>So let&#8217;s start, let&#8217;s begin with the number of languages that WordPress has been translated into. Again, sorry I&#8217;m putting you on the spot. I haven&#8217;t actually primed you to know these facts, but I&#8217;m curious as to which languages seek attention, and indeed if there&#8217;s any kind of order there.</p>\n\n\n\n<p>So you mentioned English, obviously that&#8217;s a very large language. I&#8217;m guessing you could pick the names of a dozen or more other equally large languages where you know there&#8217;s millions and millions of people. But I guess as you go slowly down that order the languages have less people, and I do wonder, are there any which are just being implemented for the first time? Or ones that you tackle later? Ones that you give more importance to? So yeah, just that question to begin.</p>\n\n\n\n<p>[00:14:01] <strong>Piermario Orecchioni:</strong> I think that the importance is relative and it&#8217;s given by the amount of people that contributes to that language. And just as I was saying, in the bit I saw yesterday, this page which most likely was last updated in 2020, speaks about 172 languages.</p>\n\n\n\n<p>But, I found there&#8217;s another interesting link which is make.wordpress.org/polyglots/teams, which lists all the locale. And I&#8217;m going to get into that a little bit right after this. And that lists, as of today, 208 locale. A locale is, it&#8217;s kind of a polyglots lingo, but it&#8217;s basically, let&#8217;s say the combination of a language code, a regional code, and peculiarities that make even a variation of a language different.</p>\n\n\n\n<p>For example, even if we take English, we have American English, we have British English, we have Australian and so on. Or Spanish, there&#8217;s the Spanish spoken in Spain but then there&#8217;s the whole of South America. So even the translation of WordPress is not in one single version of Spanish, but it&#8217;s localised. So it&#8217;s made closer and we strive to make it as familiar as possible to every local speaker.</p>\n\n\n\n<p>I translate only in Italian, but all the contributors that work on every language can pick their very specific language. Because there&#8217;s obviously have like hundreds of millions of speakers. But in the locale list you&#8217;ll find languages or dialects with like one contributor. So somebody who just started translating WordPress in their own dialect or regional language. Great. It&#8217;s a lot of work, but it&#8217;s possible. So we have the tools to make that happen.</p>\n\n\n\n<p>[00:16:12] <strong>Nathan Wrigley:</strong> That&#8217;s absolutely fascinating. I run up against this, actually. Curiously, because I&#8217;m British, there&#8217;s quite a few differences in the way that the translations that I have to do, the transcriptions for this podcast. And there are some words which are spelt in American English differently. So typically, for example, they use a zed or a zee character at the end of a word, like customise might have a Z or a Z at the end. Whereas in British English we&#8217;d replace that with an S. And I&#8217;m always confused as to how I should translate things for this podcast, because I never know, should I just stick with what I would use? Or should I try to think more about broader audience?</p>\n\n\n\n<p>In the end I settled on just having it done in the way that I would spell it, because then I can spot those mistakes more or less automatically. Whereas if it&#8217;s looking for a spelling error in American English I may not be able to pick that up. But thank you for clarifying that. So we now know difference between locales, and the fact that that obviously complicates the job of translating WordPress even more.</p>\n\n\n\n<p>Who does this work? And, is there a base language which it&#8217;s built upon? So as an example, is WordPress originally created in, let&#8217;s say, American English? And then the translation team, they get their hands on it and they begin from that baseline of that language to make the translations where necessary.</p>\n\n\n\n<p>Perhaps it&#8217;s not done that way. So yeah just tell us how it&#8217;s done, what the process is and who is doing it? And I don&#8217;t mean names I mean, who are the people? Bunch of volunteers I&#8217;m guessing just like much else in WordPress.</p>\n\n\n\n<p>[00:17:49] <strong>Piermario Orecchioni:</strong> Yeah I think it all starts with the American English version. Since 2010, I did my homework here, we do have a platform which is called, we call it Translate but it&#8217;s actually based on a system called GlotPress which is developed and maintained by the WordPress community.</p>\n\n\n\n<p>Anybody can go to translate.wordpress.org and pick and choose basically. So if you go there you can start by choosing the language you want to translate, or help with. And then once you pick the language you can pick what you would like to help with. So you can suggest translations into the WordPress Core, a plugin, a theme, or really anything that&#8217;s available. For example, other projects that we translate are like Open Verse which has been growing fast over this last years.</p>\n\n\n\n<p>New, very interesting things like Learn WordPress. That&#8217;s all in the process of being translated and made available to a larger audience, because even Learn WordPress, it&#8217;s kind of new at least in the form it has now. But it could potentially open the doors of WordPress education to everybody virtually in any language, and make WordPress education available for free to anybody. So there&#8217;s a lot of work being done on that as well.</p>\n\n\n\n<p>[00:19:28] <strong>Nathan Wrigley:</strong> That&#8217;s really fascinating, because as a consumer of WordPress news, I love it when these new initiatives come along. So you know Open Verse is a perfect point, and the new revamped, revitalized efforts into Learn and all of that. I&#8217;m just looking at it and thinking oh that&#8217;s brilliant, look there&#8217;s loads of new resources.</p>\n\n\n\n<p>And of course completely forgetting the part that you&#8217;ve got to play, your team, the team has got to play in order to make that available to everybody else. So it kind of seems like this is a hamster wheel which just gets faster and faster all the time. I&#8217;m guessing there&#8217;s never less translations to be done, there&#8217;s only more translations to be done as new ideas and new initiatives and new projects come with the growth of WordPress.</p>\n\n\n\n<p>[00:20:12] <strong>Piermario Orecchioni:</strong> Yeah, yeah. There&#8217;s always new translations or even projects. The project that personally I really hold close to my heart is the Italian localisation of the Gutenberg plugin, because it&#8217;s really one of the first project where in the Italian community somebody gave me the responsibility to kind of take care of that.</p>\n\n\n\n<p>So even to this day, but for some time, I was really focused on maintaining and you know helping people come on board to help translate Gutenberg, and have it as close to a hundred percent of translated strings.</p>\n\n\n\n<p>Our unit of thinking is string. We could go into that like super quickly. But basically anything you use in WordPress that you find on translate.wordpress.org is conveniently listed as endless, or less endless, series of strings that must be translated to have a hundred percent of the English content of that specific project or plugin, or anything translated into your language.</p>\n\n\n\n<p>So even projects like Gutenberg that, yay, a hundred percent. So we have like three minutes to celebrate because Gutenberg comes out every two weeks. So every two weeks, the strings are added or different or wait, there&#8217;s parts of the full site editing experience that now are called differently. Like we&#8217;ve seen now I didn&#8217;t prepare any examples, but I mean even going to what&#8217;s current, like 6.3 has synced patterns.</p>\n\n\n\n<p>[00:22:03] <strong>Nathan Wrigley:</strong> Right. Reusable blocks became synced patterns.</p>\n\n\n\n<p>[00:22:05] <strong>Piermario Orecchioni:</strong> We&#8217;re kind of starting to, let&#8217;s translate and do our best every time we translate. But let&#8217;s also, especially when it&#8217;s something so fluid and so fast moving as the whole new block themes, full site editing effort. Let&#8217;s just make the best we can do because it might change in weeks or months, or when we find a better way to communicate that or market that.</p>\n\n\n\n<p>[00:22:36] <strong>Nathan Wrigley:</strong> That&#8217;s really interesting. So I&#8217;ve learned a couple of things. We have this expression by the way in the UK and the expression goes, it&#8217;s like painting the Forth Bridge. There&#8217;s this very long bridge in Scotland, and there is a team of people who paint it. And because of its great length it takes them you know multiple years to get from one end to the other. And you can guess what happens. As soon as they the end they just start right over again at the far end that they, you know, a couple of years ago began. And so this process of painting never ends, and thus it is with the project that you are talking about.</p>\n\n\n\n<p>But also what I learned there was that the translations are sort of grouped into blocks. And I don&#8217;t mean blocks as in a WordPress block, I mean groups of things. So Gutenberg, that is an object if you like, that needs translating. And you can achieve a hundred percent of that, albeit that&#8217;s an example which is constantly changing and probably never quite stays at a hundred percent for particularly long because it&#8217;s constantly in flux.</p>\n\n\n\n<p>So I&#8217;m guessing that there are other groups like that. And I&#8217;m wondering if some of those things receive more importance. So as an example, something like Gutenberg which has become really the bedrock of WordPress, I&#8217;m guessing that when a new version of WordPress comes out, let&#8217;s go with a new version of WordPress rather than the plugin itself for Gutenberg. When a new version of WordPress comes out, 6.3.</p>\n\n\n\n<p>Do you have to sort of drop the translations temporarily of other things, so that you can make sure that that ships perfectly? Or at least as perfectly as you can. Do you have some sort of system of saying, okay this is the important thing for this week or this month, and some of these things may have to wait? Is there an overarching authority that makes all that happen? Or is it really just left to the contributors to decide what they&#8217;re going to do and when they&#8217;re going to do it?</p>\n\n\n\n<p>[00:24:23] <strong>Piermario Orecchioni:</strong> It&#8217;s really left to the community but we set ourselves with priorities, like when a new major version of WordPress is about to be released, lets focus on that. We do not forget Gutenberg for a few weeks, but we just focus on getting all the strings for the new version translated. Usually after a few release candidates there&#8217;s like a string freeze. At that point nothing is moving. At that moment we just check what&#8217;s left to translate and what needs our attention.</p>\n\n\n\n<p>In a way the beauty of this is that the WordPress Core and Gutenberg are so tightly related that they&#8217;re constantly above I would say 90, 95%. Like we hardly drop, as I&#8217;m talking about Italian localisation, but we hardly drop below 98% of translated strings. Sometimes we have like 50 new strings, or a hundred strings that need to be translated or reviewed because something has been slightly changed or synced pattern.</p>\n\n\n\n<p>[00:25:38] <strong>Nathan Wrigley:</strong> That&#8217;s a good example at the moment, isn&#8217;t it? Because can you imagine how many times the word, in English, reusable blocks would appear on all of the .org properties? I mean I&#8217;m guessing it&#8217;s multiple thousands. The idea of going back and changing that in, not just WordPress Core but also in, like you say, the Learn materials and the documentation for WordPress. It&#8217;s a big search and replace, isn&#8217;t it?</p>\n\n\n\n<p>[00:26:02] <strong>Piermario Orecchioni:</strong> Well in a way it could be, but we do have a few tools. We have many tools but two of the tools that are really our bread and butter as Polyglots team is the, like every locale, every language has it&#8217;s own glossary which is the reference for translating WordPress into your language. Because the Polyglots team of each country is also responsible for choosing what&#8217;s the standard translation for an English term.</p>\n\n\n\n<p>In Italy we do have this tendency to gleefully adopt English terms, which is fine by me in some cases, because I speak English. But not everybody is as tech savvy or has a specific knowledge of English that allows them to make sense of any English term you want to squeeze into a plugin translation or something, so we have to set boundaries.</p>\n\n\n\n<p>For example, one we always use when we onboard new contributors to the Italian community, is that the Italian translation of a post, like blog post, it&#8217;s articolo. It&#8217;s like article. Which kind of makes sense, but at the same time we do recognise that&#8217;s kind of weird in a world where any social media bit you publish is a post. So people are now familiar with the word post. So why don&#8217;t we just use it in WordPress? Because somebody years ago decided that we go with articolo and until, perhaps there&#8217;ll be in x time, a real reason to drop that translation that we set as standard, we&#8217;ll go with that.</p>\n\n\n\n<p>But having a glossary also allows you to create much more consistent translations. So I like to say, we like to say, that polyglots, it&#8217;s really probably or maybe just because we want to float our boat. It&#8217;s probably the easiest team to get involved with if you want to help in the WordPress community, because you don&#8217;t necessarily need to know coding. You don&#8217;t necessarily need to be an expert.</p>\n\n\n\n<p>Even in WordPress you could be a regular new user. Just have curiosity and will to help, and you can start pretty much anywhere. And when somebody&#8217;s new and it&#8217;s starting, all the entries that are in the glossary are already highlighted so that we help somebody suggesting new translation to stay consistent, and use the same terms that we already used over and over in tens, hundreds, thousands of strings all around the WordPress ecosystem.</p>\n\n\n\n<p>[00:29:09] <strong>Nathan Wrigley:</strong> I guess also, unlike many of the other teams, the enterprise of the work is fairly obvious in that you know that what you&#8217;ve got to do is look at one language, translate it into the other language, as best as you can, and rinse and repeat. So the enterprise is fairly straightforward.</p>\n\n\n\n<p>And I&#8217;m also guessing that it&#8217;s fairly atomised. What I mean by that is there&#8217;s going to be portions of text which are relatively short. So it&#8217;s the kind of thing that you could dip in and out of. Whereas maybe some of the other teams, the approach would have to be much more, you know this thing is going to take hours and hours and hours. With translations, I could be wrong forgive me if I am, but it feels like if you had the inclination you could dip in for several minutes and still achieve something valuable, but it would only have consumed a few minutes of your day which most people could probably find.</p>\n\n\n\n<p>[00:30:08] <strong>Piermario Orecchioni:</strong> Absolutely. Like I always keep some projects handy instead of playing wordle for the day. I open a plugin or something I&#8217;m curious about, or I want to help make available in Italian, and just punch in a few strings. But it&#8217;s really for everybody, like this is the message. It&#8217;s really for everybody and there&#8217;s no way you can break the internet by contributing because there&#8217;s like levels of contributors in the Polyglots team.</p>\n\n\n\n<p>[00:30:41] <strong>Nathan Wrigley:</strong> I was going to ask this. I thought this was an important point.</p>\n\n\n\n<p>[00:30:44] <strong>Piermario Orecchioni:</strong> So it&#8217;s safe, and can be really, you can take it as a game. Because if you have a wordpress.org account you can go, log in on translate.wordpress.org, pick a project and start suggesting translation for any project.</p>\n\n\n\n<p>So in that case you&#8217;ll be contributing to a translation, but at that point you are not an editor for that specific project. So basically if somebody who just discovered that they can do this thing suggests a translation, an editor, and we have two main categories of levels of editors, they can review the translation and approve it. And now that bit of WordPress is yours. Like you contributed to WordPress and it&#8217;s the best feeling.</p>\n\n\n\n<p>And usually, this is just a silly thing, but when a major version is coming out if you participate in translating the new strings for the new Core version, like 6.3 just few weeks ago. If your translation is approved you also get the warm fuzzy feeling of having your name in the WordPress translation credits.</p>\n\n\n\n<p>[00:32:11] <strong>Nathan Wrigley:</strong> That&#8217;s nice. I was curious about that because obviously the capacity to go in with your wordpress.org account and then just, well for want of a better word, and I hope it doesn&#8217;t happen all that often, but just to cause mayhem. Unless there was some sort of editorial hierarchical approach, where things entered a pending queue and then somebody with presumably more backstory in the translation team. So the longer you&#8217;ve been there, the more kudos you&#8217;ve built up, if you know what I mean, presumably the more responsibility you get.</p>\n\n\n\n<p>I would imagine that that&#8217;s probably really required. You need people who are going to get a notification or something to say okay things have been amended, go back, have a look. And so they may not be involved in doing all the translations, but they&#8217;re presumably the ones that get to say actually that one looks fine, move on. That one looks fine. Hold on a minute there&#8217;s something weird there, let&#8217;s not publish that one. Something seems to be weird. Let&#8217;s just reverse it and go back to what we had previously. So there&#8217;s those processes going on.</p>\n\n\n\n<p>[00:33:13] <strong>Piermario Orecchioni:</strong> Yeah It&#8217;s actually something we&#8217;re continuously trying to improve because in a nutshell, there&#8217;s like regular contributor, like somebody that comes in and for example, right now one of the things we are working on is the Italian translation of the new Italian WordPress website. Because if you go to the Italian website today it does not look like the English version, because the theme was not made available yet. But it&#8217;s about to be available once the translation is completed.</p>\n\n\n\n<p>So when I started with other contributors to translate that weeks ago, many strings were just version numbers. Like the page where WordPress versions are listed is version numbers, dates, and jazz musicians. So you don&#8217;t need to have like a specific knowledge of either English or jazz history or anything else to know that you can help with that bit of the translation.</p>\n\n\n\n<p>So when it comes to other projects obviously there&#8217;s like hundreds, and possibly thousands, I would leave the possibly out because there&#8217;s thousands of plugins in the WordPress plugin repo. So everybody wants to be translated in other languages.</p>\n\n\n\n<p>So at the top, let&#8217;s say with many quotes, at the top of the editor&#8217;s pyramid in the Polyglots team, that&#8217;s what we call GTEs, General Translation Editors, of which I&#8217;m one for the Italian team. Basically we have the power slash responsibility to proof and edit any string on any project related to WordPress. We can approve somebody&#8217;s suggested translation. We can edit a translation if something&#8217;s wrong or improper terms have been used in some way.</p>\n\n\n\n<p>But one of the improvements we&#8217;ve been doing, thanks to the team that develops GlotPress, and the whole platform that powers the translations, is that for probably less than a year we now have like a feedback tool. When somebody suggests a translation, as an editor you now have a field where you can ask the person to make some changes. Like, can you please change this because? Like check the glossary. You know, you can give them a hint on how to improve their translation.</p>\n\n\n\n<p>As new contributors get better at translating, and we see that their contributions are of course always welcome but the quality is good. If you want and if you show that your translation meets the standard we&#8217;re aiming for, you can become an editor for a specific project, which is usually a plugin or a theme.</p>\n\n\n\n<p>So we have lots of people that are either developers that have a plugin that they want to translate into Italian. So they want to become editors for that project and that is called, that position let&#8217;s say, it&#8217;s called PTE like Project Translation Editor.</p>\n\n\n\n<p>If you are a PTE you can approve all the strings for that specific project. So we love when somebody comes in and adopts their favorite plugin or theme that is not yet translated into their own language.</p>\n\n\n\n<p>I think it&#8217;s a beautiful way of contributing. There&#8217;s several people I admire in the WordPress community. But people like Rich Tabor, Anders Noren who have been putting out for years themes for free for the community. Having those themes translated right away, or almost right away, when they&#8217;re released, I think it&#8217;s also our way of giving back, because I think it&#8217;s just a beautiful thing and it makes us community.</p>\n\n\n\n<p>[00:37:40] <strong>Nathan Wrigley:</strong> There&#8217;s a little bit of quid pro quo there, isn&#8217;t there? Which I guess you based upon the endeavors that you&#8217;ve put in in the past.</p>\n\n\n\n<p>I have a curious question in that, and again forgive me because of my English, as in British, proclivity. So I speak English, I confess in terms of any other language I have no skills whatsoever, so it may very well be that this team is kind of out of the question for me because I couldn&#8217;t manage to translate anything. But it makes me wonder, is it possible to pollinate languages outside of English into other languages?</p>\n\n\n\n<p>So let&#8217;s say, for example that the Italian translations, like you&#8217;ve just said it sounds like your auspices and the team that you are working with, that those translations in many cases are done fairly rapidly. Which means that the Italian strings and translations could be looked at fairly swiftly as complete. Now if I don&#8217;t speak English but I do speak Italian and Japanese for example, is it possible to go in that direction? There has to be no single language which you are feeding from. Can you go from one language to another without having to have, let&#8217;s say, English in the mix?</p>\n\n\n\n<p>[00:38:51] <strong>Piermario Orecchioni:</strong> Yeah I would say so. It&#8217;s something I&#8217;ve hardly done, but sometimes I have the same curiosity so I just didn&#8217;t follow what happened next after I suggested a string in like Spanish or French. Or I translated Louis Armstrong&#8217;s name into Norwegian let&#8217;s say .</p>\n\n\n\n<p>I didn&#8217;t follow up to see if that string was approved, because if for Core versions the approved strings go into a big bucket and you get like a credit in the WordPress credit page of your localised version. But if you go check any plugin and check the translation for a specific language you can see who translated that plugin.</p>\n\n\n\n<p>So somebody translated one string, somebody 200, and so on. So I think it&#8217;s quite possible that you can suggest a string in a language that is not yours, and if it&#8217;s correct that can be approved. I just didn&#8217;t follow what happened after that, but it&#8217;s possible.</p>\n\n\n\n<p>[00:39:58] <strong>Nathan Wrigley:</strong> Yeah thank you. Just before we round it out I guess would be good to talk about the team itself and how you think about that. And then maybe move on to talking about how you can become involved. So I&#8217;ve got a few questions around that.</p>\n\n\n\n<p>The first one is, are there enough people doing this work to make it so that you know you&#8217;re all just having a very nice time of it? There&#8217;s a few things to be done each day, or is it more a case, I guess you can speak to the Italian I don&#8217;t what it&#8217;s like elsewhere, but maybe as a part of the team you&#8217;ve heard discussions around this.</p>\n\n\n\n<p>Are there enough people or does the team feel undersubscribed? Are you on the lookout constantly for new people? And are there any languages that you know of in particular or locales that you know of in particular that are crying out for help?</p>\n\n\n\n<p>[00:40:44] <strong>Piermario Orecchioni:</strong> Well every language in any part of the world could use some help, definitely. We always have room for new people, and we&#8217;re very happy when folks join us so that we can do more in less time. And we&#8217;re happy when somebody joins and stays and is happy and gets rewarded by having their translations approved, and seeing that something is in your own language because you helped. That&#8217;s always great.</p>\n\n\n\n<p>Sometimes I think we tend to think about WordPress as this huge, giant project that will be there no matter what, and is translated into my language because it has to be. Like, how can it be not available in Italian or so? But then when you go and see the numbers, I think the active general translation editors for Italian are about 15 people.</p>\n\n\n\n<p>We have hundreds of contributors that range from somebody who translated two strings two years ago, to somebody that needs a plugin, like a specific plugin, localised because their business needs it. So they become editors and they contribute even just to that.</p>\n\n\n\n<p>But there&#8217;s always room for new people in, and there&#8217;s like grunt work and weekly meetings where we hold Slack meetings, as all the WordPress community does. And having more people on board means that somebody else can host a weekly meeting. Otherwise it&#8217;s like 2, 3, 4 of us that rotate and do that. And it&#8217;s a pleasure, but sometimes you have life in your way.</p>\n\n\n\n<p>We always make space for WordPress because we love the project, and it means so much to us. And to answer your question, the team itself, I think I can even speak beyond the Italian team, because like at Work Camp Europe I had the chance to meet other Polyglots from other countries, and the vibe is really good. Like it&#8217;s a non-competitive team. Anybody&#8217;s welcome, and in the Italian community we&#8217;re really kind of family. Like we have WhatsApp chats to check on each other, like we really develop friendly relationships. That&#8217;s part of what keeps us going, because you feel like part of a group that is nice to be around.</p>\n\n\n\n<p>[00:43:23] <strong>Nathan Wrigley:</strong> Yeah that&#8217;s really nice to hear. It does strike me as a very, well I mean this may sound obvious, but it&#8217;s a very communicative team, because you are basically dealing in communication. So it&#8217;s really nice to hear that.</p>\n\n\n\n<p>Just before we wrap up, you&#8217;ve said that there&#8217;s always a need for people to do this work. And you did, I think, mention it earlier but maybe it&#8217;s a good idea to mention it again. Where&#8217;s the best place to go to get involved? For somebody that&#8217;s never touched on this before, where would you direct them?</p>\n\n\n\n<p>[00:43:51] <strong>Piermario Orecchioni:</strong> The go-to place is always make.wordpress.org or wordpress.org. Somewhere in the navigation there&#8217;s either a make menu item or a get involved menu item. So just go there and pick your team. I would suggest Polyglots.</p>\n\n\n\n<p>But really, every team, there&#8217;s like photography team. It&#8217;s something that did not really exist until a few years ago, and you can contribute to WordPress moderating photography or send in your photography so that everybody could use nice, copyright free, pictures. There&#8217;s really a space for everybody to help in every way. We like to be open and welcoming in WordPress. That&#8217;s really what we love.</p>\n\n\n\n<p>[00:44:43] <strong>Nathan Wrigley:</strong> Thank you. And finally, last question. If people wanted to get in touch with you. You may have a social media platform that you prefer to use or email address or a website, whatever it may be. Where do we get in touch with you?</p>\n\n\n\n<p>[00:44:57] <strong>Piermario Orecchioni:</strong> I&#8217;m on Slack as @Piermario. So on the WordPress Slack anybody can message me on the Italian, and the international Slack just with @ my name. I would say on what&#8217;s left of Twitter, I do have a weird handle because Piermario was taken. So my Twitter handle or X handle is succoallapera, which means pear juice, because I&#8217;m an avid pear juice drinker. And I would say that&#8217;s about it.</p>\n\n\n\n<p>One day I will keep updating piermario.com, which I&#8217;m slowly rebuilding and using. Even as a kind of sandbox or block theme playground. But I have more ideas and drafts than actually published posts for now, but one day it&#8217;ll be more lively.</p>\n\n\n\n<p>[00:45:58] <strong>Nathan Wrigley:</strong> Piermario, thank you so much for chatting to us on the podcast about this really intriguing subject. I&#8217;ve learned a lot. Thank you very much for joining us.</p>\n\n\n\n<p>[00:46:06] <strong>Piermario Orecchioni:</strong> Thank you so much and thanks again for having me.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/succoallapera\">Piermario Orecchioni</a>.</p>\n\n\n\n<p>Piermario Orecchioni, a freelance web designer, resides in Italy and is deeply involved in the global WordPress community. His journey with WordPress began in early 2017 when he created his wordpress.org account. Among his many contributions, Piermario has focused primarily on the Polyglots team, which, if you didn’t know, deals with translations. His dedication and involvement in this aspect of the WordPress community have been important to him, and he shares more about his experiences with the team and how they work.</p>\n\n\n\n<p>Piermario begins by questioning the moral and legal obligations of making websites available in multiple languages. Is it simply a nice thing to do, or are there legal reasons behind it? He sheds light on the importance of language localisation, especially when WordPress is used on government websites, to provide user-centric experiences.</p>\n\n\n\n<p>But translating websites comes with its own set of challenges, and we discuss the difficulties in translating and reviewing strings in WordPress, where slight changes can lead to a large number of strings needing translations. He emphasises the need for maintaining consistency and standards in&nbsp; translations by having a glossary in each language.</p>\n\n\n\n<p>We then talk about Piermario&#8217;s journey as a contributor to the Polyglots team. He highlights recent improvements in the translation process, thanks to the Glotpress translation platform.&nbsp;</p>\n\n\n\n<p>We get into how the project is always on the lookout for new contributors, and discuss how they can become editors for specific projects if their translations meet the required quality standards.</p>\n\n\n\n<p>We delve into the intricacies of language variations and the importance of localised translations.</p>\n\n\n\n<p>Piermario reiterates that coding expertise is not necessary to this work; even newcomers with a curious mind and a willingness to help can contribute meaningfully. He paints a picture of how the work of translation is both accessible and beneficial, where short portions of text that can be tackled in small amounts of time.</p>\n\n\n\n<p>We end with a discussion on the ongoing projects being translated, such as Learn WordPress and Openverse, which aim to reach a larger audience and make WordPress education accessible in multiple languages. Piermario shares insights into the Italian WordPress community and the process of translating plugins and themes.</p>\n\n\n\n<p>So if you’re looking to help out translating WordPress, or are just interesting in hearing about a way you can contribute, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links.</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/polyglots/teams/\">Polyglots team</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/polyglots/handbook/for-locale-managers/rosetta-for-the-community/\">Rosetta</a></p>\n\n\n\n<p><a href=\"https://translate.wordpress.com/glotpress/\">GlotPress</a></p>\n\n\n\n<p><a href=\"https://translate.wordpress.org/\">Translating WordPress</a></p>\n\n\n\n<p><a href=\"https://openverse.org/\">Openverse</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://www.piermario.com/\">Piermario&#8217;s website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Oct 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Akismet: Lead Magnet Checklist: 12 Proven Steps &amp; Inspiring Examples\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=281108\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://akismet.com/blog/lead-magnet-checklist/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:32750:\"<p>Lead magnets are like the golden ticket to Willy Wonka&#8217;s Chocolate Factory. They&#8217;re the irresistible tease that offers specific value to a prospect. And, in exchange, they hand over their contact information. In other words, they generate leads.&nbsp;</p>\n\n<p>But creating an effective lead magnet is not just about slapping together a quick guide or checklist. It requires careful planning, an in&#8209;depth understanding of your target audience, and a keen eye for what makes your offer&nbsp;irresistible.</p>\n\n<p>And that&#8217;s where our lead magnet checklist will come in&nbsp;handy.</p>\n\n<p>We&#8217;ll walk you through 12 proven steps to create lead magnets that not only generate leads but also convert them into loyal customers. Then we&#8217;ll share some inspiring lead magnet examples to help you visualize the&nbsp;process.</p>\n\n<p>Let&#8217;s dive&nbsp;in.</p>\n\n\n<span id=\"more-281108\"></span>\n\n\n<h2 class=\"wp-block-heading\">1. Clearly define your target&nbsp;audience</h2>\n\n<p>The cornerstone of a successful lead magnet is a well&#8209;defined target audience. It&#8217;s not about appealing to everyone, but rather understanding and catering to a specific demographic that aligns with your&nbsp;offer.</p>\n\n<p>Start by identifying their challenges. What are the issues they&#8217;re grappling&nbsp;with?</p>\n\n\n<p>A study by <a href=\"https://www.salesforce.com/resources/research-reports/state-of-the-connected-customer/\" target=\"_blank\" rel=\"noreferrer noopener\">Salesforce</a> found that 56% of customers expect offers to be personalized and tailored to their needs, considering these qualities a must to win their business.&nbsp;</p>\n\n\n<p>So by fully understanding these pain points, you can tailor your lead magnets to offer a solution, making them more enticing to your&nbsp;audience.</p>\n\n<p>But you should pay attention to your customers&#8217; <em>interests</em> as well. What are they passionate about? What type of content do they engage with? Aligning your lead magnet with these interests can enhance its&nbsp;reception.</p>\n\n<p>Specificity is key here. As Seth Godin famously said, &#8220;Everyone is not your customer.&#8221; The more precise you are when defining your target market, the more effective your lead magnet offer will&nbsp;be.</p>\n\n<h3 class=\"wp-block-heading\">Example of a defined target&nbsp;audience</h3>\n\n<p>For instance, if you&#8217;re a WordPress security services company, your target audience is likely to be WordPress site owners worried about security. They might fear hacking, data loss, or website downtime and be interested in website management, digital security trends, and WordPress&nbsp;tips.</p>\n\n<p>A lead magnet offering a comprehensive guide to securing a WordPress site would likely resonate with this&nbsp;audience.</p>\n\n<p>Understanding your audience is pivotal in creating a high converting lead magnet. So, invest time in research and truly get to know&nbsp;them.</p>\n\n<h2 class=\"wp-block-heading\">2. Ensure your lead magnet solves a&nbsp;problem</h2>\n\n\n<p>The second step in our lead magnet checklist is to ensure it solves a real problem for your target audience —&nbsp;rather than just offering free stuff.&nbsp;</p>\n\n\n<p>Customers usually realize they have a problem before they actively start looking for a vendor to solve it. So, your early touchpoints shouldn’t be all about selling your company or listing product&nbsp;features.</p>\n\n<p>Instead, your lead magnet format should be designed to address these problems directly. It should offer a solution that is not only valuable, but also immediately actionable. The more effectively your lead magnets can solve a problem, the more likely your audience is to exchange their contact information for&nbsp;them.</p>\n\n<h3 class=\"wp-block-heading\">Example of a lead magnet that solves a&nbsp;problem</h3>\n\n<p>For instance, if you’re a marketer promoting website design services, your offer might be an easy&#8209;to&#8209;follow guide on creating a high&#8209;converting website. Not only does it solve a real problem for your target audience, but also provides an actionable solution they can implement right&nbsp;away.</p>\n\n<p>However, it&#8217;s not enough to just solve a problem. Your lead magnet should do so in a way that positions your product or service as the ultimate solution. This is where the concept of the &#8220;tripwire&#8221; comes&nbsp;in.</p>\n\n<p>A <a href=\"https://www.activecampaign.com/glossary/tripwire-marketing\" target=\"_blank\" rel=\"noreferrer noopener\">tripwire</a> is a low&#8209;cost offer that gets customers in the door, which can then lead to more significant sales down the line. Solving a problem with your lead magnet can set up a tripwire, showing your audience that you can provide value and solve their problems, which can then lead to them becoming paying&nbsp;customers.</p>\n\n<h2 class=\"wp-block-heading\">3. Offer information that’s not readily available&nbsp;elsewhere</h2>\n\n<p>In a world where information is just a Google search away, it&#8217;s vital to offer something unique to your audience. Your lead magnet should provide information that isn&#8217;t readily available elsewhere or presents it in a unique, more accessible, or more comprehensive&nbsp;way.</p>\n\n<p>According to a <a href=\"https://contentmarketinginstitute.com/2018/10/research-b2b-audience/\" target=\"_blank\" rel=\"noreferrer noopener\">study by the Content Marketing Institute</a>, 96% of highly successful content marketers stated that their audience considers their organization as a reliable and trustworthy source. They established this trust by creating unique and excellent quality content that is not available&nbsp;elsewhere.</p>\n\n<h3 class=\"wp-block-heading\">How to develop a reliable and trustworthy&nbsp;reputation</h3>\n\n<p>To build up such a reputation, you could offer an in&#8209;depth guide on a niche topic, a comprehensive case study with unique insights, or a proprietary tool or template that you&#8217;ve created. This exclusive content not only attracts your audience but also positions your brand as an industry&nbsp;expert.</p>\n\n<h2 class=\"wp-block-heading\">4. Create a strong, enticing&nbsp;headline</h2>\n\n<p>The headline of your lead magnet is often the first thing your audience sees, and it can make or break their decision to engage&nbsp;further.</p>\n\n<p>According to <a href=\"https://www.copyblogger.com/magnetic-headlines/\" target=\"_blank\" rel=\"noreferrer noopener\">Copyblogger</a>, on average, 8 out of 10 people will read headline copy, but only 2 out of 10 will read the rest. This underscores the importance of a compelling&nbsp;headline.</p>\n\n\n<p>Your headline should be clear, concise, and communicate the value of your lead magnet. It should tell your audience exactly what they&#8217;ll get and why it&#8217;s beneficial to them. A strong headline often includes a powerful action verb, a clear benefit, and a sense of urgency or scarcity.&nbsp;</p>\n\n\n\n<p><strong>Pro-tip: </strong>Sometimes, what works on social media may also grab attention on your site. Draw from your most successful social media ads when working on copy for your next set of great lead magnets.&nbsp;</p>\n\n\n<h3 class=\"wp-block-heading\">Example of a strong, enticing headline and effective lead&nbsp;magnet</h3>\n\n<p>Take a look at this example from education brand&nbsp;<a href=\"https://heggerty.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Heggerty</a>:</p>\n\n\n<img width=\"1600\" height=\"841\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-1.png\" alt=\"Heggerty homepage\" class=\"wp-image-281110\" />\n\n\n<p>Their website’s homepage features a compelling headline that’s simple, but captivating. It immediately summarizes what they can offer to their&nbsp;audience.</p>\n\n\n<p>But they also have a great offer on their banner that promotes a free download of special summer curriculum. It’s a great way to further develop their relationship with key prospects —&nbsp;educators in need to quality language curriculum.&nbsp;</p>\n\n\n<p>Remember the headline is where you make your first impression. So make it count by ensuring it&#8217;s compelling, clear, and communicates the value of your lead&nbsp;magnet.</p>\n\n<h2 class=\"wp-block-heading\">5. Encourage action with an irresistible&nbsp;CTA</h2>\n\n<p>A call to action (CTA) is the final nudge that propels the audience towards a desired action. It&#8217;s the climax of your content, the point where the audience decides to either engage further or move on. So it&#8217;s essential to get this right and make your CTA as irresistible as&nbsp;possible.</p>\n\n<p>There are multiple things you can do to craft an effective CTA. Let&#8217;s take a&nbsp;look.</p>\n\n<h3 class=\"wp-block-heading\">Be explicit and&nbsp;precise</h3>\n\n<p>Your CTA should be unambiguous and precise about the next steps. Instead of a generic &#8220;Learn more,&#8221; opt for specific phrases like &#8220;Download our free guide now&#8221; or &#8220;Start your free trial today.&#8221; This clarity can guide your audience towards the desired&nbsp;action.</p>\n\n<h3 class=\"wp-block-heading\">Instill a sense of&nbsp;urgency</h3>\n\n<p>A sense of urgency can prompt your audience to act immediately rather than delay. Phrases like &#8220;Limited time offer&#8221; or &#8220;Only a few spots left&#8221; can induce a fear of missing out (FOMO), encouraging immediate&nbsp;action.</p>\n\n<h3 class=\"wp-block-heading\">Employ persuasive&nbsp;language</h3>\n\n<p>The language of your CTA should be compelling. Use powerful command verbs like &#8220;Discover,&#8221; &#8220;Join,&#8221; or &#8220;Start&#8221; to persuade your audience to take&nbsp;action.</p>\n\n<h3 class=\"wp-block-heading\">Ensure it stands&nbsp;out</h3>\n\n<p>Your CTA should be visually prominent. Use contrasting colors, large fonts, and sufficient white space around your CTA to make it stand out on the&nbsp;page.</p>\n\n<h3 class=\"wp-block-heading\">Highlight the value&nbsp;proposition</h3>\n\n<p>Your audience is more likely to respond to your CTA if they perceive it as valuable. Emphasize the benefits they&#8217;ll receive by taking the desired&nbsp;action.</p>\n\n<p>The effectiveness of a CTA can significantly influence the success of your content marketing strategy, so spend time crafting and testing different CTAs to see what works best for your&nbsp;audience.</p>\n\n<h2 class=\"wp-block-heading\">6. Use bullet points to outline key benefits or&nbsp;features</h2>\n\n<p>Bullet points are a powerful tool in your lead magnet garage. They allow you to succinctly and clearly communicate the key benefits or features of your&nbsp;offer.</p>\n\n<p>But you&#8217;ll definitely want to keep them concise. Bullet points should be short and to the point. Avoid long, complex sentences. Your audience should be able to quickly scan the list and understand the value of your&nbsp;offer.</p>\n\n<p>And don&#8217;t use bullet points to lay out all the features of your offer. Focus on benefits instead. While features are important, what your audience really cares about is how your offer will benefit them. For example, instead of saying &#8220;Our eBook has 100 recipes,&#8221; say &#8220;Discover 100 meals that save time and impress&nbsp;guests.&#8221;</p>\n\n<p>Making use of action words is a must as well. Just as with your CTA, start your bullet points with action verbs to make them more engaging and persuasive. So phrases like &#8220;Boost your website traffic,&#8221; or &#8220;Transform your marketing strategy,&#8221; are good&nbsp;options.</p>\n\n<p>Vague promises won&#8217;t convince your audience to take you up on the offer. So be specific about what it includes. For example: &#8220;Learn the 5&#8209;step process to double your website traffic in 30&nbsp;days.&#8221;</p>\n\n<p>Finally, think about what makes your offer different from others. Highlight this in your bullet points to show your audience why your lead magnet is worth their&nbsp;time.</p>\n\n<h3 class=\"wp-block-heading\">The goal of bullet points when promoting a lead&nbsp;magnet</h3>\n\n<p>Your goal here is to quickly communicate the value of your lead magnet and convince your audience to commit. So, make your bullet points clear, compelling, and focused on the benefits your audience will&nbsp;receive.</p>\n\n<h2 class=\"wp-block-heading\">7. Include social proof to build&nbsp;credibility</h2>\n\n<p>When people see others doing something, they assume it&#8217;s the right thing to do and follow suit. This is called social proof. Even for a good lead magnet that’s already performing well, having social proof can make it more credible and&nbsp;appealing.</p>\n\n<p>You can incorporate social proof into most lead magnets in a number of ways,&nbsp;including:</p>\n\n\n<ul><li><strong>Testimonials</strong>. Include testimonials from satisfied customers who have benefited from your offer. Make sure these are specific and highlight the value of your lead magnet. For example, &#8220;This guide helped me double my website traffic in just 30&nbsp;days!&#8221;</li>\n\n<li><strong>Case studies</strong>. If applicable, include case studies that demonstrate the effectiveness of your offer. Case studies provide concrete evidence of your claims and can be very&nbsp;persuasive.</li>\n\n<li><strong>Endorsements</strong>. If your lead magnet has been endorsed or reviewed positively by industry experts, influencers, or reputable sources, be sure to highlight&nbsp;this.</li>\n\n<li><strong>User statistics</strong>. If you have impressive user statistics, such as a large number of downloads, subscribers, or active users, include these in your lead magnet. This shows that your offer is popular and trusted by&nbsp;many.</li>\n\n<li><strong>Certifications or awards</strong>. If your offer or your company has received any certifications or awards, these can serve as strong social&nbsp;proof.</li></ul>\n\n\n<h3 class=\"wp-block-heading\">An example of social proof when promoting a lead&nbsp;magnet</h3>\n\n<p>A great example of a few of these social proof tactics come from <a href=\"https://jayclouse.com\">Jay Clouse&#8217;s&nbsp;website</a>.</p>\n\n\n<img width=\"1000\" height=\"518\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-2.png\" alt=\"Jay Clouse website showcasing social proof\" class=\"wp-image-281111\" />\n\n\n<p>The home page includes some impressive user statistics, &#8220;Join 22,000+ creators&#8230;&#8221; as well as endorsements, &#8220;Called &#8216;Exceptional&#8217; by Weber, and &#8216;Delightful&#8217; by&nbsp;ConvertKit.&#8221;</p>\n\n<p>Social proof helps your audience see that others have found value in your offer, making them more likely to see its value, too. So, don&#8217;t be shy about showcasing your achievements and positive&nbsp;feedback.</p>\n\n<h2 class=\"wp-block-heading\">8. Create a sense of urgency or limited&#8209;time&nbsp;availability</h2>\n\n<p>Creating a sense of urgency or limited availability is a powerful psychological trigger that can significantly increase the conversion rate of your lead&nbsp;magnet.</p>\n\n<p>The simplest way to do this is to set up a limited&#8209;time offer. When you make your lead magnet available for a limited time, your audience may feel that they need to act quickly, or they&#8217;ll miss&nbsp;out.</p>\n\n<p>But you could opt for a limited quantity method instead. Both ways create a sense of exclusivity and&nbsp;urgency.</p>\n\n<p>Another option is to display a countdown timer to put the pressure on. A countdown timer visually represents the limited availability of your offer, creating a sense of urgency. You can use a countdown timer on your landing page or in your email&nbsp;marketing.</p>\n\n<p>And you can&#8217;t forget about the appeal of seasonal offers. If your lead magnet is tied to a specific season or event, this can naturally create a sense of urgency. For example, a &#8220;Holiday Marketing Guide&#8221; would naturally be limited to the holiday&nbsp;season.</p>\n\n<h3 class=\"wp-block-heading\">Scarcity is important, but authenticity is&nbsp;key</h3>\n\n<p>Creating urgency can encourage your audience to act quickly. However, it&#8217;s important to be genuine and not create false urgency, as this can damage your credibility. Always follow through on your promises and make sure your offer delivers value — no matter how long it&#8217;s&nbsp;available.</p>\n\n<h2 class=\"wp-block-heading\">9. Add an explainer video to engage&nbsp;users</h2>\n\n<p>Video content continues to dominate. According to research conducted by <a href=\"https://wyzowl.s3.eu-west-2.amazonaws.com/pdfs/Wyzowl-Video-Survey-2023.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">wyzowl</a>, consumers want to see more video content from a brand or business they support. Adding an explainer video to your lead magnet can increase engagement and help your conversion&nbsp;rate.</p>\n\n<p>Here&#8217;s how you can maximize your&nbsp;video:</p>\n\n\n<ul><li><strong>Keep it short and sweet</strong>. Your explainer video should be concise and to the point. Aim for a length of 1 to 2 minutes. Remember, the goal is to pique interest and encourage the viewer to download your lead magnet, not to provide a comprehensive&nbsp;overview.</li>\n\n<li><strong>Focus on benefits</strong>. Just like written content, your video should focus on the benefits of your offer, not just the features. What problem does your lead magnet solve? How will it improve the viewer&#8217;s life or&nbsp;business?</li>\n\n<li><strong>Include a clear call to action</strong>. At the end of your video, include a clear and compelling call to action. Encourage viewers to download your lead magnet and tell them exactly how to do&nbsp;it.</li>\n\n<li><strong>Make it professional</strong>. While you don&#8217;t need a Hollywood&#8209;level production, your video should be professional and high&#8209;quality. Poor audio or video quality can detract from your message and harm your&nbsp;credibility.</li>\n\n<li><strong>Optimize for mobile</strong>. Many of your viewers will be watching on mobile devices, so make sure your video is optimized for mobile&nbsp;viewing.</li></ul>\n\n\n<h3 class=\"wp-block-heading\">Why explainer videos are effective for promoting lead&nbsp;magnets</h3>\n\n<p>An explainer video is an opportunity to engage your audience differently and provide them with a quick, visual overview of your offer. Make it engaging, informative, and fun, and as long as it&#8217;s on&#8209;brand, you really can&#8217;t go wrong&nbsp;here.</p>\n\n<h2 class=\"wp-block-heading\">10. Offer a sneak peek preview to entice&nbsp;users</h2>\n\n<p>Giving your audience a sneak peek of your lead magnet&#8217;s content can be a powerful way to entice them to sign up. It&#8217;s like letting them take a test drive before they commit to the full&nbsp;product.</p>\n\n\n<p>You can make the most of your sneak peek preview by implementing the following:&nbsp;</p>\n\n\n\n<ul><li><strong>Choose a high&#8209;value section</strong>. You don’t have to start at the beginning. Choose a section of your lead magnet that provides high value and showcases the quality of your content. This could be a particularly insightful chapter, a useful checklist, or a compelling case&nbsp;study.</li>\n\n<li><strong>Make it accessible</strong>. Provide this sneak peek in an easily accessible format. This could be a downloadable PDF, a video walkthrough, or even a blog post behind a membership&nbsp;wall.</li>\n\n<li><strong>Highlight the value</strong>. Make sure it&#8217;s clear to your audience what value they&#8217;re getting from this sneak peek. What will they learn? How will it benefit&nbsp;them?</li>\n\n<li><strong>Include a call to action</strong>. At the end of your sneak peek, include a clear call to action encouraging your audience to sign up for the full lead magnet. Remind them of the additional value they&#8217;ll get by signing&nbsp;up.</li></ul>\n\n\n<h3 class=\"wp-block-heading\">Example of a sneak preview that promotes a lead&nbsp;magnet</h3>\n\n<p>You can implement this in a number of ways, but one option is to tease the free preview as a sidebar or slide&#8209;in element. On the <a href=\"https://angerman.online/product/healing-anger-transforming-anger-into-growth-ebook/\" target=\"_blank\" rel=\"noreferrer noopener\">Moose Anger Management website</a>, they offer a free preview of an eBook about &#8220;healing&nbsp;anger&#8221;.</p>\n\n\n<img width=\"1000\" height=\"516\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-3.png\" alt=\"sneak preview lead capture example\" class=\"wp-image-281112\" />\n\n\n<p>When someone clicks the red button on the left hand side of the screen, an opt&#8209;in form slides into view where they can input their name and email address to review the free&nbsp;download.</p>\n\n<p>A sneak peek gives your audience a risk&#8209;free way to experience the value of your lead magnet. If they like what they see, they&#8217;ll be much more likely to sign up for the full&nbsp;offer.</p>\n\n<h2 class=\"wp-block-heading\">11. Keep your opt&#8209;in form short and&nbsp;simple</h2>\n\n<p>The opt&#8209;in form is the gateway between your audience and your lead magnet. If it&#8217;s too long or complicated, you risk losing potential&nbsp;leads.</p>\n\n<p>To do keep your forms short and sweet, you&nbsp;can:</p>\n\n\n<ul><li><strong>Ask only for the essentials</strong>. The more information you ask for, the less likely people are to complete your form. Stick to the essentials, like name and email address. If you need more information for your marketing efforts, consider asking for it after they&#8217;ve signed&nbsp;up.</li>\n\n<li><strong>Keep your messaging to&#8209;the&#8209;point</strong>. Make sure it&#8217;s clear what your audience is signing up for. Use straightforward language and avoid&nbsp;jargon.</li>\n\n<li><strong>Make it fast to complete</strong>. The quicker your form is to complete, the more likely people are to do it. Use pre&#8209;filled fields, dropdown menus, and checkboxes to make it as easy as&nbsp;possible.</li>\n\n<li><strong>Test your form on mobile devices</strong>. Many of your audience members will be accessing your form on a mobile device. Make sure your form is easy to complete on a small&nbsp;screen.</li>\n\n\n<li><strong>Include a privacy statement</strong>. Reassure your audience that their information is safe with you. Include a brief privacy statement or link to your full privacy policy.&nbsp;</li>\n</ul>\n\n\n<h3 class=\"wp-block-heading\">Why your opt&#8209;in forms should be&nbsp;short</h3>\n\n<p>The goal of your opt&#8209;in form is to convert website visitors into leads. So by keeping it short, simple, and user&#8209;friendly, you&#8217;ll maximize your chances of&nbsp;success.</p>\n\n<h2 class=\"wp-block-heading\">12. Avoid using CAPTCHA in your opt&#8209;in&nbsp;form</h2>\n\n<p>It’s common to see CAPTCHAs used on opt&#8209;in forms. They act as a security measure to distinguish human users from bots. And they serve a purpose in improving website security. But they also present several challenges that can negatively impact user experience and conversion&nbsp;rates.</p>\n\n\n<p>For starters, <a href=\"https://akismet.com/blog/do-captcha-and-recaptcha-protect-wordpress-sites-from-bots/\">CAPTCHA</a> can be challenging for those with visual impairments. Traditional CAPTCHA often involves identifying obscured text in an image, a task that is difficult for users who rely on screen readers to interpret web content.&nbsp;</p>\n\n\n<p>Screen readers, being machines, are unable to decipher text in an image, making CAPTCHA inaccessible to these&nbsp;users.</p>\n\n<p>A CAPTCHA can also create a <a href=\"https://akismet.com/blog/wordpress-captcha/\">frustrating user experience</a>. The distorted characters used in CAPTCHA can be hard to decipher, leading to false positives where real humans are incorrectly identified as bots. This can be particularly challenging for people with certain cognitive disorders, such as&nbsp;dyslexia.</p>\n\n<p>And that&#8217;s to say nothing of the fact that CAPTCHA can be easily bypassed with sophisticated bots, rendering the security measure ineffective. This means that, while it poses a challenge to human users, it may not effectively keep out the very bots it&#8217;s designed to&nbsp;deter.</p>\n\n<p>Combine all this with potentially slower page load times, and you&#8217;re likely to drive prospective customers away with all the&nbsp;inconveniences.</p>\n\n<h3 class=\"wp-block-heading\">An alternative to the dreaded&nbsp;CAPTCHA</h3>\n\n<p>But a powerful tool like <a href=\"https://akismet.com\">Akismet</a> can solve all of these problems! Akismet is an AI&#8209;powered spam filtering service that provides automatic spam protection without interrupting the user experience.&nbsp;.</p>\n\n\n<img width=\"1000\" height=\"545\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-4.png\" alt=\"Akismet homepage with information about the tool \" class=\"wp-image-281113\" />\n\n\n<p>Akismet works by checking all form submissions against its global database of spam to prevent your site from accepting or publishing malicious content. It can effectively <a href=\"https://akismet.com/blog/best-anti-spam-wordpress-plugins-compared/\">block spam submissions</a> without the need for CAPTCHA, thereby improving the user experience and potentially leading to higher conversion&nbsp;rates.</p>\n\n<p>While CAPTCHA serves a purpose, its negative impact on user experience and conversion rates cannot be overlooked. And with a powerful alternative like Akismet that offers a more user&#8209;friendly solution, why wouldn&#8217;t you choose to use&nbsp;it?</p>\n\n\n<p>Of all the tools that can improve your existing content to generate more leads, this may just be the most powerful.&nbsp;</p>\n\n\n<h2 class=\"wp-block-heading\">Real&#8209;world examples of powerful lead&nbsp;magnets</h2>\n\n<p>Do you need inspiration for creating an effective lead magnet? Below are some powerful lead magnet examples used by real&#8209;world&nbsp;businesses.</p>\n\n<h3 class=\"wp-block-heading\">1. Gravy for the&nbsp;Brain</h3>\n\n\n<img width=\"1000\" height=\"735\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-5.png\" alt=\"lead capture from Gravy for the Brain \" class=\"wp-image-281154\" />\n\n\n<p>The <a href=\"https://usa.gravyforthebrain.com/business-book-download/\">Gravy for the Brain</a> website is devoted to helping voice over artists establish careers for themselves through courses, webinars, and mentoring forums. They also offer a business eBook as one of their lead magnets to encourage people to sign up for additional&nbsp;tips.</p>\n\n<h3 class=\"wp-block-heading\">2. The Art of Aaron&nbsp;Blaise</h3>\n\n\n<img width=\"1000\" height=\"586\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-6.png\" alt=\"lead capture from the Art of Aaron Blaise\" class=\"wp-image-281155\" />\n\n\n<p>Another unique lead magnet idea comes from an offer on <a href=\"https://creatureartteacher.com/bears/\" target=\"_blank\" rel=\"noreferrer noopener\">The Art of Aaron Blaise</a>. Blaise is an artist who offers animation lessons, drawing tutorials, and digital painting courses. To encourage people to sign up for his email list, he currently offers a lead magnet consisting of a free &#8220;How to Draw Elephants&#8221; PDF and Photoshop sketching&nbsp;brushes.</p>\n\n<h3 class=\"wp-block-heading\">3. Digital&nbsp;Trombone</h3>\n\n\n<img width=\"1000\" height=\"571\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-7.png\" alt=\"lead capture from Digital Trombone\" class=\"wp-image-281156\" />\n\n\n\n<p>Great lead magnet ideas can be leveraged for every niche and specialty. Just take a look at the <a href=\"https://www.digitaltrombone.com/newsletter-sign-up-free-trombone-course\" target=\"_blank\" rel=\"noreferrer noopener\">Digital Trombone</a> website. Trombone player and instructor, Anders Larson, offers a free 10-day trombone course when you sign up for his newsletter.&nbsp;</p>\n\n\n<h2 class=\"wp-block-heading\">FAQs about lead&nbsp;magnets</h2>\n\n<h3 class=\"wp-block-heading\">1. What is a lead magnet, and why is it important for my&nbsp;business?</h3>\n\n\n<p>A lead magnet is a valuable resource that businesses offer to potential customers in exchange for their contact information, typically an email address. This resource could be an eBook, a checklist, a webinar, or any other piece of content that provides value.&nbsp;</p>\n\n\n<p>Lead magnets are great for businesses because they help build an email list of potential customers that you can nurture into paying customers. They also allow businesses to provide value upfront, establishing trust and&nbsp;credibility.</p>\n\n<h3 class=\"wp-block-heading\">2. What are the key components of an effective landing page for my lead&nbsp;magnet?</h3>\n\n\n<p>An effective landing page for your lead magnet should have a compelling headline, a brief but persuasive description of the lead magnet, a clear and enticing call-to-action (CTA), and an easy-to-complete opt-in form.&nbsp;</p>\n\n\n<p>It&#8217;s also beneficial to include social proof, such as testimonials or case studies, to build credibility. The page should also be visually appealing and easy to&nbsp;navigate.</p>\n\n<h3 class=\"wp-block-heading\">3. How can I optimize my opt&#8209;in form to maximize&nbsp;conversions?</h3>\n\n<p>To maximize conversions, keep your opt&#8209;in form short and simple. It should absolutely be just one page. Ask for only the essential information, typically just an email address. Make sure your CTA is clear and compelling, encouraging users to submit their information. And avoid using CAPTCHA, as it can create a barrier for users and potentially decrease&nbsp;conversions.</p>\n\n<h3 class=\"wp-block-heading\">4. How can I add spam protection to my opt&#8209;in&nbsp;form?</h3>\n\n\n<p>You can add spam protection to your opt-in form by using a service like Akismet —&nbsp;a <a href=\"https://akismet.com/features/\">spam filtering service</a> that checks all form submissions against its global database of spam. It can effectively block spam submissions without the need for CAPTCHA, improving the user experience and potentially leading to higher conversion rates.</p>\n\n\n\n<img width=\"1600\" height=\"830\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-8.png\" alt=\"Akismet landing page with the text \" />\n\n\n<h3 class=\"wp-block-heading\">5. What is Akismet, and how can it help with form conversion&nbsp;rates?</h3>\n\n\n<p>Akismet is a spam filtering service that skips the use of CAPTCHAs and can provide a more user-friendly solution to form security. It works by checking all form submissions against its global database of spam to prevent your site from accepting or publishing malicious content.&nbsp;</p>\n\n\n<p>This can help prevent false positives and minimize user frustration, especially from those with visual or cognitive impairments, or who find CAPTCHAs&nbsp;confusing.</p>\n\n<h3 class=\"wp-block-heading\">6. What types of companies generally use&nbsp;Akismet?</h3>\n\n<p>Akismet is trusted by a wide range of companies, from small businesses to <a href=\"https://akismet.com/enterprise/\">large enterprises</a>. It&#8217;s used by over 100 million sites worldwide, including trusted brands like Microsoft, <a href=\"https://akismet.com/blog/convertkit-customerstory/\">ConvertKit</a>, and Bluehost. These companies rely on Akismet to protect their forms from spam, providing a better user experience and helping to maximize conversion&nbsp;rates.</p>\n\n<h2 class=\"wp-block-heading\">Akismet: Non&#8209;intrusive anti&#8209;spam for lead capture&nbsp;forms</h2>\n\n\n<p>Lead magnets are a powerful tool for attracting quality leads and growing your email list. While there’s no such thing as a perfect lead magnet, following the tips in this article can get you pretty close.&nbsp;</p>\n\n\n<p>However, the effectiveness of your lead magnets will be significantly influenced by the user experience you provide. From the clarity of your target audience definition to the strength of your headline, every detail&nbsp;matters.</p>\n\n<p>One crucial aspect that often gets overlooked is the user experience of your opt&#8209;in form. CAPTCHA, while designed to protect your forms from spam, can often create barriers for genuine users, leading to frustration and lower conversion&nbsp;rates.</p>\n\n<p>That&#8217;s where Akismet can save the day. As a trusted spam filtering service used by over 100 million sites worldwide, Akismet offers a user&#8209;friendly solution to form security. It effectively blocks spam submissions without the need for CAPTCHA, providing a smoother user experience and higher conversion&nbsp;rates.</p>\n\n<p>So, if you&#8217;re looking to optimize your lead magnet and maximize your conversion rates, <a href=\"https://akismet.com/pricing/\">consider Akismet</a> for your form security. It&#8217;s a quick change that could make a big difference in your lead generation&nbsp;efforts.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Oct 2023 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"WPTavern: Contentious Review Process Leads Ollie Theme to Remove Innovative Onboarding Features, Amid Stagnating Block Theme Adoption\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"https://wptavern.com/contentious-review-process-leads-ollie-theme-to-remove-innovative-onboarding-features-amid-stagnating-block-theme-adoption\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14629:\"<p>Mike McAlister, creator of the <a href=\"https://olliewp.com/\">free Ollie theme</a>, will be dropping the innovative onboarding features from the theme in favor of putting them into a separate plugin after <a href=\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\">facing pushback during the review</a> for inclusion in WordPress.org&#8217;s Themes Directory.</p>\n\n\n\n<p>During what McAlister described as an &#8220;unnecessarily contentious&#8221; <a href=\"https://themes.trac.wordpress.org/ticket/149883\">review process</a> that turned unproductive and combative at certain points, and where he even <a href=\"https://twitter.com/carolinapoena/status/1707128165808713756?s=20\">became the target of subtweets</a> from a dissenting reviewer, his team decided it was not the right time to move forward with getting the whole experience approved as originally planned.</p>\n\n\n\n<p>McAlister published his decision to WordPress&#8217; Theme Review Slack channel:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>We’re going to forgo putting the onboarding feature into the Ollie theme for .org.</p>\n\n\n\n<p>While we appreciate the flexibility and open-mindedness to considering an exception for it, ultimately, it seems like it might not be the right time on the directory.</p>\n\n\n\n<p>Maybe in the future the directory has a more defined path for experiments like this, but right now it has a potential to be a burden to reviewers and other theme developers. Not to mention a very lively (and sometimes unnecessarily contentious) discussion that distracts from the excitement and positivity around block themes and Ollie. We don’t want that! That’s a lot of energy we could be using to bring something like this to core one day.</p>\n\n\n\n<p>Until then, we’re figuring out what the next steps are, but it looks like we’re going to continue with Ollie on the directory (sans onboarding) while we figure out how to deliver the onboarding experience via a plugin mechanism.</p>\n</blockquote>\n\n\n\n<p>McAlister&#8217;s decision comes as a surprise after he received the green light from WordPress project leader Matt Mullenweg, who encouraged Ollie&#8217;s approval as an experiment, and WordPress Executive Director Josepha Haden Chomphosy, who <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1696000530445789\">attempted to embolden McAlister towards giving the experiment a chance</a>. He also found the support of several forward-thinking members of the Themes team and much of the wider community.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">The rules are based on prior data, when something novel or new comes up that resonants with users we should be willing to try something else, even the opposite of what we did before, to make a new decision. Fine to allow 1-3 themes like this through and observe.</p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/1707794756468896068?ref_src=twsrc%5Etfw\">September 29, 2023</a></blockquote>\n</div>\n\n\n\n<p>&#8220;I would not be a good steward of our community of users if I didn’t suggest that getting the whole thing into the repo so it’s easy to find and use is the best experience for them,&#8221; Chomphosy said.</p>\n\n\n\n<p>&#8220;There’s some risk to adding it as-is to the repo. But the potential upside, I think, is pretty substantial.</p>\n\n\n\n<p>&#8220;If we’re not wanting to include it because we are worried that in the future we won’t have the skills to review more of them, then that’s not exactly the theme’s problem. That’s something where we should equip our reviewers for the future as best we can.&#8221;</p>\n\n\n\n<p>She also suggested another option where the theme moves forward without removing the onboarding while contributors work towards WordPress core creating a standard for providing better onboarding experiences. </p>\n\n\n\n<p>&#8220;We get the theme in (including the onboarding) and in parallel start a feature plugin process to move the onboarding to be Core-first,&#8221; Chomphosy said.</p>\n\n\n\n<p>&#8220;That’s bold, I realize. But also, I did tell the entire hosting community at Cloudfest that if they wanted to one thing to help WP succeed, it was &#8216;better onboarding&#8217; and if they wanted to do two things, the second was &#8216;better time to launch.”</p>\n\n\n\n<p>Putting the onboarding solution into a plugin would reduce the long-term burden of maintenance and create a lower risk of failure from the theme, as Merlin WP themes onboarding wizard creator Rich Tabor <a href=\"https://twitter.com/richard_tabor/status/1707775941466837232\">contends</a>, but nobody knows how long it will be before core can offer a standard solution. By then WordPress may have missed many opportunities to seamlessly onboard more block theme users. </p>\n\n\n\n<p>Chomphosy&#8217;s suggestion of going ahead with the experiment in the theme while simultaneously working on a core solution allows theme authors to use training wheels to keep the momentum of block theme adoption going until a better, more elegant solution is available in core. </p>\n\n\n\n<p>WordPress leadership&#8217;s public approval was critical in this instance after the unwelcoming experience McAlister had in trying to get his free theme approved for the directory. He cited other factors regarding negative perception that influenced his decision.</p>\n\n\n\n<p>&#8220;There is a lot of subtle and not so subtle pressure from some higher visibility folks that feel strongly that this shouldn’t be in a theme,&#8221; McAlister said. &#8220;And I don’t want those relationships to degrade as a result of how this might play out.&#8221;</p>\n\n\n\n<p>McAlister said he is still interested in bringing the onboarding experience to WordPress.org as a plugin, where it can be studied and experimented with, but isn&#8217;t sure how soon that can happen given the long delays in plugin reviews. The current queue has 1,247 plugins awaiting review, with wait time for an initial review at 103+ days.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Evolving Theme Reviews: WordPress.org Must Stop Alienating Innovators While Block Theme Adoption Is Stagnating</h3>\n\n\n\n<p>Although WordPress leadership was quick to respond in support of experimentation, recalcitrant plugin reviewers, clinging to antiquated rules written for Classic Themes, had already driven Ollie&#8217;s innovation away with their chilly, unfriendly reception.</p>\n\n\n\n<p>Mullenweg has historically communicated his support for experimenting with themes on multiple occasions, encouraging developers to do novel things with WordPress that may not fit within the guidelines. In 2015, he went so far as to <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1432861605003292\">say</a>, &#8220;I am completely okay with having something in the directory that breaks every guideline, as long as it’s interesting.&#8221;</p>\n\n\n\n<p>A few months later in 2015, he <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1438195918001732\">recommended the review team</a> &#8220;try to think of it as a more general opening up to interesting things that might not fit the guidelines but are novel and warrant inclusion in our directory.&#8221; </p>\n\n\n\n<p>At that time, Mullenweg encouraged the team to step back and examine the submission process and the directory in a new way that would encourage creativity among theme authors with fewer guidelines and restrictions.</p>\n\n\n\n<p>A fundamental culture change is necessary for this team and long overdue. It should be a matter of urgency at this point, given the tone of reviewers in <a href=\"https://themes.trac.wordpress.org/ticket/149883\">Ollie&#8217;s trac ticket</a>. Theme reviews should bend more towards enabling innovators instead of preserving familiar processes. The response to theme authors trying new things should be friendly and helpful, especially when those new things stand to greatly benefit users. The process should not be burdensome to creators who are trying to offer their work for free.</p>\n\n\n\n<p>&#8220;As I mentioned earlier in the thread, another important note is that our vision for the onboarding — some of the features that people loved about it — were removed during this long review process,&#8221; McAlister said. &#8220;So even if it went live today, it doesn’t quite reach its maximum potential as is. And if we started adding some of those features back, I feel we’d be mired in more back and forth.&#8221;</p>\n\n\n\n<p>This situation should be a wake up call for the review team, as WordPress&#8217; best product creators are watching to see how this plays out when considering where to distribute their best work.</p>\n\n\n\n<p>A recent spreadsheet created by Munich-based digital agency owner Hendrik Luehrsen <a href=\"https://docs.google.com/spreadsheets/d/11X38e9w86XcgT4tybqfjKhrL0PIbDlIsUEJwLiKtJ7Q/edit#gid=931695972\">tracks the usage of themes with the FSE tag</a>. It shows that WordPress block theme adoption is stagnating, if not in full decline. In September 2023, the total number of active installs for block themes declined for the first time since Luehrsen started tracking. The average installs by theme are also slowly and steadily declining. This could be related to the growth of the number of FSE themes available, as active installs would presumably be spread across more themes, but the number of FSE themes is growing at a glacial pace.</p>\n\n\n\n<p>&#8220;I would say it’s too early to assume definitive decline,&#8221; Luehrsen said. &#8220;But we’re most certainly not growing the FSE usage.&#8221;</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1978\" height=\"536\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-03-at-8.57.21-PM.png\" alt=\"\" class=\"wp-image-149806\" />\n\n\n\n<p>&#8220;Having run a number of block theme training courses, I&#8217;m not at all surprised,&#8221; Pootlepress founder Jamie Marsland <a href=\"https://twitter.com/pootlepress/status/1707820106556867027?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1707835806763622467%7Ctwgr%5E36cba479119394838ab431c2ac491926810ecd2b%7Ctwcon%5Es2_&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-admin%2Fpost.php%3Fpost%3D149749action%3Dedit\">said</a>. &#8220;Until Block Themes get easier to use for beginners, my guess is the numbers won&#8217;t change significantly. The dev team should try running a training course and see for themselves.&#8221;</p>\n\n\n\n<p>Marsland recently <a href=\"https://www.pootlepress.com/2023/09/wordpress-block-themes-versus-classic-themes/\">interviewed</a> McAlister, discussing some of the reasons for the slow uptake in block themes. Their adoption is hindered by a lack of effective marketing for their innovative features as well as the complexities involved in creating a block theme that fully supports everything a user can imagine doing with the block editor.  McAlister highlighted the necessity to create more user-friendly experiences and the importance of onboarding and better education for those using and making block themes.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"embed-vimeo\"></div>\n</div>\n\n\n\n<p>&#8220;I’m not kidding when I’m saying it’s in all our interests to start making sure this becomes better soon,&#8221; Joost de Valk <a href=\"https://twitter.com/jdevalk/status/1707835806763622467?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1707835806763622467%7Ctwgr%5E36cba479119394838ab431c2ac491926810ecd2b%7Ctwcon%5Es1_&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-admin%2Fpost.php%3Fpost%3D149749action%3Dedit\">said</a> in response to the latest figures from the spreadsheet tracking FSE usage. &#8220;WP stands to lose market share if we don’t get better soon.&#8221;</p>\n\n\n\n<p>With block themes struggling to gain adoption, WordPress should be doing everything it can to enable any block theme that improves the user experience, especially in the absence of a core solution for onboarding. It&#8217;s important to remember that when major versions of WordPress are released, the only people who can take advantage of the latest and greatest editor features are those whose sites are using a block theme. After three years, WordPress.org block theme installs only account for 1.7 million sites out of an estimated <a href=\"https://colorlib.com/wp/wordpress-statistics/\">810 million</a>.</p>\n\n\n\n<p>&#8220;As someone who has been trying to get block themes to be adopted by a wider audience from early, I feel onboarding/switching to block themes is a big hurdle for users still,&#8221; ElmaStudio co-creator Ellen Baer <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1696321112372359?thread_ts=1696000530.445789&cid=C02RP4Y3K\">said</a> in the conversation in the Theme Review Slack channel.</p>\n\n\n\n<p>&#8220;I personally would love to see a core solution, a standarized way that all block theme users can get familiar with. I feel unfortunately while building the site editor experience this point has been missing and block theme authors are seeing the user struggling to get started.</p>\n\n\n\n<p>&#8220;I feel a bit sad that a positive innovation that helps block themes and the site editor to gain more momentum (which is what we really need) is dragged into a discussion that seemed at least from the outside not to be a productive or positive one at times.&#8221;</p>\n\n\n\n<p>McAlister&#8217;s attempt to improve WordPress.org theme users&#8217; onboarding experience was unsuccessful but he inadvertently highlighted some areas where the culture and process around theme reviews has stagnated and become counterproductive. This failure shed light on the need for a more dynamic, user-centric approach, as well as a reassessment of the current guidelines by which the team appears to be bizarrely and inextricably bound despite years of encouragement to experiment.</p>\n\n\n\n<p>&#8220;There is a deep, deep desire for evolution of the theme directory,&#8221; McAlister said. &#8220;I think we’ve always known this, but after wading through weeks of commentary, it’s clear to me that we’ve neglected it far too long. The theme pages should be at least as good as the plugin pages, the theme demos aren’t selling the value of themes, etc.</p>\n\n\n\n<p>&#8220;The hardline approach and the echos of longstanding esoteric debates need relaxing. Users largely don’t care about the theme vs plugin debate, they want to design and publish faster. That’s not to say we throw these things out, but we have to ask if they’re serving WordPress users in the ways we think they are.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Oct 2023 03:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 6.4 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8146:\"<p>WordPress 6.4 Beta 2 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 2 in four ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.4-beta2</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a> to increase participation and partnership with those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> and tune into <a href=\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\">Episode 63 of the WP Briefing podcast</a> for details.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How to get involved with testing</h2>\n\n\n\n<p>Your help testing the WordPress 6.4 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/blob/a854e6e7a2a49a6b1ec5ef377c756a30e1c7ac5a/lib/experimental/fonts/font-library/README.md\">Font Library feature</a>, currently available in <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">Gutenberg 16.7</a>, requires more testing and feedback to ensure it is ready for inclusion in the upcoming 6.4 release. <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">Check out this guide for detailed test instructions</a>.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 2</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 2 contains more than 50 updates since the Beta 1 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=09%2F27%2F2023..10%2F03%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">18 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=09%2F27%2F2023..10%2F03%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">Closed Trac tickets since Beta 1</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Note on Twenty Twenty-Four</h3>\n\n\n\n<p>Please note that some images in the Twenty Twenty-Four theme may not load correctly. A fix is in the works! Learn more on this <a href=\"https://core.trac.wordpress.org/ticket/59526\">Trac ticket</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Note on pattern management improvements in non-block themes</h3>\n\n\n\n<p>While WordPress 6.4 will bring several exciting pattern advancements, improvements to pattern management in non-block themes will eventually be addressed in WordPress 6.5. The <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Beta 1 announcement</a> has been updated to reflect this change accordingly.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p>Not the first, nor last<br />A second space to reflect<br />Both new and not new</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/priethor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>priethor</a>, <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ironprogrammer</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 17:25:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: An Inside Look at WordCamp Sponsorships with Jason Rouet and Jon Ang\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/an-inside-look-at-wordcamp-sponsorships-from-jason-rouet-and-jon-ang/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:456:\"<p>Jason and Jon open the blackbox to share their experiences and insights on flagship WordCamp Asia and Europe sponsorships.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/an-inside-look-at-wordcamp-sponsorships-from-jason-rouet-and-jon-ang/\">An Inside Look at WordCamp Sponsorships with Jason Rouet and Jon Ang</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 12:02:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WPTavern: WordPress Global Sponsorship Program Raises Costs for 2024 to Support Expanding In-Person Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149761\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://wptavern.com/wordpress-global-sponsorship-program-raises-costs-for-2024-to-support-expanding-in-person-events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p>WordPress&#8217; Community team has <a href=\"https://make.wordpress.org/community/2023/09/28/proposed-2024-global-community-sponsorship-program/\">proposed a draft for the 2024 Global Community Sponsorship Program</a>, with fees increased to cover the costs of the rapidly expanding number of in-person events.</p>\n\n\n\n<p>The program supports the volunteer-organized local events so that they can provide free or low-cost access for attendees. It helps companies streamline their sponsorship contributions across multiple events with less administrative overhead than it would be to sponsor individual WordCamps. The program does not include flagship events such as WordCamps Europe, Asia, and US.</p>\n\n\n\n<p>Fees have gone up since 2023 for all three sponsorship packages: Gold, Silver, and Bronze, which offer varying degrees of visibility at in-person WordPress events.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<table><tbody><tr><td></td><td>Gold</td><td>Silver</td><td>Bronze</td></tr><tr><td>2023</td><td>$130,000</td><td>$95,000</td><td>$80,000</td></tr><tr><td>2024</td><td>$145,000</td><td>$115,000</td><td>$90,000</td></tr></tbody></table>\n\n\n\n<p>The 2021 and 2022 programs <a href=\"https://wptavern.com/wordpress-global-sponsorship-program-will-not-include-wordcamps-for-2022\">did not include funding for WordCamps</a>, due to the unpredictability of hosting in-person events when the pandemic made conditions unfavorable in many places across the world. At that time many WordCamp and meetup organizers opted to continue with virtual events. </p>\n\n\n\n<p>In 2023, WordPress events are ramping back up again. Automattic-sponsored community contributor Isotta Peira said the number of in-person events has increased by 60% compared to 2022, and they expect Next Gen events will keep the program growing into 2024. So far 15 pilot events have been confirmed for the new Next Gen format, with 11 of them happening in 2023.</p>\n\n\n\n<p>&#8220;As a result of the Meetup Reactivation project that started in July 2022 and ended in June 2023, 270 dormant Meetups started hosting events again,&#8221; Peira said. &#8220;Today, we have 729 WordPress Chapter Meetups in 107 countries and over 500,000 members globally. In the first 7 months of 2023, the WordPress Community has held 27 WordCamps, and another 29 are scheduled before year-end.&#8221;</p>\n\n\n\n<p>The proposal highlighted a few stats demonstrating the strong resurgence of community events: </p>\n\n\n\n<ul>\n<li>36 local WordCamps held in 2023 to date, with 25 more scheduled before year end</li>\n\n\n\n<li>173% increase in WordCamps since last year: 60 WordCamps anticipated to be held in 2023, compared to 22 in 2022</li>\n\n\n\n<li>729 meetup groups across 107 countries</li>\n\n\n\n<li>507,796 meetup group members, program-wide</li>\n\n\n\n<li>2,998 meetup events scheduled in 2023 to date, and over 340 more scheduled through the end of the year</li>\n</ul>\n\n\n\n<p>The uptick in events is the direct result of the Community team&#8217;s efforts in 2023 to reactivate dormant meetup groups, bring back in-person WordCamps, and evolve the WordCamp program to make room for new event types.</p>\n\n\n\n<p>Companies that are interested to support WordPress&#8217; burgeoning events program can get on board for 2024 by emailing <a href=\"mailto:support@wordcamp.org\">support@wordcamp.org</a> before November 30, 2023. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 03:14:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 12.0.0-beta3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=331464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2023/10/buddypress-12-0-0-beta3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3035:\"<p>Hello BuddyPress contributors!</p>\n\n\n\n<p>If you haven&#8217;t tested our two first beta releases (<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> please read <a href=\"https://buddypress.org/2023/08/buddypress-12-0-0-beta1/\">this post about beta1</a>), please consider testing this <strong>third and last</strong> beta release. Beta testing is the best way to make sure the final release will fit perfectly into your WordPress / BuddyPress specific configuration. 12.0 is introducing a very important change about how BuddyPress URLs are built, analyzed and routed and more than ever we need your help to reach this important milestone for the plugin.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-2 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.12.0.0-beta3.zip\">Test BuddyPress 12.0.0-beta3</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s new since <a href=\"https://buddypress.org/2023/09/buddypress-12-0-0-beta2/\">beta2</a>?</h2>\n\n\n\n<p>We&#8217;ve fixed 4 bugs and improved the BuddyPress URLs settings screen help area.</p>\n\n\n\n<p><strong>12.0.0 is slated to October 30</strong>, thanks in advance to all the contributors who will give us a hand to get there <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f60d.png\" alt=\"😍\" class=\"wp-smiley\" />.</p>\n\n\n\n<p>You can test <a href=\"https://downloads.wordpress.org/plugin/buddypress.12.0.0-beta3.zip\">BuddyPress 12.0.0-beta3</a> in 4 ways :</p>\n\n\n\n<ul>\n<li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/bp-beta-tester/\">BP Beta Tester</a>&nbsp;plugin.</li>\n\n\n\n<li><a href=\"https://downloads.wordpress.org/plugin/buddypress.12.0.0-beta3.zip\">Download the beta here (zip file)</a>.</li>\n\n\n\n<li>Check out our SVN repository:&nbsp;<code>svn co https://buddypress.svn.wordpress.org/trunk/</code></li>\n\n\n\n<li>Clone our read-only Git repository:&nbsp;<code>git clone git://buddypress.git.wordpress.org/</code></li>\n</ul>\n\n\n\n<p>If you find something weird, please report it on&nbsp;<a rel=\"noreferrer noopener\" href=\"https://buddypress.trac.wordpress.org/newticket\" target=\"_blank\">BuddyPress Trac</a>, post a reply to&nbsp;<a href=\"https://buddypress.org/support/topic/lets-prepare-the-buddypress-12-0-0-next-major-release/\">this support topic</a>&nbsp;or get in touch with us on our&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.slack.com/messages/buddypress\" target=\"_blank\">WordPress.org Slack channel</a>.</p>\n\n\n\n<p>Happy testing <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f469-1f3fb-200d-1f4bb.png\" alt=\"👩🏻‍💻\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f9d1-1f3fe-200d-1f4bb.png\" alt=\"🧑🏾‍💻\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 02:56:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Matt: Preserving Harvard’s Blogging History\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=99750\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://ma.tt/2023/10/preserving-harvards-blogging-history/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3221:\"<p>This month, <a href=\"https://automattic.com/\">Automattic</a> had the privilege of working with the <a href=\"https://cyber.harvard.edu/\">Berkman Klein Center for Internet &amp; Society (BKC)</a> to migrate their early 2000s blogging platform over to our <a href=\"https://pressable.com/a-quick-guide-to-wordpress-multisite-what-you-need-to-know/\" target=\"_blank\" rel=\"noreferrer noopener\">Pressable</a> infrastructure. (Pressable is a small host Automattic runs to develop our <a href=\"https://wp.cloud/\">WP.cloud</a> infrastructure, it gets you all the performance and security of our high-end WP.com plans, but with a more plain-vanilla WP interface.)</p>\n\n\n\n<p>The Harvard Blogs network that the Center launched back in 2003 was an important milestone in internet history. It provided a platform for over 1,500 high-impact bloggers—including Harvard students, faculty, fellows, staff, and alumni—to publish and engage in discussion.</p>\n\n\n\n<p>We were alerted to BKC’s plans to decommission&nbsp;<a href=\"http://blogs.harvard.edu/\" target=\"_blank\" rel=\"noreferrer noopener\">blogs.harvard.edu</a>&nbsp;by none other than&nbsp;<a href=\"http://scripting.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Dave Winer</a>, the pioneering developer behind blogging, RSS, and podcasting, and a Berkman Center fellow from 2003-2004. As BKC shared in&nbsp;<a href=\"https://archive.blogs.harvard.edu/blog/2023/03/02/blogs-harvard-edu-shutting-down/\" target=\"_blank\" rel=\"noreferrer noopener\">their announcement</a>, the network played a formative role for many now-influential bloggers and internet figures. It also contributed to the rise of podcasting and projects like&nbsp;<a href=\"https://www.ushahidi.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Ushahidi</a>.</p>\n\n\n\n<p>When we learned BKC planned to retire the Harvard Blogs platform, we wanted to ensure this valuable archive of early internet culture was preserved. We offered to host the network’s blogs indefinitely so they can remain publicly accessible for years to come.</p>\n\n\n\n<p>The Harvard Blogs multisite consisted of around 1,500 blogs. To move it over, we systematically migrated the archive to our servers and then upgraded the network to the latest version of WordPress (we also updated a handful of plugins and themes and tested the updated versions against the original sites hosted by Harvard).</p>\n\n\n\n<p>Much like our recent unveiling of the&nbsp;<a href=\"https://wordpress.com/blog/2023/08/25/introducing-the-100-year-plan/\" target=\"_blank\" rel=\"noreferrer noopener\">100 Year Plan</a>&nbsp;for&nbsp;WordPress.com, the preservation of the&nbsp;<a href=\"https://archive.blogs.harvard.edu/\" target=\"_blank\" rel=\"noreferrer noopener\">Harvard Blogs archive</a>&nbsp;demonstrates Automattic’s commitment to protect vital pieces of internet history and culture for generations to come. By preserving these blogs, we hope to inspire future generations of online voices.</p>\n\n\n\n<p>There was something really nice about the neighborhood of blogs the Harvard blog network provided that I hope they or another university tries again sometime. Harvard is now 387 years old, I hope these blogs last at least that much longer (that would be 2,410 AD!).</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 00:53:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Gravatar: New Gravatar Hovercards: Faster, Open-Source, and Everywhere\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.gravatar.com/?p=722\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://blog.gravatar.com/2023/10/02/new-gravatar-hovercards-faster-open-source-and-everywhere/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2147:\"<p>Hovercards offer a sleek, interactive way to showcase user profiles. With just a hover over the Gravatar image, a card displays essential information about the user. This eliminates the need to navigate away from the current page and encourages engagement.</p>\n\n\n\n<img width=\"800\" height=\"433\" src=\"https://gravatar.files.wordpress.com/2023/10/gravatar-hover2.gif\" alt=\"\" class=\"wp-image-736\" />\n\n\n\n<p>A new open-sourced Gravatar Hovercards library is live for users of&nbsp;<a href=\"https://href.li/?https://WordPress.com\">WordPress.com</a>&nbsp;and&nbsp;<a href=\"https://href.li/?https://jetpack.com\">Jetpack</a>, and is available to be implemented by anyone around the web. Here’s what’s new:</p>\n\n\n\n<ul>\n<li><strong>Leaner and faster:</strong>&nbsp;By pruning redundant code and harnessing modern web APIs, we’ve achieved greater efficiency and reduced file sizes by more than 200%.</li>\n\n\n\n<li><strong>Improved UX:</strong>&nbsp;The hovercard design is more refined and will work better across sites with different styles and branding. The library now&nbsp;<a href=\"https://href.li/?https://github.com/gravatar/hovercards#placement-string--right\">supports different placements</a>&nbsp;to cater to a variety of needs.</li>\n\n\n\n<li><strong>Universal hovercards:</strong>&nbsp;The new library introduces the ability to attach hovercards to any element, not just the avatar image. For example, a site can @someone and show the hovercard on hover.</li>\n\n\n\n<li><strong>Open to the world:</strong>&nbsp;Developers can integrate it into their sites via the&nbsp;<a href=\"https://href.li/?https://www.npmjs.com/package/@gravatar-com/hovercards\">NPM package</a>.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p>If you aren&#8217;t seeing hovercards on your WordPress site, go to <strong>Settings -&gt; Discussion</strong> and look for the setting to enable pop-up business cards. You will need to be hosted on WordPress.com or have the free Jetpack plugin installed. </p>\n\n\n\n<p>We encourage you to explore Gravatar hovercards, and welcome your ideas and contributions via our <a href=\"https://href.li/?https://github.com/gravatar/hovercards\">GitHub repo</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Oct 2023 12:55:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WordPress.org blog: WP Briefing: Episode 63: A WordPress 6.4 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40977:\"<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest Sarah Norris, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br />Guest: <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a><br />Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo: <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production: <a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br />Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>TwentyTwentyFour <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Theme</a> \n<ul>\n<li><a href=\"https://github.com/WordPress/twentytwentyfour\">Repo</a></li>\n\n\n\n<li><a href=\"https://www.figma.com/file/AlYr03vh4dVimwYwQkTdf6/Twenty-Twenty-Four?type=design&node-id=16-14852&mode=design\">Figma File</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/51132\">Image Lightbox Github</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\">Upcoming WordPress Meetings</a> for Contributors</li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li>Find announcements for WordPress 6.4 Beta at:\n<ul>\n<li><a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#Core</a> Slack Channel</li>\n\n\n\n<li><a href=\"https://wordpress.org/news/\">WordPress.org/news/</a></li>\n</ul>\n</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/06/documentation-translation-localization/\" target=\"_blank\">Proposal: Documentation translation/localization</a></li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/09/20/seeking-proposals-for-interop-2024/\" target=\"_blank\">Seeking proposals for Interop 2024</a>&nbsp;&#8211; Interop 2024 is happening! WordPress developers, please contribute your proposals for 2024&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/web-platform-tests/interop/issues/new/choose\" target=\"_blank\">on GitHub</a>&nbsp;or as a comment on this post.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/15/wordcamp-us-2023-qa/\" target=\"_blank\">WordCamp US 2023 Q&amp;A</a> &#8211; With a successful WCUS in the books, an extensive list of post-event questions and answers are available and inspired by the event&#8217;s community and <a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=3Fa0Q-brSeI\" target=\"_blank\">Q&amp;A</a>.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/2023/09/13/accessibility-office-hours/\" target=\"_blank\">Accessibility Office Hours</a>&nbsp;&#8211; In an effort to improve accessibility knowledge in the WordPress project,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/\" target=\"_blank\">the accessibility team</a>&nbsp;will hold Office Hours every Wednesday at 14:00 UTC</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16050\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project some insight into the community that supports it. And get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> I have with me today, Sarah Norris. She is the Core Tech Editor in the WordPress 6.4 release. Welcome, Sarah.</p>\n\n\n\n<p>[00:00:47] <strong>Sarah:</strong> Oh, hi, and thanks for having me.</p>\n\n\n\n<p>[00:00:50] <strong>Josepha:</strong> First, I should give everyone kind of a concept of what we&#8217;re doing.</p>\n\n\n\n<p>So this is the WordPress 6.4 sneak peek episode of our podcast, which means that we&#8217;re going to talk a little bit about like the stuff that we are excited to get into the release stuff that we&#8217;re hoping is actually going to make it into the final release. But also, we&#8217;re going to talk a little bit about like stuff that we wish people knew.</p>\n\n\n\n<p>That we were working on. Things that are going to be really cool for users or developers or plugin authors, theme authors, things like that, that otherwise people would miss because it&#8217;s just hard to see. And so before we get started on all of that, is this your first release where you&#8217;re part of a squad like this?</p>\n\n\n\n<p>[00:01:31] <strong>Sarah:</strong> Ah, so, it&#8217;s actually my second. I was part of 6.1 as well. I led the default theme of 2023. But I am finding that the experience is a little bit different. So I&#8217;m still learning probably just as much.&nbsp;</p>\n\n\n\n<p>[00:01:42] <strong>Josepha:</strong> Yeah, absolutely. Well, and in 6.1 versus 6.4, for one, the themes are very different. Like the default themes are very different, but also the tasks involved with leading a default theme are very different from like leading things happening in the core editor in that Gutenberg plugin.</p>\n\n\n\n<p>[00:02:01] <strong>Sarah:</strong> Yeah, there&#8217;s so many different tasks. Yeah, like, I guess maybe there&#8217;s such, there&#8217;s maybe just like a set of tasks for every part of the release squad. But they&#8217;re so different. And much more involved.</p>\n\n\n\n<p>[00:02:12] <strong>Josepha:</strong> Yeah, absolutely. And as of the time of this recording, we&#8217;re recording this on September 27th. It comes out a little bit later. But as of the time of this recording, like we just wrapped up beta 1 for WordPress 6.4 yesterday. But I understand that, like an hour ago, you wrapped up a final release of the Gutenberg plugin as well.</p>\n\n\n\n<p>So you&#8217;re just kind of everywhere with us right now.</p>\n\n\n\n<p>[00:02:36] <strong>Sarah:</strong> Yeah, that&#8217;s exactly right. Yeah, we tried to make the beta 1 for 6.4 and the latest release of Gutenberg quite close together to make it easier to, to merge those latest changes for beta 1 of 6.4. So yes, that&#8217;s why it&#8217;s so close together, and fingers crossed, they both went really smoothly, so I&#8217;m really happy about that.</p>\n\n\n\n<p>[00:02:53] <strong>Josepha:</strong> Now we all sit around and watch the support queues and hope. That part, the sitting around and watching the support queues, is both my most favorite and least favorite sometimes part of releases. Like, it&#8217;s a little bit my most favorite because I get to talk to our support folks. I&#8217;m like, hey, is anything happening? But also, it&#8217;s my least favorite because it&#8217;s like the Schrödinger&#8217;s cat of releases. You&#8217;re like, as long as I don&#8217;t look at it, it could be all well or all bad, and I just don&#8217;t know.</p>\n\n\n\n<p>[00:03:23] <strong>Sarah:</strong> I hear you. I&#8217;ve just been doing something similar with watching test releases.</p>\n\n\n\n<p>[00:03:27] <strong>Josepha:</strong> Yeah. Just waiting and waiting and waiting. Yeah, absolutely. Absolutely.</p>\n\n\n\n<p>Well, let&#8217;s talk a little bit about 6.4. So WordPress 6.4 is our third major release of 2023, which is kind of a big deal for one because, like, three major releases a year is always exciting. But this particular one is, on the one hand, much larger from a feature standpoint than we kind of expected it to be, or so far, it looks like it&#8217;s going to be a bit larger than we expected.</p>\n\n\n\n<p>But also, it is our second iteration of an underrepresented gender release squad. Which I am very excited about. It&#8217;s a way for us to kind of bring in a lot of voices that otherwise we don&#8217;t see in the space. And so we&#8217;re going to just kind of talk through both of those things today. But let&#8217;s start with first: what are the things that are going into the release that you personally are most excited about, that you are most interested in making sure that we get all the way to the end of the release cycle?</p>\n\n\n\n<p>[00:04:27] <strong>Sarah:</strong> So, ones that I am particularly excited for. So, the first one on my list is the Font Library. This is looking really good to include as well. So it&#8217;s gonna do your way for users to manage fonts across their site regardless of their active themes. So similar how to how their media library works at the moment for images and other media.</p>\n\n\n\n<p>[00:04:44] <strong>Josepha:</strong> And if I recall correctly when I was looking at the prototypes for that, like the early demos of it, that has a lot of local font management as well, which helps us with GDPR concerns that we have had with font management in the CMS for a while. One, is that still correct? And two, does it look like it&#8217;s going to make it into the release?</p>\n\n\n\n<p>[00:05:04] <strong>Sarah:</strong> Yes. Yeah. Both correct. Yes. Yeah. Very easy. Yeah, that&#8217;s exactly right. So yeah, all the fonts will be managed locally. So, including things like Google Fonts. And any of the popular libraries and the way it&#8217;s been built, as it calls its files like this, it&#8217;s been built with extensibility in mind. So yeah, hopefully, the possibility should be endless for any number of font collections to be added.</p>\n\n\n\n<p>[00:05:23] <strong>Josepha:</strong> Yeah. Yeah. I, I know, for folks who are listening to this later, hopefully not much later, but if you are listening to this between when beta 1 came out and between and beta 2 is coming out, we didn&#8217;t get as much of that into beta 1 as we expected, but beta 2 should have a good chunk of it in there.</p>\n\n\n\n<p>So get out there and test that.</p>\n\n\n\n<p>[00:05:43] <strong>Sarah:</strong> It&#8217;s also just been released with Gutenberg 16.7 as well. So, I guess for anyone that you just mentioned listening in between.&nbsp;</p>\n\n\n\n<p>[00:05:51] <strong>Josepha:</strong> I&#8217;m one of those folks that has not; I don&#8217;t run trunk because I&#8217;m not that good with like preventing WordPress from falling apart. I&#8217;m not a developer, but I do run the nightlies and for the major releases for Core, and I run also the beta of Gutenberg. And so, I got both updates done this morning and started going in and looking at everything because I don&#8217;t run trunk. I didn&#8217;t have some of the weird edge cases that I saw reported over the last few weeks, which is probably good.&nbsp;</p>\n\n\n\n<p>[00:06:21] <strong>Josepha:</strong> But also, if anyone&#8217;s running trunk and is running all of the nightlies of anything, let us know where the problems are because there are not a lot of you. It feels like, like, a thousand people in the particular combination. What else is in there that you are very excited to see?</p>\n\n\n\n<p>[00:06:37] <strong>Sarah:</strong> I&#8217;m also looking forward to, so we have a new feature called Block Hook, and for anyone who follows Gutenberg, you might have heard it&#8217;s called Auto Inserting Blocks, but we&#8217;ve renamed it to Block Hook. And yes, this is another powerful feature that expands the extensibility of block themes. And so it allows plugins to automatically insert blocks into content relative to another block.</p>\n\n\n\n<p>And so, a good example that we&#8217;ve been using is automatically adding a like button to the post content block. And so yeah, I think it&#8217;s a, it&#8217;s maybe a more developer-centric feature.&nbsp;</p>\n\n\n\n<p>[00:07:09] <strong>Josepha:</strong> So, like, it detects what block you have and suggests bits and pieces that otherwise would make sense there that other people are usually using in those blocks.</p>\n\n\n\n<p>[00:07:20] <strong>Sarah:</strong> Yeah. Yeah. So you can add all through JSON as well. You can add a block that will automatically be added.</p>\n\n\n\n<p>[00:07:25] <strong>Josepha:</strong> All right. Excellent. That was part of the Interactivity API, or is, is early parts of it rather, I guess.</p>\n\n\n\n<p>[00:07:35] <strong>Sarah:</strong> Yes, that&#8217;s right. Yeah. Yeah. It&#8217;s the start.</p>\n\n\n\n<p>[00:07:39] <strong>Josepha:</strong> Another thing that is a part of the Interactivity API, which we&#8217;ve been working on, folks. I think everybody knows for like a year or two. The other part that is shipping in 6.4 is, I think, the Lightbox for images. Is that right?</p>\n\n\n\n<p>[00:07:55] <strong>Sarah:</strong> Yes, that&#8217;s right. Yes. And yeah, that&#8217;s due to be included with 6.4 as well.</p>\n\n\n\n<p>[00:07:59] <strong>Josepha:</strong> I&#8217;m going to just tell us all a weird story. So, for maybe my entire life, like I understand what a lightbox is from a image and photography standpoint, but for the majority of my life, I thought that lightbox referred to those like big initial letters in old manuscripts. I don&#8217;t actually know what those are called if not lightboxes, but in my mind, that&#8217;s what they were.</p>\n\n\n\n<p>[00:08:22] <strong>Josepha:</strong> And so when we first started talking about this, I was like, that&#8217;s what we&#8217;re shipping is like the drop capital letter, like the big one, but it&#8217;s not. In case anyone else also was confused about what a lightbox is, it&#8217;s the image-based concept of a lightbox.</p>\n\n\n\n<p>[00:08:37] <strong>Sarah:</strong> I think it&#8217;s an important one because previously you would have to install, maybe a third-party plugin or, or build lightbox yourself so. It may sound like a, oh, it&#8217;s a tiny feature that&#8217;s been included, but it&#8217;s actually pretty awesome. You don&#8217;t have to include even more extra code.&nbsp;</p>\n\n\n\n<p>[00:08:51] <strong>Josepha:</strong> Speaking of things that we have been working on for two years or so, I think that every sneak peek for the last year, the folks of WordPress have heard me say that I was super excited about navigation and how we&#8217;re managing it, but it turns out that is a very complicated thing. Like we know that, managing menus, managing navigation on a site is complicated from just like a philosophical standpoint. When our users of WordPress, when consumers of WordPress like go through that process, that is the hardest one to explain. And therefore, very hard to manage as well.&nbsp;</p>\n\n\n\n<p>We have had like a requirement that you know three different admins in order to manage your menu, manage your navigation on your site, but we shipped some early components for it in 6.3 and in 6.4. I believe that we are planning; I&#8217;m crossing my fingers no one can see it, crossing my fingers. We&#8217;re planning on getting an updated treatment for the toolbar out. Is that correct?</p>\n\n\n\n<p>[00:09:53] <strong>Sarah:</strong> Yes, yeah, I was a little bit worried because I didn&#8217;t know too much in detail, but I did know about the toolbar. So, yes, yes, I believe that is planned to get into 6.4.</p>\n\n\n\n<p>[00:10:01] <strong>Josepha:</strong> Yeah. So, and the point of that, because for folks who have not tried this out yet, the point of that is that the navigation is kind of, when you look at it, individual components, it&#8217;s like a bunch of little blocks together, and then we wrap it as like a collection that shows up as the navigation block, but because it&#8217;s a bunch of little blocks and each of the little blocks has their own like toolbar that goes with it, it took a lot of work to kind of figure out how to get all of those toolbars to have a primary expression with the navigation. Versus like every single thing that you put into your navigation has its own toolbar, and good luck to you.</p>\n\n\n\n<p>[00:10:44] <strong>Sarah:</strong> Yeah, it&#8217;s a really, really complicated problem, and I guess maybe it always has been, and hopefully we just keep improving and all the time, and we probably never will stop improving because it&#8217;s, yeah, it&#8217;s just such a complicated thing to edit, and I think particularly in an editor without using any code.</p>\n\n\n\n<p>[00:11:00] <strong>Josepha:</strong> Yes.</p>\n\n\n\n<p>[00:11:01] <strong>Sarah:</strong> We&#8217;re getting there, it always, it always is getting better.</p>\n\n\n\n<p>[00:11:04] <strong>Josepha:</strong> Yeah. Before we move into the question of like things that you wish people knew about the release that maybe they&#8217;re not going to know, I do want to stop and talk about the default theme a little bit. Everyone loves the default theme at the end of the year. But every year, Matt and I talk about, like, what would it look like if we didn&#8217;t have a default theme.</p>\n\n\n\n<p>What if we just were like, all themes are great. Just do whatever you want, which seems too difficult, frankly. But the way that this default theme is envisioned is so different. It&#8217;s got basically three different focuses. Do you know much about this year&#8217;s default theme?</p>\n\n\n\n<p>[00:11:41] <strong>Sarah:</strong> Yeah, a little bit, so I, yeah, I know, I don&#8217;t know, I think it&#8217;s shaping up to be a really good starting point for so many different types of projects. So, I know that that is maybe the aim of every default theme. But we usually show off a lot of the features that are going into the release, like via the default theme.</p>\n\n\n\n<p>I know we did that last time as well, but this time, we&#8217;re doing that stealth. But we&#8217;re also creating like a great baseline for so many different types of projects. And I think maybe in the past, we&#8217;ve maybe only hit like one type of project. And, like, this is a good example for this one very specific thing.</p>\n\n\n\n<p>But yeah, this time, I know that that&#8217;s always like, especially working with other themers, they&#8217;re like, what&#8217;s the best base theme for this type of thing? And I&#8217;m hoping Twenty Twenty-Four is going to be the new answer for so many people.</p>\n\n\n\n<p>[00:12:23] <strong>Josepha:</strong> Yeah, yeah, I looked at the early designs for that with the, because what it has, and these, we&#8217;ll put a link to this in the show notes to the repo about it and the Figma file and all those things. But what it has is like a really robust set of default patterns for anyone who&#8217;s wanting to have like a big commercial site with a lot of things that are required, a really complicated site. Then we have a suite of default patterns that are shipping so that artists and people who are focused primarily on visual assets on their site have the specific patterns and blocks and things required for that and then one that is specific to people who focus on the content in their site.</p>\n\n\n\n<p>I am one of the people who specifically focuses on the content in the site. I was delighted to see that, but it kind of has three different levels of varying complexity based on what it is that people might, might want to have to, oh, not want to have to, might want to be able to do on their sites. And I think that&#8217;s kind of cool.</p>\n\n\n\n<p>[00:13:31] <strong>Sarah:</strong> Yeah. Yeah. It&#8217;s super cool. And I think while we&#8217;re still in the development cycle as well, for 6.4, this is a; the default theme is a great way to jump into contributing if people are looking for good ways to jump in.</p>\n\n\n\n<p>[00:13:44] <strong>Josepha:</strong> Yeah, it runs in a separate repo. And so it has a little bit of a different process, but also it feels like a little bit of a faster process. It kind of runs independently of the release cycle that we have for either the plugin or core. And so it kind of goes a bit faster.</p>\n\n\n\n<p>[00:14:03] <strong>Sarah:</strong> Yes.</p>\n\n\n\n<p>[00:14:05] <strong>Josepha:</strong> Yeah. Excellent. So, then, obvious next question. What Is happening in this release that you wish people knew about?</p>\n\n\n\n<p>[00:14:15] <strong>Sarah:</strong> Yep. Okay. So, I think maybe things that are difficult to fit into the bigger categories that will be easy to shout about when we talk about the release when it&#8217;s been released. There&#8217;s a lot of accessibility enhancement that are going to be included. So there&#8217;s things like better button placements and upgraded spoken messages, especially in site health.</p>\n\n\n\n<p>There&#8217;s also so many performance improvements that are scheduled to be included, so I know there was many performance improvements included in 6.3. We are continuing that for 6.4. There&#8217;s many more improvements to block themes and classic themes in the way the templates are loaded. And we&#8217;ve also got a we&#8217;re including a usage of the new defer and async loading strategies as well for script.</p>\n\n\n\n<p>So these are sort of like, nitty-gritty detail sort of things that will be included that don&#8217;t sound too exciting but are actually really, really cool.&nbsp;</p>\n\n\n\n<p>[00:15:07] <strong>Josepha:</strong> Yeah. I understand the whole like, this is not very exciting. This doesn&#8217;t sound interesting but trust me, it is like, sometimes it feels like half of my job is that I&#8217;m like, I know that nothing I&#8217;m about to say sounds cool, but trust me, it&#8217;s amazing. We&#8217;ve been working on it for a long time, and it&#8217;s cool.</p>\n\n\n\n<p>That&#8217;s great. That&#8217;s great. And so. For those things, it sounds like a lot, this is going to particularly be of interest to folks who are developing for other people using WordPress. But also obviously a little bit of, of benefit, maybe invisible benefit, but still benefit for our end users as we go.</p>\n\n\n\n<p>[00:15:46] <strong>Sarah:</strong> Yeah, yeah, that&#8217;s right, exactly.</p>\n\n\n\n<p>[00:15:48] <strong>Josepha:</strong> So those are kind of the sneak peek items that we&#8217;ve got going into the release. As always, with this particular episode, we&#8217;re not promising that any of those things will 100 percent for sure get in there. There is part of being a release squad that kind of doesn&#8217;t really get talked about outside of WordPress but is probably worth mentioning, which is that the release squad has the really unpleasant job of saying no at the last second for things that are breaking something, things that are not actually a better user experience.</p>\n\n\n\n<p>Like we have the uncomfortable job of saying like, no, it wasn&#8217;t good enough. Sorry, thank you. Come again in the next release cycle. And so, like, all of these things are things that are currently in and being tested, but in the event that we discover it breaks 10 percent of the sites that we have on WordPress, like, we&#8217;re gonna, we&#8217;re gonna pull it.</p>\n\n\n\n<p>So, right now, that&#8217;s all in there, we hope, and if listening to me for a whole year get excited about the changes in navigation, and then also not getting them in didn&#8217;t teach you anything, just because I want it in doesn&#8217;t mean that I get to have it in either. So, but yeah, so that&#8217;s exciting. The other exciting thing about this release, we mentioned it a bit at the top of the discussion, is that it is a gender-upresented, gender-underrepresented release squad. Not upresented, because that is a, not a word. And so this is the second one. Did you participate in the first one?</p>\n\n\n\n<p>[00:17:22] <strong>Sarah:</strong> No, I didn&#8217;t no. Yeah, but I have read all about it, especially in prep to this release as well.</p>\n\n\n\n<p>[00:17:28] <strong>Josepha:</strong> Oh, did you learn anything from it that you brought into this one, or was it just like, I need to know what I&#8217;m getting into kind of reading a lot about it?&nbsp;</p>\n\n\n\n<p>[00:17:36] <strong>Sarah:</strong> Yeah, basically, yeah, I was trying to prep myself, ever since I was involved in 6.1, I&#8217;ve tried to be, I&#8217;ve tried to follow along closely with the releases. But sometimes, there&#8217;s just so much going on all the time. Sometimes it&#8217;s a little bit much. But yeah, I just wanted to see if there was any, any big differences.</p>\n\n\n\n<p>There shouldn&#8217;t be, right? So yeah, it&#8217;s all good.</p>\n\n\n\n<p>[00:17:54] <strong>Josepha:</strong> I think all of the differences were in that boring part where people don&#8217;t, they&#8217;re like, that sounds so un-fun, we&#8217;re going to just stop listening. But it was like, in the planning and preparation for it, and the way that we did all the training, like the initial one had like an 18 month period between like, we&#8217;re gonna do it, and now it&#8217;s done, where we did a lot of additional work to get everybody in there.</p>\n\n\n\n<p>[00:18:18] <strong>Josepha:</strong> And this time, we were like, get in here! That&#8217;s all we did. So, how has your experience been on the release squad? I know that you did one before. You did one in 6.1, but is this particular squad any different compared to your last experience of it, or what you expected?</p>\n\n\n\n<p>[00:18:35] <strong>Sarah:</strong> So, I would say everyone is equally as amazing as every release and, including the resource they&#8217;re involved with. I think that the biggest difference for me, and maybe this links to something you just said, is that I, I knew I was going to be involved in the release squad a lot earlier, especially compared to me for 6.1, but I think I&#8217;ve heard other people say that as well. So, I think that&#8217;s a great thing for this release. We all have had some time ahead of the release and including during this 6.3 release as well, so I was able to watch particular people in, not in a non-creepy way, and make sure I knew which, like what the processes were.</p>\n\n\n\n<p>Yes, to try and get my head around when when I&#8217;d be doing it. And, and obviously, the big help was that I&#8217;d be doing it immediately after they&#8217;d just done it as well. And the previous release squad has been a massive help as well when I&#8217;ve come across either very, very complicated issues or like super silly issues; I can write them and answer your questions so that I think if we could carry that forward with the future releases as well.</p>\n\n\n\n<p>[00:19:28] <strong>Josepha:</strong> Yeah, absolutely. So this time around, we had almost 50 percent new folks that that, like, let us know that they were participating, probably quite a few more than that. But, like, of the people who let us know that they wanted to participate in this release, we had like 28 out of 50 people, something like that, who are brand new to contributing to WordPress in some cases, but certainly, all of them are brand new to contributing to a major release like this. Have you, cause this is not your first time doing this, but it is your first time in this type of release. Have you found that, like, you&#8217;re feeling able to help new people see what&#8217;s happening also, like, do you feel seasoned enough for that? Or are you just like, nope, I&#8217;m also new.</p>\n\n\n\n<p>[00:20:17] <strong>Sarah:</strong> Maybe a little bit of both. I guess I, yeah, I&#8217;m fortunate to have at least experienced, maybe, like how the deadlines roll. Actually, especially the point we&#8217;re at at the moment, where the weekly beta cycles happened. Last time, it took me by surprise. I was like, oh wow, okay, we have a week. Until the next one, and then a week, and so yeah, I feel a bit more psyched up for that this time around.</p>\n\n\n\n<p>And hopefully, I can tap that on you to the new folks as well. But yeah, I also noticed we have a lot of new people. We have, especially from a core editor tech lead; I think we have nearly 30 people who are sort of officially following us along or shadowing us.</p>\n\n\n\n<p>So yeah, yeah, but it&#8217;s really cool. I hope we can teach so many more people if they want to get involved with the next release or even just contributing in general. Yeah, it&#8217;d be amazing.</p>\n\n\n\n<p>[00:21:00] <strong>Josepha:</strong> Yeah. If you are listening to our podcast, and you think to yourself, well, I&#8217;m here. And I wonder if anyone knows because I&#8217;m just watching everyone in a non-creepy way, like feel free at the next meeting that you&#8217;re watching to, to raise your hand and say, I&#8217;m new. We want to know that you&#8217;re there.</p>\n\n\n\n<p>Not because we feel creepy otherwise. But also because we just want to celebrate that you exist new folks that are scared of us. Don&#8217;t be scared of us.</p>\n\n\n\n<p>Oh, man, I feel compelled now to tell everybody about the first time that I led a core chat. So the core chat, I watched that without telling anyone I was watching it for like a year before I had to actually lead it, and I just didn&#8217;t tell anybody I was there like I didn&#8217;t even participate in the waving part at the start where it&#8217;s just like, Hey, everyone, I exist, like, when I was just silently watching it all go by and so when I got announced as part of a release squad. It was shocking for everyone, I think. And there is a public record of a moment where I was panicking. I felt like everyone was asking me a thousand questions, and I didn&#8217;t know the answers to any of them. And I just told all of them, like, there are a million of you and one of me, and you&#8217;re kind of scaring me, so would you stop?</p>\n\n\n\n<p>And so there&#8217;s a public record of me calling out every developer that existed in WordPress at the time. I felt bad about it in the moment, but also like, whew, that was, I don&#8217;t think we have experiences like that for new contributors anymore, but it was, it was quite a moment. I remember distinctly, so Jeffrey Paul, he&#8217;s like one of our, I think we have three or four like self-declared project managing people.</p>\n\n\n\n<p>He is a project manager person in WordPress that I really rely on, and I was DM&#8217;ing him in the background in a full panic. I was like, I don&#8217;t know the answer to any of these questions. What am I supposed to do? And he was like no is also an answer. So, like, just tell them no. Tell them you don&#8217;t know. That&#8217;s fine. And I was like, Oh, God! So, I think that we maybe don&#8217;t have too much of that happening anymore, but I also understand that I wouldn&#8217;t see it if it were happening. No one&#8217;s coming to me to be like, is this normal? Should I panic? They&#8217;re probably coming to you with that.</p>\n\n\n\n<p>[00:23:21] <strong>Sarah:</strong> I think it&#8217;s a sort of good, I&#8217;m not good for you, maybe, but good for observers especially. You know, to see you go through that as well. I can really relate to, like, not even showing, like, a wave emoji because I&#8217;ve totally been in that situation. I think maybe we&#8217;re similar in that regard, like, it, sometimes I just feel really nervous even just showing an emoji.</p>\n\n\n\n<p>And I think, again, shouting out about that and to, to those people who also feel like that, who are watching yeah, yeah, wave if you, if you feel like you want to, and don&#8217;t wave, it&#8217;s also fine just to watch.&nbsp;</p>\n\n\n\n<p>[00:23:48] <strong>Josepha:</strong> Once you&#8217;ve been to 52 meetings, then you can wave. Oh, it&#8217;s so hardworking in open source that way because, like, there is a lot of, like, basically faith in other people because trust comes with, like experiencing things together. But initially, you do just kind of have to have faith that no one&#8217;s going to laugh you out of the room or say that your ideas are stupid or that you are like even remotely understanding the problem, and so that&#8217;s a, it&#8217;s a part of the new contributor experience that I always find so interesting I used to routinely give presentations about like this is how you get started first get ready to be uncomfortable I don&#8217;t give those presentations very often anymore but probably probably I should ask someone to get out there and be like, It&#8217;s scary for everyone, including you!</p>\n\n\n\n<p>Come be scared together! Cause I think that&#8217;s important to normalize. Fear&#8217;s normal. When you first started contributing to WordPress in general, let alone like being on a release squad, what is the team that you first joined through?</p>\n\n\n\n<p>[00:25:02] <strong>Sarah:</strong> So, I guess, full-time contribution, it was themes. I was very involved with themes, and I still am as well; I really love themes, especially block themes. And also with the editor. But, like, years and years ago, I guess it was still themes. I used to build themes.</p>\n\n\n\n<p>But that was very much; I was a forum user, and well, actually, I guess it goes back to me being very nervous and not wanting to admit the question that I wanted to ask, so I would hunt the forums, but afterwards just so helpful.</p>\n\n\n\n<p>Like, yeah, I know this is a lot of people&#8217;s story, but yeah, the forums and just chatting amongst other community members is so, so helpful. So yeah, when I became a full-time contributor, I really, I love talking to other people who are trying to get help or, yeah, reaching out any way they can because I was like, I feel that I was you and still am you as well.</p>\n\n\n\n<p>[00:25:50] <strong>Josepha:</strong> I mean, the good thing about it, like, we will always feel like we&#8217;re learning something because we are, but in my experience of folks in WordPress, and I haven&#8217;t been new in a long time, obviously been doing this for like eight years now which is ancient by technology standards, but like my favorite thing about folks in WordPress is that they are wanting to like learn enough to probably not break it forever.</p>\n\n\n\n<p>Like it&#8217;s the probably is in there, and the forever is in there like I want to. I want to know just enough to be mildly dangerous and then bring everybody with me. Let&#8217;s go be dangerous together. And I think that is really charming in a way because it&#8217;s like we know enough to sort of break it. But not break it a lot.</p>\n\n\n\n<p>So let&#8217;s go see how we break it a little bit to make it better. I think that&#8217;s such a charming attitude for some reason because then we all just get to kind of learn and be a little bit messy together, which is the nature of openly collaborating on a half-written software—all the time. But yeah, I think it&#8217;s kind of neat.</p>\n\n\n\n<p>[00:27:05] <strong>Sarah:</strong> Yeah, yeah, exactly. It&#8217;s exciting too, like if you&#8217;re staying, you&#8217;ve got that enough red push and edge that you&#8217;re just like, Ooh, I might break something. But then there&#8217;s so many people that help you out that, you know, just before you could actually break something important.&nbsp;</p>\n\n\n\n<p>[00:27:18] <strong>Josepha:</strong> Exactly. The one time when I did a very breaking thing because I didn&#8217;t know to ask about it and fixed it immediately was that I mentioned in the middle of a core chat that we were about to have a security release. But it wasn&#8217;t about it wasn&#8217;t like in the next 15 minutes, it was like three weeks away, which is not what you&#8217;re allowed to do like you are not allowed to mention that you have a security release coming in three weeks, and then hope that nobody figures out what it&#8217;s patching.</p>\n\n\n\n<p>Yeah, I got so many messages in such a short amount of time from it felt like every lead developer of WordPress. That was my, my worst moment.</p>\n\n\n\n<p>And I fixed it immediately. So that was good. But also, I don&#8217;t remember if we had to like move up the, the timeline for that release or what. I don&#8217;t; I have no idea what the outcome was because I was just in an outright panic about what I had done incorrectly.</p>\n\n\n\n<p>Anyway, so that&#8217;s the; I&#8217;m just going to tell everybody my most embarrassing early contribution stories today. That&#8217;s what I&#8217;m doing. Excellent. Well, Sarah, before we head out of here, is there a final thought that you would like to share with either our listeners here or future potential contributors to WordPress?</p>\n\n\n\n<p>[00:28:37] <strong>Sarah:</strong> Please help test 6.4, especially through the next few cycles of beta. It would be amazing to have everyone and anyone who would like to help. That is one of the best ways you can help is to test. And then, yeah, if you want to get involved a little bit further, then yeah, I guess, please reach out wherever you think you fit, which I know sounds a bit fake, but there are a lot of different places, and I&#8217;m sure there will be somewhere you fit as well.</p>\n\n\n\n<p>00:28:59] <strong>Josepha:</strong> I will leave in the show notes a link to the page that has all of the upcoming meetings on it. You can probably go to almost any meeting and say, I think this is where I would like to contribute, but also, this is the kind of thing I can contribute, and they will be able to head you in the right direction if you&#8217;re not already in the right direction. But also, like, sometimes your skills that you have are going to be applicable in places where you&#8217;re not aware of yet. And so, go to any meeting—wave to the friendly WordPressers that are around, the Sarah Norrises that exist in the project.&nbsp;</p>\n\n\n\n<p>[00:29:36] <strong>Josepha:</strong> Sarah, thank you so much for joining me today. This was a delight.</p>\n\n\n\n<p>[00:29:39] <strong>Sarah:</strong> Thanks so much for having me on; I really enjoyed it.</p>\n\n\n\n<p>[00:29:42] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:29:42] <strong>Josepha:</strong> That brings us now to our small list of big things. First thing to know is that tomorrow we have Beta 2 for WordPress 6.4. This is our final release of the year, as you know because we&#8217;ve been talking about it for the entire episode. But, just like Sarah said at the end of our conversation, we absolutely need people to help us test it, make sure that it is working in as many places as possible so that we can have the best release possible. So keep an eye out on the core channel in the Making WordPress Slack, and of course, keep an eye on WordPress.org/news as those releases get packaged and ready to go.&nbsp;</p>\n\n\n\n<p>So the second thing is a proposal for documentation translation localization process update. This is an initial step to consolidate all of that documentation into a single easy-to-reach location. So we need some feedback on it. Head on over there, leave a comment to share your feedback about where that should possibly go, where is most useful and valuable for you.&nbsp;</p>\n\n\n\n<p>The second proposal that I have is actually sort of a tangentially related one, but so it&#8217;s not specific to WordPress but does need some WordPress input. There is a call for proposal for Interop 2024. There&#8217;s a post that has a lot more information about it than I do, but we would like for any WordPress developer who&#8217;s interested to head over there and submit a proposal for what they could speak about at Interop, I believe. You can leave your thoughts on the post itself as a comment, or there&#8217;s also a GitHub repo where you can interact as well.</p>\n\n\n\n<p>The next thing on our small list of big things is that the WordCamp US Q&amp;A, the questions that we didn&#8217;t get to because there were something like 87 or something in the queue. The questions that we didn&#8217;t get to, the answers have been posted. They&#8217;re over on make.WordPress.org/project, but I&#8217;ll include a link to those to that post in the show notes.&nbsp;</p>\n\n\n\n<p>And the final thing on the small list of big things, I&#8217;m actually quite excited about. We are hosting now accessibility office hours. In an effort to improve accessibility knowledge in the WordPress project in general, the accessibility team will be holding office hours every Wednesday at 14:00 UTC.</p>\n\n\n\n<p>That started on September 20th. And so it&#8217;s been going for a couple of weeks now. And the purpose is to make sure that we have a dedicated space and time to discuss accessibility principles and best practices as we go through those things.&nbsp;</p>\n\n\n\n<p>[00:32:29] <strong>Josepha:</strong> And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Hayden Chomphosy, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\n\n\n<p>[00:32:38] (Music interlude)&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"Gutenberg Times: WordPress 6.4 Beta, NASA now on WordPress, Gutenberg 16.7, HTML API, Interactivity API – Weekend Edition #270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=25812\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"https://gutenbergtimes.com/wordpress-6-4-beta-nasa-now-on-wordpress-gutenberg-16-7-html-api-interactivity-api-weekend-edition-270/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15980:\"<p>Howdy, </p>\n\n\n\n<p>2009 I was invited to NASA first Launch TweetUp for <a href=\"https://www.flickr.com/photos/birgitpauli-haack/albums/72157622738192415\">STS 129 with ca 150 other Tweeple</a>. We learned about the shuttle lunch, it&#8217;s mission, talked to engineers, astronauts, and administrators of NASA, and shared it with our followers on Twitter. It was certainly one of the most interesting weekends in my life. </p>\n\n\n\n<p>In 2009, I also started my personal WordPress journey, testing and prodding searching for a CMS for a nonprofit internet service provider. I started on an incredible journey into web development, community building and open-source. </p>\n\n\n\n<p>Now in 2023, those two life threads come together. After three years building up to it, <a href=\"https://www.nasa.gov/general/nasa-publishes-beta-flagship-science-websites-as-improvements-continue/\">NASA launched their new website built with WordPress</a>. Members of the Website Modernization were invited to give WordCamp US participants a <a href=\"https://www.youtube.com/watch?v=LpDulftMkew\">sneak preview</a> and discussed the journey to get there. If you haven&#8217;t watched them yet, there were great presentations on the work. What a great way to showcase WordPress! WordPress and I have come a long way together. </p>\n\n\n\n<p>Other block editor and builder news are below. Enjoy! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-theme-development-for-full-site-editing-and-blocks\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong><a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">WordPress 6.4 Beta 1</a></strong> was released, and is ready for testing. There are two calls for testing, you can follow: </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Help Test WordPress 6.4</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\">FSE Program Testing Call #26: Final touches</a></li>\n\n\n\n<li>Damon Cook wrote <a href=\"https://wpengine.com/builders/beta-testing-wordpress-local-blueprints/\"><strong>Beta Testing WordPress with Local Blueprints</strong></a></li>\n</ul>\n\n\n\n<p><strong>Sarah Gooding</strong> also reported on the release for the WPTavern: <a href=\"https://wptavern.com/wordpress-6-4-beta-1-released\"><strong>WordPress 6.4 Beta 1 Released</strong></a>, with a short summary of all the great new features that will come to a WordPress instance near you. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his <strong><a href=\"https://make.wordpress.org/design/2023/09/25/design-share-sep-11-sep-22/\">Design Share: Sep 11-Sep 22</a>,</strong> <strong>Joen Asmussen</strong> highlighted the fabulous work of the WordPress design team: </p>\n\n\n\n<ul>\n<li>A second iteration for the WordPress Pattern Directory, features a refined submission flow and a new &#8220;Pattern Bundle&#8221; feature. You can navigate through a clickable prototype on Figma. </li>\n\n\n\n<li>Ongoing work in Pagination Design</li>\n\n\n\n<li>An Enterprise Notice on the WordPress site so link to a page about the &#8220;State of Enterprise for WordPress&#8221; guide. </li>\n\n\n\n<li>More exploration on organizing the Command Palette displays. </li>\n\n\n\n<li>A polished modal on Mobile</li>\n</ul>\n\n\n\n<p>Comment or contribute. </p>\n\n\n\n<a href=\"https://make.wordpress.org/design/2023/09/25/design-share-sep-11-sep-22/\"><img width=\"652\" height=\"360\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-30-at-14.59.59.png?resize=652%2C360&ssl=1\" alt=\"Pattern bundles shown in the Design share post \" class=\"wp-image-25831\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Norris</strong>, Editor Tech co-lead for WordPress 6.4, also was the release lead of Gutenberg 16.7 and published the release post to let you know<strong> <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">What’s new in Gutenberg 16.7? (27 September)</a></strong>. She highlighted a ton of features: <br /></p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/?p=108291#font-management-with-the-font-library\">Font Management with the Font Library</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#import-export-of-patterns\">Import/Export of Patterns</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#explore-new-pattern-filtering\">Explore New Pattern Filtering</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#naming-group-blocks-in-the-editor\">Naming Group Blocks in the Editor</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#my-patterns-category-reinstated-in-post-editor-inserter\">“My Patterns” Category Reinstated in Post Editor Inserter</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#simplified-lightbox-functionality-for-images\">Simplified Lightbox Functionality for Images</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#background-image-control-added-to-group-block\">Background Image Control Added to Group Block</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#new-social-link-icon-for-x\">New Social Link Icon for X</a></li>\n</ul>\n\n\n\n<a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/#font-management-with-the-font-library\"><img width=\"652\" height=\"376\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/fonts.png?resize=652%2C376&ssl=1\" alt=\"Font management screenshot \" class=\"wp-image-25833\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</a> with Tammie Lister as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/dcook\">Damon Cook</a></strong> announced on X (former Twitter) : &#8220;I&#8217;ve helped write #WordPress themes that went on to have 80,000+ installs, but never under my own name and always under the guise of an agency I was working for. Today, I&#8217;ve finally contributed a theme on .org with sole attribution.&#8221; Congratulations to Damon Gook for getting his first theme into the repository. The Theme is a block theme and called <a href=\"https://wordpress.org/themes/bounds/\"><strong>Bounds.</strong></a> &#8220;This theme is meant for slide decks. Use it for your next presentation. The default experience includes scroll snapping on large screens. There is also a style variation for a horizontal scroll snapping.&#8221; Cook wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/m_munirkamal\"><strong>Munir Kamal</strong></a> announced a new feature for the almost evergreen EditorsKit plugin: <a href=\"https://www.youtube.com/watch?v=SGEhm4_sXT4\"><strong>adding and managing Block Styles.</strong> </a>It&#8217;s a great example of how the WordPress Site editor can be used as a modern Design Tool for all kinds of use cases.  Download the <a href=\"https://wordpress.org/plugins/block-options/\">EditorsKit from the WordPress repository.</a> </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/TarunVijwani\">Tarun Vijwani</a></strong> published the release notes for the <a href=\"https://developer.woocommerce.com/2023/09/29/woocommerce-blocks-11-2-0-release-notes/\"><strong>WooCommerce Blocks 11.2</strong></a> release and highlighted blockified order confirmation, product collection patterns, the new Store API order endpoints and more. </p>\n\n\n\n<img width=\"652\" height=\"274\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-30-at-18.18.52.png?resize=652%2C274&ssl=1\" alt=\"\" class=\"wp-image-25845\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-theme-development-for-full-site-editing-and-blocks\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Sarah Gooding </strong>recounts the story of <strong>Mike McAllister&#8217;s</strong> woes of being a trailblazer.   <a href=\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\"><strong>Ollie Theme Faces Pushback from WordPress Theme Review Team</strong></a>. Adding onboarding setting screens to his newest block theme, bump up against the Theme directory&#8217;s guidelines as plugin territory. People agree that there needs onboarding solutions for new WordPress users after they log in into their freshly installed WordPress instance. </p>\n\n\n\n<p>The team at Extendify also has a <a href=\"https://extendify.com/launch/\">launch solution</a> it offers to the hosting companies as a stand-alone product also built with Gutenberg components on top of WordPress. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>James Koussertari</strong> of Gutenberg Market updated his <a href=\"https://gutenbergmarket.com/news/a-comprehensive-guide-to-building-wordpress-block-themes\"><strong>Comprehensive Guide to Building WordPress Block Themes</strong></a>. &#8220;Now inline with the latest version of WordPress (I think)&#8221; <a href=\"https://twitter.com/jkoussertari/status/1707513300190142798\">he tweeted on X</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In their <a href=\"https://www.youtube.com/watch?v=HfMYdvpbEqs\"><strong>September Friday Hangout,</strong></a> Webdev Studios folks, <strong>Brad Williams,</strong> <strong>Victor M Ramirez</strong>, <strong>Raquel Manriquez and Alfredo Navas</strong>, talked about full site editing and WordCamps. &#8220;<em>FSE is an exciting advancement in website development that makes it easier than ever for anyone to create a professional-looking website, regardless of their technical skills.&#8221;</em> They wrote in the description. They also mentioned their WDS <a href=\"https://github.com/webdevStudios/wd_f\"><strong>WordPress Site Editor (FSE) Starter Block Theme</strong></a>, that is available on GitHub. </p>\n\n\n\n<a href=\"https://www.youtube.com/watch?v=HfMYdvpbEqs\"><img width=\"652\" height=\"369\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-30-at-16.49.59.png?resize=652%2C369&ssl=1\" alt=\"Screenshot of the panel in September Friday Hangout.\" class=\"wp-image-25834\" /></a>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/marybaum\">Mary Baum</a> </strong>published an introduction to <a href=\"https://developer.wordpress.org/news/2023/09/the-html-api-process-your-tags-not-your-pain/\"><strong>The HTML API: process your tags, not your pain</strong></a> on the WordPress Developer blog: &#8220;All by itself, the HTML Tag processor is better than regular expressions. It&#8217;s convenient, reliable, fast—and You. Can. Read. It. This article shows you in two examples how to get started using the HTML Tag processor.&#8221; It also has a great list of resources for those who need to dive much, much deeper. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> posted another episode of his Block Cook Book recipes on YouTube: <a href=\"https://www.youtube.com/watch?v=Sj61X_Xtfzc\"><strong>The Interactivity API</strong></a>, and how to use the @wordpress/create-block-interactive-template template to scaffold a block that uses it.</p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: Screenshot of the WordPress site on nasa.gov in 2023. </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Sep 2023 12:54:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: Gutenberg 16.7 Introduces Font Management\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149617\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/gutenberg-16-7-introduces-font-management\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3738:\"<p><a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">Gutenberg 16.7</a> was released this week, packed with several features that are headlining the upcoming WordPress 6.4 release. This will be the last plugin release that will be rolled into the next version of WordPress. </p>\n\n\n\n<p>Font management with the new font library is now available for testing in the plugin. These features standardize a way to add font collections to WordPress&#8217; new font library, so plugin authors can register lists of fonts and users can install the ones they want. It also enables font foundries to create their own WordPress plugins to provide access to their fonts.</p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/issues/54169\">Font Library</a> manages fonts independently of a site&#8217;s active theme, allowing users to install, remove, and activate fonts from various sources in WordPress. This works in a similar way to the Media Library.</p>\n\n\n\n<p>After updating to Gutenberg 16.7, users can navigate to Styles > Typography to manage fonts. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1752\" height=\"1086\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-29-at-5.24.43-PM.png\" alt=\"\" class=\"wp-image-149693\" />\n\n\n\n<p>From there, users can launch the Font Library, which loads in a popup screen, and browse all of the installed fonts. A Google Fonts tab allows for installing additional fonts that will be loaded locally from the user&#8217;s server. This gives site editors  more freedom in selecting the typography for their websites instead of relying on a theme or plugin to provide font options.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2060\" height=\"1194\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-29-at-5.28.40-PM.png\" alt=\"\" class=\"wp-image-149694\" />\n\n\n\n<p>Gutenberg 16.7 also brings several important enhancements to patterns. Users can now <a href=\"https://github.com/WordPress/gutenberg/pull/54337\">import and export patterns as JSON files</a> from the Patterns screen, making it easier to share patterns to other WordPress sites. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2184\" height=\"998\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-29-at-5.41.01-PM.png\" alt=\"\" class=\"wp-image-149697\" />\n\n\n\n<p>The &#8220;My Patterns&#8221; category designation has also been reinstated to the post editor&#8217;s inserter, based on feedback after it had been removed.</p>\n\n\n\n<p>Inside the the inserter in the post editor, pattern filters have been relocated to a dropdown at the top of the pattern list panel, along with a sticky header to help with navigation.</p>\n\n\n\n<p>Other notable highlights of Gutenberg 16.7 include the following: </p>\n\n\n\n<ul>\n<li>Group blocks can now have custom names, making it easier to know what they are in the List View</li>\n\n\n\n<li> New Social Link icon for the X service (formerly known as Twitter)</li>\n\n\n\n<li>New ability to toggle ‘nofollow’ setting for inline links (rich text only)</li>\n\n\n\n<li>Add aspect ratio to image placeholder</li>\n\n\n\n<li>Image block: Revise lightbox UI to remove ‘behaviors’</li>\n\n\n\n<li>Image block: UI updates for the image lightbox (redo)</li>\n</ul>\n\n\n\n<p>Gutenberg 16.7 includes 331 pull requests from 88 contributors. For more details on all the enhancements, bug fixes, accessibility, performance, code quality, testing, and tooling improvements, check out the full <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/#import-export-of-patterns\">changelog in the release post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Sep 2023 22:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 20 Oct 2023 09:29:39 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Fri, 20 Oct 2023 09:15:29 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211221010300\";}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (342,'_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9','1697837380','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (343,'_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9','1697794180','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (344,'_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b','1697837380','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (345,'_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b','<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/10/state-of-the-word-2023/\'>State of the Word 2023 – Save the Date</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/10/a-new-wordpress-showcase/\'>A New WordPress Showcase</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/state-of-the-word-2023-will-broadcast-live-from-madrid-on-december-11\'>WPTavern: State of the Word 2023 Will Broadcast Live from Madrid on December 11</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-relaunches-showcase-powered-by-blocks\'>WPTavern: WordPress Relaunches Showcase Powered by Blocks</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/10/state-of-the-word-2023/\'>WordPress.org blog: State of the Word 2023 – Save the Date</a></li></ul></div>','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (346,'can_compress_scripts','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (347,'recently_activated','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (348,'litespeed.optimize.timestamp_purge_css','1697797944','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (350,'litespeed.admin_display.thirdparty_litespeed_check','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (352,'_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a','1697805028','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (353,'_site_transient_poptags_40cd750bba9870f18aada2478b24840a','O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6166;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4822;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2788;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2683;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2058;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1927;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1914;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1657;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1573;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1565;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1550;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1513;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1497;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1381;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1279;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1176;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1160;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1155;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1074;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1034;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1003;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:971;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:908;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:906;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:886;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:883;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:881;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:875;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:872;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:843;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:823;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:796;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:781;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:780;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:777;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:764;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:749;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:734;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:732;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:730;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:729;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:694;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:687;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:683;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:676;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:668;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:634;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:628;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:621;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:616;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:610;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:609;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:601;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:597;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:594;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:593;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:577;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:576;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:572;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:571;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:570;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:561;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:559;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:544;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:542;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:534;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:533;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:532;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:530;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:519;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:511;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:510;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:506;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:494;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:483;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:479;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:470;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:451;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:449;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:448;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:438;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:434;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:429;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:427;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:426;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:425;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:425;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:421;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:421;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:420;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:413;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:408;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:400;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:399;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:396;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:396;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:391;}}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (354,'litespeed.conf._version','5.7','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (355,'litespeed.conf.debug-exc_strings','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (356,'litespeed.conf.optm-ucss_file_exc_inline','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (357,'litespeed.conf.optm-js_delay_inc','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (358,'litespeed.conf.optm-dns_preconnect','[]','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (359,'litespeed.conf.media-vpi','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (360,'litespeed.conf.media-vpi_cron','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (361,'litespeed.conf.qc-token','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (362,'litespeed.conf.qc-nameservers','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (365,'finished_updating_comment_type','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (375,'_site_transient_ai1wm_last_check_for_updates','1697797171','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (376,'ai1wm_updater','a:0:{}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (379,'_site_transient_update_themes','O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1697797947;s:7:\"checked\";a:4:{s:9:\"smart-mag\";s:5:\"9.2.0\";s:15:\"twentytwentyone\";s:3:\"1.8\";s:17:\"twentytwentythree\";s:3:\"1.2\";s:15:\"twentytwentytwo\";s:3:\"1.4\";}s:8:\"response\";a:1:{s:9:\"smart-mag\";a:4:{s:5:\"theme\";s:9:\"smart-mag\";s:3:\"url\";s:55:\"https://theme-sphere.com/docs/changelog/?theme=smartmag\";s:11:\"new_version\";s:5:\"9.3.0\";s:7:\"package\";s:106:\"https://updates-cdn.theme-sphere.com/themes/smart-mag-9.3.0-1a81162a14ef39b4754c6ecf295797b4/smart-mag.zip\";}}s:9:\"no_update\";a:3:{s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.8.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.2.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.4.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (380,'current_theme','SmartMag','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (381,'theme_mods_smart-mag','a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:13:\"smartmag-main\";i:28;s:21:\"smartmag-footer-links\";i:30;}s:18:\"custom_css_post_id\";i:3537;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (382,'theme_switched','','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (383,'smartmag_license','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (384,'elementor_disable_color_schemes','yes','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (385,'elementor_disable_typography_schemes','yes','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (386,'elementor_experiment-e_dom_optimization','active','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (387,'elementor_experiment-e_optimized_assets_loading','active','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (388,'elementor_onboarded','1','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (389,'smartmag_theme_version','a:2:{s:7:\"current\";s:5:\"9.2.0\";s:13:\"first_install\";i:1697797227;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (392,'elementor_active_kit','8','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (393,'elementor_font_display','swap','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (397,'_site_transient__smartmag_update_theme','a:5:{s:4:\"safe\";b:1;s:11:\"new_version\";s:5:\"9.3.0\";s:7:\"package\";s:106:\"https://updates-cdn.theme-sphere.com/themes/smart-mag-9.3.0-1a81162a14ef39b4754c6ecf295797b4/smart-mag.zip\";s:3:\"url\";s:55:\"https://theme-sphere.com/docs/changelog/?theme=smartmag\";s:10:\"can_update\";b:1;}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (398,'elementor_version','3.16.6','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (399,'elementor_install_history','a:1:{s:6:\"3.16.6\";i:1697797331;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (400,'elementor_events_db_version','1.0.0','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (401,'widget_bunyad_about_widget','a:3:{i:1;a:8:{s:5:\"title\";s:20:\"ABOUT DEVELOPERSZONE\";s:4:\"text\";s:151:\"DevelopersZone is a sister concern of CodemanBD. We provide premium contents on WordPress Themes, Plugins, Shopify Themes &amp; Woocommerce Addons.\r\n\r\n\";s:9:\"logo_text\";s:0:\"\";s:5:\"image\";s:82:\"https://hasantalukder.com/crocoblock/wp-content/uploads/2023/10/developerszone.png\";s:8:\"image_2x\";s:82:\"https://hasantalukder.com/crocoblock/wp-content/uploads/2023/10/developerszone.png\";s:10:\"image_type\";s:4:\"logo\";s:6:\"social\";a:4:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:7:\"youtube\";i:3;s:8:\"linkedin\";}s:12:\"image_circle\";i:0;}i:2;a:7:{s:5:\"title\";s:8:\"About Us\";s:4:\"text\";s:295:\"Your source for the lifestyle news. This demo is crafted specifically to exhibit the use of the theme as a lifestyle site. Visit our main page for more demos.\r\n\r\nWe\'re accepting new partnerships right now.\r\n\r\n<strong>Email Us:</strong> info@example.com\r\n<strong>Contact:</strong> +1-320-0123-451\";s:9:\"logo_text\";s:0:\"\";s:5:\"image\";s:103:\"https://smartmag.theme-sphere.com/prime-mag/wp-content/uploads/sites/15/2021/06/PrimeMag-Logo-white.png\";s:8:\"image_2x\";s:106:\"https://smartmag.theme-sphere.com/prime-mag/wp-content/uploads/sites/15/2021/06/PrimeMag-Logo-white@2x.png\";s:10:\"image_type\";s:4:\"logo\";s:12:\"image_circle\";i:0;}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (402,'widget_bunyad-tabbed-recent-widget','a:2:{s:12:\"_multiwidget\";i:1;i:3;a:0:{}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (403,'widget_bunyad-tabber-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (404,'widget_bunyad-social','a:3:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"style\";s:3:\"b-2\";s:6:\"social\";a:6:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:9:\"pinterest\";i:3;s:9:\"instagram\";i:4;s:7:\"youtube\";i:5;s:5:\"vimeo\";}}i:2;a:4:{s:5:\"title\";s:13:\"Stay In Touch\";s:5:\"style\";s:3:\"a-2\";s:8:\"counters\";s:0:\"\";s:6:\"social\";a:6:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:9:\"pinterest\";i:3;s:9:\"instagram\";i:4;s:7:\"youtube\";i:5;s:5:\"vimeo\";}}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (405,'widget_bunyad-latest-reviews-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (406,'widget_bunyad_flickr_widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (407,'widget_smartmag-block-grid','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (408,'widget_smartmag-block-overlay','a:1:{s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (409,'widget_smartmag-block-posts-small','a:6:{i:1;a:42:{s:7:\"heading\";s:9:\"Our Picks\";s:5:\"posts\";s:1:\"4\";s:10:\"pagination\";s:1:\"0\";s:6:\"scheme\";s:0:\"\";s:9:\"title_tag\";s:2:\"h4\";s:7:\"columns\";s:0:\"\";s:11:\"space_below\";s:4:\"none\";s:10:\"cat_labels\";s:0:\"\";s:11:\"title_lines\";s:0:\"\";s:10:\"show_media\";s:1:\"1\";s:9:\"media_pos\";s:4:\"left\";s:11:\"media_ratio\";s:0:\"\";s:7:\"reviews\";s:0:\"\";s:17:\"show_post_formats\";s:1:\"0\";s:18:\"meta_items_default\";s:1:\"1\";s:14:\"meta_cat_style\";s:4:\"text\";s:15:\"meta_author_img\";s:1:\"0\";s:10:\"show_title\";s:1:\"1\";s:5:\"style\";s:1:\"a\";s:15:\"container_width\";s:2:\"33\";s:8:\"carousel\";s:1:\"0\";s:15:\"carousel_arrows\";s:1:\"b\";s:10:\"query_type\";s:6:\"custom\";s:7:\"sort_by\";s:0:\"\";s:10:\"sort_order\";s:4:\"desc\";s:6:\"offset\";s:0:\"\";s:12:\"reviews_only\";s:1:\"0\";s:4:\"tags\";s:5:\"picks\";s:8:\"post_ids\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:9:\"post_type\";s:4:\"post\";s:12:\"heading_type\";s:0:\"\";s:14:\"heading_colors\";s:0:\"\";s:12:\"heading_link\";s:0:\"\";s:17:\"heading_more_text\";s:0:\"\";s:17:\"heading_more_link\";s:0:\"\";s:10:\"column_gap\";s:0:\"\";s:14:\"css_column_gap\";s:0:\"\";s:11:\"css_row_gap\";s:0:\"\";s:10:\"separators\";s:1:\"1\";s:13:\"heading_align\";s:4:\"left\";s:7:\"has_css\";s:1:\"1\";}i:2;a:42:{s:7:\"heading\";s:10:\"Blog Posts\";s:5:\"posts\";s:1:\"4\";s:10:\"pagination\";s:1:\"0\";s:6:\"scheme\";s:0:\"\";s:9:\"title_tag\";s:2:\"h4\";s:7:\"columns\";s:0:\"\";s:11:\"space_below\";s:4:\"none\";s:10:\"cat_labels\";s:0:\"\";s:11:\"title_lines\";s:0:\"\";s:10:\"show_media\";s:1:\"1\";s:9:\"media_pos\";s:4:\"left\";s:11:\"media_ratio\";s:0:\"\";s:7:\"reviews\";s:0:\"\";s:17:\"show_post_formats\";s:1:\"0\";s:18:\"meta_items_default\";s:1:\"1\";s:14:\"meta_cat_style\";s:4:\"text\";s:15:\"meta_author_img\";s:1:\"0\";s:10:\"show_title\";s:1:\"1\";s:5:\"style\";s:1:\"a\";s:15:\"container_width\";s:2:\"33\";s:8:\"carousel\";s:1:\"0\";s:15:\"carousel_arrows\";s:1:\"b\";s:10:\"query_type\";s:6:\"custom\";s:7:\"sort_by\";s:0:\"\";s:10:\"sort_order\";s:4:\"desc\";s:6:\"offset\";s:0:\"\";s:12:\"reviews_only\";s:1:\"0\";s:4:\"tags\";s:0:\"\";s:8:\"post_ids\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:9:\"post_type\";s:4:\"post\";s:12:\"heading_type\";s:0:\"\";s:14:\"heading_colors\";s:0:\"\";s:12:\"heading_link\";s:0:\"\";s:17:\"heading_more_text\";s:0:\"\";s:17:\"heading_more_link\";s:0:\"\";s:10:\"column_gap\";s:0:\"\";s:14:\"css_column_gap\";s:0:\"\";s:11:\"css_row_gap\";s:0:\"\";s:10:\"separators\";s:1:\"1\";s:13:\"heading_align\";s:4:\"left\";s:7:\"has_css\";s:1:\"1\";}i:3;a:42:{s:7:\"heading\";s:10:\"What\'s Hot\";s:5:\"posts\";s:1:\"3\";s:10:\"pagination\";s:1:\"0\";s:6:\"scheme\";s:0:\"\";s:9:\"title_tag\";s:2:\"h4\";s:7:\"columns\";s:0:\"\";s:11:\"space_below\";s:4:\"none\";s:10:\"cat_labels\";s:0:\"\";s:11:\"title_lines\";s:0:\"\";s:10:\"show_media\";s:1:\"1\";s:9:\"media_pos\";s:4:\"left\";s:11:\"media_ratio\";s:0:\"\";s:7:\"reviews\";s:0:\"\";s:17:\"show_post_formats\";s:1:\"0\";s:18:\"meta_items_default\";s:1:\"1\";s:14:\"meta_cat_style\";s:4:\"text\";s:15:\"meta_author_img\";s:1:\"0\";s:10:\"show_title\";s:1:\"1\";s:5:\"style\";s:1:\"a\";s:15:\"container_width\";s:2:\"33\";s:8:\"carousel\";s:1:\"0\";s:15:\"carousel_arrows\";s:1:\"b\";s:10:\"query_type\";s:6:\"custom\";s:7:\"sort_by\";s:0:\"\";s:10:\"sort_order\";s:4:\"desc\";s:6:\"offset\";s:0:\"\";s:12:\"reviews_only\";s:1:\"0\";s:4:\"tags\";s:0:\"\";s:8:\"post_ids\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:9:\"post_type\";s:4:\"post\";s:12:\"heading_type\";s:0:\"\";s:14:\"heading_colors\";s:0:\"\";s:12:\"heading_link\";s:0:\"\";s:17:\"heading_more_text\";s:0:\"\";s:17:\"heading_more_link\";s:0:\"\";s:10:\"column_gap\";s:0:\"\";s:14:\"css_column_gap\";s:0:\"\";s:11:\"css_row_gap\";s:0:\"\";s:10:\"separators\";s:1:\"1\";s:13:\"heading_align\";s:4:\"left\";s:7:\"has_css\";s:1:\"1\";}i:4;a:65:{s:7:\"heading\";s:14:\"RECENT CONTENT\";s:5:\"posts\";s:1:\"2\";s:10:\"pagination\";s:1:\"0\";s:15:\"pagination_type\";s:12:\"numbers-ajax\";s:16:\"pagination_links\";s:1:\"1\";s:6:\"scheme\";s:0:\"\";s:9:\"title_tag\";s:2:\"h4\";s:7:\"columns\";s:0:\"\";s:11:\"space_below\";s:4:\"none\";s:10:\"cat_labels\";s:0:\"\";s:14:\"cat_labels_pos\";s:0:\"\";s:11:\"title_lines\";s:0:\"\";s:13:\"excerpt_lines\";s:0:\"\";s:14:\"excerpt_length\";s:2:\"15\";s:10:\"show_media\";s:1:\"1\";s:9:\"media_pos\";s:4:\"left\";s:11:\"media_ratio\";s:0:\"\";s:7:\"reviews\";s:0:\"\";s:17:\"show_post_formats\";s:1:\"0\";s:18:\"meta_items_default\";s:1:\"1\";s:14:\"meta_cat_style\";s:4:\"text\";s:15:\"meta_author_img\";s:1:\"0\";s:10:\"show_title\";s:1:\"1\";s:5:\"style\";s:1:\"a\";s:15:\"container_width\";s:2:\"33\";s:8:\"carousel\";s:1:\"0\";s:15:\"carousel_slides\";s:0:\"\";s:18:\"carousel_slides_md\";s:0:\"\";s:18:\"carousel_slides_sm\";s:0:\"\";s:15:\"carousel_arrows\";s:1:\"b\";s:13:\"carousel_dots\";s:1:\"1\";s:17:\"carousel_autoplay\";s:1:\"0\";s:19:\"carousel_play_speed\";s:0:\"\";s:10:\"query_type\";s:6:\"custom\";s:7:\"sort_by\";s:0:\"\";s:9:\"sort_days\";s:2:\"30\";s:10:\"sort_order\";s:4:\"desc\";s:3:\"cat\";s:0:\"\";s:6:\"offset\";s:0:\"\";s:12:\"reviews_only\";s:1:\"0\";s:4:\"tags\";s:5:\"picks\";s:8:\"post_ids\";s:0:\"\";s:12:\"exclude_tags\";s:0:\"\";s:11:\"exclude_ids\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:7:\"tax_ids\";s:0:\"\";s:9:\"post_type\";s:4:\"post\";s:8:\"query_id\";s:0:\"\";s:15:\"exclude_current\";s:1:\"0\";s:12:\"heading_type\";s:0:\"\";s:14:\"heading_colors\";s:0:\"\";s:12:\"heading_link\";s:0:\"\";s:17:\"heading_more_text\";s:0:\"\";s:12:\"heading_more\";s:1:\"a\";s:17:\"heading_more_link\";s:0:\"\";s:11:\"heading_tag\";s:2:\"h4\";s:10:\"column_gap\";s:0:\"\";s:14:\"css_column_gap\";s:0:\"\";s:11:\"css_row_gap\";s:0:\"\";s:10:\"separators\";s:1:\"1\";s:15:\"separators_cols\";s:1:\"0\";s:18:\"media_style_shadow\";s:0:\"\";s:13:\"heading_align\";s:4:\"left\";s:15:\"load_more_style\";s:0:\"\";s:7:\"has_css\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;i:6;a:0:{}}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (410,'widget_smartmag-block-highlights','a:2:{i:1;a:39:{s:7:\"heading\";s:10:\"Don\'t Miss\";s:5:\"posts\";s:1:\"4\";s:6:\"scheme\";s:0:\"\";s:9:\"title_tag\";s:2:\"h2\";s:11:\"small_style\";s:1:\"a\";s:7:\"columns\";s:0:\"\";s:11:\"space_below\";s:4:\"none\";s:10:\"cat_labels\";s:0:\"\";s:11:\"title_lines\";s:0:\"\";s:8:\"excerpts\";s:1:\"1\";s:14:\"excerpt_length\";s:2:\"15\";s:10:\"show_media\";s:1:\"1\";s:11:\"media_ratio\";s:0:\"\";s:9:\"read_more\";s:0:\"\";s:7:\"reviews\";s:0:\"\";s:17:\"show_post_formats\";s:1:\"1\";s:16:\"post_formats_pos\";s:0:\"\";s:18:\"meta_items_default\";s:1:\"1\";s:14:\"meta_cat_style\";s:4:\"text\";s:15:\"meta_author_img\";s:1:\"0\";s:10:\"show_title\";s:1:\"1\";s:15:\"container_width\";s:2:\"33\";s:10:\"query_type\";s:6:\"custom\";s:7:\"sort_by\";s:0:\"\";s:10:\"sort_order\";s:4:\"desc\";s:6:\"offset\";s:0:\"\";s:12:\"reviews_only\";s:1:\"0\";s:4:\"tags\";s:0:\"\";s:8:\"post_ids\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:9:\"post_type\";s:4:\"post\";s:12:\"heading_type\";s:0:\"\";s:14:\"heading_colors\";s:0:\"\";s:12:\"heading_link\";s:0:\"\";s:17:\"heading_more_text\";s:0:\"\";s:17:\"heading_more_link\";s:0:\"\";s:10:\"column_gap\";s:0:\"\";s:10:\"separators\";s:1:\"0\";s:13:\"heading_align\";s:4:\"left\";}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (411,'widget_smartmag-block-newsletter','a:3:{i:1;a:13:{s:12:\"widget_title\";s:0:\"\";s:8:\"headline\";s:20:\"Subscribe to Updates\";s:7:\"service\";s:0:\"\";s:7:\"message\";s:66:\"Get the latest creative news from SmartMag about art &amp; design.\";s:10:\"disclaimer\";s:91:\"By signing up, you agree to the our terms and our <a href=\"#\">Privacy Policy</a> agreement.\";s:8:\"checkbox\";s:1:\"1\";s:10:\"image_type\";s:4:\"none\";s:5:\"style\";s:1:\"b\";s:6:\"scheme\";s:5:\"light\";s:12:\"fields_style\";s:4:\"full\";s:9:\"container\";s:2:\"sm\";s:5:\"align\";s:6:\"center\";s:4:\"icon\";s:7:\"mail-bg\";}i:2;a:17:{s:12:\"widget_title\";s:0:\"\";s:8:\"headline\";s:20:\"Subscribe to Updates\";s:7:\"service\";s:0:\"\";s:11:\"custom_form\";s:0:\"\";s:7:\"message\";s:72:\"Get the latest creative news from FooBar about art, design and business.\";s:10:\"submit_url\";s:0:\"\";s:10:\"disclaimer\";s:91:\"By signing up, you agree to the our terms and our <a href=\"#\">Privacy Policy</a> agreement.\";s:8:\"checkbox\";s:1:\"1\";s:10:\"image_type\";s:4:\"none\";s:5:\"image\";s:0:\"\";s:8:\"image_2x\";s:0:\"\";s:5:\"style\";s:1:\"b\";s:6:\"scheme\";s:5:\"light\";s:12:\"fields_style\";s:4:\"full\";s:9:\"container\";s:2:\"sm\";s:5:\"align\";s:6:\"center\";s:4:\"icon\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (412,'widget_smartmag-block-codes','a:3:{i:1;a:4:{s:12:\"widget_title\";s:0:\"\";s:4:\"code\";s:240:\"<a href=\"https://theme-sphere.com/buy/go.php?theme=smartmag\" target=\"_blank\">\r\n  <img src=\"https://smartmag.theme-sphere.com/good-news/wp-content/uploads/sites/6/2021/02/GOODNEWS-AD-SP-01-2X.jpg\" width=\"336\" height=\"280\" alt=\"Demo\" />\r\n</a>\";s:8:\"code_amp\";s:0:\"\";s:5:\"label\";s:0:\"\";}i:2;a:4:{s:12:\"widget_title\";s:0:\"\";s:4:\"code\";s:239:\"<a href=\"https://theme-sphere.com/buy/go.php?theme=smartmag\" target=\"_blank\">\r\n<img src=\"https://smartmag.theme-sphere.com/prime-mag/wp-content/uploads/sites/15/2021/06/336x280-banner-02@2x.jpg\" width=\"336\" height=\"250\" alt=\"Demo\" />\r\n</a>\";s:8:\"code_amp\";s:0:\"\";s:5:\"label\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (414,'elementor_log','a:3:{s:32:\"1e2a5d831979788414e94322fb26435a\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2023-10-20 10:22:11\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:88:\"version_compare(): Passing null to parameter #1 ($version1) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-20 10:22:11\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:88:\"version_compare(): Passing null to parameter #1 ($version1) of type string is deprecated\";s:4:\"file\";s:91:\"/home/hasantal/public_html/crocoblock/wp-content/plugins/elementor/core/upgrade/manager.php\";s:4:\"line\";i:70;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:91:\"/home/hasantal/public_html/crocoblock/wp-content/plugins/elementor/core/upgrade/manager.php\";s:7:\"\0*\0line\";i:70;}s:32:\"9a265cd7ec074eda7c026c6297c590e1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-10-20 11:23:00\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:69:\"Cannot read properties of undefined (reading &#039;toLowerCase&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-20 11:23:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1697800980\";s:7:\"message\";s:59:\"Cannot read properties of undefined (reading \'toLowerCase\')\";s:3:\"url\";s:100:\"https://hasantalukder.com/crocoblock/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"804251\";}s:7:\"\0*\0file\";s:100:\"https://hasantalukder.com/crocoblock/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"804251\";}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-10-20 11:38:04\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2023-10-20 11:38:04\";i:1;s:19:\"2023-10-20 11:38:08\";i:2;s:19:\"2023-10-20 11:38:08\";i:3;s:19:\"2023-10-20 11:38:08\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1697801884\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:100:\"https://hasantalukder.com/crocoblock/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"804758\";}s:7:\"\0*\0file\";s:100:\"https://hasantalukder.com/crocoblock/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.16.6\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"804758\";}}','no');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (416,'_elementor_installed_time','1697797335','yes');
INSERT INTO `SERVMASK_PREFIX_options` VALUES (417,'elementor_remote_info_library','a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:18:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:18:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:18:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:18:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:18:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:18:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:18:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:18:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:18:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:18:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:18:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:18:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:18:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:18:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:18:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:18:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:18:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:18:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:18:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:18:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:18:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:18:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:18:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:18:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:18:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:18:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:18:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:18:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:18:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:18:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:18:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:18:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:18:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:18:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:18:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:18:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:18:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:18:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:18:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:18:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:18:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:18:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:18:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:18:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:18:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:18:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:18:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:18:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:18:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:18:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:18:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:18:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:18:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:18:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:18:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:18:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:18:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:18:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:18:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:18:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:18:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:18:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:18:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:18:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:18:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:18:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:18:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:18:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:18:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:18:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:18:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:18:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:18:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:18:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:18:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:18:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:18:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:18:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:18:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:18:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:18:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:18:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:18:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:18:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:18:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:18:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:18:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:18:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:18:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:18:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:18:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:18:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:18:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:18:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:18:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:18:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:18:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:18:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:18:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:18:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:18:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:18:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:18:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:18:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:18:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:18:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:18:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:18:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:18:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:18:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:18:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:18:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:18:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:18:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:18:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:18:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:18:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:18:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:18:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:18:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:18:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:18:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:18:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:18:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:18:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:18:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:18:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:18:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:18:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:18:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:18:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:18:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:18:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:18:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:18:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:18:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:18:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:18:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:18:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:18:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:18:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:18:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:18:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:18:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:18:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:18:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:18:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:18:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:18:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:18:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:18:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:18:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:18:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:18:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:18:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:18:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:18:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:18:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:18:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:18:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:18:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:18:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:18:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:18:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:18:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:18:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:18:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:18:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:18:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:18:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:18:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:18:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:18:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:18:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:18:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:18:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:18:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:18:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:18:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:18:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:18:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https:/